% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_simulation_results.R
\name{SimulationResultsMultiArmRates}
\alias{SimulationResultsMultiArmRates}
\title{Class for Simulation Results Multi-Arm Rates}
\description{
A class for simulation results rates in multi-arm designs.
}
\details{
Use \code{\link[=getSimulationMultiArmRates]{getSimulationMultiArmRates()}}
to create an object of this type.
}
\section{Fields}{

\describe{
\item{\code{activeArms}}{The number of active treatment arms to be compared with control. Is a numeric vector of length 1 containing a whole number.}

\item{\code{adaptations}}{Indicates whether or not an adaptation takes place at interim k. Is a logical vector of length \code{kMax} minus 1.}

\item{\code{allocationRatioPlanned}}{The planned allocation ratio (\code{n1 / n2}) for the groups. For multi-arm designs, it is the allocation ratio relating the active arm(s) to the control. Is a positive numeric vector of length 1.}

\item{\code{calcSubjectsFunction}}{An optional function that can be entered to define how sample size is recalculated. By default, recalculation is performed with conditional power with specified \code{minNumberOfSubjectsPerStage} and \code{maxNumberOfSubjectsPerStage}.}

\item{\code{conditionalPower}}{The conditional power at each stage of the trial. Is a numeric vector of length 1 containing a value between 0 and 1.}

\item{\code{conditionalPowerAchieved}}{The calculated conditional power, under the assumption of observed or assumed effect sizes. Is a numeric matrix.}

\item{\code{directionUpper}}{Specifies the direction of the alternative, only applicable for one-sided testing. Default is \code{TRUE} which means that larger values of the test statistics yield smaller p-values. Is a logical vector of length 1.}

\item{\code{earlyStop}}{The probability to stopping the trial either for efficacy or futility. Is a numeric vector.}

\item{\code{effectMatrix}}{The matrix of effect sizes with \code{activeArms} columns and number of rows reflecting the different situations to consider.}

\item{\code{effectMeasure}}{Criterion for treatment arm/population selection, either based on test statistic (\code{"testStatistic"}) or effect estimate (\code{"effectEstimate"}). Is a character vector of length 1.}

\item{\code{epsilonValue}}{Needs to be specified if \code{typeOfSelection = "epsilon"}. Is a numeric vector of length 1.}

\item{\code{expectedNumberOfSubjects}}{The expected number of subjects under specified alternative.}

\item{\code{futilityPerStage}}{The per-stage probabilities of stopping the trial for futility. Is a numeric matrix.}

\item{\code{futilityStop}}{In simulation results data set: indicates whether trial is stopped for futility or not.}

\item{\code{gED50}}{The ED50 of the sigmoid Emax model. Only necessary if \code{typeOfShape = "sigmoidEmax"} has been specified. Is a numeric vector of length 1.}

\item{\code{intersectionTest}}{The multiple test used for intersection hypotheses in closed systems of hypotheses. Is a character vector of length 1.}

\item{\code{iterations}}{The number of iterations used for simulations. Is a numeric vector of length 1 containing a whole number.}

\item{\code{maxNumberOfIterations}}{The number of simulation iterations. Is a numeric vector of length 1 containing a whole number.}

\item{\code{maxNumberOfSubjects}}{The maximum number of subjects for power calculations. Is a numeric vector.}

\item{\code{numberOfActiveArms}}{The number of active arms in a multi-armed design. Is a numeric matrix.}

\item{\code{piControl}}{The assumed probability in the control arm for simulation and under which the sample size recalculation is performed. Is a numeric vector of length 1 containing a value between 0 and 1.}

\item{\code{piControlH1}}{The assumed probability in the reference group, for which the conditional power was calculated. Is a numeric vector of length 1 containing a value between 0 and 1.}

\item{\code{piH1}}{The assumed probability in the active treatment arm(s) under which the sample size recalculation is performed. Is a numeric vector of length 1 containing a value between 0 and 1.}

\item{\code{piMaxVector}}{The range of assumed probabilities for the treatment group with highest response for \code{"linear"} and \code{"sigmoidEmax"} model.}

\item{\code{plannedSubjects}}{Determines the number of cumulated (overall) subjects when the interim stages are planned. For two treatment arms, is the number of subjects for both treatment arms. For multi-arm designs, refers to the number of subjects per selected active arm. Is a numeric vector of length \code{kMax} containing whole numbers.}

\item{\code{rejectAtLeastOne}}{The probability to reject at least one of the (multiple) hypotheses. Is a numeric vector.}

\item{\code{rejectedArmsPerStage}}{The simulated number of rejected arms per stage.}

\item{\code{rValue}}{Needs to be specified if \code{typeOfSelection = "rBest"}. Is a numeric vector of length 1.}

\item{\code{sampleSizes}}{The sample sizes for each group and stage. Is a numeric vector of length number of stages times number of groups containing whole numbers.}

\item{\code{seed}}{The seed used for random number generation. Is a numeric vector of length 1.}

\item{\code{selectArmsFunction}}{An optional function that can be entered to define how treatment arms are selected.}

\item{\code{selectedArms}}{The selected arms in multi-armed designs.}

\item{\code{slope}}{The slope of the sigmoid Emax model, if \code{typeOfShape = "sigmoidEmax"} Is a numeric vector of length 1.}

\item{\code{successCriterion}}{Defines when the study is stopped for efficacy at interim. \code{"all"} stops the trial if the efficacy criterion has been fulfilled for all selected treatment arms/populations, \code{"atLeastOne"} stops if at least one of the selected treatment arms/populations is shown to be superior to control at interim. Is a character vector of length 1.}

\item{\code{successPerStage}}{The simulated success probabilities per stage where success is defined by user. Is a numeric matrix.}

\item{\code{threshold}}{The selection criterion: treatment arm/population is only selected if \code{effectMeasure} exceeds \code{threshold}. Either a single numeric value or a numeric vector of length \code{activeArms} referring to a separate threshold condition for each treatment arm.}

\item{\code{typeOfSelection}}{The way the treatment arms or populations are selected at interim. Is a character vector of length 1.}

\item{\code{typeOfShape}}{The shape of the dose-response relationship over the treatment groups. Is a character vector of length 1.}
}}

\keyword{internal}
