/*
    		 Crown Copyright (c) 1997
    
    This TenDRA(r) Computer Program is subject to Copyright
    owned by the United Kingdom Secretary of State for Defence
    acting through the Defence Evaluation and Research Agency
    (DERA).  It is made available to Recipients with a
    royalty-free licence for its use, reproduction, transfer
    to other parties and amendment for any purpose not excluding
    product development provided that any such use et cetera
    shall be deemed to be acceptance of the following conditions:-
    
        (1) Its Recipients shall ensure that this Notice is
        reproduced upon any copies or amended versions of it;
    
        (2) Any amended version of it shall be clearly marked to
        show both the nature of and the organisation responsible
        for the relevant amendment or amendments;
    
        (3) Its onward transfer from a recipient to another
        party shall be deemed to be that party's acceptance of
        these conditions;
    
        (4) DERA gives no warranty or assurance as to its
        quality or suitability for any purpose and DERA accepts
        no liability whatsoever in relation to any use to which
        it may be put.
*/


#ifndef ERR_EXT_INCLUDED
#define ERR_EXT_INCLUDED


/*
    ERROR OPERATIONS

    This file describes the operations on errors.  It includes the simple
    operations generated by the calculus tool and extends them by a number
    of hand crafted operations.  This file is automatically generated from
    algebra %X (version %V) by %ZX (version %ZV).
*/

#include "err_ops.h"
@if token

#pragma token PROC (\
	EXP : int : sev,\
	EXP : int : no,\
	EXP : unsigned : sz,\
	EXP lvalue : ERROR : e\
    ) STATEMENT MAKE_err_simple_args #

#pragma token PROC (\
	EXP : ERROR : e\
    ) STATEMENT DESTROY_err_simple_args #

#pragma token PROC (\
	EXP : ERROR : e,\
	EXP : unsigned : n,\
	TYPE t\
    ) EXP : PTR ( t ) : err_arg #

#pragma interface MAKE_err_simple_args DESTROY_err_simple_args err_arg

@else

#define SIZE_err_simple		4

#define MAKE_err_simple_args( A, B, C, E )\
    {\
	unsigned sz_ = ( C ) ;\
	c_class *err_ = GEN_c_class ( SIZE_err_simple + sz_, TYPEID_err ) ;\
	err_->ag_tag = err_simple_tag ;\
	COPY_int ( err_severity ( err_ ), ( A ) ) ;\
	COPY_int ( err_simple_number ( err_ ), ( B ) ) ;\
	COPY_unsigned ( err_simple_size ( err_ ), sz_ ) ;\
	( E ) = err_ ;\
    }

#define DESTROY_err_simple_args( E )\
    {\
	ERROR err_ = ( E ) ;\
	unsigned sz_ = DEREF_unsigned ( err_simple_size ( err_ ) ) ;\
	destroy_c_class ( err_, SIZE_err_simple + sz_ ) ;\
    }

#define err_arg( E, A, T )\
	( ( E ) + ( SIZE_err_simple + ( A ) ) )

@endif

#endif
