///////////////////////////////////////////////////////////////////////
// File:        universalambigs.cpp
// Description: Data for a universal ambigs file that is useful for
//              any language.
// Author:      Ray Smith
// Created:     Mon Mar 18 11:26:00 PDT 2013
//
// (C) Copyright 2013, Google Inc.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
///////////////////////////////////////////////////////////////////////

namespace tesseract {

extern const char kUniversalAmbigsFile[] = {
    '\166', '\062', '\012', '\047', '\047', '\040', '\042', '\040', '\061',
    '\012', '\140', '\047', '\040', '\042', '\040', '\061', '\012', '\047',
    '\140', '\040', '\042', '\040', '\061', '\012', '\342', '\200', '\230',
    '\047', '\040', '\042', '\040', '\061', '\012', '\047', '\342', '\200',
    '\230', '\040', '\042', '\040', '\061', '\012', '\342', '\200', '\231',
    '\047', '\040', '\042', '\040', '\061', '\012', '\047', '\342', '\200',
    '\231', '\040', '\042', '\040', '\061', '\012', '\140', '\140', '\040',
    '\042', '\040', '\061', '\012', '\140', '\342', '\200', '\230', '\040',
    '\042', '\040', '\061', '\012', '\342', '\200', '\230', '\140', '\040',
    '\042', '\040', '\061', '\012', '\140', '\342', '\200', '\231', '\040',
    '\042', '\040', '\061', '\012', '\342', '\200', '\231', '\140', '\040',
    '\042', '\040', '\061', '\012', '\342', '\200', '\230', '\342', '\200',
    '\230', '\040', '\342', '\200', '\234', '\040', '\061', '\012', '\342',
    '\200', '\230', '\342', '\200', '\231', '\040', '\042', '\040', '\061',
    '\012', '\342', '\200', '\231', '\342', '\200', '\230', '\040', '\042',
    '\040', '\061', '\012', '\342', '\200', '\231', '\342', '\200', '\231',
    '\040', '\342', '\200', '\235', '\040', '\061', '\012', '\054', '\054',
    '\040', '\342', '\200', '\236', '\040', '\061', '\012', '\155', '\040',
    '\162', '\156', '\040', '\060', '\012', '\162', '\156', '\040', '\155',
    '\040', '\060', '\012', '\155', '\040', '\151', '\156', '\040', '\060',
    '\012', '\151', '\156', '\040', '\155', '\040', '\060', '\012', '\144',
    '\040', '\143', '\154', '\040', '\060', '\012', '\143', '\154', '\040',
    '\144', '\040', '\060', '\012', '\156', '\156', '\040', '\162', '\155',
    '\040', '\060', '\012', '\162', '\155', '\040', '\156', '\156', '\040',
    '\060', '\012', '\156', '\040', '\162', '\151', '\040', '\060', '\012',
    '\162', '\151', '\040', '\156', '\040', '\060', '\012', '\154', '\151',
    '\040', '\150', '\040', '\060', '\012', '\154', '\162', '\040', '\150',
    '\040', '\060', '\012', '\151', '\151', '\040', '\165', '\040', '\060',
    '\012', '\151', '\151', '\040', '\156', '\040', '\060', '\012', '\156',
    '\151', '\040', '\155', '\040', '\060', '\012', '\151', '\151', '\151',
    '\040', '\155', '\040', '\060', '\012', '\154', '\154', '\040', '\110',
    '\040', '\060', '\012', '\111', '\055', '\111', '\040', '\110', '\040',
    '\060', '\012', '\166', '\166', '\040', '\167', '\040', '\060', '\012',
    '\126', '\126', '\040', '\127', '\040', '\060', '\012', '\164', '\040',
    '\146', '\040', '\060', '\012', '\146', '\040', '\164', '\040', '\060',
    '\012', '\141', '\040', '\157', '\040', '\060', '\012', '\157', '\040',
    '\141', '\040', '\060', '\012', '\145', '\040', '\143', '\040', '\060',
    '\012', '\143', '\040', '\145', '\040', '\060', '\012', '\162', '\162',
    '\040', '\156', '\040', '\060', '\012', '\105', '\040', '\146', '\151',
    '\040', '\060', '\012', '\154', '\074', '\040', '\153', '\040', '\060',
    '\012', '\154', '\144', '\040', '\153', '\151', '\040', '\060', '\012',
    '\154', '\170', '\040', '\150', '\040', '\060', '\012', '\170', '\156',
    '\040', '\155', '\040', '\060', '\012', '\165', '\170', '\040', '\151',
    '\156', '\040', '\060', '\012', '\162', '\040', '\164', '\040', '\060',
    '\012', '\144', '\040', '\164', '\154', '\040', '\060', '\012', '\144',
    '\151', '\040', '\164', '\150', '\040', '\060', '\012', '\165', '\162',
    '\040', '\151', '\156', '\040', '\060', '\012', '\165', '\156', '\040',
    '\151', '\155', '\040', '\060', '\012', '\165', '\040', '\141', '\040',
    '\060', '\012', '\157', '\040', '\303', '\263', '\040', '\060', '\012',
    '\303', '\263', '\040', '\157', '\040', '\060', '\012', '\151', '\040',
    '\303', '\255', '\040', '\060', '\012', '\303', '\255', '\040', '\151',
    '\040', '\060', '\012', '\141', '\040', '\303', '\241', '\040', '\060',
    '\012', '\303', '\241', '\040', '\141', '\040', '\060', '\012', '\145',
    '\040', '\303', '\251', '\040', '\060', '\012', '\303', '\251', '\040',
    '\145', '\040', '\060', '\012', '\165', '\040', '\303', '\272', '\040',
    '\060', '\012', '\303', '\272', '\040', '\165', '\040', '\060', '\012',
    '\156', '\040', '\303', '\261', '\040', '\060', '\012', '\303', '\261',
    '\040', '\156', '\040', '\060', '\012', '\060', '\040', '\157', '\040',
    '\060', '\012', '\144', '\040', '\164', '\162', '\040', '\060', '\012',
    '\156', '\040', '\164', '\162', '\040', '\060', '\012', '\303', '\261',
    '\040', '\146', '\151', '\040', '\060', '\012', '\165', '\040', '\164',
    '\151', '\040', '\060', '\012', '\303', '\261', '\040', '\164', '\151',
    '\040', '\060', '\012', '\144', '\040', '\164', '\151', '\040', '\060',
    '\012', '\144', '\040', '\164', '\303', '\255', '\040', '\060', '\012',
    '\144', '\040', '\162', '\303', '\255', '\040', '\060', '\012', '\141',
    '\040', '\303', '\240', '\040', '\060', '\012', '\145', '\040', '\303',
    '\250', '\040', '\060', '\012', '\156', '\040', '\151', '\152', '\040',
    '\060', '\012', '\147', '\040', '\151', '\152', '\040', '\060', '\012',
    '\157', '\040', '\303', '\262', '\040', '\060', '\012', '\105', '\040',
    '\303', '\211', '\040', '\060', '\012', '\105', '\040', '\303', '\210',
    '\040', '\060', '\012', '\165', '\040', '\303', '\274', '\040', '\060',
    '\012', '\170', '\156', '\105', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\131', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\164', '\105', '\040', '\156', '\164', '\040', '\061',
    '\012', '\124', '\154', '\142', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\170', '\116', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\152', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\160', '\106', '\040', '\151', '\152', '\040', '\061',
    '\012', '\131', '\162', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\141', '\161', '\131', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\166', '\112', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\142', '\114', '\040', '\142', '\145', '\040', '\061',
    '\012', '\116', '\166', '\153', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\112', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\167', '\170', '\103', '\040', '\167', '\141', '\040', '\061',
    '\012', '\143', '\165', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\172', '\164', '\040', '\164', '\141', '\040', '\061',
    '\012', '\161', '\113', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\163', '\143', '\112', '\040', '\163', '\164', '\040', '\061',
    '\012', '\160', '\130', '\160', '\040', '\160', '\157', '\040', '\061',
    '\012', '\126', '\161', '\151', '\040', '\164', '\151', '\040', '\061',
    '\012', '\125', '\170', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\153', '\112', '\166', '\040', '\153', '\141', '\040', '\061',
    '\012', '\131', '\153', '\144', '\040', '\153', '\141', '\040', '\061',
    '\012', '\166', '\160', '\130', '\040', '\166', '\141', '\040', '\061',
    '\012', '\151', '\102', '\166', '\040', '\164', '\151', '\040', '\061',
    '\012', '\172', '\122', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\124', '\155', '\040', '\155', '\151', '\040', '\061',
    '\012', '\155', '\113', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\126', '\172', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\164', '\160', '\040', '\164', '\151', '\040', '\061',
    '\012', '\155', '\166', '\104', '\040', '\166', '\141', '\040', '\061',
    '\012', '\155', '\104', '\161', '\040', '\155', '\145', '\040', '\061',
    '\012', '\152', '\170', '\120', '\040', '\151', '\152', '\040', '\061',
    '\012', '\102', '\170', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\157', '\111', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\166', '\143', '\040', '\166', '\141', '\040', '\061',
    '\012', '\165', '\103', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\101', '\157', '\040', '\166', '\157', '\040', '\061',
    '\012', '\161', '\165', '\102', '\040', '\164', '\165', '\040', '\061',
    '\012', '\142', '\164', '\126', '\040', '\164', '\151', '\040', '\061',
    '\012', '\114', '\155', '\143', '\040', '\155', '\145', '\040', '\061',
    '\012', '\164', '\126', '\167', '\040', '\164', '\151', '\040', '\061',
    '\012', '\131', '\170', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\110', '\170', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\144', '\126', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\131', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\120', '\152', '\040', '\164', '\165', '\040', '\061',
    '\012', '\146', '\124', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\122', '\152', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\144', '\101', '\040', '\144', '\151', '\040', '\061',
    '\012', '\152', '\172', '\116', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\170', '\114', '\040', '\155', '\145', '\040', '\061',
    '\012', '\171', '\147', '\112', '\040', '\156', '\147', '\040', '\061',
    '\012', '\126', '\166', '\147', '\040', '\166', '\141', '\040', '\061',
    '\012', '\162', '\152', '\113', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\165', '\126', '\040', '\164', '\165', '\040', '\061',
    '\012', '\163', '\127', '\153', '\040', '\153', '\165', '\040', '\061',
    '\012', '\120', '\147', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\110', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\153', '\125', '\040', '\153', '\165', '\040', '\061',
    '\012', '\147', '\166', '\107', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\144', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\126', '\142', '\040', '\155', '\145', '\040', '\061',
    '\012', '\121', '\147', '\144', '\040', '\144', '\151', '\040', '\061',
    '\012', '\172', '\143', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\161', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\163', '\112', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\146', '\116', '\040', '\144', '\151', '\040', '\061',
    '\012', '\144', '\147', '\127', '\040', '\144', '\151', '\040', '\061',
    '\012', '\167', '\116', '\162', '\040', '\162', '\151', '\040', '\061',
    '\012', '\172', '\166', '\103', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\131', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\110', '\171', '\040', '\164', '\165', '\040', '\061',
    '\012', '\164', '\116', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\170', '\112', '\040', '\154', '\151', '\040', '\061',
    '\012', '\110', '\142', '\153', '\040', '\153', '\165', '\040', '\061',
    '\012', '\170', '\163', '\107', '\040', '\163', '\164', '\040', '\061',
    '\012', '\166', '\123', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\106', '\142', '\040', '\142', '\165', '\040', '\061',
    '\012', '\116', '\164', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\102', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\153', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\126', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\152', '\124', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\166', '\130', '\040', '\166', '\141', '\040', '\061',
    '\012', '\157', '\132', '\146', '\040', '\164', '\157', '\040', '\061',
    '\012', '\153', '\143', '\125', '\040', '\153', '\157', '\040', '\061',
    '\012', '\146', '\106', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\130', '\142', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\113', '\161', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\122', '\167', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\166', '\112', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\156', '\112', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\161', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\170', '\115', '\040', '\160', '\157', '\040', '\061',
    '\012', '\145', '\102', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\112', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\170', '\156', '\115', '\040', '\156', '\147', '\040', '\061',
    '\012', '\141', '\103', '\161', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\110', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\146', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\161', '\156', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\123', '\163', '\040', '\151', '\163', '\040', '\061',
    '\012', '\163', '\102', '\167', '\040', '\163', '\164', '\040', '\061',
    '\012', '\106', '\150', '\156', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\116', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\115', '\166', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\142', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\110', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\114', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\147', '\106', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\170', '\127', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\144', '\131', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\162', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\105', '\146', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\161', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\172', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\150', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\150', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\106', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\126', '\143', '\040', '\166', '\141', '\040', '\061',
    '\012', '\154', '\115', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\124', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\101', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\151', '\115', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\116', '\154', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\142', '\120', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\126', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\145', '\121', '\154', '\040', '\164', '\145', '\040', '\061',
    '\012', '\163', '\127', '\142', '\040', '\163', '\164', '\040', '\061',
    '\012', '\102', '\161', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\130', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\166', '\125', '\143', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\117', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\165', '\110', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\116', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\106', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\115', '\154', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\153', '\155', '\132', '\040', '\153', '\141', '\040', '\061',
    '\012', '\163', '\122', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\146', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\170', '\121', '\040', '\166', '\141', '\040', '\061',
    '\012', '\154', '\103', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\131', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\164', '\146', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\144', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\121', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\144', '\130', '\040', '\144', '\145', '\040', '\061',
    '\012', '\155', '\116', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\153', '\106', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\152', '\123', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\120', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\167', '\143', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\116', '\152', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\126', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\161', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\112', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\160', '\110', '\040', '\160', '\157', '\040', '\061',
    '\012', '\170', '\161', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\126', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\102', '\164', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\155', '\102', '\040', '\156', '\164', '\040', '\061',
    '\012', '\172', '\143', '\115', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\146', '\107', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\146', '\117', '\040', '\155', '\145', '\040', '\061',
    '\012', '\131', '\150', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\132', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\155', '\172', '\102', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\122', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\171', '\104', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\147', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\161', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\111', '\165', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\142', '\127', '\040', '\145', '\162', '\040', '\061',
    '\012', '\112', '\155', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\166', '\152', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\143', '\104', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\147', '\103', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\103', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\127', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\167', '\127', '\040', '\167', '\141', '\040', '\061',
    '\012', '\112', '\153', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\107', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\142', '\110', '\040', '\166', '\141', '\040', '\061',
    '\012', '\154', '\124', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\145', '\103', '\142', '\040', '\145', '\162', '\040', '\061',
    '\012', '\152', '\126', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\104', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\157', '\121', '\040', '\160', '\157', '\040', '\061',
    '\012', '\161', '\164', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\122', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\110', '\166', '\147', '\040', '\166', '\141', '\040', '\061',
    '\012', '\165', '\101', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\146', '\127', '\040', '\155', '\145', '\040', '\061',
    '\012', '\164', '\147', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\161', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\146', '\131', '\040', '\163', '\172', '\040', '\061',
    '\012', '\131', '\150', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\161', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\160', '\113', '\040', '\160', '\162', '\040', '\061',
    '\012', '\112', '\172', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\121', '\153', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\152', '\117', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\170', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\120', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\116', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\166', '\121', '\040', '\166', '\141', '\040', '\061',
    '\012', '\153', '\107', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\165', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\166', '\171', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\131', '\145', '\040', '\164', '\145', '\040', '\061',
    '\012', '\146', '\132', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\131', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\150', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\170', '\131', '\040', '\146', '\157', '\040', '\061',
    '\012', '\171', '\120', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\146', '\107', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\155', '\124', '\040', '\155', '\145', '\040', '\061',
    '\012', '\166', '\146', '\130', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\121', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\170', '\123', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\172', '\101', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\141', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\142', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\153', '\126', '\144', '\040', '\153', '\141', '\040', '\061',
    '\012', '\130', '\152', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\153', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\121', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\150', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\104', '\166', '\152', '\040', '\166', '\141', '\040', '\061',
    '\012', '\126', '\142', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\146', '\160', '\116', '\040', '\160', '\162', '\040', '\061',
    '\012', '\160', '\153', '\107', '\040', '\153', '\141', '\040', '\061',
    '\012', '\142', '\114', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\112', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\167', '\112', '\040', '\167', '\141', '\040', '\061',
    '\012', '\132', '\162', '\167', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\144', '\127', '\040', '\144', '\145', '\040', '\061',
    '\012', '\127', '\147', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\120', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\147', '\116', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\110', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\124', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\104', '\166', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\155', '\125', '\040', '\155', '\145', '\040', '\061',
    '\012', '\170', '\150', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\103', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\167', '\126', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\166', '\114', '\040', '\166', '\141', '\040', '\061',
    '\012', '\156', '\107', '\146', '\040', '\156', '\164', '\040', '\061',
    '\012', '\152', '\152', '\103', '\040', '\151', '\152', '\040', '\061',
    '\012', '\125', '\143', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\127', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\152', '\170', '\107', '\040', '\151', '\152', '\040', '\061',
    '\012', '\115', '\161', '\156', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\166', '\127', '\040', '\166', '\141', '\040', '\061',
    '\012', '\154', '\127', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\155', '\144', '\117', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\116', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\167', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\146', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\165', '\117', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\150', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\114', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\102', '\171', '\040', '\146', '\157', '\040', '\061',
    '\012', '\156', '\125', '\152', '\040', '\156', '\164', '\040', '\061',
    '\012', '\154', '\124', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\154', '\120', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\162', '\122', '\040', '\145', '\162', '\040', '\061',
    '\012', '\162', '\130', '\167', '\040', '\145', '\162', '\040', '\061',
    '\012', '\145', '\126', '\167', '\040', '\166', '\145', '\040', '\061',
    '\012', '\172', '\127', '\156', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\112', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\115', '\147', '\171', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\132', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\124', '\144', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\161', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\104', '\150', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\155', '\113', '\040', '\155', '\145', '\040', '\061',
    '\012', '\123', '\163', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\127', '\154', '\040', '\163', '\172', '\040', '\061',
    '\012', '\151', '\161', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\152', '\107', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\152', '\102', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\113', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\166', '\111', '\040', '\166', '\141', '\040', '\061',
    '\012', '\164', '\143', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\153', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\125', '\145', '\040', '\164', '\145', '\040', '\061',
    '\012', '\154', '\125', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\102', '\147', '\040', '\156', '\164', '\040', '\061',
    '\012', '\144', '\110', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\127', '\142', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\165', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\110', '\160', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\157', '\126', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\102', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\124', '\144', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\146', '\126', '\040', '\160', '\162', '\040', '\061',
    '\012', '\161', '\147', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\143', '\125', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\143', '\116', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\153', '\101', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\121', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\172', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\160', '\106', '\040', '\160', '\162', '\040', '\061',
    '\012', '\166', '\102', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\120', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\155', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\127', '\146', '\040', '\166', '\145', '\040', '\061',
    '\012', '\152', '\132', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\110', '\167', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\171', '\171', '\111', '\040', '\156', '\171', '\040', '\061',
    '\012', '\132', '\146', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\114', '\147', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\161', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\117', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\153', '\112', '\040', '\153', '\157', '\040', '\061',
    '\012', '\144', '\161', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\142', '\127', '\040', '\151', '\163', '\040', '\061',
    '\012', '\172', '\115', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\112', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\115', '\143', '\040', '\153', '\157', '\040', '\061',
    '\012', '\172', '\161', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\121', '\153', '\040', '\166', '\141', '\040', '\061',
    '\012', '\145', '\161', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\106', '\156', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\143', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\107', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\153', '\172', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\132', '\170', '\040', '\170', '\145', '\040', '\061',
    '\012', '\161', '\166', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\153', '\131', '\040', '\153', '\141', '\040', '\061',
    '\012', '\142', '\162', '\110', '\040', '\145', '\162', '\040', '\061',
    '\012', '\127', '\162', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\152', '\105', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\152', '\121', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\114', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\147', '\105', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\167', '\111', '\040', '\167', '\141', '\040', '\061',
    '\012', '\151', '\104', '\167', '\040', '\164', '\151', '\040', '\061',
    '\012', '\102', '\164', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\120', '\172', '\040', '\166', '\141', '\040', '\061',
    '\012', '\171', '\161', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\106', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\154', '\121', '\171', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\102', '\160', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\144', '\131', '\040', '\144', '\145', '\040', '\061',
    '\012', '\164', '\166', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\152', '\117', '\040', '\154', '\145', '\040', '\061',
    '\012', '\116', '\163', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\144', '\117', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\172', '\127', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\164', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\146', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\132', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\143', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\166', '\121', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\110', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\142', '\115', '\040', '\142', '\145', '\040', '\061',
    '\012', '\156', '\127', '\147', '\040', '\156', '\164', '\040', '\061',
    '\012', '\131', '\167', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\130', '\167', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\170', '\113', '\040', '\160', '\162', '\040', '\061',
    '\012', '\171', '\142', '\121', '\040', '\142', '\145', '\040', '\061',
    '\012', '\127', '\166', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\114', '\147', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\164', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\122', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\161', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\103', '\156', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\155', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\144', '\166', '\120', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\161', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\152', '\111', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\126', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\166', '\132', '\040', '\166', '\141', '\040', '\061',
    '\012', '\103', '\167', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\125', '\171', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\106', '\146', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\157', '\130', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\150', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\127', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\162', '\130', '\040', '\166', '\141', '\040', '\061',
    '\012', '\145', '\117', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\167', '\132', '\040', '\142', '\145', '\040', '\061',
    '\012', '\144', '\156', '\126', '\040', '\156', '\147', '\040', '\061',
    '\012', '\107', '\142', '\167', '\040', '\142', '\145', '\040', '\061',
    '\012', '\170', '\107', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\155', '\156', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\160', '\116', '\040', '\160', '\162', '\040', '\061',
    '\012', '\144', '\172', '\130', '\040', '\144', '\145', '\040', '\061',
    '\012', '\102', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\160', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\161', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\124', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\167', '\120', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\144', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\167', '\130', '\040', '\167', '\141', '\040', '\061',
    '\012', '\125', '\166', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\162', '\113', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\163', '\144', '\106', '\040', '\144', '\145', '\040', '\061',
    '\012', '\112', '\143', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\172', '\117', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\124', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\152', '\120', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\124', '\156', '\040', '\156', '\147', '\040', '\061',
    '\012', '\107', '\164', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\147', '\101', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\144', '\114', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\172', '\117', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\150', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\155', '\160', '\040', '\155', '\145', '\040', '\061',
    '\012', '\121', '\144', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\131', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\142', '\112', '\040', '\160', '\162', '\040', '\061',
    '\012', '\152', '\122', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\130', '\163', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\147', '\111', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\150', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\147', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\106', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\167', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\170', '\127', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\103', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\143', '\114', '\040', '\143', '\150', '\040', '\061',
    '\012', '\113', '\170', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\155', '\131', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\162', '\121', '\164', '\040', '\145', '\162', '\040', '\061',
    '\012', '\132', '\170', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\144', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\167', '\110', '\040', '\144', '\145', '\040', '\061',
    '\012', '\131', '\155', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\126', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\166', '\154', '\040', '\166', '\141', '\040', '\061',
    '\012', '\171', '\110', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\127', '\152', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\115', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\172', '\125', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\143', '\114', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\117', '\141', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\161', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\151', '\131', '\160', '\040', '\164', '\151', '\040', '\061',
    '\012', '\166', '\103', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\157', '\126', '\040', '\162', '\157', '\040', '\061',
    '\012', '\146', '\132', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\161', '\121', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\144', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\127', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\153', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\106', '\160', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\107', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\162', '\167', '\117', '\040', '\145', '\162', '\040', '\061',
    '\012', '\121', '\172', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\161', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\147', '\124', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\163', '\132', '\040', '\163', '\172', '\040', '\061',
    '\012', '\141', '\110', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\152', '\114', '\040', '\151', '\152', '\040', '\061',
    '\012', '\131', '\143', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\156', '\120', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\127', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\171', '\131', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\122', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\167', '\165', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\152', '\102', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\162', '\124', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\167', '\112', '\040', '\166', '\141', '\040', '\061',
    '\012', '\144', '\126', '\152', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\166', '\127', '\040', '\166', '\141', '\040', '\061',
    '\012', '\144', '\132', '\153', '\040', '\144', '\145', '\040', '\061',
    '\012', '\156', '\162', '\107', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\163', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\120', '\166', '\163', '\040', '\166', '\141', '\040', '\061',
    '\012', '\154', '\114', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\103', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\166', '\126', '\040', '\144', '\145', '\040', '\061',
    '\012', '\120', '\152', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\113', '\155', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\112', '\146', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\167', '\131', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\167', '\103', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\107', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\127', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\160', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\113', '\153', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\127', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\152', '\155', '\116', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\160', '\126', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\172', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\132', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\155', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\116', '\153', '\040', '\155', '\145', '\040', '\061',
    '\012', '\171', '\160', '\115', '\040', '\160', '\162', '\040', '\061',
    '\012', '\154', '\167', '\110', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\110', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\172', '\103', '\040', '\152', '\157', '\040', '\061',
    '\012', '\157', '\112', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\114', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\130', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\105', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\165', '\127', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\166', '\124', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\163', '\107', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\123', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\113', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\171', '\145', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\110', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\103', '\167', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\172', '\155', '\112', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\165', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\144', '\110', '\040', '\144', '\145', '\040', '\061',
    '\012', '\120', '\142', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\144', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\126', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\161', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\116', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\172', '\116', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\152', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\150', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\160', '\112', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\115', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\124', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\164', '\114', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\147', '\122', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\121', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\122', '\152', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\150', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\103', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\142', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\170', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\126', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\153', '\131', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\120', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\121', '\153', '\040', '\151', '\152', '\040', '\061',
    '\012', '\117', '\166', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\126', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\155', '\125', '\040', '\155', '\145', '\040', '\061',
    '\012', '\165', '\106', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\141', '\132', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\107', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\147', '\111', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\124', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\166', '\103', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\107', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\162', '\116', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\121', '\164', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\116', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\120', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\112', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\144', '\152', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\151', '\167', '\131', '\040', '\164', '\151', '\040', '\061',
    '\012', '\116', '\155', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\124', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\161', '\172', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\152', '\101', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\166', '\110', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\114', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\127', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\126', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\121', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\166', '\131', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\114', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\161', '\172', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\104', '\170', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\172', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\126', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\132', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\160', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\143', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\110', '\170', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\164', '\125', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\113', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\151', '\107', '\170', '\040', '\164', '\151', '\040', '\061',
    '\012', '\170', '\166', '\121', '\040', '\166', '\141', '\040', '\061',
    '\012', '\154', '\170', '\101', '\040', '\154', '\145', '\040', '\061',
    '\012', '\163', '\152', '\110', '\040', '\163', '\164', '\040', '\061',
    '\012', '\107', '\161', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\147', '\121', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\104', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\132', '\156', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\146', '\125', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\165', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\121', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\150', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\114', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\144', '\131', '\040', '\144', '\145', '\040', '\061',
    '\012', '\162', '\132', '\142', '\040', '\145', '\162', '\040', '\061',
    '\012', '\153', '\104', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\163', '\113', '\040', '\163', '\172', '\040', '\061',
    '\012', '\113', '\161', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\127', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\155', '\126', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\155', '\143', '\126', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\104', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\101', '\157', '\040', '\154', '\145', '\040', '\061',
    '\012', '\146', '\172', '\122', '\040', '\163', '\172', '\040', '\061',
    '\012', '\130', '\162', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\162', '\132', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\155', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\156', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\150', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\161', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\127', '\156', '\040', '\144', '\145', '\040', '\061',
    '\012', '\127', '\155', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\122', '\147', '\171', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\166', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\151', '\131', '\040', '\164', '\151', '\040', '\061',
    '\012', '\170', '\127', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\112', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\157', '\110', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\166', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\131', '\144', '\156', '\040', '\144', '\145', '\040', '\061',
    '\012', '\116', '\166', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\155', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\170', '\132', '\040', '\170', '\145', '\040', '\061',
    '\012', '\130', '\144', '\146', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\131', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\156', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\116', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\127', '\156', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\167', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\127', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\121', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\126', '\170', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\170', '\167', '\107', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\166', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\155', '\126', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\172', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\103', '\160', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\107', '\171', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\170', '\172', '\101', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\107', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\142', '\161', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\150', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\120', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\151', '\161', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\152', '\113', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\126', '\153', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\167', '\124', '\040', '\145', '\162', '\040', '\061',
    '\012', '\126', '\150', '\156', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\146', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\142', '\156', '\112', '\040', '\141', '\156', '\040', '\061',
    '\012', '\103', '\160', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\116', '\155', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\156', '\117', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\127', '\143', '\040', '\161', '\165', '\040', '\061',
    '\012', '\141', '\126', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\117', '\156', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\154', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\156', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\114', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\164', '\105', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\147', '\122', '\040', '\156', '\147', '\040', '\061',
    '\012', '\131', '\161', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\110', '\167', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\156', '\127', '\153', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\161', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\101', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\150', '\132', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\172', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\116', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\124', '\153', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\165', '\131', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\143', '\122', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\116', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\153', '\110', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\142', '\112', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\152', '\104', '\040', '\151', '\152', '\040', '\061',
    '\012', '\116', '\154', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\150', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\130', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\156', '\167', '\102', '\040', '\141', '\156', '\040', '\061',
    '\012', '\110', '\172', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\121', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\113', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\126', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\154', '\125', '\040', '\154', '\145', '\040', '\061',
    '\012', '\114', '\172', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\130', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\102', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\111', '\161', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\152', '\126', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\170', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\172', '\113', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\104', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\165', '\121', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\107', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\142', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\125', '\157', '\040', '\153', '\141', '\040', '\061',
    '\012', '\144', '\126', '\155', '\040', '\144', '\145', '\040', '\061',
    '\012', '\104', '\144', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\161', '\103', '\040', '\166', '\157', '\040', '\061',
    '\012', '\152', '\153', '\132', '\040', '\151', '\152', '\040', '\061',
    '\012', '\114', '\166', '\172', '\040', '\166', '\141', '\040', '\061',
    '\012', '\164', '\120', '\171', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\146', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\150', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\150', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\161', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\103', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\152', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\146', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\167', '\106', '\040', '\163', '\172', '\040', '\061',
    '\012', '\106', '\167', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\160', '\166', '\125', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\150', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\124', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\154', '\121', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\172', '\114', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\161', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\164', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\150', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\152', '\102', '\040', '\151', '\152', '\040', '\061',
    '\012', '\151', '\124', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\153', '\114', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\122', '\161', '\151', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\152', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\152', '\111', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\107', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\156', '\126', '\040', '\141', '\156', '\040', '\061',
    '\012', '\154', '\121', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\165', '\166', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\147', '\145', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\112', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\131', '\144', '\142', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\104', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\167', '\126', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\116', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\167', '\121', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\122', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\126', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\156', '\113', '\147', '\040', '\141', '\156', '\040', '\061',
    '\012', '\124', '\147', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\131', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\154', '\102', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\152', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\101', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\155', '\113', '\040', '\155', '\145', '\040', '\061',
    '\012', '\167', '\161', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\152', '\124', '\040', '\166', '\141', '\040', '\061',
    '\012', '\114', '\161', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\156', '\103', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\172', '\131', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\161', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\107', '\142', '\040', '\155', '\145', '\040', '\061',
    '\012', '\146', '\153', '\120', '\040', '\153', '\141', '\040', '\061',
    '\012', '\167', '\121', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\106', '\161', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\126', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\127', '\143', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\160', '\131', '\040', '\167', '\141', '\040', '\061',
    '\012', '\154', '\106', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\167', '\104', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\127', '\160', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\152', '\124', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\106', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\111', '\160', '\040', '\151', '\156', '\040', '\061',
    '\012', '\164', '\142', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\161', '\143', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\153', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\145', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\120', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\167', '\114', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\110', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\170', '\167', '\120', '\040', '\167', '\141', '\040', '\061',
    '\012', '\170', '\166', '\102', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\123', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\172', '\106', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\131', '\160', '\040', '\167', '\141', '\040', '\061',
    '\012', '\144', '\104', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\156', '\102', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\116', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\125', '\142', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\170', '\130', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\122', '\154', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\102', '\172', '\040', '\144', '\145', '\040', '\061',
    '\012', '\130', '\166', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\154', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\155', '\167', '\131', '\040', '\155', '\145', '\040', '\061',
    '\012', '\167', '\150', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\115', '\172', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\101', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\104', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\152', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\126', '\153', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\165', '\107', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\102', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\114', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\146', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\120', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\157', '\116', '\040', '\157', '\156', '\040', '\061',
    '\012', '\131', '\144', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\114', '\170', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\143', '\143', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\112', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\126', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\162', '\105', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\147', '\120', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\120', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\145', '\165', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\132', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\156', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\102', '\147', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\154', '\121', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\170', '\101', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\114', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\156', '\104', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\130', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\164', '\146', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\167', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\127', '\144', '\040', '\144', '\157', '\040', '\061',
    '\012', '\170', '\156', '\110', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\117', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\114', '\153', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\116', '\166', '\171', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\111', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\153', '\113', '\040', '\153', '\141', '\040', '\061',
    '\012', '\162', '\115', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\162', '\155', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\120', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\101', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\121', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\110', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\120', '\155', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\172', '\112', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\124', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\127', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\132', '\167', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\113', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\107', '\142', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\115', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\116', '\146', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\146', '\101', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\144', '\110', '\142', '\040', '\144', '\145', '\040', '\061',
    '\012', '\154', '\170', '\110', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\161', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\124', '\154', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\152', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\111', '\171', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\157', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\150', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\115', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\146', '\172', '\106', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\162', '\122', '\040', '\145', '\162', '\040', '\061',
    '\012', '\171', '\116', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\141', '\120', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\167', '\107', '\040', '\167', '\141', '\040', '\061',
    '\012', '\103', '\155', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\163', '\166', '\113', '\040', '\166', '\141', '\040', '\061',
    '\012', '\163', '\162', '\117', '\040', '\145', '\162', '\040', '\061',
    '\012', '\125', '\150', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\120', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\124', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\172', '\110', '\040', '\163', '\172', '\040', '\061',
    '\012', '\111', '\157', '\170', '\040', '\157', '\156', '\040', '\061',
    '\012', '\146', '\121', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\132', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\156', '\161', '\125', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\120', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\124', '\172', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\156', '\122', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\146', '\112', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\171', '\130', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\114', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\152', '\120', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\155', '\122', '\040', '\155', '\145', '\040', '\061',
    '\012', '\145', '\120', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\171', '\124', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\152', '\120', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\163', '\110', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\167', '\102', '\040', '\166', '\141', '\040', '\061',
    '\012', '\131', '\156', '\162', '\040', '\141', '\156', '\040', '\061',
    '\012', '\124', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\114', '\166', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\164', '\103', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\160', '\102', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\130', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\150', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\131', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\104', '\160', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\147', '\122', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\146', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\112', '\171', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\120', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\141', '\117', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\132', '\167', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\146', '\106', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\142', '\104', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\113', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\110', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\150', '\162', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\106', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\114', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\141', '\131', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\103', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\127', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\144', '\131', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\167', '\111', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\114', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\115', '\172', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\113', '\153', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\115', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\143', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\152', '\102', '\040', '\151', '\152', '\040', '\061',
    '\012', '\115', '\161', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\170', '\127', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\132', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\146', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\167', '\104', '\040', '\167', '\141', '\040', '\061',
    '\012', '\154', '\150', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\126', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\146', '\127', '\040', '\166', '\141', '\040', '\061',
    '\012', '\154', '\170', '\120', '\040', '\154', '\145', '\040', '\061',
    '\012', '\131', '\171', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\120', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\125', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\144', '\117', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\122', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\130', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\147', '\126', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\101', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\167', '\130', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\113', '\166', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\163', '\166', '\114', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\127', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\144', '\162', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\114', '\160', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\113', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\103', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\167', '\110', '\040', '\167', '\141', '\040', '\061',
    '\012', '\143', '\166', '\103', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\125', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\157', '\120', '\170', '\040', '\157', '\156', '\040', '\061',
    '\012', '\164', '\152', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\102', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\166', '\160', '\111', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\172', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\157', '\132', '\163', '\040', '\157', '\156', '\040', '\061',
    '\012', '\160', '\113', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\113', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\143', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\146', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\163', '\166', '\115', '\040', '\166', '\141', '\040', '\061',
    '\012', '\126', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\154', '\126', '\167', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\127', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\130', '\160', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\154', '\143', '\101', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\114', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\104', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\130', '\152', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\144', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\113', '\155', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\156', '\127', '\040', '\141', '\156', '\040', '\061',
    '\012', '\124', '\143', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\147', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\132', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\112', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\131', '\170', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\153', '\146', '\115', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\113', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\115', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\144', '\147', '\131', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\107', '\144', '\040', '\156', '\147', '\040', '\061',
    '\012', '\126', '\143', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\123', '\146', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\170', '\104', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\124', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\122', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\117', '\141', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\165', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\147', '\112', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\122', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\153', '\131', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\167', '\104', '\040', '\167', '\141', '\040', '\061',
    '\012', '\166', '\130', '\163', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\154', '\103', '\040', '\154', '\145', '\040', '\061',
    '\012', '\153', '\155', '\110', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\150', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\170', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\166', '\164', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\127', '\155', '\040', '\151', '\156', '\040', '\061',
    '\012', '\161', '\126', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\110', '\152', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\120', '\170', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\131', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\167', '\147', '\107', '\040', '\156', '\147', '\040', '\061',
    '\012', '\112', '\166', '\163', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\110', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\172', '\171', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\152', '\111', '\040', '\151', '\152', '\040', '\061',
    '\012', '\165', '\126', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\120', '\172', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\170', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\120', '\171', '\040', '\167', '\141', '\040', '\061',
    '\012', '\142', '\130', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\172', '\131', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\161', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\170', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\146', '\102', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\120', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\142', '\160', '\103', '\040', '\160', '\162', '\040', '\061',
    '\012', '\150', '\106', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\103', '\161', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\167', '\111', '\040', '\144', '\145', '\040', '\061',
    '\012', '\124', '\143', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\132', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\117', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\112', '\146', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\151', '\132', '\162', '\040', '\151', '\156', '\040', '\061',
    '\012', '\126', '\170', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\114', '\160', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\110', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\106', '\171', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\143', '\104', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\115', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\171', '\125', '\040', '\156', '\171', '\040', '\061',
    '\012', '\155', '\107', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\112', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\113', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\115', '\155', '\040', '\154', '\145', '\040', '\061',
    '\012', '\155', '\161', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\110', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\154', '\107', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\145', '\111', '\152', '\040', '\164', '\145', '\040', '\061',
    '\012', '\126', '\144', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\103', '\153', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\121', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\167', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\172', '\125', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\132', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\116', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\104', '\170', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\131', '\162', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\113', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\104', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\156', '\106', '\040', '\141', '\156', '\040', '\061',
    '\012', '\114', '\163', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\110', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\103', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\156', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\102', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\152', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\117', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\161', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\146', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\143', '\152', '\123', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\146', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\166', '\111', '\040', '\166', '\141', '\040', '\061',
    '\012', '\117', '\167', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\147', '\130', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\157', '\103', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\115', '\162', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\111', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\112', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\161', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\161', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\120', '\172', '\040', '\145', '\162', '\040', '\061',
    '\012', '\151', '\167', '\127', '\040', '\151', '\156', '\040', '\061',
    '\012', '\143', '\115', '\160', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\124', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\111', '\167', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\170', '\154', '\132', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\152', '\121', '\040', '\166', '\141', '\040', '\061',
    '\012', '\151', '\120', '\142', '\040', '\151', '\156', '\040', '\061',
    '\012', '\127', '\150', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\166', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\172', '\104', '\040', '\163', '\172', '\040', '\061',
    '\012', '\110', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\161', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\150', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\162', '\122', '\040', '\145', '\162', '\040', '\061',
    '\012', '\156', '\154', '\126', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\131', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\126', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\160', '\117', '\040', '\166', '\141', '\040', '\061',
    '\012', '\122', '\166', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\163', '\143', '\131', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\144', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\114', '\153', '\040', '\166', '\141', '\040', '\061',
    '\012', '\163', '\166', '\111', '\040', '\166', '\141', '\040', '\061',
    '\012', '\155', '\144', '\105', '\040', '\144', '\145', '\040', '\061',
    '\012', '\150', '\102', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\162', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\152', '\127', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\124', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\131', '\160', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\115', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\143', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\103', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\146', '\126', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\141', '\120', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\160', '\125', '\040', '\160', '\162', '\040', '\061',
    '\012', '\126', '\153', '\142', '\040', '\153', '\141', '\040', '\061',
    '\012', '\164', '\142', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\121', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\170', '\126', '\040', '\156', '\147', '\040', '\061',
    '\012', '\123', '\146', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\131', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\127', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\105', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\155', '\130', '\171', '\040', '\155', '\145', '\040', '\061',
    '\012', '\154', '\156', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\155', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\153', '\171', '\040', '\153', '\141', '\040', '\061',
    '\012', '\167', '\167', '\130', '\040', '\167', '\141', '\040', '\061',
    '\012', '\125', '\167', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\143', '\146', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\107', '\170', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\160', '\114', '\040', '\160', '\162', '\040', '\061',
    '\012', '\152', '\124', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\132', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\154', '\113', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\102', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\161', '\151', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\107', '\163', '\040', '\154', '\145', '\040', '\061',
    '\012', '\104', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\147', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\103', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\116', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\161', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\154', '\104', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\130', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\130', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\153', '\150', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\132', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\123', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\110', '\167', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\146', '\130', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\147', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\144', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\150', '\143', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\112', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\155', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\166', '\126', '\040', '\166', '\141', '\040', '\061',
    '\012', '\116', '\161', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\170', '\123', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\107', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\106', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\172', '\115', '\040', '\163', '\172', '\040', '\061',
    '\012', '\130', '\162', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\144', '\143', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\121', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\116', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\170', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\167', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\102', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\162', '\113', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\144', '\103', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\101', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\144', '\114', '\164', '\040', '\163', '\164', '\040', '\061',
    '\012', '\160', '\147', '\106', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\147', '\127', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\160', '\116', '\040', '\166', '\141', '\040', '\061',
    '\012', '\111', '\166', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\131', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\122', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\120', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\117', '\161', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\152', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\160', '\110', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\104', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\146', '\112', '\040', '\146', '\157', '\040', '\061',
    '\012', '\146', '\161', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\102', '\146', '\040', '\145', '\162', '\040', '\061',
    '\012', '\132', '\153', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\110', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\101', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\116', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\146', '\152', '\130', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\161', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\152', '\113', '\040', '\154', '\145', '\040', '\061',
    '\012', '\107', '\153', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\142', '\123', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\115', '\170', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\104', '\161', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\113', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\106', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\155', '\112', '\040', '\155', '\145', '\040', '\061',
    '\012', '\166', '\172', '\124', '\040', '\166', '\141', '\040', '\061',
    '\012', '\162', '\150', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\110', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\112', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\161', '\127', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\166', '\153', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\153', '\102', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\105', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\125', '\147', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\155', '\171', '\040', '\155', '\145', '\040', '\061',
    '\012', '\114', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\107', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\154', '\110', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\107', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\106', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\156', '\126', '\040', '\141', '\156', '\040', '\061',
    '\012', '\145', '\106', '\171', '\040', '\145', '\162', '\040', '\061',
    '\012', '\116', '\146', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\150', '\123', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\130', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\110', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\165', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\130', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\143', '\124', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\112', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\127', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\161', '\160', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\161', '\105', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\146', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\162', '\111', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\147', '\113', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\171', '\120', '\040', '\156', '\171', '\040', '\061',
    '\012', '\132', '\155', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\114', '\153', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\145', '\125', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\162', '\131', '\040', '\145', '\162', '\040', '\061',
    '\012', '\153', '\106', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\125', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\154', '\132', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\156', '\126', '\040', '\143', '\150', '\040', '\061',
    '\012', '\141', '\120', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\152', '\105', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\132', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\165', '\106', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\156', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\106', '\160', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\146', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\156', '\103', '\040', '\141', '\156', '\040', '\061',
    '\012', '\104', '\154', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\162', '\115', '\040', '\145', '\162', '\040', '\061',
    '\012', '\163', '\146', '\102', '\040', '\163', '\172', '\040', '\061',
    '\012', '\107', '\170', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\106', '\153', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\107', '\153', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\122', '\155', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\127', '\146', '\040', '\145', '\162', '\040', '\061',
    '\012', '\162', '\131', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\105', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\110', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\123', '\155', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\154', '\106', '\160', '\040', '\154', '\145', '\040', '\061',
    '\012', '\153', '\104', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\123', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\162', '\114', '\167', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\156', '\132', '\040', '\141', '\156', '\040', '\061',
    '\012', '\127', '\152', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\124', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\143', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\113', '\163', '\040', '\166', '\141', '\040', '\061',
    '\012', '\142', '\143', '\113', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\167', '\171', '\040', '\166', '\141', '\040', '\061',
    '\012', '\125', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\166', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\144', '\143', '\126', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\126', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\165', '\111', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\154', '\116', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\167', '\114', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\127', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\120', '\170', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\162', '\122', '\142', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\146', '\104', '\040', '\142', '\145', '\040', '\061',
    '\012', '\171', '\103', '\170', '\040', '\156', '\171', '\040', '\061',
    '\012', '\156', '\112', '\163', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\103', '\155', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\142', '\107', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\103', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\155', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\145', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\156', '\123', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\167', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\127', '\152', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\155', '\111', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\152', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\167', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\112', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\143', '\156', '\101', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\102', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\147', '\106', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\104', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\147', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\125', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\104', '\156', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\110', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\167', '\130', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\171', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\153', '\104', '\040', '\153', '\141', '\040', '\061',
    '\012', '\163', '\114', '\172', '\040', '\163', '\164', '\040', '\061',
    '\012', '\172', '\170', '\106', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\115', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\154', '\122', '\040', '\154', '\145', '\040', '\061',
    '\012', '\160', '\167', '\132', '\040', '\160', '\162', '\040', '\061',
    '\012', '\160', '\131', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\146', '\114', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\164', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\124', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\144', '\103', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\167', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\170', '\103', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\146', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\114', '\156', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\131', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\160', '\127', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\111', '\170', '\040', '\157', '\156', '\040', '\061',
    '\012', '\171', '\167', '\105', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\116', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\167', '\117', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\132', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\107', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\143', '\126', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\152', '\113', '\040', '\151', '\152', '\040', '\061',
    '\012', '\107', '\172', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\167', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\102', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\124', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\110', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\163', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\105', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\162', '\113', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\115', '\142', '\040', '\155', '\145', '\040', '\061',
    '\012', '\160', '\110', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\143', '\152', '\116', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\130', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\167', '\117', '\040', '\167', '\141', '\040', '\061',
    '\012', '\146', '\154', '\102', '\040', '\154', '\145', '\040', '\061',
    '\012', '\121', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\113', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\106', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\146', '\107', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\146', '\102', '\040', '\167', '\141', '\040', '\061',
    '\012', '\112', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\167', '\113', '\040', '\167', '\141', '\040', '\061',
    '\012', '\150', '\150', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\125', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\106', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\153', '\124', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\114', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\150', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\155', '\126', '\040', '\155', '\145', '\040', '\061',
    '\012', '\164', '\155', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\122', '\164', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\171', '\131', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\171', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\122', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\130', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\132', '\156', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\161', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\115', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\167', '\126', '\040', '\156', '\147', '\040', '\061',
    '\012', '\120', '\142', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\143', '\115', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\120', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\167', '\125', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\112', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\171', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\130', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\142', '\163', '\132', '\040', '\163', '\172', '\040', '\061',
    '\012', '\102', '\161', '\151', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\107', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\156', '\116', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\131', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\124', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\155', '\120', '\040', '\155', '\145', '\040', '\061',
    '\012', '\152', '\160', '\132', '\040', '\151', '\152', '\040', '\061',
    '\012', '\115', '\161', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\152', '\115', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\126', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\165', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\102', '\153', '\040', '\145', '\162', '\040', '\061',
    '\012', '\152', '\165', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\105', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\127', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\172', '\110', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\114', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\116', '\143', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\146', '\116', '\040', '\153', '\141', '\040', '\061',
    '\012', '\165', '\125', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\103', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\103', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\125', '\171', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\102', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\152', '\102', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\104', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\155', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\164', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\143', '\123', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\120', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\121', '\155', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\172', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\143', '\114', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\162', '\111', '\040', '\145', '\162', '\040', '\061',
    '\012', '\144', '\166', '\116', '\040', '\166', '\141', '\040', '\061',
    '\012', '\103', '\167', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\150', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\172', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\144', '\117', '\040', '\144', '\145', '\040', '\061',
    '\012', '\102', '\161', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\114', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\154', '\170', '\146', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\131', '\153', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\123', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\153', '\123', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\113', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\120', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\120', '\155', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\154', '\127', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\165', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\143', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\172', '\121', '\040', '\163', '\172', '\040', '\061',
    '\012', '\107', '\172', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\145', '\120', '\155', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\167', '\127', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\167', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\121', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\170', '\120', '\040', '\142', '\145', '\040', '\061',
    '\012', '\144', '\155', '\104', '\040', '\144', '\145', '\040', '\061',
    '\012', '\141', '\167', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\126', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\142', '\167', '\131', '\040', '\167', '\141', '\040', '\061',
    '\012', '\132', '\170', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\150', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\131', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\103', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\146', '\121', '\040', '\156', '\171', '\040', '\061',
    '\012', '\172', '\107', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\166', '\105', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\103', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\157', '\120', '\146', '\040', '\157', '\156', '\040', '\061',
    '\012', '\172', '\130', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\150', '\166', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\172', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\146', '\130', '\040', '\155', '\145', '\040', '\061',
    '\012', '\144', '\120', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\114', '\162', '\146', '\040', '\145', '\162', '\040', '\061',
    '\012', '\154', '\162', '\107', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\131', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\150', '\116', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\101', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\170', '\121', '\040', '\163', '\164', '\040', '\061',
    '\012', '\153', '\124', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\117', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\144', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\167', '\113', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\121', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\104', '\161', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\127', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\170', '\105', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\130', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\166', '\102', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\130', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\103', '\161', '\151', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\172', '\127', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\122', '\146', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\132', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\156', '\106', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\141', '\107', '\040', '\141', '\156', '\040', '\061',
    '\012', '\102', '\161', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\115', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\110', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\114', '\152', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\115', '\167', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\160', '\172', '\113', '\040', '\163', '\172', '\040', '\061',
    '\012', '\155', '\120', '\142', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\152', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\122', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\132', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\156', '\161', '\107', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\126', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\152', '\103', '\040', '\151', '\152', '\040', '\061',
    '\012', '\165', '\110', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\104', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\161', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\147', '\125', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\112', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\172', '\156', '\113', '\040', '\141', '\156', '\040', '\061',
    '\012', '\162', '\150', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\104', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\112', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\153', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\156', '\112', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\122', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\172', '\101', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\121', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\124', '\170', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\142', '\153', '\107', '\040', '\153', '\141', '\040', '\061',
    '\012', '\171', '\167', '\132', '\040', '\167', '\141', '\040', '\061',
    '\012', '\172', '\127', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\150', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\155', '\106', '\040', '\156', '\147', '\040', '\061',
    '\012', '\163', '\146', '\121', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\155', '\107', '\040', '\163', '\172', '\040', '\061',
    '\012', '\117', '\147', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\165', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\101', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\104', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\126', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\122', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\170', '\155', '\115', '\040', '\155', '\145', '\040', '\061',
    '\012', '\160', '\170', '\102', '\040', '\160', '\162', '\040', '\061',
    '\012', '\172', '\164', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\172', '\112', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\106', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\126', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\156', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\107', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\144', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\126', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\115', '\150', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\161', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\110', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\167', '\103', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\153', '\107', '\040', '\166', '\141', '\040', '\061',
    '\012', '\130', '\153', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\164', '\122', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\166', '\126', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\167', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\150', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\167', '\117', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\121', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\162', '\122', '\040', '\143', '\150', '\040', '\061',
    '\012', '\115', '\162', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\121', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\102', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\125', '\171', '\040', '\166', '\141', '\040', '\061',
    '\012', '\164', '\167', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\147', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\116', '\170', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\150', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\160', '\130', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\166', '\104', '\040', '\166', '\141', '\040', '\061',
    '\012', '\103', '\166', '\171', '\040', '\166', '\141', '\040', '\061',
    '\012', '\157', '\110', '\152', '\040', '\157', '\156', '\040', '\061',
    '\012', '\121', '\161', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\131', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\150', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\132', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\171', '\113', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\170', '\131', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\143', '\125', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\105', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\130', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\155', '\154', '\121', '\040', '\154', '\145', '\040', '\061',
    '\012', '\107', '\147', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\114', '\160', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\170', '\125', '\040', '\156', '\171', '\040', '\061',
    '\012', '\147', '\166', '\112', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\161', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\163', '\116', '\040', '\163', '\172', '\040', '\061',
    '\012', '\111', '\152', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\142', '\112', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\115', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\153', '\130', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\162', '\124', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\117', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\160', '\107', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\107', '\153', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\103', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\161', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\104', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\156', '\121', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\144', '\126', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\147', '\123', '\040', '\156', '\147', '\040', '\061',
    '\012', '\124', '\161', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\105', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\132', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\131', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\120', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\150', '\147', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\120', '\166', '\171', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\170', '\113', '\040', '\146', '\157', '\040', '\061',
    '\012', '\110', '\167', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\170', '\122', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\144', '\155', '\120', '\040', '\144', '\145', '\040', '\061',
    '\012', '\155', '\143', '\131', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\170', '\122', '\040', '\142', '\145', '\040', '\061',
    '\012', '\114', '\163', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\122', '\154', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\167', '\121', '\040', '\151', '\156', '\040', '\061',
    '\012', '\127', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\146', '\126', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\167', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\160', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\155', '\162', '\117', '\040', '\145', '\162', '\040', '\061',
    '\012', '\151', '\106', '\143', '\040', '\164', '\151', '\040', '\061',
    '\012', '\167', '\172', '\104', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\142', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\146', '\123', '\040', '\146', '\157', '\040', '\061',
    '\012', '\120', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\131', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\154', '\104', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\164', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\172', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\152', '\113', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\104', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\156', '\103', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\103', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\170', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\115', '\166', '\040', '\157', '\156', '\040', '\061',
    '\012', '\143', '\147', '\131', '\040', '\143', '\150', '\040', '\061',
    '\012', '\127', '\161', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\153', '\121', '\040', '\153', '\141', '\040', '\061',
    '\012', '\164', '\161', '\117', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\156', '\103', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\107', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\102', '\146', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\131', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\160', '\143', '\114', '\040', '\143', '\150', '\040', '\061',
    '\012', '\106', '\147', '\160', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\164', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\150', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\125', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\156', '\116', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\124', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\163', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\141', '\112', '\147', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\121', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\107', '\156', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\155', '\115', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\161', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\152', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\156', '\170', '\110', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\144', '\117', '\040', '\143', '\150', '\040', '\061',
    '\012', '\141', '\101', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\125', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\130', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\102', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\147', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\132', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\112', '\153', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\160', '\166', '\104', '\040', '\166', '\141', '\040', '\061',
    '\012', '\142', '\155', '\124', '\040', '\155', '\145', '\040', '\061',
    '\012', '\157', '\131', '\170', '\040', '\157', '\156', '\040', '\061',
    '\012', '\150', '\167', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\152', '\102', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\131', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\151', '\110', '\170', '\040', '\151', '\156', '\040', '\061',
    '\012', '\154', '\131', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\103', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\146', '\150', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\104', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\103', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\170', '\102', '\040', '\154', '\145', '\040', '\061',
    '\012', '\145', '\130', '\152', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\166', '\127', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\143', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\124', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\161', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\116', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\153', '\115', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\122', '\166', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\156', '\111', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\167', '\103', '\040', '\167', '\141', '\040', '\061',
    '\012', '\172', '\161', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\121', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\170', '\162', '\103', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\106', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\157', '\145', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\114', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\167', '\124', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\167', '\104', '\040', '\167', '\141', '\040', '\061',
    '\012', '\166', '\160', '\105', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\154', '\131', '\040', '\154', '\145', '\040', '\061',
    '\012', '\163', '\122', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\123', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\165', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\162', '\111', '\040', '\145', '\162', '\040', '\061',
    '\012', '\131', '\163', '\156', '\040', '\163', '\164', '\040', '\061',
    '\012', '\126', '\150', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\103', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\147', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\120', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\153', '\102', '\040', '\153', '\141', '\040', '\061',
    '\012', '\164', '\122', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\141', '\152', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\143', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\104', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\121', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\145', '\125', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\143', '\115', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\126', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\122', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\106', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\142', '\127', '\040', '\142', '\145', '\040', '\061',
    '\012', '\165', '\125', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\116', '\150', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\153', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\127', '\164', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\115', '\172', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\160', '\124', '\040', '\151', '\156', '\040', '\061',
    '\012', '\130', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\167', '\116', '\040', '\167', '\141', '\040', '\061',
    '\012', '\150', '\130', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\114', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\107', '\170', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\144', '\104', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\102', '\146', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\146', '\153', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\117', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\104', '\144', '\153', '\040', '\144', '\145', '\040', '\061',
    '\012', '\116', '\152', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\152', '\112', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\150', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\167', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\171', '\127', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\156', '\106', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\114', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\161', '\142', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\155', '\130', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\156', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\121', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\172', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\116', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\160', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\102', '\170', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\147', '\107', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\154', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\151', '\110', '\161', '\040', '\151', '\156', '\040', '\061',
    '\012', '\163', '\167', '\116', '\040', '\163', '\172', '\040', '\061',
    '\012', '\116', '\152', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\120', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\157', '\122', '\166', '\040', '\157', '\156', '\040', '\061',
    '\012', '\160', '\112', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\132', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\166', '\126', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\126', '\142', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\106', '\146', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\172', '\121', '\040', '\163', '\172', '\040', '\061',
    '\012', '\107', '\166', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\120', '\147', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\120', '\160', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\103', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\153', '\116', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\142', '\155', '\104', '\040', '\155', '\145', '\040', '\061',
    '\012', '\155', '\127', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\154', '\106', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\151', '\130', '\040', '\151', '\156', '\040', '\061',
    '\012', '\171', '\122', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\154', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\146', '\132', '\040', '\163', '\172', '\040', '\061',
    '\012', '\127', '\146', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\166', '\162', '\117', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\170', '\124', '\040', '\156', '\147', '\040', '\061',
    '\012', '\154', '\167', '\105', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\144', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\160', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\121', '\160', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\132', '\156', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\146', '\112', '\040', '\142', '\145', '\040', '\061',
    '\012', '\161', '\121', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\101', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\141', '\161', '\127', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\161', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\167', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\116', '\156', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\114', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\127', '\164', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\143', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\152', '\122', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\127', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\132', '\155', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\132', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\131', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\126', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\130', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\167', '\112', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\167', '\132', '\040', '\151', '\152', '\040', '\061',
    '\012', '\154', '\167', '\114', '\040', '\154', '\145', '\040', '\061',
    '\012', '\145', '\107', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\123', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\102', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\163', '\123', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\156', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\116', '\156', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\155', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\123', '\161', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\146', '\121', '\040', '\146', '\157', '\040', '\061',
    '\012', '\126', '\143', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\155', '\104', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\131', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\101', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\156', '\142', '\127', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\112', '\155', '\040', '\156', '\147', '\040', '\061',
    '\012', '\112', '\167', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\170', '\112', '\040', '\155', '\145', '\040', '\061',
    '\012', '\170', '\142', '\103', '\040', '\142', '\145', '\040', '\061',
    '\012', '\122', '\142', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\132', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\112', '\171', '\040', '\142', '\145', '\040', '\061',
    '\012', '\130', '\171', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\153', '\126', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\157', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\143', '\125', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\132', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\120', '\155', '\040', '\145', '\162', '\040', '\061',
    '\012', '\162', '\107', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\154', '\143', '\114', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\103', '\147', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\103', '\164', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\145', '\107', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\122', '\172', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\121', '\150', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\114', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\126', '\161', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\144', '\112', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\126', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\164', '\114', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\146', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\170', '\126', '\040', '\167', '\141', '\040', '\061',
    '\012', '\171', '\122', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\131', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\150', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\114', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\132', '\166', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\166', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\143', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\115', '\167', '\160', '\040', '\167', '\141', '\040', '\061',
    '\012', '\143', '\124', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\130', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\121', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\112', '\142', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\171', '\146', '\107', '\040', '\156', '\171', '\040', '\061',
    '\012', '\160', '\150', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\152', '\110', '\040', '\156', '\147', '\040', '\061',
    '\012', '\127', '\144', '\147', '\040', '\144', '\145', '\040', '\061',
    '\012', '\160', '\120', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\102', '\167', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\156', '\102', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\167', '\112', '\040', '\167', '\141', '\040', '\061',
    '\012', '\165', '\164', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\152', '\103', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\126', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\124', '\155', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\115', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\113', '\147', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\156', '\122', '\144', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\115', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\152', '\121', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\131', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\131', '\152', '\040', '\163', '\164', '\040', '\061',
    '\012', '\152', '\116', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\130', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\172', '\102', '\040', '\163', '\172', '\040', '\061',
    '\012', '\123', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\164', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\131', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\147', '\154', '\124', '\040', '\156', '\147', '\040', '\061',
    '\012', '\125', '\165', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\117', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\151', '\102', '\170', '\040', '\151', '\156', '\040', '\061',
    '\012', '\122', '\161', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\127', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\110', '\143', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\116', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\121', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\151', '\110', '\144', '\040', '\151', '\156', '\040', '\061',
    '\012', '\127', '\160', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\156', '\146', '\131', '\040', '\141', '\156', '\040', '\061',
    '\012', '\122', '\153', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\113', '\161', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\146', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\153', '\162', '\103', '\040', '\145', '\162', '\040', '\061',
    '\012', '\127', '\150', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\152', '\115', '\040', '\154', '\145', '\040', '\061',
    '\012', '\171', '\170', '\107', '\040', '\156', '\171', '\040', '\061',
    '\012', '\146', '\160', '\127', '\040', '\160', '\162', '\040', '\061',
    '\012', '\142', '\143', '\106', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\162', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\165', '\104', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\172', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\167', '\120', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\114', '\146', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\102', '\153', '\160', '\040', '\153', '\141', '\040', '\061',
    '\012', '\130', '\153', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\170', '\110', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\111', '\152', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\124', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\105', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\161', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\154', '\104', '\040', '\154', '\145', '\040', '\061',
    '\012', '\164', '\106', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\116', '\146', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\106', '\161', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\124', '\172', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\112', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\111', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\106', '\142', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\172', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\126', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\126', '\161', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\161', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\144', '\112', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\111', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\132', '\156', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\153', '\113', '\040', '\151', '\152', '\040', '\061',
    '\012', '\162', '\146', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\153', '\111', '\040', '\153', '\165', '\040', '\061',
    '\012', '\146', '\111', '\157', '\040', '\162', '\157', '\040', '\061',
    '\012', '\154', '\161', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\160', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\160', '\101', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\162', '\162', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\111', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\104', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\157', '\110', '\170', '\040', '\157', '\156', '\040', '\061',
    '\012', '\167', '\112', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\103', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\166', '\102', '\040', '\166', '\141', '\040', '\061',
    '\012', '\171', '\161', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\114', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\106', '\172', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\132', '\146', '\040', '\144', '\145', '\040', '\061',
    '\012', '\116', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\122', '\156', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\124', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\126', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\106', '\144', '\155', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\146', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\167', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\120', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\170', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\106', '\166', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\132', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\126', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\102', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\130', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\120', '\154', '\167', '\040', '\154', '\145', '\040', '\061',
    '\012', '\116', '\154', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\103', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\113', '\167', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\112', '\161', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\107', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\165', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\172', '\114', '\040', '\163', '\172', '\040', '\061',
    '\012', '\151', '\106', '\170', '\040', '\151', '\156', '\040', '\061',
    '\012', '\146', '\124', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\171', '\127', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\110', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\106', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\155', '\161', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\141', '\121', '\153', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\104', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\142', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\160', '\147', '\112', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\153', '\116', '\040', '\153', '\141', '\040', '\061',
    '\012', '\160', '\102', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\102', '\144', '\166', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\155', '\127', '\040', '\151', '\152', '\040', '\061',
    '\012', '\112', '\166', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\130', '\160', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\121', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\144', '\107', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\153', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\123', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\106', '\144', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\147', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\144', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\116', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\146', '\101', '\040', '\144', '\145', '\040', '\061',
    '\012', '\110', '\172', '\171', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\127', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\170', '\110', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\170', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\150', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\121', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\160', '\167', '\124', '\040', '\160', '\162', '\040', '\061',
    '\012', '\114', '\167', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\172', '\104', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\170', '\113', '\040', '\153', '\141', '\040', '\061',
    '\012', '\155', '\164', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\150', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\167', '\122', '\040', '\167', '\141', '\040', '\061',
    '\012', '\152', '\111', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\127', '\172', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\161', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\154', '\132', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\115', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\167', '\160', '\122', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\110', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\141', '\117', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\153', '\125', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\122', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\152', '\130', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\165', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\155', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\165', '\112', '\040', '\157', '\165', '\040', '\061',
    '\012', '\171', '\127', '\170', '\040', '\156', '\171', '\040', '\061',
    '\012', '\150', '\125', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\172', '\120', '\040', '\166', '\141', '\040', '\061',
    '\012', '\162', '\123', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\147', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\172', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\152', '\102', '\040', '\163', '\172', '\040', '\061',
    '\012', '\123', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\146', '\101', '\040', '\146', '\157', '\040', '\061',
    '\012', '\146', '\110', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\153', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\144', '\106', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\127', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\142', '\101', '\040', '\151', '\152', '\040', '\061',
    '\012', '\102', '\155', '\142', '\040', '\155', '\145', '\040', '\061',
    '\012', '\171', '\152', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\170', '\132', '\040', '\145', '\162', '\040', '\061',
    '\012', '\126', '\155', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\151', '\111', '\161', '\040', '\151', '\156', '\040', '\061',
    '\012', '\127', '\147', '\154', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\122', '\160', '\040', '\155', '\145', '\040', '\061',
    '\012', '\167', '\166', '\123', '\040', '\166', '\141', '\040', '\061',
    '\012', '\125', '\166', '\171', '\040', '\166', '\141', '\040', '\061',
    '\012', '\171', '\160', '\121', '\040', '\160', '\162', '\040', '\061',
    '\012', '\166', '\106', '\167', '\040', '\166', '\157', '\040', '\061',
    '\012', '\146', '\161', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\167', '\112', '\040', '\163', '\164', '\040', '\061',
    '\012', '\112', '\162', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\170', '\105', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\132', '\153', '\040', '\154', '\145', '\040', '\061',
    '\012', '\146', '\126', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\150', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\150', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\123', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\121', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\110', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\165', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\160', '\107', '\040', '\151', '\152', '\040', '\061',
    '\012', '\120', '\153', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\121', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\106', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\107', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\163', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\167', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\171', '\121', '\040', '\156', '\171', '\040', '\061',
    '\012', '\144', '\161', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\110', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\115', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\113', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\114', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\155', '\117', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\102', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\160', '\152', '\121', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\132', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\111', '\165', '\040', '\165', '\156', '\040', '\061',
    '\012', '\171', '\143', '\131', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\104', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\171', '\112', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\111', '\163', '\170', '\040', '\163', '\164', '\040', '\061',
    '\012', '\121', '\161', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\153', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\103', '\160', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\131', '\166', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\152', '\107', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\107', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\144', '\155', '\040', '\144', '\145', '\040', '\061',
    '\012', '\150', '\102', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\170', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\131', '\167', '\142', '\040', '\157', '\167', '\040', '\061',
    '\012', '\126', '\164', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\152', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\104', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\165', '\107', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\166', '\106', '\040', '\166', '\141', '\040', '\061',
    '\012', '\165', '\161', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\167', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\102', '\147', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\156', '\125', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\160', '\111', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\113', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\130', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\114', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\131', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\170', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\110', '\150', '\171', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\160', '\112', '\040', '\160', '\162', '\040', '\061',
    '\012', '\143', '\126', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\126', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\112', '\172', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\156', '\104', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\152', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\132', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\161', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\106', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\116', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\106', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\110', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\122', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\170', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\160', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\156', '\115', '\153', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\152', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\150', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\160', '\104', '\040', '\160', '\162', '\040', '\061',
    '\012', '\104', '\146', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\171', '\117', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\150', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\126', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\156', '\113', '\143', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\153', '\112', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\167', '\123', '\040', '\143', '\150', '\040', '\061',
    '\012', '\157', '\104', '\146', '\040', '\157', '\156', '\040', '\061',
    '\012', '\155', '\153', '\131', '\040', '\153', '\141', '\040', '\061',
    '\012', '\147', '\144', '\126', '\040', '\156', '\147', '\040', '\061',
    '\012', '\130', '\150', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\125', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\141', '\112', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\121', '\170', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\172', '\123', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\125', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\124', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\110', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\170', '\113', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\142', '\106', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\127', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\161', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\155', '\110', '\040', '\144', '\145', '\040', '\061',
    '\012', '\124', '\164', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\121', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\106', '\150', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\143', '\131', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\163', '\122', '\040', '\163', '\164', '\040', '\061',
    '\012', '\151', '\127', '\147', '\040', '\151', '\156', '\040', '\061',
    '\012', '\130', '\171', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\130', '\152', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\170', '\160', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\154', '\172', '\131', '\040', '\154', '\145', '\040', '\061',
    '\012', '\160', '\172', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\126', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\111', '\152', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\166', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\156', '\142', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\144', '\110', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\104', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\161', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\146', '\125', '\040', '\156', '\171', '\040', '\061',
    '\012', '\161', '\157', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\153', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\113', '\143', '\153', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\125', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\127', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\102', '\146', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\162', '\121', '\152', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\145', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\160', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\161', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\172', '\117', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\152', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\124', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\122', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\144', '\121', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\142', '\121', '\040', '\167', '\141', '\040', '\061',
    '\012', '\121', '\160', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\111', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\170', '\116', '\040', '\156', '\171', '\040', '\061',
    '\012', '\156', '\103', '\153', '\040', '\141', '\156', '\040', '\061',
    '\012', '\112', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\105', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\144', '\105', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\103', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\121', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\113', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\124', '\152', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\132', '\143', '\171', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\155', '\122', '\040', '\153', '\141', '\040', '\061',
    '\012', '\143', '\124', '\160', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\161', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\166', '\132', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\114', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\157', '\111', '\167', '\040', '\157', '\156', '\040', '\061',
    '\012', '\170', '\152', '\107', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\164', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\143', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\147', '\124', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\161', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\165', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\163', '\131', '\040', '\163', '\164', '\040', '\061',
    '\012', '\152', '\103', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\142', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\161', '\110', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\152', '\172', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\147', '\122', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\151', '\130', '\040', '\151', '\156', '\040', '\061',
    '\012', '\161', '\156', '\117', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\155', '\116', '\040', '\155', '\145', '\040', '\061',
    '\012', '\167', '\147', '\110', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\142', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\153', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\160', '\172', '\103', '\040', '\160', '\157', '\040', '\061',
    '\012', '\154', '\146', '\130', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\102', '\165', '\040', '\165', '\156', '\040', '\061',
    '\012', '\155', '\114', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\160', '\155', '\131', '\040', '\155', '\145', '\040', '\061',
    '\012', '\170', '\161', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\152', '\131', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\162', '\110', '\040', '\145', '\162', '\040', '\061',
    '\012', '\111', '\165', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\146', '\104', '\040', '\156', '\171', '\040', '\061',
    '\012', '\143', '\154', '\107', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\144', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\145', '\124', '\144', '\040', '\145', '\162', '\040', '\061',
    '\012', '\154', '\130', '\166', '\040', '\154', '\145', '\040', '\061',
    '\012', '\153', '\160', '\126', '\040', '\153', '\141', '\040', '\061',
    '\012', '\163', '\132', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\170', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\155', '\112', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\153', '\105', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\125', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\103', '\161', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\103', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\170', '\121', '\040', '\160', '\162', '\040', '\061',
    '\012', '\131', '\167', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\167', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\127', '\152', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\161', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\124', '\160', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\132', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\144', '\110', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\165', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\126', '\155', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\152', '\131', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\150', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\146', '\104', '\040', '\167', '\141', '\040', '\061',
    '\012', '\132', '\152', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\151', '\120', '\166', '\040', '\151', '\156', '\040', '\061',
    '\012', '\155', '\172', '\127', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\130', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\105', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\117', '\172', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\105', '\160', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\104', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\132', '\154', '\167', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\142', '\122', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\103', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\157', '\131', '\040', '\157', '\156', '\040', '\061',
    '\012', '\160', '\153', '\124', '\040', '\153', '\141', '\040', '\061',
    '\012', '\153', '\142', '\111', '\040', '\153', '\141', '\040', '\061',
    '\012', '\150', '\144', '\127', '\040', '\144', '\145', '\040', '\061',
    '\012', '\110', '\163', '\170', '\040', '\163', '\164', '\040', '\061',
    '\012', '\172', '\160', '\130', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\146', '\126', '\040', '\163', '\172', '\040', '\061',
    '\012', '\104', '\150', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\115', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\150', '\172', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\114', '\167', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\172', '\155', '\116', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\152', '\121', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\153', '\113', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\102', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\142', '\144', '\105', '\040', '\144', '\145', '\040', '\061',
    '\012', '\121', '\170', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\161', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\150', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\131', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\150', '\105', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\142', '\106', '\040', '\143', '\150', '\040', '\061',
    '\012', '\112', '\156', '\142', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\170', '\116', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\131', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\150', '\112', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\122', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\156', '\123', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\114', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\102', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\161', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\123', '\144', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\145', '\132', '\040', '\145', '\162', '\040', '\061',
    '\012', '\112', '\167', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\144', '\120', '\146', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\116', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\153', '\111', '\142', '\040', '\153', '\141', '\040', '\061',
    '\012', '\143', '\142', '\114', '\040', '\143', '\150', '\040', '\061',
    '\012', '\121', '\144', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\115', '\146', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\152', '\112', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\155', '\170', '\131', '\040', '\155', '\145', '\040', '\061',
    '\012', '\154', '\106', '\144', '\040', '\154', '\145', '\040', '\061',
    '\012', '\164', '\167', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\106', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\143', '\162', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\122', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\110', '\164', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\131', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\162', '\126', '\143', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\122', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\126', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\160', '\101', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\154', '\131', '\040', '\154', '\145', '\040', '\061',
    '\012', '\163', '\116', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\113', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\164', '\166', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\152', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\167', '\120', '\040', '\155', '\145', '\040', '\061',
    '\012', '\112', '\171', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\164', '\102', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\123', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\115', '\154', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\152', '\112', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\131', '\172', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\120', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\161', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\106', '\166', '\040', '\163', '\164', '\040', '\061',
    '\012', '\170', '\153', '\110', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\132', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\150', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\167', '\116', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\152', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\121', '\155', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\115', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\143', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\112', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\124', '\155', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\155', '\121', '\040', '\153', '\141', '\040', '\061',
    '\012', '\127', '\154', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\131', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\145', '\112', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\124', '\153', '\142', '\040', '\153', '\141', '\040', '\061',
    '\012', '\150', '\146', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\170', '\131', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\104', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\143', '\116', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\121', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\157', '\150', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\122', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\142', '\126', '\040', '\154', '\145', '\040', '\061',
    '\012', '\154', '\113', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\170', '\102', '\040', '\167', '\141', '\040', '\061',
    '\012', '\114', '\167', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\146', '\161', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\153', '\132', '\040', '\153', '\141', '\040', '\061',
    '\012', '\151', '\167', '\117', '\040', '\151', '\156', '\040', '\061',
    '\012', '\144', '\147', '\125', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\166', '\117', '\040', '\144', '\145', '\040', '\061',
    '\012', '\160', '\104', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\166', '\113', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\154', '\126', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\130', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\153', '\106', '\040', '\153', '\165', '\040', '\061',
    '\012', '\151', '\171', '\124', '\040', '\151', '\156', '\040', '\061',
    '\012', '\125', '\146', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\156', '\172', '\125', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\142', '\110', '\040', '\142', '\165', '\040', '\061',
    '\012', '\154', '\123', '\142', '\040', '\154', '\145', '\040', '\061',
    '\012', '\130', '\160', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\125', '\166', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\171', '\171', '\106', '\040', '\156', '\171', '\040', '\061',
    '\012', '\146', '\170', '\120', '\040', '\146', '\157', '\040', '\061',
    '\012', '\152', '\131', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\152', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\170', '\114', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\167', '\111', '\040', '\160', '\162', '\040', '\061',
    '\012', '\152', '\125', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\162', '\106', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\163', '\106', '\040', '\163', '\164', '\040', '\061',
    '\012', '\143', '\144', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\167', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\144', '\110', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\131', '\163', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\106', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\111', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\111', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\124', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\146', '\105', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\122', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\150', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\115', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\160', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\170', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\120', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\156', '\142', '\102', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\153', '\121', '\040', '\163', '\164', '\040', '\061',
    '\012', '\165', '\113', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\121', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\153', '\127', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\167', '\161', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\167', '\101', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\112', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\150', '\143', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\146', '\113', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\130', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\147', '\101', '\040', '\143', '\150', '\040', '\061',
    '\012', '\120', '\152', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\114', '\161', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\167', '\103', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\152', '\116', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\153', '\120', '\040', '\153', '\141', '\040', '\061',
    '\012', '\122', '\161', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\107', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\120', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\142', '\124', '\040', '\153', '\141', '\040', '\061',
    '\012', '\153', '\160', '\121', '\040', '\153', '\141', '\040', '\061',
    '\012', '\115', '\172', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\152', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\153', '\104', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\167', '\122', '\040', '\151', '\152', '\040', '\061',
    '\012', '\127', '\171', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\170', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\107', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\166', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\116', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\103', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\154', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\102', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\155', '\112', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\106', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\104', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\146', '\103', '\040', '\160', '\162', '\040', '\061',
    '\012', '\114', '\160', '\171', '\040', '\160', '\162', '\040', '\061',
    '\012', '\106', '\150', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\170', '\123', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\127', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\106', '\147', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\156', '\106', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\170', '\106', '\040', '\143', '\150', '\040', '\061',
    '\012', '\141', '\126', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\123', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\152', '\172', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\156', '\103', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\162', '\132', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\116', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\156', '\166', '\127', '\040', '\141', '\156', '\040', '\061',
    '\012', '\121', '\171', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\106', '\150', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\107', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\114', '\160', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\114', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\113', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\112', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\152', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\156', '\121', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\156', '\160', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\151', '\117', '\040', '\151', '\156', '\040', '\061',
    '\012', '\166', '\166', '\107', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\117', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\150', '\105', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\144', '\116', '\040', '\144', '\145', '\040', '\061',
    '\012', '\103', '\172', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\152', '\125', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\126', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\143', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\166', '\110', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\164', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\111', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\152', '\121', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\106', '\171', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\160', '\125', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\170', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\142', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\166', '\112', '\040', '\163', '\164', '\040', '\061',
    '\012', '\166', '\152', '\127', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\160', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\156', '\122', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\121', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\103', '\166', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\153', '\102', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\147', '\102', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\146', '\104', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\110', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\144', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\124', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\154', '\124', '\155', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\147', '\102', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\170', '\123', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\120', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\160', '\121', '\040', '\160', '\162', '\040', '\061',
    '\012', '\171', '\170', '\127', '\040', '\156', '\171', '\040', '\061',
    '\012', '\110', '\152', '\153', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\116', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\143', '\156', '\112', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\110', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\166', '\110', '\040', '\151', '\152', '\040', '\061',
    '\012', '\107', '\147', '\156', '\040', '\156', '\147', '\040', '\061',
    '\012', '\154', '\142', '\123', '\040', '\154', '\145', '\040', '\061',
    '\012', '\121', '\143', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\161', '\122', '\040', '\143', '\150', '\040', '\061',
    '\012', '\112', '\171', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\122', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\156', '\146', '\101', '\040', '\141', '\156', '\040', '\061',
    '\012', '\154', '\130', '\167', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\155', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\163', '\167', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\121', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\163', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\111', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\152', '\132', '\040', '\151', '\152', '\040', '\061',
    '\012', '\114', '\154', '\142', '\040', '\154', '\145', '\040', '\061',
    '\012', '\155', '\115', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\154', '\126', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\160', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\155', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\170', '\115', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\107', '\167', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\121', '\152', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\154', '\161', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\112', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\153', '\171', '\040', '\153', '\141', '\040', '\061',
    '\012', '\150', '\104', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\114', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\131', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\103', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\155', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\124', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\153', '\106', '\040', '\153', '\141', '\040', '\061',
    '\012', '\150', '\106', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\156', '\102', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\171', '\112', '\040', '\156', '\171', '\040', '\061',
    '\012', '\156', '\111', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\131', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\127', '\161', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\161', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\131', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\121', '\144', '\172', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\142', '\116', '\040', '\142', '\145', '\040', '\061',
    '\012', '\161', '\167', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\142', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\167', '\164', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\121', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\112', '\153', '\040', '\151', '\152', '\040', '\061',
    '\012', '\116', '\172', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\144', '\103', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\116', '\146', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\110', '\147', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\143', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\166', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\163', '\170', '\112', '\040', '\163', '\164', '\040', '\061',
    '\012', '\167', '\115', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\106', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\107', '\172', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\146', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\144', '\121', '\040', '\144', '\145', '\040', '\061',
    '\012', '\130', '\147', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\153', '\111', '\040', '\153', '\141', '\040', '\061',
    '\012', '\160', '\166', '\113', '\040', '\166', '\141', '\040', '\061',
    '\012', '\103', '\161', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\106', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\157', '\110', '\155', '\040', '\157', '\156', '\040', '\061',
    '\012', '\141', '\112', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\106', '\172', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\127', '\153', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\155', '\105', '\040', '\155', '\145', '\040', '\061',
    '\012', '\163', '\115', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\164', '\102', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\116', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\121', '\144', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\150', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\101', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\162', '\115', '\040', '\145', '\162', '\040', '\061',
    '\012', '\162', '\110', '\167', '\040', '\145', '\162', '\040', '\061',
    '\012', '\114', '\166', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\122', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\152', '\126', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\122', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\153', '\126', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\127', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\131', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\124', '\171', '\040', '\166', '\141', '\040', '\061',
    '\012', '\144', '\170', '\126', '\040', '\144', '\145', '\040', '\061',
    '\012', '\155', '\113', '\171', '\040', '\155', '\145', '\040', '\061',
    '\012', '\121', '\154', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\160', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\121', '\160', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\167', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\171', '\130', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\124', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\156', '\124', '\040', '\141', '\156', '\040', '\061',
    '\012', '\126', '\154', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\161', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\144', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\130', '\161', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\104', '\146', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\157', '\145', '\117', '\040', '\157', '\156', '\040', '\061',
    '\012', '\156', '\103', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\154', '\130', '\144', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\110', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\101', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\131', '\142', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\172', '\104', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\107', '\153', '\040', '\144', '\145', '\040', '\061',
    '\012', '\160', '\154', '\110', '\040', '\154', '\145', '\040', '\061',
    '\012', '\154', '\170', '\107', '\040', '\154', '\145', '\040', '\061',
    '\012', '\110', '\147', '\160', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\122', '\172', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\124', '\163', '\040', '\144', '\145', '\040', '\061',
    '\012', '\155', '\103', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\154', '\110', '\146', '\040', '\154', '\145', '\040', '\061',
    '\012', '\154', '\114', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\164', '\116', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\113', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\147', '\107', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\154', '\121', '\040', '\154', '\145', '\040', '\061',
    '\012', '\131', '\171', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\104', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\130', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\172', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\105', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\154', '\150', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\172', '\115', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\161', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\143', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\142', '\106', '\040', '\142', '\145', '\040', '\061',
    '\012', '\130', '\163', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\114', '\156', '\143', '\040', '\141', '\156', '\040', '\061',
    '\012', '\107', '\161', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\152', '\117', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\150', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\147', '\110', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\127', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\113', '\146', '\040', '\156', '\171', '\040', '\061',
    '\012', '\165', '\121', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\167', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\170', '\107', '\040', '\144', '\145', '\040', '\061',
    '\012', '\131', '\161', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\113', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\127', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\143', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\146', '\131', '\040', '\167', '\141', '\040', '\061',
    '\012', '\162', '\102', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\112', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\131', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\123', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\121', '\166', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\160', '\106', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\143', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\146', '\113', '\040', '\156', '\171', '\040', '\061',
    '\012', '\152', '\121', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\147', '\124', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\167', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\120', '\156', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\132', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\120', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\165', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\170', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\151', '\130', '\162', '\040', '\151', '\156', '\040', '\061',
    '\012', '\160', '\143', '\105', '\040', '\143', '\150', '\040', '\061',
    '\012', '\116', '\161', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\152', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\172', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\155', '\106', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\166', '\127', '\040', '\166', '\141', '\040', '\061',
    '\012', '\145', '\112', '\167', '\040', '\145', '\162', '\040', '\061',
    '\012', '\111', '\161', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\130', '\171', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\146', '\127', '\040', '\167', '\141', '\040', '\061',
    '\012', '\126', '\144', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\112', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\120', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\102', '\152', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\114', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\144', '\127', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\121', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\172', '\127', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\167', '\121', '\040', '\166', '\141', '\040', '\061',
    '\012', '\162', '\167', '\125', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\120', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\106', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\166', '\110', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\127', '\154', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\147', '\117', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\114', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\153', '\142', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\102', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\104', '\150', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\147', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\160', '\101', '\040', '\160', '\162', '\040', '\061',
    '\012', '\172', '\170', '\103', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\146', '\123', '\040', '\156', '\147', '\040', '\061',
    '\012', '\115', '\166', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\165', '\120', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\161', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\161', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\115', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\167', '\161', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\162', '\112', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\144', '\116', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\167', '\122', '\040', '\160', '\162', '\040', '\061',
    '\012', '\150', '\115', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\120', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\126', '\142', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\172', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\116', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\112', '\142', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\124', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\132', '\146', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\106', '\172', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\143', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\145', '\113', '\146', '\040', '\145', '\162', '\040', '\061',
    '\012', '\160', '\161', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\160', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\152', '\153', '\106', '\040', '\151', '\152', '\040', '\061',
    '\012', '\126', '\170', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\150', '\107', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\102', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\143', '\124', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\115', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\132', '\166', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\153', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\111', '\146', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\144', '\122', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\132', '\154', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\113', '\167', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\116', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\144', '\131', '\171', '\040', '\144', '\145', '\040', '\061',
    '\012', '\150', '\132', '\154', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\164', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\120', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\153', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\112', '\154', '\167', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\116', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\162', '\127', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\127', '\144', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\130', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\121', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\146', '\106', '\040', '\151', '\152', '\040', '\061',
    '\012', '\105', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\107', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\132', '\152', '\172', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\144', '\115', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\154', '\106', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\170', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\132', '\147', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\143', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\154', '\105', '\040', '\154', '\145', '\040', '\061',
    '\012', '\156', '\131', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\127', '\146', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\112', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\142', '\166', '\106', '\040', '\166', '\141', '\040', '\061',
    '\012', '\110', '\156', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\127', '\153', '\166', '\040', '\153', '\141', '\040', '\061',
    '\012', '\115', '\166', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\104', '\170', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\102', '\166', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\115', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\122', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\166', '\114', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\107', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\106', '\160', '\040', '\155', '\145', '\040', '\061',
    '\012', '\147', '\116', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\103', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\106', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\113', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\112', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\172', '\111', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\147', '\107', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\113', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\161', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\170', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\166', '\107', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\147', '\106', '\040', '\156', '\147', '\040', '\061',
    '\012', '\130', '\170', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\114', '\167', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\154', '\130', '\040', '\154', '\145', '\040', '\061',
    '\012', '\154', '\120', '\172', '\040', '\154', '\145', '\040', '\061',
    '\012', '\127', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\172', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\165', '\110', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\106', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\166', '\126', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\130', '\145', '\040', '\154', '\145', '\040', '\061',
    '\012', '\132', '\146', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\111', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\142', '\102', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\132', '\146', '\040', '\156', '\171', '\040', '\061',
    '\012', '\163', '\113', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\160', '\114', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\113', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\111', '\142', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\151', '\121', '\142', '\040', '\151', '\156', '\040', '\061',
    '\012', '\106', '\170', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\160', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\127', '\166', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\172', '\104', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\153', '\124', '\040', '\153', '\141', '\040', '\061',
    '\012', '\131', '\153', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\152', '\107', '\040', '\141', '\156', '\040', '\061',
    '\012', '\125', '\166', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\146', '\124', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\143', '\111', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\104', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\144', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\115', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\112', '\142', '\171', '\040', '\142', '\145', '\040', '\061',
    '\012', '\154', '\167', '\112', '\040', '\154', '\145', '\040', '\061',
    '\012', '\163', '\127', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\123', '\166', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\156', '\162', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\166', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\126', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\164', '\161', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\126', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\153', '\121', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\146', '\142', '\107', '\040', '\142', '\145', '\040', '\061',
    '\012', '\162', '\161', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\110', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\150', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\172', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\106', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\121', '\160', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\101', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\170', '\120', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\103', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\141', '\115', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\154', '\131', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\124', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\102', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\143', '\121', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\122', '\142', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\126', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\107', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\144', '\116', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\146', '\116', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\120', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\143', '\111', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\170', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\110', '\142', '\040', '\145', '\162', '\040', '\061',
    '\012', '\160', '\126', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\162', '\126', '\152', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\147', '\123', '\040', '\156', '\147', '\040', '\061',
    '\012', '\106', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\115', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\121', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\132', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\102', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\167', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\110', '\146', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\172', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\143', '\124', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\106', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\143', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\146', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\161', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\146', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\152', '\125', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\150', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\127', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\161', '\105', '\040', '\151', '\156', '\040', '\061',
    '\012', '\147', '\160', '\125', '\040', '\156', '\147', '\040', '\061',
    '\012', '\151', '\127', '\142', '\040', '\151', '\156', '\040', '\061',
    '\012', '\164', '\154', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\131', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\103', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\157', '\113', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\123', '\147', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\166', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\146', '\131', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\142', '\115', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\166', '\101', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\110', '\160', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\166', '\113', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\160', '\132', '\040', '\160', '\162', '\040', '\061',
    '\012', '\144', '\146', '\130', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\162', '\113', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\145', '\105', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\153', '\131', '\040', '\153', '\141', '\040', '\061',
    '\012', '\163', '\142', '\130', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\143', '\123', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\113', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\154', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\132', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\127', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\144', '\114', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\166', '\107', '\040', '\151', '\152', '\040', '\061',
    '\012', '\115', '\147', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\167', '\106', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\144', '\120', '\040', '\144', '\145', '\040', '\061',
    '\012', '\165', '\115', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\143', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\162', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\115', '\164', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\121', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\110', '\160', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\172', '\160', '\111', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\153', '\122', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\150', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\123', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\106', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\165', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\171', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\107', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\131', '\172', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\142', '\103', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\123', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\163', '\132', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\122', '\172', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\106', '\154', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\142', '\161', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\143', '\110', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\155', '\107', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\103', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\141', '\104', '\040', '\141', '\156', '\040', '\061',
    '\012', '\151', '\167', '\110', '\040', '\151', '\156', '\040', '\061',
    '\012', '\161', '\104', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\107', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\130', '\150', '\171', '\040', '\164', '\150', '\040', '\061',
    '\012', '\145', '\126', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\153', '\112', '\040', '\167', '\141', '\040', '\061',
    '\012', '\114', '\143', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\147', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\104', '\150', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\146', '\117', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\126', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\155', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\117', '\167', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\132', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\156', '\116', '\040', '\141', '\156', '\040', '\061',
    '\012', '\115', '\172', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\155', '\131', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\171', '\114', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\170', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\167', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\124', '\170', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\113', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\142', '\152', '\130', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\142', '\123', '\040', '\160', '\162', '\040', '\061',
    '\012', '\172', '\162', '\120', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\112', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\147', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\167', '\131', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\130', '\153', '\040', '\145', '\162', '\040', '\061',
    '\012', '\156', '\104', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\107', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\155', '\121', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\160', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\114', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\126', '\146', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\167', '\103', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\147', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\132', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\152', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\141', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\162', '\107', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\112', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\112', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\115', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\121', '\143', '\163', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\153', '\113', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\116', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\162', '\131', '\040', '\145', '\162', '\040', '\061',
    '\012', '\130', '\167', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\162', '\132', '\154', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\170', '\125', '\040', '\156', '\147', '\040', '\061',
    '\012', '\114', '\156', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\147', '\103', '\040', '\156', '\147', '\040', '\061',
    '\012', '\104', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\114', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\156', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\152', '\125', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\166', '\117', '\040', '\166', '\141', '\040', '\061',
    '\012', '\157', '\126', '\155', '\040', '\157', '\156', '\040', '\061',
    '\012', '\166', '\127', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\107', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\142', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\123', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\112', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\112', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\157', '\121', '\166', '\040', '\157', '\156', '\040', '\061',
    '\012', '\126', '\167', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\156', '\125', '\040', '\141', '\156', '\040', '\061',
    '\012', '\116', '\155', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\124', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\105', '\144', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\165', '\161', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\162', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\156', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\112', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\153', '\104', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\150', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\114', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\153', '\125', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\161', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\131', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\106', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\142', '\121', '\040', '\142', '\145', '\040', '\061',
    '\012', '\166', '\143', '\123', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\161', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\153', '\106', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\106', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\160', '\105', '\040', '\153', '\141', '\040', '\061',
    '\012', '\107', '\170', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\132', '\164', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\111', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\153', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\144', '\126', '\040', '\144', '\145', '\040', '\061',
    '\012', '\162', '\167', '\120', '\040', '\145', '\162', '\040', '\061',
    '\012', '\141', '\103', '\147', '\040', '\141', '\156', '\040', '\061',
    '\012', '\132', '\162', '\163', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\155', '\127', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\146', '\117', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\102', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\142', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\104', '\170', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\144', '\104', '\040', '\144', '\145', '\040', '\061',
    '\012', '\156', '\102', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\154', '\162', '\126', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\121', '\161', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\154', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\164', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\161', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\122', '\155', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\126', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\103', '\162', '\161', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\106', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\130', '\152', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\103', '\155', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\127', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\172', '\117', '\040', '\151', '\152', '\040', '\061',
    '\012', '\115', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\164', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\107', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\153', '\107', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\114', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\127', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\143', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\126', '\160', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\127', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\130', '\172', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\127', '\153', '\142', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\172', '\110', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\165', '\120', '\040', '\165', '\156', '\040', '\061',
    '\012', '\144', '\110', '\166', '\040', '\144', '\145', '\040', '\061',
    '\012', '\104', '\155', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\104', '\147', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\147', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\164', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\115', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\110', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\132', '\146', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\132', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\152', '\153', '\110', '\040', '\151', '\152', '\040', '\061',
    '\012', '\162', '\116', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\115', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\160', '\106', '\040', '\160', '\162', '\040', '\061',
    '\012', '\144', '\152', '\104', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\170', '\126', '\040', '\142', '\145', '\040', '\061',
    '\012', '\150', '\147', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\120', '\153', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\104', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\115', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\144', '\107', '\152', '\040', '\144', '\145', '\040', '\061',
    '\012', '\153', '\142', '\110', '\040', '\153', '\141', '\040', '\061',
    '\012', '\114', '\150', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\104', '\166', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\162', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\111', '\152', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\165', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\167', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\150', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\143', '\122', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\150', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\147', '\120', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\153', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\161', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\170', '\131', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\126', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\154', '\113', '\144', '\040', '\154', '\145', '\040', '\061',
    '\012', '\116', '\154', '\171', '\040', '\154', '\145', '\040', '\061',
    '\012', '\171', '\113', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\102', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\121', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\153', '\131', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\121', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\166', '\127', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\107', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\171', '\164', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\166', '\125', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\152', '\172', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\126', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\121', '\142', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\161', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\167', '\165', '\040', '\153', '\165', '\040', '\061',
    '\012', '\121', '\167', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\144', '\143', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\150', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\155', '\123', '\040', '\156', '\147', '\040', '\061',
    '\012', '\111', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\132', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\114', '\156', '\040', '\164', '\150', '\040', '\061',
    '\012', '\145', '\115', '\146', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\116', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\120', '\155', '\040', '\165', '\155', '\040', '\061',
    '\012', '\160', '\115', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\172', '\127', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\122', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\172', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\142', '\117', '\040', '\142', '\145', '\040', '\061',
    '\012', '\130', '\170', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\156', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\102', '\166', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\152', '\132', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\143', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\155', '\102', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\106', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\170', '\102', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\102', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\126', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\142', '\157', '\121', '\040', '\157', '\156', '\040', '\061',
    '\012', '\170', '\157', '\110', '\040', '\157', '\156', '\040', '\061',
    '\012', '\144', '\127', '\147', '\040', '\144', '\145', '\040', '\061',
    '\012', '\124', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\116', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\131', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\104', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\154', '\167', '\107', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\104', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\144', '\171', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\156', '\132', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\172', '\125', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\113', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\166', '\103', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\165', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\156', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\103', '\171', '\040', '\166', '\141', '\040', '\061',
    '\012', '\125', '\144', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\142', '\124', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\142', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\142', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\104', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\127', '\150', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\142', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\146', '\117', '\040', '\164', '\150', '\040', '\061',
    '\012', '\124', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\142', '\127', '\040', '\144', '\145', '\040', '\061',
    '\012', '\102', '\144', '\171', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\152', '\122', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\142', '\103', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\165', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\103', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\127', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\122', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\142', '\127', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\166', '\132', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\144', '\112', '\152', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\132', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\147', '\161', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\142', '\110', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\112', '\154', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\150', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\126', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\126', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\103', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\157', '\131', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\167', '\110', '\040', '\153', '\141', '\040', '\061',
    '\012', '\166', '\167', '\116', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\146', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\154', '\117', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\164', '\130', '\040', '\164', '\151', '\040', '\061',
    '\012', '\144', '\113', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\121', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\104', '\154', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\126', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\160', '\116', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\153', '\107', '\040', '\153', '\141', '\040', '\061',
    '\012', '\145', '\161', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\144', '\104', '\040', '\144', '\151', '\040', '\061',
    '\012', '\146', '\121', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\131', '\150', '\154', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\102', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\105', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\150', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\147', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\114', '\163', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\146', '\112', '\040', '\144', '\145', '\040', '\061',
    '\012', '\132', '\144', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\162', '\132', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\132', '\150', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\164', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\170', '\121', '\040', '\163', '\172', '\040', '\061',
    '\012', '\126', '\156', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\110', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\131', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\102', '\161', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\162', '\126', '\040', '\145', '\162', '\040', '\061',
    '\012', '\131', '\143', '\163', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\122', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\151', '\127', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\126', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\132', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\103', '\161', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\146', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\162', '\102', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\117', '\152', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\107', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\132', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\106', '\166', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\132', '\147', '\163', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\146', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\167', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\131', '\162', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\151', '\106', '\160', '\040', '\151', '\156', '\040', '\061',
    '\012', '\142', '\126', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\172', '\146', '\115', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\144', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\107', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\164', '\156', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\144', '\122', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\102', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\172', '\103', '\040', '\156', '\147', '\040', '\061',
    '\012', '\120', '\167', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\101', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\156', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\147', '\124', '\040', '\156', '\147', '\040', '\061',
    '\012', '\157', '\101', '\167', '\040', '\153', '\157', '\040', '\061',
    '\012', '\170', '\102', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\144', '\116', '\146', '\040', '\144', '\145', '\040', '\061',
    '\012', '\120', '\161', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\116', '\160', '\144', '\040', '\144', '\151', '\040', '\061',
    '\012', '\157', '\125', '\171', '\040', '\153', '\157', '\040', '\061',
    '\012', '\146', '\160', '\104', '\040', '\160', '\162', '\040', '\061',
    '\012', '\122', '\146', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\154', '\130', '\155', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\127', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\127', '\166', '\040', '\166', '\151', '\040', '\061',
    '\012', '\106', '\167', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\114', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\166', '\121', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\147', '\102', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\112', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\127', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\130', '\166', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\104', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\144', '\120', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\126', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\120', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\144', '\167', '\101', '\040', '\144', '\145', '\040', '\061',
    '\012', '\117', '\161', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\151', '\132', '\040', '\151', '\156', '\040', '\061',
    '\012', '\170', '\144', '\126', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\106', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\172', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\167', '\114', '\040', '\167', '\141', '\040', '\061',
    '\012', '\163', '\127', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\124', '\160', '\171', '\040', '\160', '\162', '\040', '\061',
    '\012', '\167', '\142', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\165', '\120', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\113', '\156', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\151', '\165', '\117', '\040', '\151', '\156', '\040', '\061',
    '\012', '\121', '\144', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\131', '\146', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\165', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\114', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\112', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\116', '\146', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\131', '\161', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\163', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\172', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\111', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\163', '\121', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\147', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\123', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\170', '\121', '\040', '\146', '\157', '\040', '\061',
    '\012', '\150', '\143', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\142', '\112', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\122', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\143', '\171', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\132', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\130', '\172', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\147', '\122', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\154', '\117', '\040', '\154', '\145', '\040', '\061',
    '\012', '\164', '\103', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\155', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\132', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\142', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\104', '\147', '\161', '\040', '\156', '\147', '\040', '\061',
    '\012', '\126', '\153', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\161', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\115', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\125', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\147', '\103', '\040', '\156', '\147', '\040', '\061',
    '\012', '\163', '\142', '\104', '\040', '\163', '\172', '\040', '\061',
    '\012', '\123', '\161', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\115', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\102', '\172', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\111', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\126', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\112', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\152', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\110', '\155', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\141', '\121', '\144', '\040', '\141', '\156', '\040', '\061',
    '\012', '\151', '\110', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\115', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\167', '\127', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\165', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\103', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\156', '\120', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\114', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\122', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\115', '\166', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\155', '\122', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\146', '\112', '\040', '\156', '\171', '\040', '\061',
    '\012', '\170', '\103', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\163', '\121', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\165', '\103', '\040', '\165', '\156', '\040', '\061',
    '\012', '\103', '\164', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\120', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\152', '\111', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\155', '\103', '\040', '\155', '\145', '\040', '\061',
    '\012', '\170', '\144', '\112', '\040', '\144', '\145', '\040', '\061',
    '\012', '\156', '\130', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\163', '\117', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\122', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\142', '\106', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\116', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\153', '\110', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\167', '\115', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\170', '\104', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\150', '\151', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\161', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\156', '\114', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\113', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\151', '\161', '\116', '\040', '\151', '\156', '\040', '\061',
    '\012', '\144', '\153', '\130', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\121', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\116', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\124', '\154', '\153', '\040', '\154', '\145', '\040', '\061',
    '\012', '\116', '\154', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\103', '\170', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\115', '\161', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\120', '\166', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\167', '\132', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\107', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\156', '\162', '\106', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\153', '\123', '\040', '\153', '\141', '\040', '\061',
    '\012', '\144', '\122', '\166', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\112', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\151', '\161', '\106', '\040', '\151', '\156', '\040', '\061',
    '\012', '\146', '\107', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\170', '\127', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\163', '\127', '\040', '\163', '\172', '\040', '\061',
    '\012', '\155', '\146', '\121', '\040', '\155', '\145', '\040', '\061',
    '\012', '\146', '\147', '\120', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\154', '\110', '\040', '\154', '\145', '\040', '\061',
    '\012', '\156', '\162', '\111', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\130', '\166', '\040', '\153', '\141', '\040', '\061',
    '\012', '\126', '\160', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\115', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\110', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\152', '\144', '\115', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\161', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\103', '\153', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\113', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\172', '\107', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\111', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\116', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\152', '\131', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\167', '\114', '\040', '\167', '\141', '\040', '\061',
    '\012', '\144', '\132', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\147', '\106', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\130', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\166', '\132', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\103', '\164', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\161', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\117', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\147', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\127', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\147', '\162', '\106', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\156', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\125', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\160', '\155', '\103', '\040', '\155', '\145', '\040', '\061',
    '\012', '\165', '\172', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\111', '\166', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\166', '\111', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\156', '\132', '\040', '\141', '\156', '\040', '\061',
    '\012', '\154', '\170', '\132', '\040', '\154', '\145', '\040', '\061',
    '\012', '\130', '\167', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\104', '\161', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\113', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\126', '\167', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\123', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\110', '\167', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\171', '\116', '\170', '\040', '\156', '\171', '\040', '\061',
    '\012', '\171', '\157', '\121', '\040', '\157', '\156', '\040', '\061',
    '\012', '\143', '\123', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\105', '\166', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\111', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\146', '\132', '\040', '\144', '\145', '\040', '\061',
    '\012', '\150', '\172', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\102', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\153', '\161', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\102', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\154', '\112', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\152', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\162', '\127', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\141', '\104', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\104', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\114', '\170', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\121', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\112', '\164', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\122', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\146', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\142', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\132', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\163', '\162', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\112', '\161', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\106', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\116', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\122', '\153', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\160', '\172', '\112', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\142', '\101', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\102', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\113', '\171', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\143', '\117', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\130', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\126', '\163', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\131', '\155', '\040', '\145', '\162', '\040', '\061',
    '\012', '\153', '\126', '\155', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\143', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\172', '\103', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\113', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\120', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\143', '\114', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\152', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\170', '\125', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\142', '\124', '\040', '\142', '\145', '\040', '\061',
    '\012', '\156', '\166', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\155', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\170', '\114', '\040', '\142', '\145', '\040', '\061',
    '\012', '\130', '\167', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\152', '\123', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\154', '\116', '\146', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\124', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\106', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\114', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\162', '\130', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\130', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\166', '\105', '\040', '\163', '\172', '\040', '\061',
    '\012', '\110', '\167', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\106', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\147', '\122', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\104', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\117', '\161', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\126', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\164', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\167', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\146', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\120', '\143', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\160', '\117', '\040', '\160', '\162', '\040', '\061',
    '\012', '\103', '\167', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\170', '\117', '\040', '\167', '\141', '\040', '\061',
    '\012', '\142', '\126', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\106', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\156', '\106', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\170', '\110', '\040', '\153', '\141', '\040', '\061',
    '\012', '\131', '\167', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\144', '\104', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\127', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\124', '\154', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\155', '\127', '\040', '\153', '\141', '\040', '\061',
    '\012', '\155', '\150', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\172', '\124', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\166', '\112', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\143', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\153', '\123', '\040', '\153', '\141', '\040', '\061',
    '\012', '\163', '\130', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\163', '\103', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\116', '\164', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\110', '\150', '\040', '\154', '\157', '\040', '\061',
    '\012', '\131', '\166', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\126', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\153', '\105', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\146', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\127', '\155', '\040', '\157', '\156', '\040', '\061',
    '\012', '\164', '\115', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\131', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\106', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\121', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\121', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\113', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\113', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\165', '\114', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\111', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\162', '\110', '\040', '\145', '\162', '\040', '\061',
    '\012', '\160', '\147', '\114', '\040', '\156', '\147', '\040', '\061',
    '\012', '\114', '\142', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\152', '\106', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\106', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\144', '\130', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\124', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\112', '\167', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\154', '\170', '\125', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\152', '\101', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\120', '\147', '\040', '\151', '\156', '\040', '\061',
    '\012', '\130', '\156', '\163', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\153', '\127', '\040', '\153', '\141', '\040', '\061',
    '\012', '\160', '\146', '\120', '\040', '\160', '\162', '\040', '\061',
    '\012', '\104', '\171', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\127', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\172', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\152', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\167', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\116', '\167', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\142', '\102', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\167', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\164', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\154', '\130', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\132', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\131', '\155', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\167', '\146', '\130', '\040', '\167', '\141', '\040', '\061',
    '\012', '\126', '\161', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\161', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\125', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\152', '\172', '\124', '\040', '\152', '\157', '\040', '\061',
    '\012', '\153', '\116', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\155', '\121', '\040', '\155', '\145', '\040', '\061',
    '\012', '\144', '\130', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\171', '\154', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\127', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\166', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\150', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\112', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\142', '\124', '\040', '\160', '\162', '\040', '\061',
    '\012', '\141', '\102', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\122', '\150', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\101', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\102', '\147', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\161', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\144', '\103', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\102', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\143', '\130', '\153', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\155', '\115', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\122', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\110', '\153', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\150', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\171', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\153', '\107', '\155', '\040', '\153', '\141', '\040', '\061',
    '\012', '\163', '\107', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\113', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\104', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\114', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\112', '\163', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\116', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\127', '\147', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\155', '\114', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\106', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\142', '\104', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\124', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\167', '\130', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\122', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\101', '\172', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\121', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\121', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\157', '\132', '\040', '\157', '\156', '\040', '\061',
    '\012', '\152', '\120', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\171', '\107', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\130', '\152', '\040', '\153', '\141', '\040', '\061',
    '\012', '\171', '\102', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\156', '\167', '\120', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\156', '\101', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\113', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\161', '\142', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\107', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\152', '\107', '\040', '\151', '\152', '\040', '\061',
    '\012', '\113', '\161', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\123', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\163', '\127', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\104', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\110', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\131', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\172', '\162', '\127', '\040', '\145', '\162', '\040', '\061',
    '\012', '\154', '\104', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\121', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\102', '\144', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\161', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\121', '\155', '\040', '\157', '\156', '\040', '\061',
    '\012', '\121', '\163', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\115', '\146', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\142', '\121', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\165', '\122', '\040', '\165', '\156', '\040', '\061',
    '\012', '\143', '\115', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\161', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\130', '\146', '\040', '\144', '\145', '\040', '\061',
    '\012', '\162', '\110', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\150', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\116', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\110', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\124', '\160', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\152', '\131', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\112', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\103', '\153', '\040', '\154', '\145', '\040', '\061',
    '\012', '\120', '\146', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\117', '\161', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\155', '\122', '\040', '\155', '\145', '\040', '\061',
    '\012', '\121', '\160', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\116', '\143', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\131', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\146', '\101', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\162', '\123', '\040', '\145', '\162', '\040', '\061',
    '\012', '\107', '\160', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\152', '\155', '\104', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\167', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\122', '\142', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\150', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\130', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\131', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\126', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\103', '\172', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\115', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\160', '\113', '\040', '\160', '\162', '\040', '\061',
    '\012', '\150', '\126', '\171', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\143', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\117', '\153', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\112', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\114', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\156', '\131', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\156', '\160', '\106', '\040', '\157', '\156', '\040', '\061',
    '\012', '\162', '\127', '\153', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\143', '\120', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\132', '\155', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\131', '\142', '\040', '\146', '\157', '\040', '\061',
    '\012', '\172', '\142', '\103', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\102', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\152', '\171', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\111', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\164', '\167', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\147', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\103', '\172', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\164', '\117', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\122', '\154', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\171', '\103', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\105', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\155', '\110', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\164', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\111', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\152', '\111', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\142', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\167', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\161', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\146', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\146', '\127', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\127', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\127', '\160', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\115', '\147', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\123', '\146', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\131', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\143', '\111', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\154', '\124', '\040', '\154', '\145', '\040', '\061',
    '\012', '\107', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\103', '\155', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\110', '\146', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\102', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\103', '\146', '\040', '\156', '\171', '\040', '\061',
    '\012', '\161', '\172', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\144', '\106', '\040', '\144', '\145', '\040', '\061',
    '\012', '\126', '\144', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\112', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\146', '\122', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\154', '\126', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\117', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\156', '\146', '\106', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\124', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\107', '\153', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\101', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\166', '\146', '\106', '\040', '\166', '\141', '\040', '\061',
    '\012', '\104', '\172', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\106', '\160', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\124', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\156', '\116', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\143', '\116', '\040', '\143', '\150', '\040', '\061',
    '\012', '\112', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\113', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\162', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\155', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\115', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\146', '\122', '\040', '\146', '\157', '\040', '\061',
    '\012', '\167', '\121', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\161', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\125', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\157', '\151', '\125', '\040', '\151', '\156', '\040', '\061',
    '\012', '\161', '\163', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\107', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\164', '\117', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\120', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\122', '\161', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\153', '\130', '\040', '\153', '\141', '\040', '\061',
    '\012', '\127', '\163', '\142', '\040', '\163', '\164', '\040', '\061',
    '\012', '\143', '\170', '\122', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\132', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\171', '\121', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\151', '\125', '\040', '\151', '\156', '\040', '\061',
    '\012', '\170', '\166', '\127', '\040', '\166', '\141', '\040', '\061',
    '\012', '\141', '\104', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\121', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\170', '\103', '\040', '\151', '\152', '\040', '\061',
    '\012', '\124', '\167', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\163', '\121', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\102', '\146', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\141', '\107', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\120', '\147', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\110', '\172', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\147', '\127', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\144', '\106', '\040', '\144', '\145', '\040', '\061',
    '\012', '\153', '\142', '\131', '\040', '\153', '\141', '\040', '\061',
    '\012', '\121', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\110', '\170', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\126', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\170', '\132', '\040', '\141', '\156', '\040', '\061',
    '\012', '\157', '\126', '\144', '\040', '\157', '\156', '\040', '\061',
    '\012', '\110', '\154', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\113', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\101', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\144', '\116', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\160', '\161', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\111', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\155', '\127', '\040', '\155', '\145', '\040', '\061',
    '\012', '\171', '\143', '\113', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\121', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\150', '\155', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\154', '\106', '\040', '\141', '\156', '\040', '\061',
    '\012', '\107', '\153', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\102', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\150', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\156', '\153', '\040', '\141', '\156', '\040', '\061',
    '\012', '\126', '\146', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\156', '\102', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\166', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\141', '\161', '\116', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\114', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\112', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\164', '\121', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\127', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\167', '\127', '\040', '\167', '\141', '\040', '\061',
    '\012', '\166', '\172', '\102', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\171', '\122', '\040', '\156', '\171', '\040', '\061',
    '\012', '\161', '\161', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\171', '\111', '\040', '\156', '\171', '\040', '\061',
    '\012', '\152', '\172', '\112', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\147', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\147', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\114', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\161', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\156', '\162', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\110', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\141', '\121', '\147', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\106', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\152', '\121', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\160', '\104', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\172', '\116', '\040', '\163', '\172', '\040', '\061',
    '\012', '\151', '\111', '\167', '\040', '\151', '\156', '\040', '\061',
    '\012', '\144', '\121', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\121', '\171', '\040', '\160', '\162', '\040', '\061',
    '\012', '\130', '\171', '\170', '\040', '\156', '\171', '\040', '\061',
    '\012', '\163', '\127', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\106', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\160', '\106', '\040', '\160', '\162', '\040', '\061',
    '\012', '\126', '\163', '\166', '\040', '\163', '\164', '\040', '\061',
    '\012', '\121', '\161', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\172', '\124', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\161', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\172', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\157', '\106', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\153', '\112', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\153', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\114', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\155', '\125', '\040', '\155', '\145', '\040', '\061',
    '\012', '\143', '\162', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\154', '\130', '\040', '\154', '\145', '\040', '\061',
    '\012', '\124', '\172', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\142', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\160', '\111', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\103', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\106', '\155', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\121', '\150', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\121', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\122', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\131', '\143', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\152', '\120', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\165', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\111', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\153', '\127', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\112', '\167', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\126', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\152', '\161', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\172', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\103', '\167', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\105', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\162', '\130', '\040', '\145', '\162', '\040', '\061',
    '\012', '\113', '\161', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\154', '\131', '\166', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\107', '\166', '\040', '\144', '\145', '\040', '\061',
    '\012', '\103', '\167', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\156', '\104', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\117', '\152', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\104', '\156', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\162', '\106', '\040', '\145', '\162', '\040', '\061',
    '\012', '\112', '\155', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\146', '\111', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\161', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\166', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\156', '\120', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\141', '\126', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\102', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\153', '\126', '\142', '\040', '\153', '\141', '\040', '\061',
    '\012', '\147', '\143', '\110', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\142', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\122', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\121', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\110', '\170', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\104', '\156', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\127', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\107', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\147', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\167', '\120', '\040', '\167', '\141', '\040', '\061',
    '\012', '\156', '\162', '\127', '\040', '\141', '\156', '\040', '\061',
    '\012', '\151', '\126', '\161', '\040', '\144', '\151', '\040', '\061',
    '\012', '\170', '\172', '\105', '\040', '\163', '\172', '\040', '\061',
    '\012', '\126', '\170', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\114', '\172', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\112', '\167', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\147', '\103', '\161', '\040', '\156', '\147', '\040', '\061',
    '\012', '\117', '\164', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\166', '\120', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\116', '\162', '\040', '\143', '\150', '\040', '\061',
    '\012', '\151', '\130', '\161', '\040', '\151', '\156', '\040', '\061',
    '\012', '\121', '\156', '\154', '\040', '\151', '\156', '\040', '\061',
    '\012', '\164', '\120', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\111', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\141', '\120', '\147', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\166', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\161', '\117', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\161', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\152', '\121', '\040', '\151', '\152', '\040', '\061',
    '\012', '\154', '\167', '\121', '\040', '\154', '\145', '\040', '\061',
    '\012', '\160', '\105', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\127', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\163', '\167', '\124', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\155', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\122', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\132', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\115', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\154', '\170', '\117', '\040', '\154', '\145', '\040', '\061',
    '\012', '\153', '\142', '\121', '\040', '\153', '\141', '\040', '\061',
    '\012', '\171', '\146', '\116', '\040', '\156', '\171', '\040', '\061',
    '\012', '\171', '\155', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\160', '\113', '\040', '\151', '\152', '\040', '\061',
    '\012', '\127', '\152', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\155', '\127', '\040', '\155', '\145', '\040', '\061',
    '\012', '\162', '\113', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\144', '\154', '\110', '\040', '\154', '\145', '\040', '\061',
    '\012', '\153', '\143', '\113', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\142', '\126', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\116', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\110', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\154', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\102', '\166', '\040', '\154', '\145', '\040', '\061',
    '\012', '\157', '\141', '\106', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\146', '\115', '\040', '\146', '\157', '\040', '\061',
    '\012', '\162', '\132', '\144', '\040', '\145', '\162', '\040', '\061',
    '\012', '\152', '\147', '\127', '\040', '\156', '\147', '\040', '\061',
    '\012', '\110', '\166', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\153', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\143', '\104', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\114', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\121', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\150', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\166', '\121', '\040', '\151', '\156', '\040', '\061',
    '\012', '\125', '\153', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\160', '\126', '\040', '\160', '\162', '\040', '\061',
    '\012', '\142', '\112', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\141', '\120', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\144', '\113', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\107', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\114', '\152', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\150', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\106', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\146', '\111', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\150', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\165', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\106', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\147', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\106', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\155', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\132', '\160', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\156', '\106', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\102', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\147', '\111', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\102', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\125', '\167', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\162', '\115', '\040', '\145', '\162', '\040', '\061',
    '\012', '\171', '\102', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\122', '\154', '\146', '\040', '\154', '\145', '\040', '\061',
    '\012', '\120', '\172', '\150', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\132', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\126', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\170', '\112', '\040', '\144', '\145', '\040', '\061',
    '\012', '\114', '\143', '\172', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\106', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\111', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\164', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\142', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\110', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\162', '\131', '\040', '\145', '\162', '\040', '\061',
    '\012', '\164', '\102', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\113', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\116', '\153', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\103', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\171', '\130', '\040', '\142', '\145', '\040', '\061',
    '\012', '\157', '\102', '\160', '\040', '\157', '\156', '\040', '\061',
    '\012', '\127', '\152', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\146', '\120', '\040', '\163', '\172', '\040', '\061',
    '\012', '\141', '\121', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\156', '\146', '\127', '\040', '\141', '\156', '\040', '\061',
    '\012', '\156', '\130', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\112', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\141', '\123', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\151', '\122', '\146', '\040', '\151', '\156', '\040', '\061',
    '\012', '\171', '\115', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\102', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\170', '\122', '\040', '\166', '\141', '\040', '\061',
    '\012', '\114', '\154', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\171', '\107', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\112', '\163', '\171', '\040', '\163', '\172', '\040', '\061',
    '\012', '\114', '\166', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\145', '\106', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\142', '\115', '\040', '\167', '\141', '\040', '\061',
    '\012', '\165', '\117', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\127', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\142', '\166', '\125', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\156', '\117', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\172', '\111', '\040', '\163', '\172', '\040', '\061',
    '\012', '\126', '\143', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\150', '\105', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\147', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\147', '\120', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\142', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\132', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\130', '\164', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\131', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\144', '\113', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\172', '\102', '\040', '\163', '\172', '\040', '\061',
    '\012', '\131', '\171', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\125', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\102', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\161', '\152', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\130', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\130', '\161', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\124', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\162', '\105', '\040', '\145', '\162', '\040', '\061',
    '\012', '\163', '\116', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\132', '\150', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\126', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\107', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\112', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\124', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\150', '\105', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\121', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\124', '\155', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\170', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\172', '\105', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\115', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\103', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\167', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\126', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\154', '\122', '\153', '\040', '\154', '\145', '\040', '\061',
    '\012', '\117', '\167', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\131', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\121', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\116', '\154', '\146', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\104', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\110', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\143', '\152', '\101', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\147', '\125', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\121', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\171', '\116', '\146', '\040', '\156', '\171', '\040', '\061',
    '\012', '\154', '\167', '\132', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\107', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\126', '\155', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\160', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\106', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\110', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\142', '\123', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\105', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\145', '\167', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\145', '\127', '\144', '\040', '\145', '\162', '\040', '\061',
    '\012', '\152', '\146', '\122', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\160', '\131', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\166', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\130', '\162', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\112', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\105', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\116', '\170', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\115', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\107', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\171', '\121', '\040', '\160', '\162', '\040', '\061',
    '\012', '\152', '\160', '\125', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\157', '\101', '\040', '\157', '\156', '\040', '\061',
    '\012', '\147', '\130', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\161', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\130', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\154', '\120', '\040', '\154', '\145', '\040', '\061',
    '\012', '\114', '\172', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\170', '\102', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\112', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\143', '\124', '\040', '\143', '\150', '\040', '\061',
    '\012', '\127', '\164', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\114', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\125', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\156', '\106', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\112', '\163', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\102', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\106', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\166', '\103', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\106', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\161', '\156', '\101', '\040', '\141', '\156', '\040', '\061',
    '\012', '\132', '\142', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\120', '\172', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\163', '\112', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\132', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\146', '\120', '\040', '\156', '\171', '\040', '\061',
    '\012', '\147', '\131', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\146', '\103', '\040', '\142', '\145', '\040', '\061',
    '\012', '\144', '\115', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\150', '\154', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\122', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\152', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\152', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\121', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\124', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\125', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\161', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\154', '\122', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\161', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\167', '\122', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\115', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\172', '\153', '\124', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\161', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\154', '\122', '\040', '\141', '\156', '\040', '\061',
    '\012', '\110', '\161', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\141', '\141', '\112', '\040', '\141', '\156', '\040', '\061',
    '\012', '\154', '\113', '\167', '\040', '\154', '\145', '\040', '\061',
    '\012', '\142', '\172', '\102', '\040', '\163', '\172', '\040', '\061',
    '\012', '\126', '\147', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\141', '\126', '\155', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\156', '\122', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\170', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\172', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\172', '\170', '\126', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\147', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\166', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\167', '\116', '\040', '\151', '\152', '\040', '\061',
    '\012', '\105', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\102', '\170', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\172', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\146', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\120', '\160', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\101', '\161', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\112', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\172', '\106', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\146', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\172', '\126', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\147', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\163', '\123', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\121', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\153', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\150', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\112', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\117', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\162', '\161', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\131', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\106', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\116', '\143', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\115', '\167', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\152', '\111', '\040', '\143', '\150', '\040', '\061',
    '\012', '\112', '\143', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\105', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\145', '\121', '\171', '\040', '\145', '\162', '\040', '\061',
    '\012', '\123', '\170', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\125', '\170', '\040', '\155', '\142', '\040', '\061',
    '\012', '\172', '\144', '\112', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\160', '\116', '\040', '\154', '\145', '\040', '\061',
    '\012', '\122', '\153', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\166', '\111', '\040', '\166', '\141', '\040', '\061',
    '\012', '\121', '\155', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\147', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\146', '\105', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\143', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\154', '\124', '\040', '\154', '\145', '\040', '\061',
    '\012', '\142', '\142', '\126', '\040', '\142', '\145', '\040', '\061',
    '\012', '\160', '\155', '\132', '\040', '\155', '\145', '\040', '\061',
    '\012', '\165', '\161', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\131', '\171', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\155', '\131', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\154', '\102', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\116', '\144', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\166', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\166', '\114', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\114', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\143', '\107', '\040', '\143', '\150', '\040', '\061',
    '\012', '\121', '\152', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\156', '\161', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\170', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\141', '\161', '\111', '\040', '\141', '\156', '\040', '\061',
    '\012', '\113', '\161', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\130', '\161', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\166', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\161', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\110', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\110', '\143', '\040', '\141', '\156', '\040', '\061',
    '\012', '\125', '\161', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\146', '\116', '\040', '\163', '\172', '\040', '\061',
    '\012', '\155', '\130', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\147', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\104', '\163', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\122', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\142', '\132', '\040', '\167', '\141', '\040', '\061',
    '\012', '\110', '\156', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\125', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\143', '\131', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\124', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\102', '\147', '\161', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\103', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\130', '\155', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\152', '\112', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\144', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\150', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\106', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\153', '\121', '\040', '\144', '\145', '\040', '\061',
    '\012', '\114', '\143', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\111', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\111', '\167', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\152', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\142', '\130', '\040', '\163', '\172', '\040', '\061',
    '\012', '\131', '\150', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\166', '\110', '\040', '\143', '\150', '\040', '\061',
    '\012', '\114', '\143', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\127', '\146', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\116', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\115', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\166', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\121', '\156', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\142', '\107', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\106', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\154', '\112', '\040', '\154', '\145', '\040', '\061',
    '\012', '\142', '\120', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\170', '\160', '\111', '\040', '\160', '\162', '\040', '\061',
    '\012', '\155', '\162', '\126', '\040', '\145', '\162', '\040', '\061',
    '\012', '\106', '\167', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\117', '\171', '\040', '\167', '\141', '\040', '\061',
    '\012', '\120', '\155', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\150', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\142', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\160', '\147', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\142', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\101', '\167', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\155', '\143', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\153', '\107', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\153', '\127', '\040', '\153', '\141', '\040', '\061',
    '\012', '\120', '\156', '\167', '\040', '\151', '\156', '\040', '\061',
    '\012', '\142', '\116', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\130', '\162', '\040', '\141', '\156', '\040', '\061',
    '\012', '\126', '\155', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\145', '\125', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\171', '\121', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\153', '\170', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\113', '\163', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\160', '\127', '\040', '\160', '\162', '\040', '\061',
    '\012', '\161', '\145', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\166', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\122', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\112', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\163', '\131', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\167', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\103', '\161', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\131', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\120', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\157', '\101', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\144', '\143', '\123', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\167', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\152', '\114', '\040', '\163', '\172', '\040', '\061',
    '\012', '\157', '\132', '\170', '\040', '\157', '\156', '\040', '\061',
    '\012', '\153', '\152', '\122', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\104', '\171', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\123', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\145', '\121', '\146', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\102', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\114', '\142', '\040', '\155', '\145', '\040', '\061',
    '\012', '\132', '\162', '\152', '\040', '\145', '\162', '\040', '\061',
    '\012', '\107', '\153', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\160', '\153', '\130', '\040', '\153', '\141', '\040', '\061',
    '\012', '\166', '\124', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\132', '\147', '\160', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\150', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\120', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\156', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\110', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\130', '\147', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\103', '\167', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\154', '\142', '\116', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\116', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\116', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\112', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\157', '\112', '\144', '\040', '\157', '\156', '\040', '\061',
    '\012', '\122', '\171', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\166', '\114', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\166', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\167', '\103', '\040', '\166', '\141', '\040', '\061',
    '\012', '\153', '\106', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\110', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\143', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\124', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\121', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\104', '\154', '\146', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\114', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\142', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\161', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\150', '\117', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\117', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\155', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\155', '\121', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\121', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\166', '\121', '\040', '\157', '\156', '\040', '\061',
    '\012', '\147', '\146', '\122', '\040', '\156', '\147', '\040', '\061',
    '\012', '\120', '\155', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\124', '\143', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\161', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\167', '\126', '\040', '\155', '\145', '\040', '\061',
    '\012', '\142', '\130', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\152', '\154', '\101', '\040', '\154', '\145', '\040', '\061',
    '\012', '\146', '\152', '\107', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\170', '\131', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\167', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\166', '\125', '\040', '\153', '\141', '\040', '\061',
    '\012', '\102', '\153', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\146', '\101', '\040', '\156', '\147', '\040', '\061',
    '\012', '\101', '\167', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\126', '\155', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\121', '\150', '\154', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\155', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\115', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\110', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\120', '\142', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\154', '\113', '\040', '\154', '\145', '\040', '\061',
    '\012', '\131', '\147', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\112', '\163', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\127', '\154', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\126', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\163', '\162', '\116', '\040', '\145', '\162', '\040', '\061',
    '\012', '\125', '\150', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\146', '\122', '\040', '\166', '\141', '\040', '\061',
    '\012', '\153', '\106', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\112', '\154', '\172', '\040', '\154', '\145', '\040', '\061',
    '\012', '\146', '\113', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\122', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\127', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\166', '\117', '\040', '\163', '\172', '\040', '\061',
    '\012', '\130', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\111', '\152', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\112', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\106', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\116', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\170', '\114', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\114', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\144', '\161', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\122', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\114', '\152', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\122', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\143', '\170', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\152', '\110', '\040', '\143', '\150', '\040', '\061',
    '\012', '\126', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\112', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\106', '\153', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\161', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\105', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\122', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\146', '\124', '\040', '\166', '\141', '\040', '\061',
    '\012', '\132', '\161', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\107', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\123', '\142', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\151', '\167', '\126', '\040', '\151', '\156', '\040', '\061',
    '\012', '\152', '\146', '\111', '\040', '\151', '\152', '\040', '\061',
    '\012', '\156', '\127', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\114', '\152', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\152', '\107', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\106', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\161', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\126', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\152', '\147', '\113', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\132', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\102', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\165', '\107', '\040', '\165', '\156', '\040', '\061',
    '\012', '\154', '\103', '\166', '\040', '\154', '\145', '\040', '\061',
    '\012', '\154', '\170', '\127', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\107', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\166', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\152', '\106', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\164', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\131', '\171', '\040', '\160', '\162', '\040', '\061',
    '\012', '\131', '\162', '\146', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\126', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\160', '\122', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\113', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\160', '\115', '\040', '\160', '\162', '\040', '\061',
    '\012', '\143', '\114', '\153', '\040', '\143', '\150', '\040', '\061',
    '\012', '\123', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\127', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\127', '\172', '\040', '\163', '\164', '\040', '\061',
    '\012', '\163', '\162', '\123', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\126', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\116', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\150', '\120', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\107', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\144', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\112', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\125', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\144', '\112', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\150', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\164', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\107', '\142', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\104', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\146', '\127', '\040', '\163', '\172', '\040', '\061',
    '\012', '\116', '\155', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\110', '\163', '\167', '\040', '\163', '\164', '\040', '\061',
    '\012', '\160', '\146', '\107', '\040', '\160', '\162', '\040', '\061',
    '\012', '\144', '\115', '\152', '\040', '\144', '\145', '\040', '\061',
    '\012', '\153', '\113', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\152', '\123', '\040', '\145', '\162', '\040', '\061',
    '\012', '\121', '\154', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\116', '\146', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\143', '\161', '\115', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\127', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\165', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\146', '\106', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\147', '\110', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\160', '\132', '\040', '\160', '\162', '\040', '\061',
    '\012', '\142', '\164', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\161', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\171', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\162', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\171', '\164', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\110', '\155', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\102', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\171', '\116', '\040', '\156', '\171', '\040', '\061',
    '\012', '\121', '\162', '\152', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\113', '\144', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\146', '\125', '\040', '\142', '\145', '\040', '\061',
    '\012', '\121', '\146', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\161', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\117', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\150', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\161', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\152', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\146', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\141', '\130', '\153', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\142', '\126', '\040', '\160', '\162', '\040', '\061',
    '\012', '\166', '\152', '\120', '\040', '\151', '\152', '\040', '\061',
    '\012', '\131', '\142', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\112', '\155', '\142', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\106', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\120', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\127', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\166', '\150', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\167', '\124', '\040', '\151', '\156', '\040', '\061',
    '\012', '\161', '\132', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\161', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\106', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\160', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\114', '\160', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\146', '\114', '\040', '\153', '\141', '\040', '\061',
    '\012', '\160', '\121', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\167', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\160', '\115', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\153', '\155', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\147', '\110', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\152', '\120', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\147', '\114', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\114', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\170', '\116', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\127', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\112', '\152', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\150', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\166', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\162', '\105', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\132', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\114', '\166', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\145', '\116', '\167', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\152', '\102', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\143', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\132', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\167', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\120', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\115', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\150', '\146', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\172', '\121', '\040', '\163', '\172', '\040', '\061',
    '\012', '\125', '\165', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\107', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\103', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\160', '\103', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\127', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\152', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\120', '\172', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\167', '\165', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\150', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\115', '\161', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\163', '\111', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\144', '\125', '\040', '\144', '\145', '\040', '\061',
    '\012', '\130', '\162', '\155', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\121', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\153', '\127', '\040', '\153', '\141', '\040', '\061',
    '\012', '\144', '\110', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\143', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\127', '\165', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\111', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\162', '\131', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\130', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\161', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\155', '\116', '\040', '\155', '\145', '\040', '\061',
    '\012', '\163', '\112', '\146', '\040', '\163', '\164', '\040', '\061',
    '\012', '\171', '\115', '\146', '\040', '\156', '\171', '\040', '\061',
    '\012', '\123', '\146', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\172', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\166', '\124', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\155', '\130', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\161', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\156', '\107', '\040', '\141', '\156', '\040', '\061',
    '\012', '\112', '\160', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\146', '\162', '\130', '\040', '\145', '\162', '\040', '\061',
    '\012', '\171', '\114', '\146', '\040', '\156', '\171', '\040', '\061',
    '\012', '\165', '\171', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\104', '\144', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\124', '\147', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\145', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\105', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\103', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\155', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\152', '\110', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\115', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\131', '\167', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\172', '\147', '\104', '\040', '\156', '\147', '\040', '\061',
    '\012', '\120', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\161', '\115', '\040', '\157', '\156', '\040', '\061',
    '\012', '\167', '\144', '\130', '\040', '\144', '\145', '\040', '\061',
    '\012', '\102', '\160', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\150', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\105', '\160', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\142', '\150', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\166', '\121', '\040', '\153', '\141', '\040', '\061',
    '\012', '\122', '\163', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\142', '\120', '\040', '\142', '\145', '\040', '\061',
    '\012', '\156', '\115', '\155', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\165', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\152', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\170', '\130', '\040', '\146', '\157', '\040', '\061',
    '\012', '\150', '\166', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\120', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\155', '\171', '\040', '\155', '\145', '\040', '\061',
    '\012', '\121', '\172', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\116', '\163', '\172', '\040', '\163', '\164', '\040', '\061',
    '\012', '\166', '\127', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\150', '\146', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\103', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\121', '\170', '\040', '\156', '\171', '\040', '\061',
    '\012', '\167', '\150', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\162', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\147', '\127', '\040', '\156', '\147', '\040', '\061',
    '\012', '\112', '\150', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\150', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\120', '\167', '\146', '\040', '\157', '\167', '\040', '\061',
    '\012', '\154', '\152', '\103', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\166', '\102', '\040', '\166', '\141', '\040', '\061',
    '\012', '\155', '\143', '\116', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\110', '\170', '\040', '\156', '\171', '\040', '\061',
    '\012', '\142', '\102', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\122', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\154', '\110', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\132', '\160', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\112', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\123', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\126', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\165', '\127', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\170', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\146', '\152', '\115', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\150', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\103', '\152', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\132', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\103', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\167', '\131', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\105', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\144', '\125', '\166', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\122', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\107', '\143', '\165', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\104', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\152', '\110', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\154', '\125', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\171', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\130', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\154', '\142', '\103', '\040', '\154', '\145', '\040', '\061',
    '\012', '\120', '\167', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\117', '\141', '\145', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\142', '\103', '\040', '\160', '\162', '\040', '\061',
    '\012', '\144', '\127', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\172', '\125', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\112', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\131', '\152', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\102', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\122', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\144', '\152', '\107', '\040', '\144', '\145', '\040', '\061',
    '\012', '\155', '\131', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\142', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\156', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\120', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\167', '\166', '\116', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\107', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\116', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\122', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\125', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\170', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\146', '\172', '\130', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\152', '\115', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\161', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\115', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\155', '\114', '\040', '\155', '\145', '\040', '\061',
    '\012', '\105', '\171', '\170', '\040', '\156', '\171', '\040', '\061',
    '\012', '\150', '\110', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\107', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\146', '\104', '\040', '\155', '\145', '\040', '\061',
    '\012', '\112', '\146', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\127', '\152', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\132', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\111', '\171', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\122', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\144', '\125', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\112', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\152', '\171', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\141', '\157', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\130', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\123', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\101', '\157', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\114', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\103', '\163', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\153', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\170', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\144', '\116', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\131', '\170', '\040', '\156', '\171', '\040', '\061',
    '\012', '\144', '\153', '\116', '\040', '\144', '\145', '\040', '\061',
    '\012', '\122', '\147', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\147', '\114', '\040', '\163', '\172', '\040', '\061',
    '\012', '\122', '\143', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\151', '\127', '\172', '\040', '\151', '\156', '\040', '\061',
    '\012', '\144', '\114', '\153', '\040', '\144', '\145', '\040', '\061',
    '\012', '\155', '\160', '\130', '\040', '\155', '\145', '\040', '\061',
    '\012', '\107', '\142', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\156', '\110', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\144', '\115', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\161', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\115', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\167', '\110', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\147', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\114', '\152', '\153', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\154', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\147', '\105', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\143', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\126', '\142', '\171', '\040', '\142', '\145', '\040', '\061',
    '\012', '\155', '\126', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\110', '\147', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\161', '\120', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\150', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\106', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\102', '\146', '\040', '\156', '\171', '\040', '\061',
    '\012', '\127', '\155', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\166', '\116', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\115', '\156', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\132', '\155', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\172', '\123', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\146', '\103', '\040', '\156', '\171', '\040', '\061',
    '\012', '\105', '\160', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\154', '\152', '\107', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\125', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\121', '\147', '\157', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\161', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\153', '\155', '\040', '\153', '\141', '\040', '\061',
    '\012', '\127', '\166', '\171', '\040', '\166', '\141', '\040', '\061',
    '\012', '\102', '\152', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\146', '\132', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\170', '\124', '\040', '\167', '\141', '\040', '\061',
    '\012', '\126', '\170', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\144', '\122', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\126', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\151', '\127', '\146', '\040', '\151', '\156', '\040', '\061',
    '\012', '\123', '\155', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\167', '\107', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\143', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\121', '\147', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\127', '\153', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\162', '\114', '\040', '\145', '\162', '\040', '\061',
    '\012', '\164', '\126', '\150', '\040', '\143', '\150', '\040', '\061',
    '\012', '\132', '\154', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\104', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\170', '\120', '\040', '\156', '\171', '\040', '\061',
    '\012', '\131', '\171', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\172', '\120', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\102', '\147', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\117', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\157', '\130', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\121', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\170', '\106', '\040', '\146', '\157', '\040', '\061',
    '\012', '\144', '\117', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\164', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\150', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\150', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\161', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\106', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\145', '\103', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\152', '\110', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\161', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\160', '\114', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\147', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\106', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\121', '\152', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\113', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\121', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\116', '\150', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\161', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\167', '\117', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\131', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\127', '\156', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\123', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\101', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\161', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\105', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\113', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\156', '\155', '\113', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\130', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\166', '\152', '\103', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\130', '\142', '\040', '\144', '\145', '\040', '\061',
    '\012', '\164', '\121', '\156', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\157', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\122', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\171', '\171', '\114', '\040', '\156', '\171', '\040', '\061',
    '\012', '\153', '\123', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\130', '\171', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\155', '\101', '\040', '\166', '\141', '\040', '\061',
    '\012', '\132', '\147', '\155', '\040', '\156', '\147', '\040', '\061',
    '\012', '\114', '\142', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\142', '\111', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\132', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\110', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\131', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\115', '\161', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\115', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\163', '\166', '\040', '\163', '\164', '\040', '\061',
    '\012', '\172', '\130', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\121', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\143', '\126', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\146', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\115', '\150', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\102', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\127', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\127', '\172', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\127', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\116', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\142', '\132', '\040', '\142', '\145', '\040', '\061',
    '\012', '\155', '\124', '\142', '\040', '\155', '\145', '\040', '\061',
    '\012', '\113', '\144', '\146', '\040', '\144', '\145', '\040', '\061',
    '\012', '\160', '\146', '\121', '\040', '\160', '\162', '\040', '\061',
    '\012', '\166', '\103', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\120', '\161', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\146', '\132', '\040', '\157', '\156', '\040', '\061',
    '\012', '\167', '\131', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\124', '\146', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\107', '\156', '\142', '\040', '\141', '\156', '\040', '\061',
    '\012', '\132', '\144', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\126', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\124', '\161', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\172', '\126', '\040', '\163', '\172', '\040', '\061',
    '\012', '\111', '\147', '\161', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\166', '\166', '\040', '\166', '\151', '\040', '\061',
    '\012', '\120', '\155', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\110', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\142', '\122', '\040', '\142', '\145', '\040', '\061',
    '\012', '\143', '\106', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\113', '\166', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\132', '\170', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\157', '\126', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\150', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\167', '\120', '\040', '\167', '\141', '\040', '\061',
    '\012', '\126', '\166', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\144', '\127', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\106', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\122', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\142', '\161', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\150', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\102', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\142', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\112', '\172', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\162', '\123', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\153', '\132', '\040', '\155', '\145', '\040', '\061',
    '\012', '\142', '\113', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\152', '\120', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\130', '\161', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\107', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\114', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\156', '\162', '\126', '\040', '\141', '\156', '\040', '\061',
    '\012', '\124', '\155', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\166', '\132', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\127', '\154', '\040', '\156', '\147', '\040', '\061',
    '\012', '\131', '\170', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\171', '\127', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\161', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\127', '\165', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\132', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\161', '\111', '\040', '\151', '\156', '\040', '\061',
    '\012', '\143', '\160', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\120', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\161', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\155', '\111', '\040', '\156', '\147', '\040', '\061',
    '\012', '\127', '\153', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\132', '\166', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\144', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\131', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\102', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\104', '\167', '\142', '\040', '\157', '\167', '\040', '\061',
    '\012', '\127', '\172', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\144', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\166', '\122', '\040', '\163', '\172', '\040', '\061',
    '\012', '\116', '\166', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\122', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\104', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\107', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\167', '\124', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\124', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\103', '\166', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\154', '\121', '\040', '\154', '\145', '\040', '\061',
    '\012', '\155', '\127', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\167', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\160', '\115', '\040', '\141', '\156', '\040', '\061',
    '\012', '\125', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\165', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\103', '\152', '\040', '\157', '\156', '\040', '\061',
    '\012', '\164', '\170', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\146', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\167', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\144', '\172', '\040', '\144', '\145', '\040', '\061',
    '\012', '\126', '\147', '\161', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\153', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\120', '\170', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\155', '\103', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\150', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\147', '\102', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\166', '\127', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\144', '\114', '\040', '\144', '\145', '\040', '\061',
    '\012', '\114', '\170', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\163', '\166', '\102', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\165', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\106', '\171', '\040', '\156', '\147', '\040', '\061',
    '\012', '\157', '\126', '\166', '\040', '\157', '\156', '\040', '\061',
    '\012', '\132', '\150', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\161', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\112', '\160', '\040', '\157', '\156', '\040', '\061',
    '\012', '\147', '\111', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\167', '\106', '\040', '\167', '\141', '\040', '\061',
    '\012', '\166', '\114', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\147', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\113', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\170', '\122', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\167', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\116', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\107', '\166', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\121', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\142', '\126', '\040', '\142', '\145', '\040', '\061',
    '\012', '\144', '\160', '\132', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\110', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\102', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\125', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\172', '\101', '\040', '\164', '\150', '\040', '\061',
    '\012', '\115', '\156', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\102', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\141', '\105', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\154', '\113', '\040', '\154', '\145', '\040', '\061',
    '\012', '\127', '\154', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\150', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\166', '\130', '\040', '\166', '\141', '\040', '\061',
    '\012', '\106', '\146', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\147', '\130', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\127', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\107', '\160', '\171', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\155', '\123', '\040', '\155', '\145', '\040', '\061',
    '\012', '\147', '\132', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\152', '\130', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\153', '\130', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\154', '\120', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\103', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\150', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\167', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\154', '\104', '\040', '\154', '\145', '\040', '\061',
    '\012', '\122', '\150', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\141', '\105', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\160', '\131', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\126', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\156', '\112', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\144', '\126', '\040', '\144', '\145', '\040', '\061',
    '\012', '\122', '\166', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\117', '\161', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\160', '\124', '\040', '\163', '\172', '\040', '\061',
    '\012', '\120', '\172', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\124', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\146', '\161', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\164', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\132', '\142', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\110', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\121', '\143', '\162', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\126', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\116', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\130', '\150', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\131', '\171', '\040', '\157', '\156', '\040', '\061',
    '\012', '\106', '\154', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\167', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\162', '\167', '\110', '\040', '\145', '\162', '\040', '\061',
    '\012', '\157', '\127', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\102', '\167', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\152', '\130', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\114', '\153', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\126', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\130', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\153', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\162', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\161', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\170', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\147', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\106', '\147', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\167', '\115', '\040', '\141', '\156', '\040', '\061',
    '\012', '\127', '\172', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\147', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\131', '\147', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\130', '\144', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\152', '\115', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\110', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\113', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\166', '\115', '\040', '\144', '\145', '\040', '\061',
    '\012', '\132', '\160', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\167', '\120', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\151', '\101', '\040', '\151', '\156', '\040', '\061',
    '\012', '\152', '\171', '\126', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\171', '\122', '\040', '\151', '\152', '\040', '\061',
    '\012', '\125', '\157', '\170', '\040', '\157', '\156', '\040', '\061',
    '\012', '\121', '\153', '\172', '\040', '\153', '\141', '\040', '\061',
    '\012', '\114', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\160', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\155', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\153', '\122', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\106', '\153', '\040', '\151', '\152', '\040', '\061',
    '\012', '\156', '\132', '\143', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\103', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\142', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\172', '\154', '\106', '\040', '\154', '\145', '\040', '\061',
    '\012', '\153', '\161', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\127', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\113', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\160', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\154', '\142', '\122', '\040', '\154', '\145', '\040', '\061',
    '\012', '\162', '\142', '\112', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\146', '\113', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\126', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\132', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\172', '\156', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\132', '\142', '\040', '\147', '\141', '\040', '\061',
    '\012', '\167', '\164', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\166', '\127', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\150', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\162', '\126', '\040', '\145', '\162', '\040', '\061',
    '\012', '\160', '\131', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\121', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\160', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\106', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\144', '\117', '\040', '\144', '\145', '\040', '\061',
    '\012', '\112', '\166', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\121', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\127', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\104', '\164', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\113', '\172', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\153', '\111', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\123', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\171', '\103', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\167', '\150', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\126', '\155', '\040', '\154', '\145', '\040', '\061',
    '\012', '\171', '\110', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\120', '\154', '\155', '\040', '\154', '\145', '\040', '\061',
    '\012', '\112', '\160', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\150', '\105', '\167', '\040', '\150', '\141', '\040', '\061',
    '\012', '\172', '\110', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\111', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\172', '\102', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\163', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\142', '\130', '\040', '\160', '\162', '\040', '\061',
    '\012', '\152', '\171', '\131', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\104', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\124', '\161', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\124', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\142', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\103', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\143', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\150', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\167', '\122', '\040', '\167', '\141', '\040', '\061',
    '\012', '\144', '\121', '\155', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\103', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\171', '\150', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\154', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\126', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\120', '\144', '\171', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\117', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\132', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\157', '\161', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\161', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\153', '\130', '\040', '\151', '\152', '\040', '\061',
    '\012', '\113', '\146', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\160', '\121', '\040', '\160', '\162', '\040', '\061',
    '\012', '\162', '\150', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\152', '\111', '\040', '\151', '\152', '\040', '\061',
    '\012', '\102', '\161', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\141', '\103', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\143', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\107', '\155', '\040', '\155', '\141', '\040', '\061',
    '\012', '\160', '\141', '\125', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\125', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\114', '\144', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\146', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\167', '\110', '\040', '\167', '\141', '\040', '\061',
    '\012', '\120', '\156', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\170', '\126', '\040', '\153', '\141', '\040', '\061',
    '\012', '\116', '\142', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\163', '\161', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\103', '\152', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\143', '\132', '\040', '\153', '\141', '\040', '\061',
    '\012', '\127', '\161', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\172', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\161', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\131', '\171', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\114', '\172', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\132', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\163', '\144', '\131', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\130', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\116', '\142', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\167', '\114', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\116', '\161', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\167', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\171', '\166', '\110', '\040', '\166', '\141', '\040', '\061',
    '\012', '\171', '\154', '\103', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\171', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\156', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\110', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\125', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\147', '\111', '\040', '\156', '\147', '\040', '\061',
    '\012', '\132', '\164', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\166', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\164', '\107', '\156', '\040', '\164', '\150', '\040', '\061',
    '\012', '\125', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\110', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\127', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\130', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\106', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\144', '\124', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\110', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\103', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\155', '\126', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\121', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\127', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\171', '\106', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\152', '\131', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\164', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\154', '\115', '\040', '\154', '\145', '\040', '\061',
    '\012', '\111', '\167', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\120', '\144', '\142', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\164', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\152', '\122', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\150', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\130', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\142', '\105', '\040', '\142', '\145', '\040', '\061',
    '\012', '\110', '\161', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\114', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\142', '\104', '\040', '\153', '\141', '\040', '\061',
    '\012', '\166', '\125', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\132', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\121', '\153', '\145', '\040', '\154', '\145', '\040', '\061',
    '\012', '\146', '\150', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\145', '\110', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\110', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\124', '\146', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\157', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\103', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\114', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\144', '\127', '\040', '\144', '\145', '\040', '\061',
    '\012', '\103', '\147', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\114', '\162', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\117', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\161', '\117', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\161', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\164', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\167', '\125', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\131', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\172', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\156', '\127', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\154', '\116', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\127', '\161', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\143', '\104', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\146', '\104', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\126', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\172', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\146', '\110', '\040', '\151', '\152', '\040', '\061',
    '\012', '\122', '\162', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\104', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\117', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\167', '\132', '\040', '\167', '\141', '\040', '\061',
    '\012', '\155', '\121', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\156', '\161', '\113', '\040', '\141', '\156', '\040', '\061',
    '\012', '\125', '\166', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\153', '\122', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\150', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\163', '\104', '\040', '\163', '\164', '\040', '\061',
    '\012', '\114', '\144', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\121', '\166', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\115', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\142', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\152', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\142', '\124', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\116', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\167', '\103', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\156', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\132', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\103', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\110', '\153', '\040', '\144', '\145', '\040', '\061',
    '\012', '\103', '\143', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\115', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\166', '\107', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\120', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\111', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\154', '\110', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\146', '\156', '\102', '\040', '\141', '\156', '\040', '\061',
    '\012', '\105', '\142', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\162', '\107', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\147', '\104', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\112', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\143', '\107', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\142', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\157', '\104', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\122', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\112', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\164', '\106', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\144', '\166', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\110', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\125', '\161', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\131', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\110', '\160', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\150', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\132', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\121', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\167', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\172', '\125', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\121', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\142', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\126', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\112', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\162', '\146', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\115', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\112', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\104', '\161', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\115', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\172', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\127', '\144', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\124', '\144', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\155', '\143', '\124', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\117', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\113', '\147', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\162', '\124', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\161', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\156', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\114', '\172', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\114', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\114', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\172', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\121', '\162', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\145', '\106', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\116', '\155', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\160', '\170', '\105', '\040', '\160', '\162', '\040', '\061',
    '\012', '\103', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\143', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\130', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\146', '\142', '\125', '\040', '\142', '\145', '\040', '\061',
    '\012', '\141', '\145', '\117', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\166', '\126', '\040', '\163', '\164', '\040', '\061',
    '\012', '\171', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\122', '\160', '\040', '\163', '\164', '\040', '\061',
    '\012', '\162', '\170', '\125', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\150', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\121', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\130', '\167', '\040', '\157', '\156', '\040', '\061',
    '\012', '\112', '\166', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\153', '\166', '\110', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\126', '\171', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\117', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\127', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\151', '\130', '\166', '\040', '\151', '\156', '\040', '\061',
    '\012', '\143', '\102', '\153', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\153', '\115', '\040', '\153', '\141', '\040', '\061',
    '\012', '\166', '\110', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\142', '\127', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\131', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\156', '\110', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\122', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\166', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\115', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\161', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\102', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\157', '\120', '\152', '\040', '\157', '\156', '\040', '\061',
    '\012', '\146', '\106', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\126', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\164', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\116', '\164', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\167', '\114', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\106', '\172', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\126', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\107', '\142', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\157', '\112', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\153', '\114', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\157', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\170', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\162', '\132', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\103', '\147', '\144', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\166', '\127', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\131', '\166', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\152', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\156', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\112', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\127', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\142', '\130', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\126', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\165', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\110', '\172', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\165', '\104', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\167', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\112', '\153', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\144', '\155', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\143', '\117', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\154', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\146', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\114', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\172', '\107', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\150', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\146', '\104', '\040', '\153', '\141', '\040', '\061',
    '\012', '\153', '\142', '\112', '\040', '\153', '\141', '\040', '\061',
    '\012', '\116', '\161', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\131', '\161', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\164', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\143', '\104', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\147', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\144', '\124', '\040', '\144', '\141', '\040', '\061',
    '\012', '\166', '\124', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\116', '\172', '\040', '\143', '\150', '\040', '\061',
    '\012', '\112', '\142', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\143', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\125', '\167', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\130', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\122', '\146', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\112', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\141', '\161', '\101', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\117', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\120', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\165', '\104', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\161', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\130', '\162', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\162', '\114', '\040', '\145', '\162', '\040', '\061',
    '\012', '\156', '\112', '\153', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\163', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\161', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\145', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\114', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\105', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\160', '\155', '\105', '\040', '\155', '\145', '\040', '\061',
    '\012', '\152', '\111', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\172', '\132', '\040', '\163', '\172', '\040', '\061',
    '\012', '\121', '\150', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\156', '\116', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\120', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\132', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\151', '\167', '\122', '\040', '\151', '\156', '\040', '\061',
    '\012', '\157', '\112', '\166', '\040', '\153', '\157', '\040', '\061',
    '\012', '\165', '\146', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\113', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\165', '\127', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\103', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\167', '\102', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\125', '\171', '\146', '\040', '\156', '\171', '\040', '\061',
    '\012', '\165', '\126', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\113', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\155', '\162', '\132', '\040', '\145', '\162', '\040', '\061',
    '\012', '\154', '\130', '\142', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\112', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\131', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\110', '\153', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\105', '\167', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\112', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\105', '\155', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\143', '\161', '\114', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\126', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\120', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\172', '\143', '\103', '\040', '\143', '\150', '\040', '\061',
    '\012', '\116', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\127', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\143', '\115', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\153', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\150', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\141', '\120', '\040', '\141', '\156', '\040', '\061',
    '\012', '\162', '\126', '\163', '\040', '\145', '\162', '\040', '\061',
    '\012', '\144', '\114', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\123', '\147', '\155', '\040', '\156', '\147', '\040', '\061',
    '\012', '\130', '\150', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\161', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\161', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\122', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\127', '\144', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\143', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\142', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\164', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\167', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\146', '\126', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\147', '\120', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\167', '\127', '\040', '\160', '\162', '\040', '\061',
    '\012', '\160', '\161', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\153', '\160', '\040', '\153', '\141', '\040', '\061',
    '\012', '\151', '\172', '\112', '\040', '\151', '\156', '\040', '\061',
    '\012', '\143', '\131', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\151', '\121', '\154', '\040', '\151', '\156', '\040', '\061',
    '\012', '\121', '\166', '\171', '\040', '\166', '\141', '\040', '\061',
    '\012', '\171', '\154', '\122', '\040', '\154', '\145', '\040', '\061',
    '\012', '\163', '\106', '\160', '\040', '\163', '\164', '\040', '\061',
    '\012', '\114', '\161', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\156', '\120', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\131', '\154', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\111', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\161', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\160', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\130', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\162', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\163', '\152', '\111', '\040', '\163', '\164', '\040', '\061',
    '\012', '\151', '\171', '\130', '\040', '\151', '\156', '\040', '\061',
    '\012', '\132', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\164', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\132', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\130', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\112', '\167', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\142', '\120', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\165', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\122', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\130', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\126', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\107', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\116', '\170', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\171', '\113', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\101', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\157', '\125', '\170', '\040', '\157', '\156', '\040', '\061',
    '\012', '\156', '\127', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\167', '\125', '\040', '\167', '\141', '\040', '\061',
    '\012', '\155', '\113', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\150', '\117', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\107', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\127', '\167', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\156', '\105', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\152', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\171', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\127', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\121', '\144', '\152', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\123', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\111', '\157', '\171', '\040', '\157', '\156', '\040', '\061',
    '\012', '\130', '\160', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\112', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\170', '\166', '\124', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\144', '\124', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\150', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\126', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\152', '\124', '\040', '\143', '\150', '\040', '\061',
    '\012', '\110', '\161', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\142', '\120', '\040', '\141', '\156', '\040', '\061',
    '\012', '\125', '\167', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\113', '\143', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\163', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\153', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\162', '\130', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\142', '\116', '\040', '\163', '\172', '\040', '\061',
    '\012', '\155', '\131', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\147', '\114', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\163', '\107', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\120', '\142', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\143', '\126', '\040', '\143', '\150', '\040', '\061',
    '\012', '\121', '\152', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\166', '\102', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\113', '\160', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\132', '\171', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\150', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\103', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\114', '\162', '\153', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\122', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\143', '\115', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\157', '\150', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\162', '\113', '\040', '\145', '\162', '\040', '\061',
    '\012', '\144', '\121', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\110', '\144', '\152', '\040', '\144', '\145', '\040', '\061',
    '\012', '\102', '\153', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\171', '\130', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\144', '\117', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\127', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\130', '\164', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\125', '\170', '\040', '\141', '\162', '\040', '\061',
    '\012', '\161', '\110', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\121', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\172', '\125', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\124', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\153', '\116', '\040', '\163', '\172', '\040', '\061',
    '\012', '\106', '\161', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\112', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\153', '\121', '\040', '\153', '\141', '\040', '\061',
    '\012', '\167', '\170', '\106', '\040', '\167', '\141', '\040', '\061',
    '\012', '\166', '\122', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\172', '\104', '\040', '\163', '\172', '\040', '\061',
    '\012', '\132', '\161', '\165', '\040', '\165', '\156', '\040', '\061',
    '\012', '\172', '\127', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\147', '\125', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\147', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\155', '\102', '\040', '\155', '\145', '\040', '\061',
    '\012', '\147', '\172', '\101', '\040', '\156', '\147', '\040', '\061',
    '\012', '\132', '\152', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\111', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\157', '\113', '\040', '\157', '\156', '\040', '\061',
    '\012', '\107', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\114', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\107', '\167', '\040', '\154', '\145', '\040', '\061',
    '\012', '\164', '\132', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\143', '\116', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\120', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\161', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\167', '\107', '\040', '\160', '\162', '\040', '\061',
    '\012', '\166', '\146', '\120', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\111', '\171', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\105', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\161', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\110', '\170', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\114', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\160', '\171', '\040', '\160', '\162', '\040', '\061',
    '\012', '\160', '\122', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\132', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\126', '\166', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\153', '\102', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\107', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\153', '\166', '\132', '\040', '\153', '\141', '\040', '\061',
    '\012', '\143', '\161', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\114', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\131', '\160', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\162', '\122', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\167', '\132', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\126', '\144', '\040', '\156', '\147', '\040', '\061',
    '\012', '\151', '\103', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\106', '\170', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\171', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\147', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\114', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\160', '\130', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\116', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\110', '\147', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\112', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\110', '\166', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\165', '\130', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\114', '\172', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\167', '\120', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\166', '\116', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\160', '\106', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\132', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\120', '\146', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\143', '\111', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\126', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\144', '\103', '\040', '\144', '\145', '\040', '\061',
    '\012', '\160', '\142', '\105', '\040', '\160', '\162', '\040', '\061',
    '\012', '\152', '\121', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\124', '\161', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\115', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\153', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\144', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\111', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\150', '\110', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\114', '\163', '\142', '\040', '\163', '\164', '\040', '\061',
    '\012', '\127', '\166', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\121', '\143', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\146', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\106', '\152', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\102', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\114', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\172', '\153', '\122', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\152', '\101', '\040', '\151', '\152', '\040', '\061',
    '\012', '\106', '\143', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\150', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\151', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\121', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\130', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\114', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\112', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\163', '\117', '\152', '\040', '\163', '\164', '\040', '\061',
    '\012', '\166', '\127', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\101', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\113', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\151', '\111', '\171', '\040', '\151', '\156', '\040', '\061',
    '\012', '\160', '\112', '\171', '\040', '\160', '\162', '\040', '\061',
    '\012', '\114', '\161', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\102', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\153', '\122', '\142', '\040', '\153', '\141', '\040', '\061',
    '\012', '\114', '\143', '\160', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\146', '\102', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\126', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\127', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\171', '\146', '\040', '\156', '\171', '\040', '\061',
    '\012', '\160', '\165', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\111', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\107', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\152', '\152', '\114', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\143', '\105', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\150', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\170', '\116', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\115', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\122', '\172', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\147', '\117', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\155', '\124', '\040', '\166', '\141', '\040', '\061',
    '\012', '\104', '\143', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\157', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\116', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\150', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\102', '\161', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\127', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\155', '\105', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\143', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\131', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\104', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\125', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\126', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\161', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\165', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\172', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\166', '\130', '\040', '\166', '\141', '\040', '\061',
    '\012', '\120', '\171', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\165', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\114', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\161', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\126', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\147', '\163', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\152', '\106', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\153', '\107', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\112', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\172', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\111', '\170', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\115', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\146', '\121', '\040', '\144', '\145', '\040', '\061',
    '\012', '\145', '\117', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\110', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\153', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\156', '\161', '\127', '\040', '\141', '\156', '\040', '\061',
    '\012', '\156', '\112', '\144', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\105', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\126', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\132', '\171', '\146', '\040', '\156', '\171', '\040', '\061',
    '\012', '\156', '\155', '\124', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\163', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\120', '\153', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\144', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\153', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\121', '\156', '\143', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\102', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\115', '\152', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\155', '\112', '\040', '\155', '\145', '\040', '\061',
    '\012', '\115', '\170', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\150', '\142', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\121', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\104', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\144', '\152', '\103', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\144', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\156', '\114', '\040', '\141', '\156', '\040', '\061',
    '\012', '\131', '\152', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\125', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\152', '\127', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\127', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\170', '\166', '\106', '\040', '\166', '\141', '\040', '\061',
    '\012', '\107', '\161', '\151', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\107', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\130', '\165', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\103', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\170', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\154', '\116', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\144', '\114', '\040', '\144', '\145', '\040', '\061',
    '\012', '\126', '\164', '\156', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\112', '\152', '\040', '\163', '\164', '\040', '\061',
    '\012', '\153', '\121', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\146', '\130', '\040', '\146', '\157', '\040', '\061',
    '\012', '\116', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\102', '\163', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\172', '\120', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\125', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\154', '\142', '\124', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\171', '\126', '\040', '\167', '\141', '\040', '\061',
    '\012', '\130', '\153', '\155', '\040', '\153', '\141', '\040', '\061',
    '\012', '\127', '\144', '\166', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\121', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\161', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\146', '\127', '\040', '\163', '\164', '\040', '\061',
    '\012', '\147', '\146', '\115', '\040', '\156', '\147', '\040', '\061',
    '\012', '\126', '\154', '\160', '\040', '\154', '\145', '\040', '\061',
    '\012', '\130', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\111', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\167', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\170', '\132', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\151', '\113', '\167', '\040', '\151', '\156', '\040', '\061',
    '\012', '\124', '\142', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\121', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\155', '\132', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\160', '\105', '\040', '\160', '\162', '\040', '\061',
    '\012', '\172', '\123', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\106', '\147', '\151', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\111', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\166', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\162', '\161', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\152', '\132', '\040', '\151', '\152', '\040', '\061',
    '\012', '\116', '\152', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\153', '\167', '\106', '\040', '\153', '\141', '\040', '\061',
    '\012', '\117', '\166', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\167', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\115', '\166', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\104', '\166', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\163', '\120', '\040', '\163', '\164', '\040', '\061',
    '\012', '\147', '\132', '\161', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\130', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\107', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\154', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\116', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\116', '\166', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\144', '\132', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\170', '\126', '\040', '\166', '\141', '\040', '\061',
    '\012', '\116', '\150', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\132', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\171', '\123', '\040', '\151', '\156', '\040', '\061',
    '\012', '\161', '\132', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\162', '\132', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\154', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\152', '\115', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\131', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\151', '\171', '\106', '\040', '\151', '\156', '\040', '\061',
    '\012', '\103', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\167', '\105', '\040', '\167', '\141', '\040', '\061',
    '\012', '\170', '\146', '\126', '\040', '\146', '\157', '\040', '\061',
    '\012', '\167', '\142', '\106', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\165', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\154', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\103', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\143', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\107', '\152', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\114', '\154', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\114', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\155', '\120', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\131', '\157', '\040', '\143', '\150', '\040', '\061',
    '\012', '\122', '\150', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\162', '\115', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\104', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\171', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\165', '\171', '\127', '\040', '\165', '\156', '\040', '\061',
    '\012', '\153', '\107', '\142', '\040', '\153', '\141', '\040', '\061',
    '\012', '\151', '\167', '\113', '\040', '\151', '\156', '\040', '\061',
    '\012', '\161', '\153', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\130', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\103', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\121', '\146', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\162', '\117', '\040', '\145', '\162', '\040', '\061',
    '\012', '\106', '\172', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\123', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\120', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\102', '\161', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\127', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\150', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\102', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\171', '\166', '\114', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\143', '\124', '\040', '\143', '\150', '\040', '\061',
    '\012', '\106', '\142', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\105', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\105', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\165', '\121', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\110', '\167', '\040', '\165', '\163', '\040', '\061',
    '\012', '\106', '\166', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\153', '\117', '\040', '\153', '\141', '\040', '\061',
    '\012', '\167', '\151', '\131', '\040', '\151', '\156', '\040', '\061',
    '\012', '\163', '\120', '\155', '\040', '\163', '\164', '\040', '\061',
    '\012', '\144', '\106', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\121', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\163', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\125', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\114', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\122', '\153', '\040', '\163', '\164', '\040', '\061',
    '\012', '\172', '\153', '\120', '\040', '\163', '\172', '\040', '\061',
    '\012', '\155', '\166', '\106', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\131', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\163', '\167', '\131', '\040', '\151', '\163', '\040', '\061',
    '\012', '\162', '\122', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\110', '\144', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\104', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\154', '\127', '\166', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\157', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\115', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\160', '\146', '\112', '\040', '\160', '\162', '\040', '\061',
    '\012', '\104', '\155', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\157', '\142', '\121', '\040', '\157', '\156', '\040', '\061',
    '\012', '\126', '\146', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\126', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\103', '\152', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\113', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\152', '\105', '\040', '\151', '\152', '\040', '\061',
    '\012', '\101', '\161', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\103', '\170', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\160', '\110', '\040', '\166', '\141', '\040', '\061',
    '\012', '\114', '\170', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\160', '\110', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\157', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\122', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\131', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\144', '\125', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\113', '\170', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\125', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\150', '\104', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\104', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\127', '\163', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\172', '\132', '\040', '\163', '\172', '\040', '\061',
    '\012', '\155', '\107', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\152', '\152', '\126', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\146', '\122', '\040', '\160', '\162', '\040', '\061',
    '\012', '\142', '\120', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\114', '\167', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\161', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\122', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\146', '\124', '\040', '\163', '\172', '\040', '\061',
    '\012', '\107', '\162', '\167', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\107', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\143', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\125', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\122', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\132', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\123', '\166', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\120', '\150', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\166', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\154', '\155', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\147', '\123', '\040', '\156', '\147', '\040', '\061',
    '\012', '\115', '\155', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\120', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\161', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\127', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\111', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\103', '\170', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\167', '\164', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\113', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\164', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\122', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\172', '\163', '\102', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\142', '\104', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\113', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\150', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\150', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\131', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\152', '\103', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\172', '\113', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\112', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\121', '\162', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\165', '\166', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\146', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\151', '\161', '\130', '\040', '\151', '\156', '\040', '\061',
    '\012', '\166', '\116', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\143', '\115', '\040', '\143', '\150', '\040', '\061',
    '\012', '\127', '\166', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\155', '\123', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\127', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\141', '\111', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\155', '\123', '\040', '\151', '\152', '\040', '\061',
    '\012', '\106', '\155', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\151', '\171', '\116', '\040', '\151', '\156', '\040', '\061',
    '\012', '\142', '\132', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\172', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\126', '\167', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\125', '\154', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\162', '\103', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\166', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\153', '\162', '\040', '\162', '\151', '\040', '\061',
    '\012', '\146', '\152', '\103', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\122', '\162', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\103', '\171', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\142', '\103', '\040', '\142', '\145', '\040', '\061',
    '\012', '\146', '\121', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\153', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\104', '\161', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\147', '\105', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\115', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\144', '\120', '\142', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\152', '\114', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\113', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\120', '\171', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\145', '\130', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\156', '\126', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\112', '\167', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\104', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\103', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\164', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\161', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\102', '\150', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\143', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\113', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\164', '\146', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\142', '\132', '\040', '\151', '\156', '\040', '\061',
    '\012', '\116', '\172', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\127', '\156', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\130', '\171', '\040', '\166', '\141', '\040', '\061',
    '\012', '\151', '\126', '\146', '\040', '\151', '\156', '\040', '\061',
    '\012', '\144', '\170', '\124', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\170', '\121', '\040', '\151', '\152', '\040', '\061',
    '\012', '\104', '\144', '\166', '\040', '\144', '\145', '\040', '\061',
    '\012', '\155', '\130', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\125', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\147', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\114', '\147', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\147', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\115', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\160', '\112', '\040', '\156', '\147', '\040', '\061',
    '\012', '\163', '\132', '\170', '\040', '\163', '\164', '\040', '\061',
    '\012', '\156', '\130', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\127', '\166', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\154', '\126', '\153', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\103', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\170', '\166', '\111', '\040', '\166', '\141', '\040', '\061',
    '\012', '\155', '\146', '\112', '\040', '\155', '\145', '\040', '\061',
    '\012', '\164', '\121', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\124', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\111', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\166', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\146', '\116', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\121', '\163', '\040', '\156', '\147', '\040', '\061',
    '\012', '\151', '\126', '\160', '\040', '\151', '\156', '\040', '\061',
    '\012', '\152', '\107', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\115', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\170', '\166', '\167', '\040', '\167', '\151', '\040', '\061',
    '\012', '\172', '\111', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\146', '\122', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\127', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\145', '\150', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\132', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\155', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\114', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\132', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\166', '\156', '\112', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\166', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\130', '\150', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\152', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\147', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\141', '\112', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\123', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\130', '\172', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\124', '\172', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\130', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\160', '\121', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\103', '\161', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\123', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\160', '\162', '\127', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\104', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\130', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\143', '\104', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\147', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\124', '\172', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\143', '\122', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\167', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\130', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\131', '\167', '\166', '\040', '\167', '\151', '\040', '\061',
    '\012', '\162', '\160', '\113', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\120', '\163', '\040', '\151', '\163', '\040', '\061',
    '\012', '\113', '\152', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\104', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\152', '\162', '\106', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\142', '\121', '\040', '\142', '\145', '\040', '\061',
    '\012', '\121', '\144', '\142', '\040', '\144', '\145', '\040', '\061',
    '\012', '\162', '\113', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\131', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\170', '\101', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\150', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\163', '\125', '\040', '\163', '\164', '\040', '\061',
    '\012', '\172', '\130', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\167', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\163', '\122', '\040', '\163', '\164', '\040', '\061',
    '\012', '\153', '\110', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\127', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\146', '\123', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\111', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\142', '\143', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\144', '\115', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\103', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\172', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\121', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\157', '\152', '\130', '\040', '\157', '\156', '\040', '\061',
    '\012', '\126', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\127', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\153', '\142', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\156', '\112', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\112', '\172', '\040', '\163', '\164', '\040', '\061',
    '\012', '\150', '\122', '\162', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\130', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\145', '\142', '\040', '\145', '\162', '\040', '\061',
    '\012', '\125', '\167', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\156', '\131', '\147', '\040', '\141', '\156', '\040', '\061',
    '\012', '\131', '\146', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\170', '\162', '\107', '\040', '\145', '\162', '\040', '\061',
    '\012', '\145', '\132', '\162', '\040', '\154', '\145', '\040', '\061',
    '\012', '\165', '\146', '\126', '\040', '\165', '\163', '\040', '\061',
    '\012', '\162', '\130', '\155', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\132', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\121', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\124', '\156', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\122', '\155', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\154', '\115', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\161', '\117', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\127', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\152', '\143', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\146', '\126', '\040', '\151', '\152', '\040', '\061',
    '\012', '\132', '\155', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\170', '\115', '\040', '\142', '\145', '\040', '\061',
    '\012', '\146', '\106', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\152', '\120', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\115', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\163', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\153', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\155', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\131', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\144', '\166', '\130', '\040', '\144', '\145', '\040', '\061',
    '\012', '\162', '\167', '\103', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\167', '\127', '\040', '\167', '\141', '\040', '\061',
    '\012', '\121', '\160', '\171', '\040', '\160', '\162', '\040', '\061',
    '\012', '\152', '\130', '\171', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\117', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\155', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\105', '\161', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\112', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\110', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\150', '\104', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\104', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\153', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\114', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\110', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\156', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\170', '\123', '\040', '\151', '\152', '\040', '\061',
    '\012', '\112', '\164', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\147', '\105', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\160', '\110', '\040', '\160', '\162', '\040', '\061',
    '\012', '\111', '\161', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\115', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\155', '\105', '\040', '\144', '\145', '\040', '\061',
    '\012', '\110', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\123', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\150', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\152', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\146', '\130', '\040', '\156', '\171', '\040', '\061',
    '\012', '\166', '\165', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\106', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\172', '\156', '\123', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\154', '\126', '\040', '\154', '\145', '\040', '\061',
    '\012', '\154', '\153', '\113', '\040', '\154', '\145', '\040', '\061',
    '\012', '\106', '\166', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\152', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\157', '\121', '\040', '\157', '\156', '\040', '\061',
    '\012', '\127', '\166', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\115', '\156', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\115', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\143', '\106', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\142', '\102', '\040', '\144', '\145', '\040', '\061',
    '\012', '\103', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\103', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\112', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\104', '\146', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\163', '\152', '\114', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\151', '\107', '\040', '\151', '\156', '\040', '\061',
    '\012', '\132', '\154', '\163', '\040', '\154', '\145', '\040', '\061',
    '\012', '\126', '\163', '\146', '\040', '\163', '\164', '\040', '\061',
    '\012', '\106', '\147', '\144', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\155', '\104', '\040', '\155', '\145', '\040', '\061',
    '\012', '\104', '\170', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\161', '\162', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\112', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\114', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\144', '\102', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\142', '\115', '\040', '\142', '\145', '\040', '\061',
    '\012', '\155', '\166', '\115', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\164', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\156', '\102', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\164', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\163', '\144', '\040', '\163', '\164', '\040', '\061',
    '\012', '\167', '\161', '\154', '\040', '\167', '\141', '\040', '\061',
    '\012', '\155', '\150', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\112', '\171', '\040', '\157', '\156', '\040', '\061',
    '\012', '\107', '\150', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\157', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\163', '\111', '\040', '\163', '\164', '\040', '\061',
    '\012', '\166', '\106', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\131', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\154', '\156', '\126', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\130', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\105', '\157', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\143', '\115', '\040', '\167', '\141', '\040', '\061',
    '\012', '\152', '\167', '\113', '\040', '\151', '\152', '\040', '\061',
    '\012', '\107', '\153', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\165', '\106', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\143', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\161', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\164', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\110', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\145', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\152', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\165', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\106', '\143', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\113', '\161', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\114', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\167', '\125', '\040', '\155', '\145', '\040', '\061',
    '\012', '\146', '\121', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\153', '\123', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\156', '\131', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\107', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\166', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\161', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\150', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\115', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\102', '\150', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\130', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\161', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\171', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\162', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\156', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\165', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\163', '\172', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\113', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\171', '\111', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\116', '\143', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\114', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\123', '\163', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\142', '\105', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\141', '\127', '\040', '\141', '\156', '\040', '\061',
    '\012', '\122', '\164', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\142', '\106', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\147', '\122', '\040', '\156', '\147', '\040', '\061',
    '\012', '\163', '\143', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\110', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\145', '\131', '\167', '\040', '\145', '\162', '\040', '\061',
    '\012', '\114', '\170', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\122', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\160', '\116', '\040', '\151', '\152', '\040', '\061',
    '\012', '\162', '\152', '\127', '\040', '\145', '\162', '\040', '\061',
    '\012', '\154', '\147', '\113', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\103', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\107', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\172', '\124', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\121', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\153', '\154', '\112', '\040', '\154', '\151', '\040', '\061',
    '\012', '\143', '\161', '\153', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\115', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\131', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\150', '\121', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\170', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\145', '\131', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\150', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\102', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\146', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\146', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\142', '\124', '\040', '\163', '\164', '\040', '\061',
    '\012', '\144', '\121', '\171', '\040', '\144', '\145', '\040', '\061',
    '\012', '\106', '\155', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\150', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\164', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\162', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\171', '\161', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\104', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\146', '\126', '\040', '\155', '\145', '\040', '\061',
    '\012', '\157', '\123', '\170', '\040', '\157', '\156', '\040', '\061',
    '\012', '\112', '\170', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\117', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\112', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\166', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\105', '\161', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\161', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\170', '\111', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\113', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\144', '\127', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\143', '\115', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\143', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\106', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\122', '\166', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\156', '\116', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\142', '\125', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\116', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\152', '\113', '\040', '\151', '\152', '\040', '\061',
    '\012', '\112', '\142', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\102', '\146', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\145', '\130', '\040', '\154', '\145', '\040', '\061',
    '\012', '\164', '\130', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\154', '\112', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\113', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\103', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\147', '\126', '\040', '\156', '\147', '\040', '\061',
    '\012', '\115', '\150', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\113', '\146', '\040', '\163', '\164', '\040', '\061',
    '\012', '\150', '\161', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\144', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\172', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\116', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\152', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\143', '\116', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\143', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\152', '\125', '\040', '\144', '\145', '\040', '\061',
    '\012', '\131', '\147', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\157', '\111', '\040', '\157', '\156', '\040', '\061',
    '\012', '\131', '\171', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\121', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\146', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\162', '\114', '\040', '\141', '\156', '\040', '\061',
    '\012', '\154', '\121', '\163', '\040', '\154', '\145', '\040', '\061',
    '\012', '\155', '\164', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\142', '\130', '\040', '\167', '\141', '\040', '\061',
    '\012', '\147', '\155', '\122', '\040', '\156', '\147', '\040', '\061',
    '\012', '\132', '\163', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\164', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\142', '\106', '\040', '\155', '\145', '\040', '\061',
    '\012', '\146', '\147', '\124', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\127', '\165', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\170', '\107', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\116', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\146', '\127', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\162', '\103', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\157', '\130', '\040', '\157', '\156', '\040', '\061',
    '\012', '\167', '\152', '\124', '\040', '\151', '\152', '\040', '\061',
    '\012', '\120', '\161', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\153', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\156', '\114', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\152', '\126', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\143', '\120', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\154', '\121', '\040', '\154', '\145', '\040', '\061',
    '\012', '\106', '\147', '\161', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\147', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\161', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\113', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\146', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\171', '\132', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\151', '\132', '\040', '\151', '\156', '\040', '\061',
    '\012', '\162', '\130', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\131', '\143', '\171', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\166', '\101', '\040', '\166', '\141', '\040', '\061',
    '\012', '\124', '\161', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\132', '\171', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\167', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\126', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\115', '\150', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\123', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\150', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\172', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\166', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\161', '\125', '\040', '\143', '\150', '\040', '\061',
    '\012', '\110', '\150', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\121', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\167', '\114', '\040', '\160', '\162', '\040', '\061',
    '\012', '\163', '\116', '\167', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\105', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\116', '\172', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\163', '\104', '\040', '\163', '\164', '\040', '\061',
    '\012', '\155', '\104', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\164', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\114', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\124', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\112', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\161', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\161', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\162', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\161', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\111', '\171', '\040', '\155', '\145', '\040', '\061',
    '\012', '\111', '\160', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\152', '\103', '\040', '\151', '\152', '\040', '\061',
    '\012', '\154', '\114', '\160', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\161', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\127', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\131', '\143', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\152', '\125', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\130', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\161', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\170', '\124', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\156', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\102', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\154', '\163', '\040', '\154', '\145', '\040', '\061',
    '\012', '\153', '\150', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\161', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\142', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\151', '\104', '\170', '\040', '\154', '\151', '\040', '\061',
    '\012', '\132', '\156', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\112', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\161', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\142', '\125', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\122', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\160', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\154', '\107', '\040', '\154', '\145', '\040', '\061',
    '\012', '\127', '\147', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\126', '\170', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\123', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\151', '\150', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\172', '\124', '\040', '\163', '\172', '\040', '\061',
    '\012', '\141', '\145', '\132', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\113', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\127', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\114', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\160', '\113', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\112', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\107', '\166', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\105', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\163', '\113', '\144', '\040', '\163', '\164', '\040', '\061',
    '\012', '\170', '\150', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\141', '\115', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\145', '\150', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\146', '\132', '\040', '\153', '\165', '\040', '\061',
    '\012', '\127', '\167', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\155', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\126', '\153', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\172', '\104', '\040', '\163', '\172', '\040', '\061',
    '\012', '\130', '\153', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\126', '\172', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\166', '\126', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\110', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\113', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\155', '\115', '\040', '\166', '\141', '\040', '\061',
    '\012', '\121', '\170', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\116', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\161', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\161', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\161', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\166', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\154', '\102', '\146', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\161', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\103', '\163', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\122', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\156', '\155', '\040', '\141', '\156', '\040', '\061',
    '\012', '\114', '\172', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\151', '\167', '\116', '\040', '\151', '\156', '\040', '\061',
    '\012', '\160', '\146', '\116', '\040', '\160', '\162', '\040', '\061',
    '\012', '\150', '\103', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\165', '\110', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\114', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\167', '\104', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\152', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\117', '\152', '\171', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\155', '\126', '\040', '\144', '\151', '\040', '\061',
    '\012', '\143', '\103', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\130', '\163', '\040', '\154', '\145', '\040', '\061',
    '\012', '\163', '\155', '\122', '\040', '\163', '\164', '\040', '\061',
    '\012', '\155', '\170', '\117', '\040', '\155', '\145', '\040', '\061',
    '\012', '\112', '\162', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\152', '\116', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\102', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\170', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\113', '\144', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\104', '\154', '\142', '\040', '\154', '\145', '\040', '\061',
    '\012', '\160', '\161', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\161', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\123', '\160', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\103', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\146', '\120', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\107', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\142', '\105', '\040', '\142', '\145', '\040', '\061',
    '\012', '\130', '\160', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\130', '\172', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\161', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\161', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\166', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\127', '\151', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\170', '\132', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\157', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\123', '\147', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\122', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\127', '\147', '\151', '\040', '\156', '\147', '\040', '\061',
    '\012', '\145', '\104', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\127', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\106', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\170', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\151', '\127', '\160', '\040', '\151', '\156', '\040', '\061',
    '\012', '\146', '\122', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\167', '\164', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\167', '\127', '\040', '\163', '\164', '\040', '\061',
    '\012', '\147', '\162', '\113', '\040', '\156', '\147', '\040', '\061',
    '\012', '\110', '\146', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\146', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\161', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\113', '\152', '\040', '\157', '\156', '\040', '\061',
    '\012', '\166', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\127', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\165', '\127', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\103', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\153', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\104', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\123', '\146', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\131', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\166', '\122', '\040', '\166', '\141', '\040', '\061',
    '\012', '\145', '\101', '\157', '\040', '\145', '\162', '\040', '\061',
    '\012', '\160', '\131', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\122', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\151', '\127', '\144', '\040', '\151', '\156', '\040', '\061',
    '\012', '\147', '\107', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\130', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\143', '\120', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\143', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\103', '\146', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\155', '\127', '\040', '\156', '\147', '\040', '\061',
    '\012', '\110', '\153', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\162', '\150', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\161', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\121', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\103', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\127', '\152', '\040', '\144', '\145', '\040', '\061',
    '\012', '\110', '\162', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\163', '\124', '\172', '\040', '\163', '\164', '\040', '\061',
    '\012', '\141', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\167', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\166', '\105', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\113', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\143', '\131', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\160', '\115', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\154', '\103', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\154', '\107', '\040', '\154', '\145', '\040', '\061',
    '\012', '\157', '\124', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\151', '\114', '\160', '\040', '\151', '\156', '\040', '\061',
    '\012', '\170', '\163', '\114', '\040', '\163', '\164', '\040', '\061',
    '\012', '\154', '\106', '\172', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\150', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\154', '\130', '\040', '\154', '\145', '\040', '\061',
    '\012', '\160', '\155', '\117', '\040', '\155', '\145', '\040', '\061',
    '\012', '\131', '\143', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\156', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\131', '\142', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\121', '\154', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\170', '\101', '\040', '\142', '\145', '\040', '\061',
    '\012', '\164', '\106', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\114', '\161', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\143', '\125', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\146', '\113', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\160', '\121', '\040', '\166', '\141', '\040', '\061',
    '\012', '\104', '\164', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\124', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\126', '\166', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\121', '\142', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\172', '\127', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\123', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\172', '\160', '\113', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\124', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\155', '\153', '\103', '\040', '\153', '\141', '\040', '\061',
    '\012', '\143', '\122', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\102', '\153', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\107', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\156', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\141', '\161', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\150', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\167', '\120', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\161', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\143', '\125', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\154', '\123', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\152', '\105', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\161', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\122', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\126', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\165', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\162', '\102', '\040', '\145', '\162', '\040', '\061',
    '\012', '\121', '\171', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\123', '\147', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\131', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\120', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\106', '\144', '\166', '\040', '\144', '\145', '\040', '\061',
    '\012', '\130', '\155', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\120', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\120', '\161', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\131', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\112', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\144', '\121', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\170', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\110', '\167', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\147', '\103', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\152', '\113', '\040', '\151', '\152', '\040', '\061',
    '\012', '\156', '\162', '\103', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\161', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\102', '\147', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\103', '\142', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\125', '\167', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\143', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\102', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\124', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\167', '\130', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\127', '\147', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\117', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\142', '\102', '\040', '\142', '\145', '\040', '\061',
    '\012', '\170', '\161', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\121', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\157', '\121', '\040', '\157', '\156', '\040', '\061',
    '\012', '\171', '\152', '\127', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\166', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\142', '\106', '\040', '\142', '\145', '\040', '\061',
    '\012', '\156', '\127', '\165', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\152', '\121', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\152', '\113', '\040', '\143', '\150', '\040', '\061',
    '\012', '\123', '\170', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\142', '\130', '\040', '\142', '\145', '\040', '\061',
    '\012', '\145', '\131', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\102', '\155', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\104', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\130', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\156', '\115', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\123', '\170', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\154', '\110', '\155', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\146', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\156', '\167', '\107', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\110', '\154', '\040', '\156', '\147', '\040', '\061',
    '\012', '\127', '\160', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\167', '\106', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\107', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\167', '\103', '\040', '\167', '\141', '\040', '\061',
    '\012', '\115', '\154', '\146', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\112', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\156', '\103', '\040', '\141', '\156', '\040', '\061',
    '\012', '\106', '\166', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\164', '\107', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\150', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\153', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\167', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\142', '\113', '\040', '\142', '\145', '\040', '\061',
    '\012', '\172', '\126', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\124', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\162', '\104', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\122', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\106', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\150', '\127', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\172', '\105', '\040', '\154', '\145', '\040', '\061',
    '\012', '\154', '\167', '\130', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\110', '\171', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\161', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\104', '\161', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\124', '\166', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\120', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\120', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\144', '\124', '\040', '\163', '\172', '\040', '\061',
    '\012', '\155', '\166', '\101', '\040', '\166', '\141', '\040', '\061',
    '\012', '\132', '\166', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\141', '\125', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\167', '\121', '\040', '\167', '\141', '\040', '\061',
    '\012', '\122', '\163', '\167', '\040', '\163', '\164', '\040', '\061',
    '\012', '\153', '\154', '\102', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\154', '\116', '\040', '\154', '\145', '\040', '\061',
    '\012', '\107', '\166', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\144', '\112', '\040', '\144', '\145', '\040', '\061',
    '\012', '\154', '\143', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\124', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\150', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\114', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\172', '\122', '\040', '\163', '\172', '\040', '\061',
    '\012', '\130', '\171', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\130', '\154', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\161', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\172', '\150', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\147', '\124', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\160', '\107', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\153', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\161', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\143', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\146', '\102', '\040', '\142', '\145', '\040', '\061',
    '\012', '\127', '\160', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\127', '\170', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\130', '\142', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\106', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\122', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\150', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\170', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\113', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\164', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\130', '\145', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\130', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\107', '\150', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\172', '\131', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\130', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\170', '\127', '\040', '\153', '\141', '\040', '\061',
    '\012', '\166', '\126', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\112', '\170', '\165', '\040', '\165', '\156', '\040', '\061',
    '\012', '\142', '\142', '\130', '\040', '\142', '\145', '\040', '\061',
    '\012', '\162', '\120', '\142', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\103', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\151', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\147', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\116', '\150', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\107', '\160', '\040', '\160', '\157', '\040', '\061',
    '\012', '\150', '\120', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\124', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\111', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\112', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\143', '\105', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\103', '\142', '\040', '\155', '\145', '\040', '\061',
    '\012', '\142', '\112', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\172', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\161', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\110', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\142', '\167', '\110', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\103', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\161', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\170', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\160', '\117', '\040', '\160', '\162', '\040', '\061',
    '\012', '\153', '\143', '\116', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\153', '\126', '\040', '\153', '\141', '\040', '\061',
    '\012', '\155', '\121', '\142', '\040', '\155', '\145', '\040', '\061',
    '\012', '\131', '\161', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\126', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\166', '\142', '\130', '\040', '\166', '\141', '\040', '\061',
    '\012', '\155', '\124', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\130', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\167', '\161', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\113', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\153', '\123', '\040', '\153', '\141', '\040', '\061',
    '\012', '\127', '\166', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\111', '\171', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\107', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\172', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\150', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\166', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\130', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\156', '\130', '\143', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\112', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\116', '\161', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\152', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\106', '\150', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\171', '\113', '\040', '\151', '\152', '\040', '\061',
    '\012', '\112', '\172', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\161', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\155', '\132', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\142', '\106', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\160', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\120', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\123', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\115', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\130', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\171', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\106', '\167', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\155', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\116', '\154', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\161', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\107', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\155', '\130', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\131', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\155', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\104', '\161', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\127', '\153', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\144', '\160', '\124', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\171', '\112', '\040', '\151', '\152', '\040', '\061',
    '\012', '\112', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\152', '\132', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\116', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\101', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\102', '\156', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\160', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\147', '\127', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\130', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\162', '\115', '\154', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\147', '\126', '\040', '\156', '\147', '\040', '\061',
    '\012', '\156', '\114', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\106', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\164', '\166', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\121', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\146', '\144', '\106', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\170', '\113', '\040', '\142', '\145', '\040', '\061',
    '\012', '\102', '\143', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\160', '\131', '\040', '\145', '\162', '\040', '\061',
    '\012', '\163', '\112', '\142', '\040', '\163', '\164', '\040', '\061',
    '\012', '\113', '\166', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\116', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\110', '\144', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\172', '\106', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\112', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\146', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\121', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\160', '\113', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\150', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\132', '\151', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\150', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\161', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\156', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\112', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\112', '\153', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\122', '\167', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\172', '\166', '\115', '\040', '\166', '\141', '\040', '\061',
    '\012', '\142', '\170', '\131', '\040', '\142', '\145', '\040', '\061',
    '\012', '\160', '\130', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\125', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\160', '\166', '\105', '\040', '\166', '\141', '\040', '\061',
    '\012', '\114', '\160', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\144', '\172', '\126', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\111', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\167', '\132', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\156', '\160', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\127', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\147', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\112', '\161', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\155', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\146', '\115', '\040', '\151', '\152', '\040', '\061',
    '\012', '\154', '\127', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\160', '\142', '\116', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\166', '\106', '\040', '\166', '\141', '\040', '\061',
    '\012', '\163', '\104', '\144', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\144', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\162', '\114', '\040', '\145', '\162', '\040', '\061',
    '\012', '\165', '\110', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\167', '\116', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\102', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\172', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\104', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\143', '\172', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\172', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\105', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\170', '\110', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\161', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\161', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\153', '\104', '\040', '\156', '\147', '\040', '\061',
    '\012', '\130', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\130', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\103', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\120', '\172', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\122', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\161', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\166', '\127', '\040', '\166', '\141', '\040', '\061',
    '\012', '\122', '\146', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\147', '\161', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\147', '\117', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\125', '\171', '\040', '\167', '\141', '\040', '\061',
    '\012', '\112', '\153', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\150', '\123', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\153', '\127', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\147', '\171', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\112', '\142', '\040', '\144', '\145', '\040', '\061',
    '\012', '\160', '\162', '\106', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\165', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\126', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\164', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\104', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\147', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\113', '\161', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\171', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\154', '\112', '\153', '\040', '\154', '\145', '\040', '\061',
    '\012', '\163', '\170', '\131', '\040', '\163', '\164', '\040', '\061',
    '\012', '\170', '\146', '\131', '\040', '\146', '\157', '\040', '\061',
    '\012', '\130', '\153', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\147', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\171', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\142', '\106', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\124', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\163', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\154', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\172', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\161', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\160', '\121', '\040', '\160', '\157', '\040', '\061',
    '\012', '\161', '\112', '\165', '\040', '\165', '\156', '\040', '\061',
    '\012', '\150', '\131', '\151', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\154', '\115', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\104', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\166', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\116', '\163', '\146', '\040', '\163', '\164', '\040', '\061',
    '\012', '\142', '\112', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\116', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\121', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\113', '\161', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\113', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\155', '\110', '\160', '\040', '\155', '\145', '\040', '\061',
    '\012', '\125', '\171', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\170', '\131', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\111', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\124', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\146', '\120', '\040', '\167', '\141', '\040', '\061',
    '\012', '\146', '\170', '\111', '\040', '\146', '\157', '\040', '\061',
    '\012', '\166', '\121', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\166', '\116', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\167', '\116', '\040', '\160', '\162', '\040', '\061',
    '\012', '\166', '\141', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\170', '\121', '\040', '\155', '\145', '\040', '\061',
    '\012', '\142', '\144', '\126', '\040', '\144', '\145', '\040', '\061',
    '\012', '\103', '\147', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\152', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\127', '\161', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\160', '\117', '\040', '\160', '\162', '\040', '\061',
    '\012', '\167', '\157', '\121', '\040', '\157', '\156', '\040', '\061',
    '\012', '\170', '\131', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\160', '\124', '\040', '\160', '\162', '\040', '\061',
    '\012', '\154', '\116', '\160', '\040', '\154', '\145', '\040', '\061',
    '\012', '\160', '\166', '\130', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\114', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\113', '\163', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\127', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\151', '\125', '\171', '\040', '\151', '\156', '\040', '\061',
    '\012', '\142', '\146', '\130', '\040', '\142', '\145', '\040', '\061',
    '\012', '\170', '\163', '\126', '\040', '\163', '\164', '\040', '\061',
    '\012', '\130', '\156', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\155', '\127', '\040', '\144', '\145', '\040', '\061',
    '\012', '\157', '\121', '\167', '\040', '\157', '\156', '\040', '\061',
    '\012', '\132', '\170', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\117', '\141', '\171', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\152', '\107', '\040', '\151', '\152', '\040', '\061',
    '\012', '\132', '\142', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\161', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\127', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\125', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\170', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\103', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\146', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\166', '\125', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\111', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\104', '\146', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\132', '\155', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\103', '\161', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\121', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\116', '\142', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\112', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\150', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\172', '\121', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\131', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\102', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\143', '\126', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\107', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\126', '\167', '\040', '\151', '\156', '\040', '\061',
    '\012', '\106', '\172', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\152', '\110', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\165', '\131', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\167', '\123', '\040', '\151', '\152', '\040', '\061',
    '\012', '\103', '\161', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\112', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\153', '\144', '\112', '\040', '\144', '\145', '\040', '\061',
    '\012', '\153', '\144', '\124', '\040', '\144', '\145', '\040', '\061',
    '\012', '\156', '\161', '\102', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\127', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\163', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\114', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\144', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\147', '\126', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\131', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\145', '\132', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\146', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\166', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\141', '\126', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\115', '\163', '\040', '\156', '\147', '\040', '\061',
    '\012', '\120', '\142', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\155', '\121', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\171', '\125', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\166', '\107', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\147', '\106', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\166', '\131', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\162', '\101', '\040', '\145', '\162', '\040', '\061',
    '\012', '\171', '\162', '\115', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\115', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\125', '\171', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\144', '\114', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\107', '\152', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\105', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\130', '\144', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\110', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\157', '\120', '\172', '\040', '\157', '\156', '\040', '\061',
    '\012', '\170', '\111', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\103', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\104', '\172', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\152', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\107', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\152', '\125', '\040', '\151', '\152', '\040', '\061',
    '\012', '\103', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\113', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\166', '\117', '\040', '\166', '\141', '\040', '\061',
    '\012', '\120', '\172', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\162', '\113', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\150', '\117', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\154', '\102', '\040', '\154', '\145', '\040', '\061',
    '\012', '\154', '\104', '\153', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\154', '\117', '\040', '\154', '\145', '\040', '\061',
    '\012', '\160', '\147', '\110', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\121', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\163', '\144', '\132', '\040', '\163', '\164', '\040', '\061',
    '\012', '\153', '\121', '\155', '\040', '\153', '\141', '\040', '\061',
    '\012', '\154', '\122', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\121', '\171', '\040', '\157', '\156', '\040', '\061',
    '\012', '\164', '\167', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\102', '\144', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\152', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\156', '\120', '\040', '\141', '\156', '\040', '\061',
    '\012', '\116', '\156', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\151', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\103', '\143', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\110', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\114', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\163', '\146', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\113', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\146', '\153', '\105', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\154', '\130', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\132', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\126', '\167', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\142', '\101', '\040', '\163', '\172', '\040', '\061',
    '\012', '\110', '\150', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\142', '\131', '\040', '\143', '\150', '\040', '\061',
    '\012', '\111', '\153', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\107', '\162', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\152', '\160', '\120', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\146', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\150', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\155', '\130', '\040', '\155', '\145', '\040', '\061',
    '\012', '\141', '\112', '\142', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\146', '\117', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\130', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\130', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\156', '\126', '\040', '\141', '\156', '\040', '\061',
    '\012', '\131', '\160', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\172', '\103', '\171', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\150', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\130', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\107', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\170', '\124', '\040', '\143', '\150', '\040', '\061',
    '\012', '\132', '\163', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\107', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\172', '\115', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\152', '\123', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\146', '\123', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\160', '\110', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\147', '\117', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\161', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\146', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\124', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\132', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\105', '\152', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\121', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\131', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\152', '\126', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\127', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\146', '\122', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\165', '\123', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\103', '\170', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\114', '\143', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\172', '\113', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\161', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\112', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\103', '\152', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\166', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\167', '\116', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\155', '\122', '\040', '\155', '\145', '\040', '\061',
    '\012', '\142', '\164', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\124', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\153', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\150', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\111', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\163', '\121', '\040', '\163', '\164', '\040', '\061',
    '\012', '\147', '\123', '\144', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\104', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\126', '\152', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\155', '\111', '\040', '\155', '\145', '\040', '\061',
    '\012', '\166', '\127', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\113', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\120', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\157', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\147', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\167', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\163', '\147', '\112', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\127', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\146', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\150', '\153', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\161', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\167', '\127', '\040', '\151', '\152', '\040', '\061',
    '\012', '\163', '\121', '\172', '\040', '\163', '\164', '\040', '\061',
    '\012', '\167', '\125', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\155', '\113', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\157', '\121', '\146', '\040', '\157', '\156', '\040', '\061',
    '\012', '\152', '\126', '\153', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\167', '\124', '\040', '\167', '\141', '\040', '\061',
    '\012', '\163', '\124', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\161', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\154', '\160', '\040', '\154', '\145', '\040', '\061',
    '\012', '\160', '\115', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\113', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\160', '\130', '\040', '\160', '\162', '\040', '\061',
    '\012', '\166', '\121', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\112', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\113', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\153', '\112', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\142', '\121', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\132', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\130', '\147', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\172', '\125', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\124', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\160', '\116', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\167', '\104', '\040', '\145', '\162', '\040', '\061',
    '\012', '\121', '\144', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\161', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\162', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\167', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\167', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\172', '\106', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\154', '\127', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\172', '\120', '\040', '\163', '\172', '\040', '\061',
    '\012', '\127', '\170', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\162', '\104', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\107', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\132', '\164', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\125', '\166', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\145', '\107', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\132', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\121', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\106', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\115', '\161', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\156', '\104', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\166', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\111', '\171', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\146', '\104', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\113', '\142', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\131', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\127', '\170', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\113', '\167', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\162', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\103', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\170', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\150', '\105', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\144', '\125', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\107', '\152', '\040', '\163', '\164', '\040', '\061',
    '\012', '\107', '\167', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\131', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\155', '\125', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\104', '\155', '\040', '\160', '\157', '\040', '\061',
    '\012', '\161', '\155', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\124', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\121', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\126', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\101', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\105', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\113', '\160', '\171', '\040', '\160', '\162', '\040', '\061',
    '\012', '\110', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\103', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\141', '\161', '\132', '\040', '\141', '\156', '\040', '\061',
    '\012', '\154', '\125', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\120', '\166', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\104', '\161', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\144', '\115', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\172', '\114', '\040', '\163', '\172', '\040', '\061',
    '\012', '\102', '\150', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\107', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\164', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\124', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\170', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\126', '\166', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\110', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\132', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\150', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\144', '\132', '\040', '\144', '\145', '\040', '\061',
    '\012', '\150', '\132', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\120', '\155', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\146', '\124', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\152', '\111', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\144', '\132', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\153', '\121', '\040', '\151', '\152', '\040', '\061',
    '\012', '\123', '\144', '\152', '\040', '\144', '\145', '\040', '\061',
    '\012', '\150', '\104', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\145', '\112', '\152', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\152', '\131', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\114', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\145', '\106', '\163', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\147', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\132', '\155', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\154', '\166', '\112', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\131', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\116', '\172', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\112', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\171', '\121', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\160', '\146', '\115', '\040', '\160', '\162', '\040', '\061',
    '\012', '\144', '\150', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\155', '\113', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\150', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\107', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\166', '\121', '\040', '\166', '\141', '\040', '\061',
    '\012', '\103', '\147', '\161', '\040', '\156', '\147', '\040', '\061',
    '\012', '\112', '\146', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\153', '\104', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\144', '\123', '\040', '\144', '\145', '\040', '\061',
    '\012', '\111', '\166', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\107', '\153', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\111', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\102', '\172', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\102', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\124', '\160', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\171', '\131', '\040', '\166', '\141', '\040', '\061',
    '\012', '\125', '\170', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\153', '\167', '\127', '\040', '\153', '\141', '\040', '\061',
    '\012', '\147', '\120', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\161', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\124', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\172', '\111', '\040', '\163', '\172', '\040', '\061',
    '\012', '\131', '\160', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\166', '\104', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\103', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\143', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\132', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\132', '\170', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\167', '\142', '\101', '\040', '\167', '\141', '\040', '\061',
    '\012', '\142', '\124', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\162', '\170', '\122', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\161', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\106', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\160', '\116', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\153', '\115', '\166', '\040', '\153', '\141', '\040', '\061',
    '\012', '\166', '\125', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\117', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\170', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\111', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\172', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\163', '\144', '\040', '\163', '\164', '\040', '\061',
    '\012', '\157', '\152', '\131', '\040', '\157', '\156', '\040', '\061',
    '\012', '\143', '\105', '\157', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\167', '\122', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\152', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\124', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\172', '\124', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\146', '\117', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\123', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\116', '\143', '\153', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\167', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\155', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\111', '\151', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\167', '\105', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\121', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\126', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\131', '\167', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\106', '\170', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\166', '\102', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\131', '\145', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\167', '\124', '\040', '\156', '\147', '\040', '\061',
    '\012', '\127', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\110', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\115', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\112', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\126', '\153', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\106', '\170', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\154', '\110', '\166', '\040', '\154', '\145', '\040', '\061',
    '\012', '\127', '\160', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\101', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\170', '\102', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\165', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\111', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\142', '\146', '\105', '\040', '\142', '\145', '\040', '\061',
    '\012', '\147', '\122', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\102', '\160', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\142', '\170', '\116', '\040', '\142', '\145', '\040', '\061',
    '\012', '\153', '\147', '\125', '\040', '\156', '\147', '\040', '\061',
    '\012', '\120', '\170', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\103', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\116', '\160', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\154', '\170', '\105', '\040', '\154', '\145', '\040', '\061',
    '\012', '\154', '\103', '\171', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\147', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\114', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\142', '\121', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\147', '\106', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\170', '\132', '\040', '\160', '\162', '\040', '\061',
    '\012', '\160', '\120', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\151', '\131', '\172', '\040', '\151', '\156', '\040', '\061',
    '\012', '\166', '\112', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\153', '\124', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\126', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\167', '\123', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\124', '\144', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\121', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\105', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\160', '\120', '\040', '\160', '\162', '\040', '\061',
    '\012', '\161', '\152', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\117', '\171', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\155', '\143', '\117', '\040', '\143', '\150', '\040', '\061',
    '\012', '\126', '\152', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\144', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\114', '\146', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\166', '\132', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\117', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\152', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\113', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\147', '\125', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\147', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\115', '\166', '\040', '\144', '\145', '\040', '\061',
    '\012', '\130', '\143', '\160', '\040', '\143', '\150', '\040', '\061',
    '\012', '\106', '\167', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\167', '\101', '\040', '\160', '\162', '\040', '\061',
    '\012', '\114', '\160', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\153', '\120', '\040', '\153', '\141', '\040', '\061',
    '\012', '\166', '\110', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\112', '\152', '\171', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\103', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\166', '\115', '\040', '\166', '\141', '\040', '\061',
    '\012', '\111', '\143', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\146', '\112', '\040', '\153', '\141', '\040', '\061',
    '\012', '\150', '\163', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\127', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\125', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\114', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\152', '\116', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\147', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\114', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\161', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\155', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\132', '\152', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\132', '\153', '\160', '\040', '\153', '\141', '\040', '\061',
    '\012', '\151', '\171', '\110', '\040', '\151', '\156', '\040', '\061',
    '\012', '\167', '\165', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\172', '\124', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\167', '\113', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\103', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\171', '\144', '\107', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\144', '\125', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\124', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\154', '\110', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\171', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\154', '\126', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\171', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\127', '\156', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\115', '\172', '\040', '\145', '\162', '\040', '\061',
    '\012', '\160', '\130', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\130', '\142', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\110', '\155', '\040', '\153', '\141', '\040', '\061',
    '\012', '\143', '\126', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\172', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\144', '\116', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\115', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\152', '\123', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\155', '\103', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\111', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\146', '\160', '\115', '\040', '\160', '\162', '\040', '\061',
    '\012', '\154', '\143', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\110', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\112', '\152', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\154', '\107', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\143', '\113', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\121', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\166', '\111', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\167', '\102', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\167', '\143', '\111', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\112', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\121', '\142', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\102', '\152', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\160', '\131', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\143', '\106', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\123', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\151', '\130', '\152', '\040', '\151', '\156', '\040', '\061',
    '\012', '\121', '\147', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\104', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\143', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\123', '\161', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\155', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\143', '\125', '\040', '\143', '\150', '\040', '\061',
    '\012', '\102', '\166', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\172', '\105', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\164', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\142', '\114', '\040', '\166', '\141', '\040', '\061',
    '\012', '\142', '\103', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\160', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\155', '\130', '\163', '\040', '\155', '\145', '\040', '\061',
    '\012', '\132', '\161', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\153', '\171', '\040', '\153', '\141', '\040', '\061',
    '\012', '\130', '\155', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\114', '\156', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\131', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\122', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\155', '\113', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\167', '\120', '\040', '\166', '\141', '\040', '\061',
    '\012', '\145', '\106', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\116', '\152', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\153', '\154', '\107', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\142', '\105', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\127', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\160', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\132', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\122', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\130', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\151', '\171', '\104', '\040', '\151', '\156', '\040', '\061',
    '\012', '\146', '\166', '\114', '\040', '\166', '\141', '\040', '\061',
    '\012', '\162', '\120', '\167', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\144', '\122', '\040', '\144', '\145', '\040', '\061',
    '\012', '\151', '\123', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\142', '\121', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\170', '\121', '\040', '\170', '\145', '\040', '\061',
    '\012', '\104', '\152', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\147', '\113', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\150', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\147', '\107', '\040', '\156', '\147', '\040', '\061',
    '\012', '\131', '\153', '\171', '\040', '\153', '\141', '\040', '\061',
    '\012', '\103', '\170', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\127', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\154', '\155', '\131', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\162', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\167', '\113', '\040', '\167', '\141', '\040', '\061',
    '\012', '\170', '\161', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\124', '\167', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\130', '\147', '\161', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\167', '\132', '\040', '\144', '\145', '\040', '\061',
    '\012', '\156', '\121', '\154', '\040', '\141', '\156', '\040', '\061',
    '\012', '\107', '\150', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\156', '\110', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\155', '\125', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\161', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\152', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\172', '\123', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\167', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\131', '\162', '\040', '\156', '\147', '\040', '\061',
    '\012', '\106', '\147', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\144', '\113', '\040', '\144', '\145', '\040', '\061',
    '\012', '\150', '\170', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\125', '\170', '\040', '\170', '\145', '\040', '\061',
    '\012', '\167', '\155', '\124', '\040', '\155', '\145', '\040', '\061',
    '\012', '\171', '\131', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\143', '\104', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\126', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\123', '\147', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\120', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\131', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\142', '\172', '\105', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\150', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\116', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\164', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\150', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\114', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\114', '\146', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\147', '\126', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\153', '\123', '\040', '\156', '\147', '\040', '\061',
    '\012', '\112', '\161', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\127', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\147', '\117', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\147', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\120', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\127', '\170', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\147', '\161', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\103', '\146', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\157', '\125', '\040', '\157', '\156', '\040', '\061',
    '\012', '\171', '\143', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\167', '\104', '\040', '\153', '\141', '\040', '\061',
    '\012', '\123', '\142', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\161', '\143', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\110', '\167', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\155', '\114', '\040', '\155', '\145', '\040', '\061',
    '\012', '\147', '\167', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\113', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\130', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\151', '\113', '\170', '\040', '\151', '\156', '\040', '\061',
    '\012', '\154', '\122', '\172', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\110', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\106', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\112', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\155', '\111', '\040', '\155', '\145', '\040', '\061',
    '\012', '\143', '\103', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\151', '\131', '\144', '\040', '\151', '\156', '\040', '\061',
    '\012', '\171', '\146', '\131', '\040', '\156', '\171', '\040', '\061',
    '\012', '\170', '\142', '\131', '\040', '\142', '\145', '\040', '\061',
    '\012', '\142', '\155', '\105', '\040', '\155', '\145', '\040', '\061',
    '\012', '\146', '\102', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\144', '\110', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\143', '\122', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\166', '\114', '\040', '\166', '\141', '\040', '\061',
    '\012', '\162', '\152', '\114', '\040', '\145', '\162', '\040', '\061',
    '\012', '\163', '\131', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\127', '\160', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\170', '\102', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\102', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\144', '\112', '\040', '\156', '\147', '\040', '\061',
    '\012', '\131', '\152', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\146', '\160', '\121', '\040', '\160', '\162', '\040', '\061',
    '\012', '\161', '\117', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\152', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\143', '\124', '\040', '\143', '\150', '\040', '\061',
    '\012', '\114', '\146', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\106', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\115', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\123', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\121', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\104', '\171', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\162', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\131', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\126', '\156', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\110', '\143', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\144', '\125', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\166', '\120', '\040', '\166', '\141', '\040', '\061',
    '\012', '\131', '\146', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\153', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\110', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\126', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\153', '\126', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\160', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\106', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\127', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\160', '\131', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\116', '\166', '\040', '\144', '\145', '\040', '\061',
    '\012', '\127', '\167', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\106', '\155', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\155', '\104', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\115', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\132', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\116', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\150', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\142', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\154', '\113', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\151', '\132', '\170', '\040', '\151', '\156', '\040', '\061',
    '\012', '\163', '\152', '\124', '\040', '\163', '\172', '\040', '\061',
    '\012', '\151', '\152', '\131', '\040', '\151', '\156', '\040', '\061',
    '\012', '\161', '\164', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\124', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\110', '\160', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\151', '\107', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\161', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\147', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\106', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\117', '\161', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\130', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\132', '\142', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\113', '\155', '\040', '\154', '\145', '\040', '\061',
    '\012', '\123', '\166', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\113', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\126', '\155', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\155', '\111', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\147', '\113', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\124', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\146', '\103', '\040', '\146', '\157', '\040', '\061',
    '\012', '\150', '\113', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\123', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\113', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\156', '\121', '\163', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\151', '\107', '\040', '\151', '\156', '\040', '\061',
    '\012', '\161', '\147', '\115', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\121', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\103', '\152', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\120', '\171', '\040', '\151', '\152', '\040', '\061',
    '\012', '\130', '\161', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\120', '\172', '\171', '\040', '\163', '\172', '\040', '\061',
    '\012', '\106', '\164', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\143', '\105', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\153', '\114', '\040', '\153', '\141', '\040', '\061',
    '\012', '\110', '\172', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\124', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\130', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\155', '\115', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\126', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\124', '\161', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\127', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\170', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\121', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\166', '\114', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\120', '\147', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\110', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\170', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\112', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\115', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\111', '\170', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\103', '\171', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\160', '\130', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\160', '\114', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\124', '\167', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\104', '\164', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\122', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\130', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\150', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\111', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\152', '\114', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\170', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\104', '\155', '\040', '\154', '\145', '\040', '\061',
    '\012', '\164', '\130', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\152', '\103', '\040', '\156', '\147', '\040', '\061',
    '\012', '\132', '\172', '\144', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\147', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\156', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\152', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\126', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\142', '\111', '\040', '\142', '\145', '\040', '\061',
    '\012', '\132', '\160', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\146', '\117', '\040', '\142', '\145', '\040', '\061',
    '\012', '\155', '\123', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\141', '\106', '\040', '\141', '\156', '\040', '\061',
    '\012', '\141', '\121', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\152', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\130', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\161', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\166', '\122', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\123', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\144', '\126', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\124', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\113', '\172', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\164', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\145', '\147', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\170', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\150', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\107', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\104', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\157', '\131', '\040', '\157', '\156', '\040', '\061',
    '\012', '\144', '\113', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\112', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\167', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\111', '\170', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\115', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\130', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\121', '\171', '\040', '\163', '\172', '\040', '\061',
    '\012', '\116', '\160', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\121', '\146', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\114', '\155', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\107', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\110', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\143', '\131', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\161', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\104', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\147', '\107', '\040', '\156', '\147', '\040', '\061',
    '\012', '\104', '\161', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\155', '\117', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\144', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\116', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\162', '\130', '\152', '\040', '\145', '\162', '\040', '\061',
    '\012', '\112', '\167', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\104', '\142', '\040', '\155', '\145', '\040', '\061',
    '\012', '\167', '\115', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\131', '\152', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\152', '\131', '\040', '\151', '\152', '\040', '\061',
    '\012', '\151', '\112', '\142', '\040', '\151', '\156', '\040', '\061',
    '\012', '\143', '\144', '\103', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\142', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\106', '\160', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\172', '\150', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\103', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\130', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\153', '\104', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\165', '\161', '\124', '\040', '\165', '\156', '\040', '\061',
    '\012', '\102', '\170', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\102', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\107', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\130', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\171', '\142', '\106', '\040', '\142', '\145', '\040', '\061',
    '\012', '\144', '\164', '\101', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\126', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\103', '\142', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\164', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\144', '\152', '\040', '\144', '\145', '\040', '\061',
    '\012', '\153', '\120', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\132', '\166', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\120', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\157', '\110', '\040', '\157', '\156', '\040', '\061',
    '\012', '\130', '\160', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\130', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\124', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\167', '\121', '\040', '\153', '\141', '\040', '\061',
    '\012', '\153', '\132', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\125', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\112', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\103', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\115', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\150', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\142', '\102', '\040', '\153', '\141', '\040', '\061',
    '\012', '\107', '\160', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\107', '\172', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\167', '\105', '\040', '\167', '\141', '\040', '\061',
    '\012', '\124', '\164', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\161', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\172', '\116', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\153', '\117', '\040', '\153', '\141', '\040', '\061',
    '\012', '\165', '\172', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\170', '\121', '\040', '\157', '\156', '\040', '\061',
    '\012', '\126', '\147', '\155', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\155', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\161', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\122', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\124', '\156', '\162', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\152', '\127', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\167', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\164', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\156', '\114', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\104', '\170', '\040', '\156', '\171', '\040', '\061',
    '\012', '\170', '\146', '\121', '\040', '\146', '\157', '\040', '\061',
    '\012', '\167', '\170', '\112', '\040', '\167', '\141', '\040', '\061',
    '\012', '\156', '\170', '\105', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\121', '\156', '\040', '\151', '\156', '\040', '\061',
    '\012', '\127', '\153', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\167', '\104', '\040', '\167', '\141', '\040', '\061',
    '\012', '\160', '\106', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\154', '\142', '\113', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\110', '\171', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\126', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\117', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\143', '\116', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\127', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\115', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\167', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\156', '\115', '\040', '\141', '\156', '\040', '\061',
    '\012', '\132', '\164', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\121', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\126', '\170', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\125', '\170', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\127', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\171', '\122', '\170', '\040', '\156', '\171', '\040', '\061',
    '\012', '\161', '\113', '\165', '\040', '\165', '\156', '\040', '\061',
    '\012', '\152', '\130', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\160', '\130', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\153', '\107', '\040', '\144', '\145', '\040', '\061',
    '\012', '\102', '\156', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\131', '\153', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\147', '\142', '\127', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\154', '\130', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\153', '\110', '\040', '\153', '\141', '\040', '\061',
    '\012', '\144', '\113', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\113', '\160', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\161', '\115', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\102', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\120', '\152', '\040', '\145', '\162', '\040', '\061',
    '\012', '\110', '\172', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\131', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\107', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\111', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\125', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\162', '\124', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\161', '\111', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\146', '\120', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\122', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\122', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\152', '\152', '\113', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\146', '\105', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\163', '\167', '\040', '\163', '\164', '\040', '\061',
    '\012', '\106', '\143', '\155', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\112', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\164', '\130', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\122', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\161', '\105', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\107', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\113', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\130', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\102', '\171', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\124', '\144', '\040', '\154', '\145', '\040', '\061',
    '\012', '\127', '\161', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\106', '\164', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\144', '\102', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\156', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\102', '\161', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\161', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\144', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\157', '\152', '\112', '\040', '\157', '\156', '\040', '\061',
    '\012', '\161', '\132', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\172', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\154', '\121', '\040', '\154', '\145', '\040', '\061',
    '\012', '\132', '\142', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\155', '\166', '\114', '\040', '\166', '\141', '\040', '\061',
    '\012', '\114', '\152', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\107', '\161', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\146', '\105', '\040', '\155', '\145', '\040', '\061',
    '\012', '\170', '\121', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\114', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\114', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\102', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\125', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\144', '\114', '\040', '\144', '\145', '\040', '\061',
    '\012', '\155', '\112', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\144', '\170', '\125', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\161', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\160', '\107', '\040', '\160', '\162', '\040', '\061',
    '\012', '\164', '\154', '\117', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\150', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\104', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\122', '\161', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\166', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\152', '\131', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\162', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\171', '\131', '\040', '\156', '\171', '\040', '\061',
    '\012', '\171', '\150', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\131', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\114', '\155', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\112', '\163', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\142', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\141', '\120', '\142', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\167', '\112', '\040', '\144', '\145', '\040', '\061',
    '\012', '\130', '\171', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\165', '\143', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\124', '\146', '\040', '\144', '\145', '\040', '\061',
    '\012', '\154', '\102', '\142', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\113', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\143', '\122', '\040', '\143', '\150', '\040', '\061',
    '\012', '\145', '\121', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\131', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\126', '\164', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\103', '\143', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\101', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\170', '\112', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\166', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\102', '\150', '\155', '\040', '\155', '\141', '\040', '\061',
    '\012', '\132', '\147', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\172', '\112', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\166', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\124', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\144', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\167', '\107', '\040', '\166', '\141', '\040', '\061',
    '\012', '\131', '\155', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\157', '\131', '\167', '\040', '\157', '\156', '\040', '\061',
    '\012', '\152', '\130', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\167', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\166', '\126', '\170', '\040', '\166', '\151', '\040', '\061',
    '\012', '\122', '\167', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\104', '\166', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\113', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\114', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\171', '\166', '\040', '\166', '\151', '\040', '\061',
    '\012', '\103', '\161', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\122', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\121', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\161', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\132', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\161', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\142', '\117', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\126', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\154', '\155', '\040', '\154', '\145', '\040', '\061',
    '\012', '\165', '\132', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\120', '\160', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\126', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\126', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\112', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\131', '\172', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\103', '\166', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\167', '\123', '\040', '\160', '\162', '\040', '\061',
    '\012', '\113', '\153', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\127', '\166', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\106', '\144', '\171', '\040', '\144', '\145', '\040', '\061',
    '\012', '\160', '\160', '\130', '\040', '\160', '\162', '\040', '\061',
    '\012', '\150', '\166', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\167', '\107', '\040', '\151', '\156', '\040', '\061',
    '\012', '\162', '\102', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\102', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\131', '\163', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\143', '\117', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\105', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\142', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\121', '\163', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\166', '\103', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\153', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\151', '\167', '\040', '\151', '\156', '\040', '\061',
    '\012', '\107', '\164', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\101', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\126', '\171', '\040', '\167', '\141', '\040', '\061',
    '\012', '\142', '\170', '\124', '\040', '\142', '\145', '\040', '\061',
    '\012', '\121', '\150', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\154', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\142', '\101', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\146', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\170', '\127', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\145', '\126', '\040', '\145', '\162', '\040', '\061',
    '\012', '\162', '\161', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\161', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\113', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\151', '\124', '\146', '\040', '\151', '\156', '\040', '\061',
    '\012', '\153', '\167', '\125', '\040', '\153', '\141', '\040', '\061',
    '\012', '\151', '\106', '\161', '\040', '\151', '\156', '\040', '\061',
    '\012', '\155', '\152', '\132', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\147', '\112', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\114', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\163', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\104', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\144', '\106', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\170', '\116', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\107', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\144', '\125', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\112', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\103', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\104', '\150', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\111', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\141', '\121', '\155', '\040', '\141', '\156', '\040', '\061',
    '\012', '\131', '\172', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\166', '\110', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\142', '\152', '\126', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\123', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\161', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\162', '\127', '\040', '\145', '\162', '\040', '\061',
    '\012', '\110', '\172', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\127', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\115', '\153', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\147', '\106', '\040', '\156', '\147', '\040', '\061',
    '\012', '\103', '\156', '\153', '\040', '\141', '\156', '\040', '\061',
    '\012', '\162', '\104', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\172', '\102', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\117', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\165', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\146', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\115', '\150', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\131', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\153', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\131', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\164', '\161', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\160', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\142', '\107', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\170', '\106', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\167', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\113', '\147', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\111', '\161', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\112', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\121', '\153', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\126', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\124', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\132', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\104', '\172', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\146', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\141', '\146', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\121', '\167', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\144', '\112', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\124', '\165', '\040', '\165', '\156', '\040', '\061',
    '\012', '\125', '\143', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\110', '\156', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\110', '\142', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\171', '\110', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\124', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\170', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\144', '\123', '\040', '\144', '\145', '\040', '\061',
    '\012', '\127', '\147', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\157', '\161', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\162', '\146', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\131', '\171', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\115', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\113', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\110', '\171', '\170', '\040', '\156', '\171', '\040', '\061',
    '\012', '\115', '\170', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\110', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\146', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\147', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\155', '\117', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\172', '\123', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\167', '\121', '\040', '\151', '\152', '\040', '\061',
    '\012', '\106', '\150', '\143', '\040', '\151', '\143', '\040', '\061',
    '\012', '\170', '\111', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\146', '\110', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\161', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\106', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\121', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\150', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\103', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\110', '\147', '\162', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\161', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\147', '\123', '\040', '\156', '\147', '\040', '\061',
    '\012', '\116', '\161', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\121', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\121', '\172', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\111', '\170', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\103', '\170', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\155', '\170', '\116', '\040', '\155', '\145', '\040', '\061',
    '\012', '\166', '\121', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\143', '\101', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\145', '\103', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\161', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\161', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\126', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\161', '\157', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\170', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\172', '\130', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\130', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\121', '\164', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\150', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\147', '\171', '\040', '\156', '\147', '\040', '\061',
    '\012', '\130', '\156', '\142', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\127', '\155', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\130', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\127', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\113', '\155', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\166', '\110', '\040', '\166', '\141', '\040', '\061',
    '\012', '\125', '\145', '\167', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\112', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\110', '\153', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\155', '\120', '\040', '\155', '\145', '\040', '\061',
    '\012', '\163', '\154', '\122', '\040', '\151', '\163', '\040', '\061',
    '\012', '\125', '\141', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\142', '\107', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\116', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\126', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\107', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\151', '\167', '\125', '\040', '\151', '\156', '\040', '\061',
    '\012', '\103', '\156', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\162', '\130', '\144', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\127', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\107', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\142', '\131', '\040', '\142', '\145', '\040', '\061',
    '\012', '\150', '\172', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\127', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\115', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\152', '\172', '\127', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\114', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\132', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\110', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\126', '\167', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\166', '\164', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\145', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\170', '\107', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\121', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\107', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\166', '\101', '\040', '\143', '\150', '\040', '\061',
    '\012', '\157', '\124', '\155', '\040', '\157', '\156', '\040', '\061',
    '\012', '\160', '\152', '\131', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\125', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\152', '\167', '\125', '\040', '\151', '\152', '\040', '\061',
    '\012', '\112', '\147', '\155', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\146', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\145', '\117', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\102', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\102', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\123', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\171', '\120', '\040', '\151', '\152', '\040', '\061',
    '\012', '\106', '\153', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\152', '\123', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\164', '\101', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\155', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\131', '\164', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\120', '\161', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\167', '\112', '\040', '\167', '\141', '\040', '\061',
    '\012', '\157', '\127', '\146', '\040', '\157', '\156', '\040', '\061',
    '\012', '\153', '\170', '\112', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\110', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\143', '\120', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\102', '\163', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\153', '\113', '\040', '\153', '\141', '\040', '\061',
    '\012', '\166', '\144', '\121', '\040', '\144', '\145', '\040', '\061',
    '\012', '\160', '\152', '\132', '\040', '\151', '\152', '\040', '\061',
    '\012', '\126', '\147', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\163', '\166', '\107', '\040', '\163', '\164', '\040', '\061',
    '\012', '\153', '\107', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\127', '\152', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\155', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\107', '\154', '\166', '\040', '\154', '\145', '\040', '\061',
    '\012', '\164', '\155', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\154', '\131', '\040', '\154', '\145', '\040', '\061',
    '\012', '\120', '\143', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\121', '\167', '\040', '\167', '\151', '\040', '\061',
    '\012', '\170', '\141', '\117', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\146', '\116', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\107', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\166', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\167', '\101', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\155', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\166', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\102', '\160', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\112', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\155', '\132', '\040', '\166', '\141', '\040', '\061',
    '\012', '\156', '\112', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\161', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\110', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\121', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\107', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\121', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\102', '\160', '\040', '\155', '\145', '\040', '\061',
    '\012', '\164', '\160', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\153', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\165', '\125', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\144', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\146', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\114', '\166', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\151', '\130', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\117', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\150', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\115', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\106', '\163', '\167', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\101', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\167', '\112', '\040', '\167', '\141', '\040', '\061',
    '\012', '\146', '\120', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\104', '\146', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\132', '\142', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\102', '\147', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\121', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\153', '\121', '\160', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\157', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\161', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\131', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\163', '\104', '\146', '\040', '\163', '\164', '\040', '\061',
    '\012', '\170', '\165', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\122', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\121', '\163', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\124', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\121', '\170', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\110', '\166', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\132', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\104', '\165', '\040', '\165', '\156', '\040', '\061',
    '\012', '\146', '\170', '\101', '\040', '\146', '\157', '\040', '\061',
    '\012', '\170', '\120', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\167', '\130', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\112', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\144', '\113', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\160', '\127', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\147', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\170', '\107', '\040', '\153', '\141', '\040', '\061',
    '\012', '\144', '\114', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\102', '\167', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\126', '\144', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\121', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\163', '\170', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\123', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\125', '\153', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\120', '\152', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\106', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\152', '\120', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\127', '\166', '\040', '\153', '\141', '\040', '\061',
    '\012', '\113', '\150', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\107', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\156', '\104', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\131', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\147', '\122', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\152', '\103', '\040', '\145', '\162', '\040', '\061',
    '\012', '\130', '\152', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\153', '\172', '\105', '\040', '\163', '\172', '\040', '\061',
    '\012', '\121', '\147', '\161', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\147', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\150', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\153', '\117', '\040', '\153', '\141', '\040', '\061',
    '\012', '\165', '\167', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\120', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\130', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\101', '\157', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\166', '\107', '\040', '\153', '\141', '\040', '\061',
    '\012', '\166', '\143', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\117', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\130', '\172', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\155', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\107', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\152', '\122', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\153', '\111', '\040', '\153', '\165', '\040', '\061',
    '\012', '\160', '\161', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\156', '\110', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\150', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\144', '\122', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\104', '\146', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\111', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\103', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\122', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\113', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\111', '\165', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\161', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\105', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\146', '\117', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\165', '\112', '\040', '\165', '\156', '\040', '\061',
    '\012', '\156', '\122', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\170', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\146', '\132', '\040', '\156', '\171', '\040', '\061',
    '\012', '\157', '\161', '\124', '\040', '\150', '\157', '\040', '\061',
    '\012', '\143', '\147', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\142', '\114', '\040', '\160', '\162', '\040', '\061',
    '\012', '\130', '\155', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\126', '\152', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\171', '\154', '\131', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\146', '\113', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\147', '\104', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\167', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\120', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\103', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\160', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\112', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\172', '\121', '\040', '\154', '\145', '\040', '\061',
    '\012', '\146', '\147', '\115', '\040', '\156', '\147', '\040', '\061',
    '\012', '\131', '\154', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\124', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\122', '\152', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\122', '\147', '\152', '\040', '\152', '\157', '\040', '\061',
    '\012', '\107', '\153', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\170', '\107', '\040', '\146', '\157', '\040', '\061',
    '\012', '\155', '\164', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\147', '\112', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\144', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\110', '\153', '\040', '\151', '\156', '\040', '\061',
    '\012', '\107', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\104', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\172', '\132', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\106', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\124', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\164', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\142', '\124', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\166', '\113', '\040', '\144', '\145', '\040', '\061',
    '\012', '\103', '\164', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\144', '\107', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\113', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\103', '\154', '\146', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\162', '\125', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\155', '\124', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\130', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\172', '\117', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\130', '\156', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\162', '\172', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\121', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\160', '\124', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\131', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\114', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\130', '\147', '\144', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\132', '\154', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\106', '\171', '\040', '\154', '\145', '\040', '\061',
    '\012', '\132', '\156', '\147', '\040', '\141', '\156', '\040', '\061',
    '\012', '\141', '\130', '\147', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\142', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\143', '\131', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\161', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\102', '\154', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\157', '\161', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\120', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\132', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\144', '\132', '\040', '\144', '\145', '\040', '\061',
    '\012', '\102', '\161', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\160', '\107', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\144', '\120', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\165', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\142', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\150', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\167', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\153', '\117', '\040', '\153', '\157', '\040', '\061',
    '\012', '\147', '\163', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\107', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\153', '\166', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\160', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\167', '\113', '\040', '\145', '\162', '\040', '\061',
    '\012', '\114', '\150', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\165', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\161', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\143', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\127', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\156', '\106', '\040', '\141', '\156', '\040', '\061',
    '\012', '\154', '\127', '\167', '\040', '\154', '\145', '\040', '\061',
    '\012', '\164', '\170', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\156', '\105', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\124', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\154', '\106', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\144', '\112', '\040', '\144', '\145', '\040', '\061',
    '\012', '\145', '\126', '\153', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\152', '\132', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\120', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\161', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\120', '\143', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\144', '\153', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\166', '\105', '\040', '\163', '\164', '\040', '\061',
    '\012', '\127', '\161', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\143', '\126', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\110', '\170', '\040', '\157', '\156', '\040', '\061',
    '\012', '\167', '\101', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\150', '\146', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\141', '\115', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\167', '\117', '\040', '\160', '\162', '\040', '\061',
    '\012', '\131', '\167', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\143', '\142', '\110', '\040', '\143', '\150', '\040', '\061',
    '\012', '\157', '\152', '\132', '\040', '\157', '\156', '\040', '\061',
    '\012', '\163', '\165', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\143', '\125', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\161', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\115', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\160', '\170', '\107', '\040', '\160', '\162', '\040', '\061',
    '\012', '\162', '\102', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\154', '\131', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\171', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\103', '\166', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\124', '\161', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\123', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\126', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\105', '\161', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\156', '\104', '\040', '\141', '\156', '\040', '\061',
    '\012', '\117', '\167', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\124', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\167', '\152', '\114', '\040', '\151', '\152', '\040', '\061',
    '\012', '\122', '\170', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\156', '\127', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\110', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\102', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\116', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\172', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\167', '\123', '\040', '\167', '\141', '\040', '\061',
    '\012', '\103', '\142', '\171', '\040', '\142', '\145', '\040', '\061',
    '\012', '\172', '\122', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\167', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\156', '\102', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\111', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\107', '\153', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\152', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\147', '\126', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\104', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\121', '\171', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\143', '\110', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\170', '\102', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\166', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\121', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\162', '\122', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\156', '\113', '\040', '\141', '\156', '\040', '\061',
    '\012', '\110', '\154', '\162', '\040', '\154', '\145', '\040', '\061',
    '\012', '\104', '\156', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\156', '\125', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\103', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\124', '\152', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\105', '\160', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\114', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\160', '\132', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\166', '\122', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\161', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\154', '\107', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\166', '\116', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\142', '\115', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\116', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\172', '\114', '\040', '\163', '\172', '\040', '\061',
    '\012', '\127', '\154', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\141', '\131', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\144', '\131', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\146', '\107', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\146', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\102', '\166', '\040', '\153', '\141', '\040', '\061',
    '\012', '\142', '\164', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\115', '\161', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\162', '\103', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\165', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\171', '\112', '\040', '\156', '\171', '\040', '\061',
    '\012', '\161', '\155', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\153', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\103', '\155', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\130', '\171', '\040', '\142', '\145', '\040', '\061',
    '\012', '\131', '\155', '\171', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\170', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\116', '\154', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\172', '\125', '\040', '\146', '\157', '\040', '\061',
    '\012', '\122', '\166', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\154', '\111', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\115', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\121', '\150', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\110', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\167', '\114', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\131', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\121', '\170', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\116', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\116', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\155', '\120', '\040', '\151', '\152', '\040', '\061',
    '\012', '\120', '\142', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\125', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\110', '\171', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\144', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\123', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\127', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\153', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\132', '\164', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\125', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\102', '\155', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\112', '\171', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\144', '\111', '\040', '\144', '\145', '\040', '\061',
    '\012', '\156', '\124', '\144', '\040', '\141', '\156', '\040', '\061',
    '\012', '\131', '\152', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\152', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\130', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\167', '\102', '\040', '\157', '\167', '\040', '\061',
    '\012', '\153', '\154', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\146', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\104', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\132', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\155', '\161', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\132', '\162', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\155', '\131', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\114', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\143', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\113', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\161', '\104', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\113', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\142', '\146', '\122', '\040', '\142', '\145', '\040', '\061',
    '\012', '\122', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\150', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\116', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\124', '\143', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\110', '\142', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\114', '\167', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\143', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\144', '\113', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\160', '\122', '\040', '\160', '\162', '\040', '\061',
    '\012', '\154', '\127', '\155', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\116', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\101', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\162', '\126', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\155', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\114', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\151', '\167', '\102', '\040', '\151', '\156', '\040', '\061',
    '\012', '\145', '\161', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\156', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\157', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\126', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\142', '\125', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\160', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\144', '\132', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\172', '\127', '\040', '\144', '\145', '\040', '\061',
    '\012', '\127', '\146', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\132', '\161', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\112', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\127', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\131', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\152', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\144', '\167', '\102', '\040', '\144', '\145', '\040', '\061',
    '\012', '\126', '\154', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\113', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\114', '\170', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\110', '\160', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\155', '\166', '\122', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\115', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\127', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\144', '\143', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\105', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\162', '\163', '\040', '\145', '\162', '\040', '\061',
    '\012', '\106', '\164', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\171', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\123', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\127', '\172', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\120', '\172', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\153', '\127', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\167', '\131', '\040', '\167', '\141', '\040', '\061',
    '\012', '\157', '\107', '\142', '\040', '\157', '\156', '\040', '\061',
    '\012', '\152', '\102', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\160', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\127', '\155', '\040', '\145', '\162', '\040', '\061',
    '\012', '\163', '\155', '\121', '\040', '\163', '\164', '\040', '\061',
    '\012', '\165', '\107', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\153', '\126', '\040', '\153', '\141', '\040', '\061',
    '\012', '\167', '\112', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\143', '\152', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\116', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\152', '\122', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\104', '\144', '\040', '\167', '\141', '\040', '\061',
    '\012', '\154', '\162', '\102', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\150', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\113', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\116', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\161', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\155', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\112', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\162', '\116', '\040', '\145', '\162', '\040', '\061',
    '\012', '\165', '\102', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\165', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\115', '\172', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\104', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\147', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\144', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\106', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\152', '\125', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\162', '\130', '\040', '\145', '\162', '\040', '\061',
    '\012', '\113', '\166', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\171', '\131', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\172', '\121', '\040', '\163', '\172', '\040', '\061',
    '\012', '\117', '\152', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\146', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\126', '\161', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\141', '\121', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\110', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\111', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\113', '\160', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\144', '\121', '\153', '\040', '\153', '\157', '\040', '\061',
    '\012', '\107', '\150', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\132', '\163', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\166', '\110', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\167', '\112', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\115', '\155', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\152', '\111', '\040', '\156', '\147', '\040', '\061',
    '\012', '\154', '\120', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\102', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\150', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\114', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\102', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\143', '\165', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\121', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\160', '\130', '\040', '\160', '\162', '\040', '\061',
    '\012', '\155', '\121', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\155', '\122', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\146', '\110', '\040', '\146', '\157', '\040', '\061',
    '\012', '\160', '\161', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\164', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\143', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\127', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\120', '\170', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\121', '\155', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\144', '\130', '\040', '\144', '\145', '\040', '\061',
    '\012', '\102', '\170', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\132', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\116', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\142', '\116', '\040', '\142', '\145', '\040', '\061',
    '\012', '\142', '\153', '\132', '\040', '\153', '\141', '\040', '\061',
    '\012', '\156', '\126', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\154', '\113', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\112', '\152', '\040', '\157', '\156', '\040', '\061',
    '\012', '\160', '\102', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\147', '\101', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\170', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\166', '\112', '\040', '\141', '\156', '\040', '\061',
    '\012', '\130', '\143', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\106', '\144', '\142', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\101', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\167', '\121', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\164', '\155', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\166', '\132', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\116', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\172', '\113', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\122', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\124', '\154', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\151', '\121', '\152', '\040', '\151', '\156', '\040', '\061',
    '\012', '\152', '\155', '\125', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\142', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\126', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\124', '\166', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\126', '\147', '\040', '\141', '\156', '\040', '\061',
    '\012', '\114', '\170', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\166', '\147', '\117', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\146', '\105', '\040', '\144', '\145', '\040', '\061',
    '\012', '\156', '\126', '\155', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\113', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\161', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\124', '\143', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\124', '\153', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\113', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\127', '\153', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\166', '\132', '\040', '\154', '\145', '\040', '\061',
    '\012', '\162', '\107', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\153', '\113', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\103', '\142', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\152', '\121', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\132', '\146', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\166', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\147', '\116', '\040', '\156', '\147', '\040', '\061',
    '\012', '\113', '\160', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\172', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\170', '\132', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\161', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\147', '\103', '\040', '\156', '\147', '\040', '\061',
    '\012', '\106', '\161', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\115', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\152', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\146', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\152', '\116', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\116', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\120', '\172', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\155', '\150', '\117', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\125', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\150', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\123', '\152', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\150', '\127', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\150', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\107', '\160', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\164', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\167', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\162', '\113', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\161', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\143', '\117', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\121', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\121', '\161', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\112', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\130', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\165', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\156', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\104', '\154', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\115', '\170', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\171', '\116', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\155', '\126', '\040', '\155', '\145', '\040', '\061',
    '\012', '\146', '\130', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\155', '\167', '\127', '\040', '\155', '\145', '\040', '\061',
    '\012', '\154', '\111', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\106', '\166', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\164', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\107', '\153', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\131', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\126', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\142', '\124', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\111', '\152', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\156', '\115', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\155', '\117', '\040', '\155', '\145', '\040', '\061',
    '\012', '\147', '\121', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\113', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\125', '\146', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\123', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\126', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\143', '\131', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\152', '\105', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\131', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\162', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\172', '\113', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\146', '\103', '\040', '\163', '\172', '\040', '\061',
    '\012', '\131', '\142', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\147', '\123', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\143', '\126', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\116', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\130', '\153', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\124', '\160', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\102', '\167', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\150', '\167', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\121', '\154', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\104', '\163', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\131', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\124', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\161', '\127', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\152', '\124', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\152', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\104', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\150', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\127', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\103', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\171', '\102', '\040', '\151', '\152', '\040', '\061',
    '\012', '\165', '\127', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\116', '\156', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\166', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\172', '\126', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\102', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\111', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\122', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\162', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\132', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\122', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\116', '\172', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\121', '\146', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\116', '\152', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\106', '\171', '\040', '\142', '\145', '\040', '\061',
    '\012', '\154', '\150', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\145', '\127', '\152', '\040', '\145', '\162', '\040', '\061',
    '\012', '\152', '\142', '\115', '\040', '\151', '\152', '\040', '\061',
    '\012', '\130', '\163', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\163', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\154', '\106', '\040', '\154', '\145', '\040', '\061',
    '\012', '\120', '\150', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\127', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\142', '\103', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\147', '\146', '\112', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\126', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\121', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\143', '\120', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\104', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\124', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\147', '\163', '\040', '\156', '\147', '\040', '\061',
    '\012', '\126', '\165', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\146', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\102', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\160', '\124', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\123', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\142', '\104', '\040', '\155', '\145', '\040', '\061',
    '\012', '\126', '\167', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\150', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\146', '\120', '\040', '\153', '\141', '\040', '\061',
    '\012', '\120', '\167', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\150', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\132', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\122', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\103', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\152', '\116', '\040', '\151', '\152', '\040', '\061',
    '\012', '\122', '\161', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\112', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\154', '\122', '\040', '\154', '\145', '\040', '\061',
    '\012', '\130', '\155', '\142', '\040', '\155', '\145', '\040', '\061',
    '\012', '\112', '\152', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\161', '\111', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\161', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\151', '\126', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\110', '\147', '\165', '\040', '\156', '\147', '\040', '\061',
    '\012', '\151', '\110', '\167', '\040', '\151', '\156', '\040', '\061',
    '\012', '\145', '\121', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\172', '\105', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\152', '\132', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\116', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\154', '\105', '\040', '\154', '\145', '\040', '\061',
    '\012', '\153', '\107', '\160', '\040', '\153', '\141', '\040', '\061',
    '\012', '\111', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\102', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\132', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\104', '\153', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\154', '\110', '\040', '\154', '\145', '\040', '\061',
    '\012', '\164', '\170', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\121', '\162', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\117', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\112', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\172', '\142', '\114', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\153', '\104', '\040', '\153', '\141', '\040', '\061',
    '\012', '\163', '\143', '\126', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\130', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\111', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\116', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\112', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\155', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\143', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\167', '\132', '\040', '\153', '\141', '\040', '\061',
    '\012', '\165', '\132', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\156', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\113', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\162', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\130', '\171', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\143', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\120', '\146', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\167', '\115', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\111', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\165', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\104', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\110', '\152', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\144', '\121', '\146', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\166', '\112', '\040', '\167', '\141', '\040', '\061',
    '\012', '\164', '\110', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\144', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\170', '\111', '\040', '\167', '\141', '\040', '\061',
    '\012', '\160', '\117', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\127', '\155', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\150', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\160', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\155', '\103', '\040', '\155', '\145', '\040', '\061',
    '\012', '\167', '\143', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\152', '\110', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\127', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\107', '\144', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\114', '\144', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\123', '\142', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\132', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\113', '\167', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\150', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\122', '\146', '\040', '\156', '\171', '\040', '\061',
    '\012', '\150', '\167', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\160', '\112', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\155', '\126', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\107', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\161', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\120', '\150', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\127', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\126', '\170', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\163', '\110', '\172', '\040', '\163', '\164', '\040', '\061',
    '\012', '\127', '\142', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\142', '\146', '\113', '\040', '\142', '\145', '\040', '\061',
    '\012', '\112', '\147', '\154', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\124', '\142', '\040', '\153', '\141', '\040', '\061',
    '\012', '\113', '\142', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\153', '\172', '\103', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\113', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\167', '\102', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\132', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\164', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\130', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\172', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\127', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\162', '\110', '\040', '\145', '\162', '\040', '\061',
    '\012', '\157', '\121', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\154', '\124', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\146', '\111', '\040', '\144', '\145', '\040', '\061',
    '\012', '\121', '\155', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\163', '\147', '\105', '\040', '\156', '\147', '\040', '\061',
    '\012', '\131', '\163', '\170', '\040', '\163', '\164', '\040', '\061',
    '\012', '\122', '\172', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\114', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\163', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\161', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\103', '\155', '\040', '\153', '\141', '\040', '\061',
    '\012', '\142', '\106', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\151', '\147', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\163', '\122', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\107', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\123', '\172', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\131', '\166', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\130', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\107', '\156', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\127', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\104', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\161', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\156', '\110', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\144', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\117', '\166', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\132', '\156', '\154', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\165', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\114', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\146', '\121', '\040', '\157', '\156', '\040', '\061',
    '\012', '\166', '\131', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\171', '\110', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\161', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\112', '\171', '\040', '\143', '\150', '\040', '\061',
    '\012', '\127', '\142', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\154', '\124', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\154', '\127', '\040', '\154', '\145', '\040', '\061',
    '\012', '\130', '\170', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\103', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\113', '\146', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\167', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\110', '\153', '\040', '\145', '\162', '\040', '\061',
    '\012', '\144', '\142', '\116', '\040', '\144', '\145', '\040', '\061',
    '\012', '\165', '\125', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\147', '\116', '\040', '\156', '\147', '\040', '\061',
    '\012', '\120', '\170', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\116', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\171', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\160', '\110', '\040', '\151', '\152', '\040', '\061',
    '\012', '\126', '\164', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\152', '\112', '\040', '\163', '\164', '\040', '\061',
    '\012', '\121', '\154', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\167', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\107', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\126', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\163', '\121', '\040', '\163', '\164', '\040', '\061',
    '\012', '\170', '\156', '\124', '\040', '\141', '\156', '\040', '\061',
    '\012', '\162', '\160', '\112', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\172', '\111', '\040', '\163', '\172', '\040', '\061',
    '\012', '\132', '\150', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\141', '\104', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\125', '\170', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\120', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\123', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\113', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\102', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\120', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\126', '\153', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\151', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\153', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\117', '\165', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\157', '\110', '\040', '\157', '\156', '\040', '\061',
    '\012', '\161', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\170', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\152', '\172', '\106', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\167', '\110', '\040', '\163', '\164', '\040', '\061',
    '\012', '\156', '\102', '\142', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\150', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\122', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\156', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\157', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\170', '\120', '\040', '\155', '\145', '\040', '\061',
    '\012', '\142', '\167', '\122', '\040', '\167', '\141', '\040', '\061',
    '\012', '\147', '\112', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\156', '\153', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\115', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\170', '\117', '\040', '\144', '\145', '\040', '\061',
    '\012', '\162', '\172', '\126', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\160', '\120', '\040', '\166', '\141', '\040', '\061',
    '\012', '\116', '\166', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\116', '\146', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\103', '\156', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\157', '\124', '\144', '\040', '\157', '\156', '\040', '\061',
    '\012', '\144', '\161', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\110', '\155', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\160', '\163', '\130', '\040', '\163', '\164', '\040', '\061',
    '\012', '\163', '\167', '\115', '\040', '\163', '\164', '\040', '\061',
    '\012', '\144', '\161', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\167', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\156', '\130', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\153', '\131', '\040', '\153', '\141', '\040', '\061',
    '\012', '\167', '\146', '\103', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\123', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\126', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\104', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\131', '\166', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\161', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\170', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\113', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\143', '\116', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\127', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\122', '\162', '\172', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\155', '\107', '\040', '\155', '\145', '\040', '\061',
    '\012', '\163', '\162', '\132', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\127', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\103', '\146', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\116', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\143', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\156', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\112', '\150', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\111', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\123', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\145', '\125', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\111', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\132', '\155', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\107', '\146', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\121', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\130', '\143', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\154', '\113', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\155', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\154', '\114', '\040', '\154', '\145', '\040', '\061',
    '\012', '\155', '\167', '\103', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\152', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\102', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\150', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\120', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\102', '\146', '\040', '\163', '\164', '\040', '\061',
    '\012', '\165', '\130', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\153', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\162', '\107', '\172', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\130', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\165', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\166', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\142', '\143', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\105', '\157', '\152', '\040', '\157', '\156', '\040', '\061',
    '\012', '\151', '\126', '\164', '\040', '\151', '\156', '\040', '\061',
    '\012', '\171', '\150', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\126', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\115', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\132', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\126', '\166', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\151', '\103', '\166', '\040', '\151', '\156', '\040', '\061',
    '\012', '\166', '\121', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\154', '\102', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\125', '\147', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\164', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\103', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\166', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\126', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\162', '\120', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\146', '\110', '\040', '\167', '\141', '\040', '\061',
    '\012', '\150', '\142', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\152', '\106', '\040', '\151', '\152', '\040', '\061',
    '\012', '\157', '\130', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\123', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\122', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\110', '\143', '\165', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\170', '\112', '\040', '\156', '\171', '\040', '\061',
    '\012', '\154', '\124', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\131', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\127', '\170', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\162', '\105', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\107', '\171', '\040', '\163', '\172', '\040', '\061',
    '\012', '\112', '\161', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\172', '\111', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\147', '\126', '\040', '\147', '\151', '\040', '\061',
    '\012', '\122', '\166', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\126', '\156', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\112', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\106', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\124', '\147', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\141', '\121', '\143', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\172', '\112', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\116', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\146', '\101', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\143', '\117', '\040', '\143', '\150', '\040', '\061',
    '\012', '\127', '\153', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\102', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\150', '\147', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\123', '\170', '\040', '\151', '\156', '\040', '\061',
    '\012', '\170', '\103', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\171', '\152', '\130', '\040', '\151', '\152', '\040', '\061',
    '\012', '\165', '\111', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\147', '\161', '\040', '\156', '\147', '\040', '\061',
    '\012', '\124', '\172', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\152', '\117', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\162', '\131', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\155', '\132', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\161', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\102', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\166', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\143', '\101', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\162', '\130', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\112', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\130', '\161', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\120', '\170', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\141', '\104', '\142', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\130', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\145', '\107', '\167', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\152', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\124', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\115', '\144', '\040', '\157', '\156', '\040', '\061',
    '\012', '\146', '\113', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\116', '\160', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\161', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\142', '\106', '\040', '\154', '\145', '\040', '\061',
    '\012', '\110', '\166', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\132', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\121', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\153', '\131', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\132', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\132', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\171', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\155', '\112', '\040', '\144', '\145', '\040', '\061',
    '\012', '\153', '\146', '\113', '\040', '\153', '\141', '\040', '\061',
    '\012', '\151', '\120', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\167', '\125', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\166', '\123', '\040', '\166', '\141', '\040', '\061',
    '\012', '\151', '\150', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\143', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\112', '\152', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\155', '\115', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\160', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\103', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\113', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\154', '\111', '\040', '\154', '\145', '\040', '\061',
    '\012', '\116', '\155', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\172', '\126', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\132', '\163', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\122', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\125', '\146', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\160', '\106', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\167', '\131', '\040', '\167', '\141', '\040', '\061',
    '\012', '\107', '\170', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\114', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\172', '\105', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\122', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\162', '\122', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\153', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\125', '\171', '\040', '\144', '\145', '\040', '\061',
    '\012', '\130', '\152', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\113', '\144', '\142', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\160', '\103', '\040', '\151', '\152', '\040', '\061',
    '\012', '\157', '\125', '\152', '\040', '\157', '\156', '\040', '\061',
    '\012', '\161', '\155', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\152', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\122', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\150', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\122', '\150', '\162', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\164', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\120', '\152', '\161', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\167', '\125', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\171', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\170', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\120', '\161', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\122', '\144', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\161', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\106', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\115', '\167', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\105', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\116', '\170', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\120', '\172', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\146', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\106', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\121', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\102', '\156', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\154', '\115', '\166', '\040', '\154', '\145', '\040', '\061',
    '\012', '\164', '\113', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\145', '\126', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\124', '\171', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\162', '\112', '\040', '\145', '\162', '\040', '\061',
    '\012', '\157', '\110', '\167', '\040', '\157', '\156', '\040', '\061',
    '\012', '\154', '\106', '\153', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\160', '\127', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\152', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\116', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\102', '\150', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\150', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\104', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\160', '\131', '\040', '\160', '\162', '\040', '\061',
    '\012', '\164', '\156', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\146', '\114', '\040', '\144', '\145', '\040', '\061',
    '\012', '\150', '\172', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\116', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\102', '\155', '\040', '\154', '\145', '\040', '\061',
    '\012', '\154', '\130', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\171', '\120', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\132', '\143', '\154', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\115', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\112', '\152', '\040', '\162', '\151', '\040', '\061',
    '\012', '\141', '\130', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\163', '\121', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\121', '\155', '\040', '\143', '\150', '\040', '\061',
    '\012', '\123', '\161', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\113', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\166', '\117', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\107', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\142', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\103', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\154', '\107', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\104', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\104', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\122', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\166', '\130', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\161', '\151', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\106', '\163', '\040', '\143', '\150', '\040', '\061',
    '\012', '\114', '\150', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\105', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\121', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\112', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\172', '\117', '\040', '\154', '\145', '\040', '\061',
    '\012', '\106', '\170', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\164', '\104', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\156', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\170', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\107', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\166', '\107', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\160', '\103', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\170', '\104', '\040', '\160', '\162', '\040', '\061',
    '\012', '\132', '\146', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\157', '\127', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\166', '\126', '\040', '\166', '\141', '\040', '\061',
    '\012', '\107', '\167', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\131', '\143', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\143', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\115', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\171', '\121', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\165', '\107', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\116', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\131', '\143', '\155', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\111', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\171', '\114', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\155', '\122', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\156', '\162', '\113', '\040', '\141', '\156', '\040', '\061',
    '\012', '\132', '\171', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\116', '\143', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\155', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\120', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\127', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\105', '\147', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\116', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\163', '\116', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\160', '\144', '\127', '\040', '\144', '\145', '\040', '\061',
    '\012', '\123', '\156', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\162', '\120', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\112', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\164', '\126', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\166', '\103', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\150', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\144', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\155', '\124', '\040', '\155', '\145', '\040', '\061',
    '\012', '\114', '\142', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\160', '\112', '\040', '\160', '\162', '\040', '\061',
    '\012', '\155', '\131', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\167', '\126', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\152', '\104', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\161', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\125', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\144', '\150', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\132', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\164', '\167', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\142', '\115', '\040', '\142', '\145', '\040', '\061',
    '\012', '\150', '\147', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\113', '\142', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\112', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\105', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\117', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\130', '\154', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\160', '\126', '\040', '\160', '\162', '\040', '\061',
    '\012', '\164', '\161', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\125', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\124', '\167', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\115', '\147', '\161', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\121', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\171', '\152', '\124', '\040', '\151', '\152', '\040', '\061',
    '\012', '\141', '\126', '\144', '\040', '\141', '\156', '\040', '\061',
    '\012', '\145', '\110', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\107', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\163', '\162', '\107', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\126', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\154', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\162', '\124', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\122', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\114', '\162', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\162', '\110', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\124', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\166', '\111', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\161', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\111', '\170', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\145', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\116', '\171', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\122', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\165', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\143', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\113', '\172', '\142', '\040', '\142', '\151', '\040', '\061',
    '\012', '\127', '\170', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\152', '\115', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\144', '\117', '\040', '\144', '\145', '\040', '\061',
    '\012', '\112', '\146', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\142', '\126', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\121', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\156', '\143', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\126', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\123', '\170', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\125', '\142', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\167', '\166', '\103', '\040', '\166', '\141', '\040', '\061',
    '\012', '\153', '\150', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\161', '\106', '\040', '\143', '\150', '\040', '\061',
    '\012', '\116', '\170', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\104', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\171', '\104', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\151', '\171', '\111', '\040', '\151', '\156', '\040', '\061',
    '\012', '\145', '\130', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\161', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\170', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\163', '\131', '\040', '\163', '\164', '\040', '\061',
    '\012', '\124', '\167', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\146', '\161', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\155', '\103', '\040', '\155', '\145', '\040', '\061',
    '\012', '\166', '\106', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\156', '\103', '\040', '\141', '\156', '\040', '\061',
    '\012', '\156', '\127', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\172', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\146', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\164', '\121', '\145', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\165', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\154', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\107', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\117', '\161', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\116', '\160', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\150', '\147', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\170', '\115', '\040', '\146', '\157', '\040', '\061',
    '\012', '\152', '\123', '\171', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\112', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\152', '\107', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\147', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\117', '\147', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\110', '\142', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\114', '\152', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\151', '\166', '\132', '\040', '\151', '\156', '\040', '\061',
    '\012', '\142', '\155', '\131', '\040', '\155', '\145', '\040', '\061',
    '\012', '\121', '\146', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\167', '\146', '\121', '\040', '\167', '\141', '\040', '\061',
    '\012', '\150', '\103', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\165', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\144', '\132', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\126', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\155', '\132', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\154', '\117', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\111', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\132', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\170', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\155', '\171', '\040', '\155', '\145', '\040', '\061',
    '\012', '\112', '\161', '\151', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\170', '\114', '\040', '\143', '\150', '\040', '\061',
    '\012', '\132', '\164', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\144', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\127', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\107', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\127', '\167', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\160', '\102', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\171', '\161', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\131', '\154', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\156', '\127', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\171', '\112', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\107', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\116', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\150', '\106', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\170', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\166', '\112', '\040', '\153', '\141', '\040', '\061',
    '\012', '\106', '\170', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\167', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\166', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\122', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\121', '\161', '\151', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\172', '\105', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\116', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\160', '\127', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\143', '\120', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\120', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\143', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\121', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\171', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\143', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\155', '\131', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\154', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\105', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\161', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\117', '\150', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\144', '\115', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\114', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\161', '\101', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\167', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\114', '\172', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\161', '\117', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\130', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\113', '\144', '\163', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\166', '\125', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\120', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\156', '\132', '\162', '\040', '\141', '\156', '\040', '\061',
    '\012', '\110', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\103', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\146', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\146', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\146', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\161', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\165', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\146', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\154', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\152', '\104', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\164', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\155', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\127', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\121', '\170', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\126', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\155', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\144', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\161', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\130', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\155', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\146', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\121', '\162', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\150', '\162', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\166', '\123', '\040', '\166', '\141', '\040', '\061',
    '\012', '\165', '\104', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\144', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\166', '\105', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\166', '\123', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\122', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\166', '\104', '\040', '\145', '\162', '\040', '\061',
    '\012', '\130', '\171', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\112', '\146', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\141', '\102', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\156', '\127', '\143', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\102', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\147', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\107', '\142', '\040', '\142', '\151', '\040', '\061',
    '\012', '\147', '\152', '\105', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\154', '\167', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\162', '\124', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\121', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\154', '\152', '\131', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\166', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\113', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\160', '\124', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\124', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\156', '\126', '\040', '\141', '\156', '\040', '\061',
    '\012', '\162', '\127', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\156', '\127', '\144', '\040', '\141', '\156', '\040', '\061',
    '\012', '\156', '\113', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\115', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\153', '\107', '\040', '\153', '\141', '\040', '\061',
    '\012', '\142', '\167', '\130', '\040', '\167', '\141', '\040', '\061',
    '\012', '\143', '\167', '\126', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\167', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\114', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\115', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\160', '\132', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\115', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\124', '\164', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\166', '\117', '\040', '\156', '\147', '\040', '\061',
    '\012', '\112', '\143', '\172', '\040', '\143', '\150', '\040', '\061',
    '\012', '\103', '\171', '\170', '\040', '\156', '\171', '\040', '\061',
    '\012', '\156', '\152', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\141', '\126', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\130', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\125', '\161', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\126', '\172', '\040', '\144', '\145', '\040', '\061',
    '\012', '\122', '\143', '\160', '\040', '\143', '\150', '\040', '\061',
    '\012', '\145', '\113', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\130', '\172', '\156', '\040', '\151', '\156', '\040', '\061',
    '\012', '\166', '\171', '\106', '\040', '\166', '\141', '\040', '\061',
    '\012', '\113', '\154', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\144', '\111', '\040', '\144', '\145', '\040', '\061',
    '\012', '\110', '\161', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\105', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\160', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\104', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\112', '\150', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\165', '\113', '\040', '\165', '\156', '\040', '\061',
    '\012', '\166', '\147', '\125', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\127', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\120', '\156', '\155', '\040', '\141', '\156', '\040', '\061',
    '\012', '\156', '\114', '\155', '\040', '\141', '\156', '\040', '\061',
    '\012', '\102', '\150', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\120', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\160', '\111', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\114', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\160', '\123', '\040', '\166', '\141', '\040', '\061',
    '\012', '\106', '\170', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\104', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\172', '\115', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\167', '\112', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\102', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\107', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\114', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\102', '\152', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\146', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\154', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\122', '\147', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\107', '\163', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\125', '\166', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\121', '\147', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\146', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\121', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\166', '\107', '\040', '\166', '\141', '\040', '\061',
    '\012', '\153', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\107', '\146', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\143', '\101', '\040', '\143', '\150', '\040', '\061',
    '\012', '\105', '\150', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\102', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\107', '\160', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\164', '\102', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\146', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\112', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\163', '\161', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\162', '\131', '\040', '\145', '\162', '\040', '\061',
    '\012', '\104', '\161', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\172', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\115', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\146', '\115', '\040', '\156', '\171', '\040', '\061',
    '\012', '\107', '\170', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\167', '\172', '\120', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\116', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\113', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\162', '\144', '\040', '\145', '\162', '\040', '\061',
    '\012', '\110', '\166', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\146', '\104', '\040', '\156', '\147', '\040', '\061',
    '\012', '\127', '\155', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\112', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\156', '\124', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\166', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\120', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\167', '\122', '\040', '\166', '\141', '\040', '\061',
    '\012', '\142', '\115', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\167', '\111', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\170', '\131', '\040', '\153', '\141', '\040', '\061',
    '\012', '\147', '\132', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\106', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\115', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\110', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\126', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\154', '\130', '\040', '\154', '\145', '\040', '\061',
    '\012', '\146', '\163', '\114', '\040', '\163', '\164', '\040', '\061',
    '\012', '\160', '\122', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\172', '\163', '\130', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\102', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\172', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\144', '\122', '\040', '\144', '\145', '\040', '\061',
    '\012', '\132', '\154', '\172', '\040', '\154', '\145', '\040', '\061',
    '\012', '\127', '\146', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\122', '\152', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\106', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\153', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\142', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\170', '\121', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\113', '\170', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\170', '\103', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\156', '\161', '\126', '\040', '\141', '\156', '\040', '\061',
    '\012', '\127', '\167', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\153', '\144', '\127', '\040', '\144', '\145', '\040', '\061',
    '\012', '\160', '\153', '\111', '\040', '\153', '\141', '\040', '\061',
    '\012', '\157', '\150', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\144', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\103', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\163', '\170', '\114', '\040', '\163', '\164', '\040', '\061',
    '\012', '\121', '\162', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\130', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\161', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\151', '\152', '\113', '\040', '\151', '\156', '\040', '\061',
    '\012', '\163', '\106', '\172', '\040', '\163', '\164', '\040', '\061',
    '\012', '\110', '\154', '\167', '\040', '\154', '\145', '\040', '\061',
    '\012', '\107', '\161', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\120', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\167', '\132', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\161', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\172', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\102', '\144', '\172', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\121', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\164', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\125', '\171', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\127', '\143', '\171', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\161', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\102', '\156', '\163', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\104', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\112', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\127', '\146', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\150', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\127', '\160', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\161', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\153', '\102', '\040', '\153', '\141', '\040', '\061',
    '\012', '\127', '\164', '\154', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\172', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\115', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\160', '\170', '\116', '\040', '\160', '\162', '\040', '\061',
    '\012', '\166', '\150', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\161', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\121', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\171', '\153', '\103', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\115', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\105', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\130', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\155', '\132', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\160', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\107', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\124', '\152', '\170', '\040', '\172', '\152', '\040', '\061',
    '\012', '\164', '\166', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\131', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\106', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\151', '\112', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\120', '\153', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\143', '\104', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\171', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\126', '\143', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\150', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\116', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\143', '\104', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\156', '\127', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\166', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\172', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\120', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\167', '\104', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\160', '\117', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\104', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\166', '\105', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\132', '\143', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\162', '\130', '\040', '\145', '\162', '\040', '\061',
    '\012', '\144', '\150', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\152', '\112', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\104', '\153', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\162', '\112', '\040', '\145', '\162', '\040', '\061',
    '\012', '\141', '\127', '\147', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\166', '\112', '\040', '\166', '\141', '\040', '\061',
    '\012', '\131', '\164', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\151', '\121', '\040', '\151', '\156', '\040', '\061',
    '\012', '\164', '\106', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\112', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\132', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\125', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\157', '\161', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\104', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\146', '\105', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\123', '\142', '\040', '\155', '\145', '\040', '\061',
    '\012', '\152', '\155', '\122', '\040', '\151', '\152', '\040', '\061',
    '\012', '\162', '\106', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\130', '\152', '\171', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\120', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\151', '\161', '\121', '\040', '\164', '\151', '\040', '\061',
    '\012', '\155', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\170', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\102', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\130', '\166', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\166', '\131', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\144', '\115', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\147', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\131', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\154', '\101', '\040', '\154', '\145', '\040', '\061',
    '\012', '\160', '\106', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\171', '\106', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\143', '\113', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\146', '\132', '\040', '\146', '\157', '\040', '\061',
    '\012', '\152', '\104', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\116', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\164', '\113', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\164', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\110', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\103', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\143', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\104', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\131', '\167', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\130', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\171', '\115', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\107', '\167', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\131', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\103', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\152', '\132', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\157', '\121', '\144', '\040', '\157', '\156', '\040', '\061',
    '\012', '\106', '\172', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\167', '\106', '\040', '\154', '\145', '\040', '\061',
    '\012', '\130', '\172', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\116', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\157', '\111', '\040', '\157', '\156', '\040', '\061',
    '\012', '\163', '\112', '\155', '\040', '\163', '\164', '\040', '\061',
    '\012', '\167', '\113', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\121', '\164', '\150', '\040', '\143', '\150', '\040', '\061',
    '\012', '\114', '\154', '\172', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\126', '\146', '\040', '\147', '\151', '\040', '\061',
    '\012', '\160', '\120', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\107', '\171', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\172', '\122', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\130', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\116', '\160', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\167', '\166', '\122', '\040', '\166', '\141', '\040', '\061',
    '\012', '\171', '\130', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\155', '\115', '\154', '\040', '\154', '\151', '\040', '\061',
    '\012', '\142', '\131', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\146', '\172', '\132', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\162', '\107', '\040', '\145', '\162', '\040', '\061',
    '\012', '\113', '\144', '\153', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\161', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\153', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\113', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\132', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\120', '\146', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\162', '\154', '\127', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\120', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\117', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\107', '\164', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\164', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\154', '\171', '\040', '\154', '\145', '\040', '\061',
    '\012', '\171', '\110', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\153', '\121', '\142', '\040', '\153', '\141', '\040', '\061',
    '\012', '\114', '\144', '\143', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\125', '\170', '\040', '\163', '\164', '\040', '\061',
    '\012', '\143', '\112', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\114', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\115', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\103', '\152', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\141', '\167', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\107', '\164', '\154', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\172', '\116', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\101', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\172', '\130', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\102', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\163', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\125', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\163', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\163', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\172', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\147', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\116', '\170', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\110', '\161', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\162', '\130', '\154', '\040', '\145', '\162', '\040', '\061',
    '\012', '\156', '\154', '\120', '\040', '\141', '\156', '\040', '\061',
    '\012', '\141', '\126', '\147', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\150', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\146', '\101', '\040', '\153', '\141', '\040', '\061',
    '\012', '\126', '\155', '\153', '\040', '\155', '\107', '\040', '\061',
    '\012', '\152', '\113', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\120', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\141', '\120', '\144', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\131', '\171', '\040', '\142', '\145', '\040', '\061',
    '\012', '\142', '\156', '\132', '\040', '\141', '\156', '\040', '\061',
    '\012', '\107', '\163', '\152', '\040', '\163', '\164', '\040', '\061',
    '\012', '\153', '\170', '\121', '\040', '\153', '\141', '\040', '\061',
    '\012', '\166', '\153', '\106', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\172', '\123', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\127', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\121', '\143', '\165', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\132', '\146', '\040', '\145', '\162', '\040', '\061',
    '\012', '\152', '\142', '\132', '\040', '\151', '\152', '\040', '\061',
    '\012', '\141', '\121', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\172', '\117', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\132', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\162', '\116', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\153', '\114', '\040', '\153', '\141', '\040', '\061',
    '\012', '\104', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\153', '\103', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\114', '\167', '\040', '\163', '\164', '\040', '\061',
    '\012', '\116', '\166', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\116', '\142', '\171', '\040', '\142', '\145', '\040', '\061',
    '\012', '\145', '\115', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\106', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\103', '\170', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\151', '\132', '\160', '\040', '\151', '\156', '\040', '\061',
    '\012', '\144', '\166', '\132', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\111', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\103', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\120', '\172', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\166', '\116', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\161', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\155', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\170', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\154', '\104', '\040', '\156', '\147', '\040', '\061',
    '\012', '\107', '\142', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\112', '\166', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\106', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\115', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\153', '\112', '\040', '\153', '\141', '\040', '\061',
    '\012', '\123', '\170', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\141', '\146', '\125', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\110', '\142', '\040', '\155', '\145', '\040', '\061',
    '\012', '\152', '\170', '\125', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\112', '\154', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\161', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\116', '\161', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\107', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\172', '\107', '\040', '\143', '\150', '\040', '\061',
    '\012', '\113', '\146', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\127', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\130', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\146', '\156', '\104', '\040', '\141', '\156', '\040', '\061',
    '\012', '\112', '\162', '\144', '\040', '\145', '\162', '\040', '\061',
    '\012', '\157', '\170', '\132', '\040', '\157', '\156', '\040', '\061',
    '\012', '\150', '\130', '\156', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\161', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\101', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\151', '\107', '\153', '\040', '\151', '\156', '\040', '\061',
    '\012', '\170', '\105', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\146', '\126', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\164', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\150', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\121', '\172', '\040', '\157', '\156', '\040', '\061',
    '\012', '\160', '\147', '\117', '\040', '\156', '\147', '\040', '\061',
    '\012', '\131', '\161', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\112', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\153', '\143', '\126', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\156', '\115', '\040', '\141', '\156', '\040', '\061',
    '\012', '\103', '\167', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\127', '\147', '\144', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\160', '\124', '\040', '\160', '\162', '\040', '\061',
    '\012', '\112', '\144', '\152', '\040', '\144', '\145', '\040', '\061',
    '\012', '\116', '\142', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\167', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\145', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\113', '\144', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\121', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\120', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\127', '\160', '\040', '\154', '\145', '\040', '\061',
    '\012', '\106', '\142', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\126', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\154', '\111', '\040', '\154', '\145', '\040', '\061',
    '\012', '\102', '\172', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\146', '\113', '\040', '\151', '\152', '\040', '\061',
    '\012', '\131', '\166', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\106', '\164', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\141', '\115', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\172', '\126', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\117', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\110', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\127', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\106', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\104', '\166', '\040', '\163', '\164', '\040', '\061',
    '\012', '\166', '\155', '\104', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\152', '\114', '\040', '\151', '\152', '\040', '\061',
    '\012', '\151', '\102', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\161', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\163', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\170', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\152', '\163', '\107', '\040', '\163', '\164', '\040', '\061',
    '\012', '\143', '\130', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\142', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\145', '\112', '\040', '\145', '\162', '\040', '\061',
    '\012', '\157', '\120', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\130', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\166', '\114', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\143', '\106', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\106', '\142', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\130', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\101', '\157', '\170', '\040', '\157', '\156', '\040', '\061',
    '\012', '\172', '\153', '\121', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\120', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\106', '\166', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\142', '\130', '\040', '\142', '\145', '\040', '\061',
    '\012', '\157', '\103', '\146', '\040', '\157', '\156', '\040', '\061',
    '\012', '\131', '\152', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\120', '\160', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\116', '\152', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\143', '\132', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\156', '\107', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\167', '\112', '\040', '\143', '\155', '\040', '\061',
    '\012', '\161', '\112', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\116', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\124', '\146', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\167', '\113', '\040', '\166', '\141', '\040', '\061',
    '\012', '\132', '\143', '\163', '\040', '\143', '\150', '\040', '\061',
    '\012', '\145', '\102', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\114', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\161', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\162', '\104', '\040', '\143', '\150', '\040', '\061',
    '\012', '\111', '\143', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\102', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\172', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\152', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\170', '\125', '\040', '\166', '\141', '\040', '\061',
    '\012', '\153', '\132', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\114', '\144', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\146', '\115', '\040', '\142', '\145', '\040', '\061',
    '\012', '\155', '\121', '\155', '\040', '\121', '\117', '\040', '\061',
    '\012', '\172', '\154', '\121', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\142', '\125', '\040', '\151', '\152', '\040', '\061',
    '\012', '\113', '\166', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\125', '\170', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\160', '\152', '\123', '\040', '\151', '\152', '\040', '\061',
    '\012', '\130', '\166', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\153', '\152', '\111', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\131', '\151', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\112', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\121', '\170', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\141', '\116', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\112', '\146', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\142', '\116', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\144', '\121', '\040', '\144', '\145', '\040', '\061',
    '\012', '\102', '\172', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\132', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\143', '\160', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\107', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\153', '\103', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\147', '\167', '\120', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\142', '\126', '\040', '\167', '\141', '\040', '\061',
    '\012', '\105', '\161', '\164', '\040', '\145', '\161', '\040', '\061',
    '\012', '\130', '\150', '\156', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\125', '\146', '\040', '\157', '\156', '\040', '\061',
    '\012', '\144', '\113', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\170', '\116', '\040', '\163', '\164', '\040', '\061',
    '\012', '\117', '\146', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\103', '\160', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\150', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\147', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\156', '\125', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\152', '\124', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\163', '\132', '\040', '\163', '\164', '\040', '\061',
    '\012', '\154', '\107', '\166', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\115', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\165', '\153', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\150', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\122', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\122', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\167', '\113', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\112', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\164', '\126', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\161', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\151', '\131', '\154', '\040', '\151', '\156', '\040', '\061',
    '\012', '\170', '\114', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\130', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\143', '\117', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\154', '\115', '\040', '\154', '\145', '\040', '\061',
    '\012', '\142', '\104', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\116', '\155', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\144', '\113', '\166', '\040', '\144', '\145', '\040', '\061',
    '\012', '\150', '\120', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\124', '\152', '\171', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\131', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\156', '\146', '\112', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\146', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\112', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\113', '\160', '\040', '\154', '\145', '\040', '\061',
    '\012', '\111', '\171', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\165', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\113', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\163', '\132', '\146', '\040', '\163', '\164', '\040', '\061',
    '\012', '\172', '\160', '\121', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\146', '\114', '\040', '\163', '\164', '\040', '\061',
    '\012', '\155', '\152', '\124', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\130', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\113', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\167', '\126', '\040', '\145', '\162', '\040', '\061',
    '\012', '\160', '\152', '\102', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\131', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\131', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\161', '\131', '\040', '\145', '\161', '\040', '\061',
    '\012', '\165', '\111', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\124', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\161', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\112', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\107', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\167', '\106', '\040', '\163', '\164', '\040', '\061',
    '\012', '\110', '\146', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\110', '\164', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\146', '\127', '\040', '\150', '\127', '\040', '\061',
    '\012', '\151', '\171', '\107', '\040', '\151', '\156', '\040', '\061',
    '\012', '\172', '\120', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\172', '\126', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\126', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\120', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\113', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\145', '\106', '\142', '\040', '\145', '\162', '\040', '\061',
    '\012', '\121', '\152', '\151', '\040', '\152', '\123', '\040', '\061',
    '\012', '\155', '\164', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\147', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\110', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\124', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\170', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\113', '\164', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\127', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\127', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\123', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\106', '\172', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\150', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\160', '\127', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\166', '\120', '\040', '\151', '\152', '\040', '\061',
    '\012', '\165', '\131', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\170', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\123', '\161', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\143', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\115', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\132', '\147', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\107', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\126', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\125', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\157', '\161', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\107', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\131', '\142', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\122', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\162', '\132', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\124', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\132', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\147', '\117', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\112', '\152', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\120', '\160', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\161', '\167', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\143', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\106', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\167', '\131', '\040', '\167', '\141', '\040', '\061',
    '\012', '\153', '\124', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\107', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\145', '\121', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\107', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\160', '\126', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\124', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\117', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\160', '\130', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\131', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\164', '\152', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\114', '\172', '\156', '\040', '\114', '\107', '\040', '\061',
    '\012', '\131', '\152', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\165', '\131', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\144', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\130', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\111', '\167', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\150', '\112', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\124', '\146', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\170', '\117', '\040', '\143', '\150', '\040', '\061',
    '\012', '\121', '\161', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\104', '\166', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\163', '\117', '\040', '\163', '\164', '\040', '\061',
    '\012', '\155', '\162', '\107', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\152', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\147', '\104', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\125', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\144', '\102', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\154', '\125', '\040', '\154', '\145', '\040', '\061',
    '\012', '\142', '\102', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\161', '\142', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\154', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\127', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\147', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\162', '\125', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\147', '\111', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\152', '\112', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\166', '\125', '\040', '\166', '\141', '\040', '\061',
    '\012', '\162', '\103', '\160', '\040', '\107', '\103', '\040', '\061',
    '\012', '\156', '\126', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\142', '\107', '\040', '\142', '\145', '\040', '\061',
    '\012', '\164', '\144', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\152', '\122', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\121', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\172', '\132', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\125', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\152', '\131', '\040', '\151', '\152', '\040', '\061',
    '\012', '\112', '\170', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\132', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\166', '\132', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\154', '\122', '\163', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\167', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\160', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\163', '\167', '\123', '\040', '\163', '\164', '\040', '\061',
    '\012', '\105', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\105', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\164', '\153', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\147', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\167', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\163', '\152', '\127', '\040', '\163', '\164', '\040', '\061',
    '\012', '\144', '\130', '\155', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\166', '\131', '\040', '\166', '\113', '\040', '\061',
    '\012', '\154', '\162', '\117', '\040', '\145', '\162', '\040', '\061',
    '\012', '\114', '\144', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\170', '\126', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\106', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\126', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\120', '\171', '\146', '\040', '\156', '\171', '\040', '\061',
    '\012', '\113', '\170', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\167', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\160', '\114', '\040', '\143', '\150', '\040', '\061',
    '\012', '\110', '\147', '\145', '\040', '\156', '\147', '\040', '\061',
    '\012', '\127', '\142', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\121', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\104', '\154', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\160', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\132', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\132', '\161', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\155', '\125', '\040', '\155', '\145', '\040', '\061',
    '\012', '\164', '\125', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\127', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\162', '\144', '\040', '\145', '\162', '\040', '\061',
    '\012', '\160', '\121', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\162', '\132', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\152', '\111', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\121', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\166', '\107', '\171', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\167', '\131', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\116', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\160', '\120', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\113', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\126', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\164', '\115', '\150', '\040', '\143', '\150', '\040', '\061',
    '\012', '\113', '\164', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\160', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\104', '\146', '\040', '\151', '\156', '\040', '\061',
    '\012', '\161', '\113', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\114', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\112', '\152', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\143', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\124', '\161', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\107', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\170', '\126', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\143', '\103', '\040', '\143', '\150', '\040', '\061',
    '\012', '\106', '\167', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\120', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\155', '\105', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\155', '\124', '\040', '\155', '\145', '\040', '\061',
    '\012', '\154', '\170', '\103', '\040', '\107', '\103', '\040', '\061',
    '\012', '\154', '\122', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\121', '\153', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\151', '\150', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\114', '\154', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\161', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\110', '\150', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\120', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\166', '\121', '\040', '\121', '\117', '\040', '\061',
    '\012', '\152', '\107', '\171', '\040', '\151', '\152', '\040', '\061',
    '\012', '\154', '\115', '\153', '\040', '\154', '\145', '\040', '\061',
    '\012', '\165', '\117', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\144', '\124', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\166', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\143', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\153', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\142', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\146', '\113', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\115', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\160', '\106', '\040', '\166', '\141', '\040', '\061',
    '\012', '\144', '\147', '\120', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\170', '\106', '\040', '\155', '\145', '\040', '\061',
    '\012', '\162', '\132', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\107', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\120', '\170', '\040', '\163', '\164', '\040', '\061',
    '\012', '\162', '\107', '\144', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\142', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\104', '\146', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\152', '\103', '\040', '\163', '\164', '\040', '\061',
    '\012', '\172', '\123', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\111', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\111', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\153', '\160', '\106', '\040', '\153', '\141', '\040', '\061',
    '\012', '\145', '\125', '\167', '\040', '\145', '\162', '\040', '\061',
    '\012', '\110', '\170', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\166', '\107', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\125', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\152', '\106', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\114', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\152', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\114', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\144', '\123', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\167', '\113', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\110', '\171', '\040', '\164', '\150', '\040', '\061',
    '\012', '\123', '\163', '\167', '\040', '\163', '\164', '\040', '\061',
    '\012', '\150', '\152', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\104', '\144', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\120', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\127', '\160', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\162', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\160', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\157', '\130', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\152', '\113', '\040', '\151', '\152', '\040', '\061',
    '\012', '\126', '\172', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\131', '\144', '\040', '\154', '\145', '\040', '\061',
    '\012', '\117', '\144', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\150', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\122', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\132', '\164', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\126', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\152', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\106', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\114', '\150', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\154', '\117', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\166', '\102', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\142', '\116', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\120', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\164', '\121', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\166', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\162', '\161', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\105', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\152', '\163', '\102', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\155', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\164', '\105', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\144', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\104', '\155', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\167', '\111', '\040', '\167', '\141', '\040', '\061',
    '\012', '\152', '\160', '\121', '\040', '\151', '\152', '\040', '\061',
    '\012', '\165', '\130', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\131', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\157', '\106', '\172', '\040', '\157', '\156', '\040', '\061',
    '\012', '\164', '\102', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\103', '\156', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\132', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\162', '\114', '\040', '\145', '\162', '\040', '\061',
    '\012', '\112', '\162', '\171', '\040', '\145', '\162', '\040', '\061',
    '\012', '\151', '\113', '\144', '\040', '\151', '\156', '\040', '\061',
    '\012', '\166', '\143', '\116', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\116', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\122', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\143', '\110', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\141', '\117', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\141', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\170', '\114', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\125', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\166', '\117', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\120', '\170', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\165', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\146', '\116', '\040', '\163', '\164', '\040', '\061',
    '\012', '\121', '\154', '\166', '\040', '\154', '\145', '\040', '\061',
    '\012', '\142', '\132', '\171', '\040', '\142', '\145', '\040', '\061',
    '\012', '\166', '\105', '\161', '\040', '\166', '\113', '\040', '\061',
    '\012', '\130', '\166', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\112', '\170', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\172', '\107', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\103', '\161', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\120', '\160', '\040', '\163', '\164', '\040', '\061',
    '\012', '\166', '\101', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\127', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\162', '\143', '\132', '\040', '\143', '\155', '\040', '\061',
    '\012', '\154', '\104', '\163', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\104', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\160', '\123', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\167', '\123', '\040', '\166', '\141', '\040', '\061',
    '\012', '\153', '\147', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\162', '\124', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\113', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\150', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\115', '\154', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\113', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\144', '\106', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\146', '\116', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\144', '\117', '\040', '\163', '\164', '\040', '\061',
    '\012', '\153', '\110', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\166', '\105', '\040', '\166', '\141', '\040', '\061',
    '\012', '\142', '\120', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\162', '\172', '\130', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\123', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\106', '\146', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\130', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\142', '\122', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\132', '\170', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\130', '\172', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\162', '\122', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\110', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\161', '\145', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\162', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\153', '\111', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\162', '\131', '\040', '\145', '\162', '\040', '\061',
    '\012', '\152', '\161', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\132', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\124', '\155', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\110', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\144', '\161', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\154', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\166', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\113', '\154', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\142', '\123', '\040', '\156', '\147', '\040', '\061',
    '\012', '\163', '\142', '\121', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\165', '\106', '\040', '\165', '\156', '\040', '\061',
    '\012', '\161', '\172', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\141', '\111', '\040', '\141', '\156', '\040', '\061',
    '\012', '\126', '\155', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\141', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\121', '\153', '\142', '\040', '\153', '\141', '\040', '\061',
    '\012', '\130', '\152', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\157', '\103', '\161', '\040', '\107', '\103', '\040', '\061',
    '\012', '\161', '\121', '\150', '\040', '\121', '\117', '\040', '\061',
    '\012', '\143', '\167', '\117', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\115', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\162', '\113', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\113', '\171', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\113', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\143', '\161', '\123', '\040', '\143', '\150', '\040', '\061',
    '\012', '\151', '\107', '\166', '\040', '\151', '\156', '\040', '\061',
    '\012', '\170', '\130', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\146', '\115', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\132', '\155', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\131', '\161', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\104', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\170', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\171', '\171', '\105', '\040', '\156', '\171', '\040', '\061',
    '\012', '\163', '\125', '\166', '\040', '\163', '\164', '\040', '\061',
    '\012', '\143', '\126', '\162', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\161', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\147', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\161', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\124', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\151', '\115', '\166', '\040', '\151', '\156', '\040', '\061',
    '\012', '\161', '\127', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\144', '\126', '\040', '\144', '\145', '\040', '\061',
    '\012', '\157', '\121', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\132', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\157', '\131', '\040', '\157', '\156', '\040', '\061',
    '\012', '\152', '\122', '\153', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\120', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\161', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\161', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\102', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\160', '\130', '\040', '\160', '\162', '\040', '\061',
    '\012', '\142', '\131', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\131', '\145', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\152', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\161', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\150', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\166', '\106', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\143', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\106', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\110', '\144', '\171', '\040', '\144', '\145', '\040', '\061',
    '\012', '\154', '\162', '\132', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\132', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\124', '\146', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\172', '\162', '\111', '\040', '\145', '\162', '\040', '\061',
    '\012', '\144', '\104', '\166', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\145', '\110', '\040', '\145', '\162', '\040', '\061',
    '\012', '\154', '\172', '\110', '\040', '\154', '\145', '\040', '\061',
    '\012', '\163', '\114', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\151', '\113', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\172', '\143', '\040', '\143', '\155', '\040', '\061',
    '\012', '\170', '\122', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\123', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\167', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\170', '\131', '\040', '\167', '\141', '\040', '\061',
    '\012', '\131', '\153', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\157', '\126', '\160', '\040', '\157', '\156', '\040', '\061',
    '\012', '\143', '\147', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\106', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\152', '\124', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\132', '\172', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\150', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\172', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\110', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\166', '\116', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\154', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\166', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\160', '\125', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\164', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\121', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\113', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\122', '\167', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\162', '\117', '\040', '\145', '\162', '\040', '\061',
    '\012', '\156', '\160', '\102', '\040', '\141', '\156', '\040', '\061',
    '\012', '\121', '\164', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\115', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\117', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\104', '\172', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\126', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\124', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\121', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\124', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\121', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\132', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\112', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\162', '\120', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\161', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\104', '\167', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\126', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\161', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\112', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\164', '\170', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\132', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\130', '\156', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\146', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\126', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\126', '\160', '\040', '\156', '\147', '\040', '\061',
    '\012', '\156', '\102', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\156', '\132', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\161', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\120', '\172', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\112', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\156', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\113', '\170', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\144', '\130', '\154', '\040', '\130', '\155', '\040', '\061',
    '\012', '\150', '\167', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\122', '\162', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\154', '\114', '\040', '\154', '\145', '\040', '\061',
    '\012', '\146', '\117', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\167', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\103', '\155', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\106', '\142', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\150', '\127', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\123', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\102', '\170', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\143', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\166', '\130', '\040', '\154', '\145', '\040', '\061',
    '\012', '\113', '\153', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\146', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\113', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\153', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\112', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\111', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\101', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\146', '\110', '\040', '\160', '\162', '\040', '\061',
    '\012', '\121', '\167', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\142', '\125', '\040', '\167', '\141', '\040', '\061',
    '\012', '\166', '\104', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\112', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\154', '\122', '\040', '\154', '\145', '\040', '\061',
    '\012', '\155', '\130', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\162', '\110', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\157', '\126', '\172', '\040', '\157', '\156', '\040', '\061',
    '\012', '\147', '\164', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\162', '\113', '\040', '\110', '\113', '\040', '\061',
    '\012', '\127', '\170', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\160', '\156', '\112', '\040', '\141', '\156', '\040', '\061',
    '\012', '\106', '\161', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\126', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\142', '\120', '\040', '\143', '\150', '\040', '\061',
    '\012', '\107', '\152', '\143', '\040', '\152', '\123', '\040', '\061',
    '\012', '\152', '\121', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\164', '\166', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\172', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\171', '\127', '\040', '\151', '\152', '\040', '\061',
    '\012', '\130', '\142', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\161', '\146', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\166', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\142', '\114', '\040', '\167', '\141', '\040', '\061',
    '\012', '\155', '\153', '\117', '\040', '\153', '\141', '\040', '\061',
    '\012', '\145', '\161', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\166', '\123', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\107', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\127', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\154', '\130', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\112', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\114', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\116', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\153', '\172', '\121', '\040', '\163', '\172', '\040', '\061',
    '\012', '\103', '\172', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\156', '\126', '\040', '\141', '\156', '\040', '\061',
    '\012', '\122', '\152', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\116', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\120', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\170', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\150', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\125', '\166', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\146', '\125', '\040', '\146', '\157', '\040', '\061',
    '\012', '\151', '\116', '\160', '\040', '\151', '\156', '\040', '\061',
    '\012', '\171', '\131', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\157', '\120', '\142', '\040', '\157', '\156', '\040', '\061',
    '\012', '\161', '\151', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\143', '\104', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\126', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\107', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\122', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\142', '\102', '\040', '\142', '\145', '\040', '\061',
    '\012', '\163', '\132', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\170', '\117', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\106', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\115', '\170', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\170', '\120', '\040', '\144', '\145', '\040', '\061',
    '\012', '\154', '\122', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\142', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\105', '\141', '\157', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\147', '\101', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\143', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\155', '\121', '\040', '\166', '\141', '\040', '\061',
    '\012', '\131', '\161', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\151', '\117', '\040', '\151', '\156', '\040', '\061',
    '\012', '\170', '\117', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\110', '\146', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\142', '\146', '\123', '\040', '\142', '\145', '\040', '\061',
    '\012', '\121', '\150', '\156', '\040', '\164', '\150', '\040', '\061',
    '\012', '\103', '\155', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\154', '\131', '\163', '\040', '\154', '\145', '\040', '\061',
    '\012', '\116', '\161', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\145', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\164', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\115', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\165', '\150', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\123', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\131', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\146', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\123', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\123', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\103', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\160', '\167', '\103', '\040', '\160', '\162', '\040', '\061',
    '\012', '\107', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\115', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\153', '\103', '\040', '\153', '\141', '\040', '\061',
    '\012', '\165', '\161', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\102', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\163', '\127', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\132', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\170', '\152', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\110', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\167', '\116', '\040', '\167', '\141', '\040', '\061',
    '\012', '\166', '\115', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\110', '\150', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\163', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\162', '\112', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\166', '\115', '\040', '\166', '\141', '\040', '\061',
    '\012', '\155', '\130', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\127', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\144', '\170', '\132', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\126', '\152', '\040', '\163', '\164', '\040', '\061',
    '\012', '\170', '\162', '\106', '\040', '\145', '\162', '\040', '\061',
    '\012', '\160', '\142', '\125', '\040', '\160', '\162', '\040', '\061',
    '\012', '\124', '\146', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\161', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\143', '\106', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\162', '\123', '\040', '\141', '\156', '\040', '\061',
    '\012', '\127', '\150', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\147', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\130', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\153', '\112', '\142', '\040', '\153', '\141', '\040', '\061',
    '\012', '\162', '\132', '\153', '\040', '\145', '\162', '\040', '\061',
    '\012', '\160', '\102', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\125', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\110', '\161', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\106', '\152', '\040', '\157', '\156', '\040', '\061',
    '\012', '\170', '\142', '\116', '\040', '\142', '\145', '\040', '\061',
    '\012', '\160', '\156', '\113', '\040', '\141', '\156', '\040', '\061',
    '\012', '\114', '\142', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\144', '\115', '\142', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\123', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\163', '\166', '\040', '\163', '\164', '\040', '\061',
    '\012', '\167', '\162', '\126', '\040', '\145', '\162', '\040', '\061',
    '\012', '\165', '\113', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\154', '\131', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\170', '\106', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\152', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\162', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\166', '\106', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\114', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\162', '\113', '\040', '\145', '\162', '\040', '\061',
    '\012', '\121', '\154', '\172', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\170', '\104', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\144', '\131', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\166', '\104', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\121', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\106', '\165', '\040', '\165', '\156', '\040', '\061',
    '\012', '\163', '\146', '\112', '\040', '\163', '\164', '\040', '\061',
    '\012', '\160', '\111', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\150', '\170', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\116', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\111', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\110', '\146', '\040', '\156', '\171', '\040', '\061',
    '\012', '\161', '\130', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\154', '\104', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\106', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\127', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\145', '\113', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\150', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\142', '\126', '\040', '\142', '\145', '\040', '\061',
    '\012', '\170', '\130', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\131', '\150', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\167', '\130', '\040', '\167', '\141', '\040', '\061',
    '\012', '\142', '\161', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\166', '\131', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\166', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\162', '\142', '\120', '\040', '\145', '\162', '\040', '\061',
    '\012', '\163', '\130', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\125', '\167', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\155', '\127', '\040', '\155', '\145', '\040', '\061',
    '\012', '\160', '\170', '\126', '\040', '\160', '\162', '\040', '\061',
    '\012', '\156', '\152', '\132', '\040', '\141', '\156', '\040', '\061',
    '\012', '\124', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\155', '\105', '\040', '\163', '\172', '\040', '\061',
    '\012', '\122', '\161', '\165', '\040', '\165', '\156', '\040', '\061',
    '\012', '\161', '\161', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\150', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\112', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\161', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\103', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\160', '\127', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\144', '\171', '\040', '\144', '\145', '\040', '\061',
    '\012', '\151', '\122', '\170', '\040', '\151', '\156', '\040', '\061',
    '\012', '\126', '\143', '\155', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\111', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\130', '\142', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\143', '\107', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\152', '\130', '\040', '\151', '\152', '\040', '\061',
    '\012', '\156', '\155', '\117', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\121', '\152', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\146', '\126', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\142', '\113', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\106', '\144', '\040', '\141', '\156', '\040', '\061',
    '\012', '\157', '\127', '\166', '\040', '\157', '\156', '\040', '\061',
    '\012', '\156', '\110', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\156', '\113', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\170', '\132', '\040', '\142', '\145', '\040', '\061',
    '\012', '\167', '\155', '\110', '\040', '\155', '\145', '\040', '\061',
    '\012', '\146', '\147', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\172', '\110', '\040', '\156', '\147', '\040', '\061',
    '\012', '\132', '\142', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\147', '\115', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\155', '\113', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\166', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\145', '\121', '\163', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\110', '\155', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\102', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\110', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\166', '\161', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\116', '\160', '\171', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\172', '\114', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\115', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\167', '\125', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\146', '\130', '\040', '\160', '\162', '\040', '\061',
    '\012', '\156', '\106', '\147', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\106', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\126', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\105', '\155', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\130', '\171', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\126', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\166', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\110', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\127', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\170', '\143', '\113', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\125', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\114', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\126', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\106', '\163', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\107', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\167', '\171', '\040', '\167', '\141', '\040', '\061',
    '\012', '\147', '\172', '\124', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\116', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\162', '\125', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\164', '\101', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\161', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\167', '\115', '\040', '\160', '\162', '\040', '\061',
    '\012', '\154', '\162', '\120', '\040', '\145', '\162', '\040', '\061',
    '\012', '\152', '\155', '\103', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\155', '\120', '\040', '\155', '\145', '\040', '\061',
    '\012', '\171', '\151', '\131', '\040', '\151', '\156', '\040', '\061',
    '\012', '\160', '\124', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\132', '\167', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\160', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\150', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\117', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\143', '\113', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\147', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\146', '\106', '\040', '\146', '\157', '\040', '\061',
    '\012', '\143', '\124', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\160', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\114', '\146', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\147', '\167', '\125', '\040', '\156', '\147', '\040', '\061',
    '\012', '\104', '\172', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\104', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\120', '\166', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\144', '\131', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\127', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\163', '\121', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\152', '\131', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\103', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\162', '\123', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\123', '\146', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\132', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\115', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\116', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\152', '\124', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\155', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\170', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\101', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\110', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\146', '\147', '\101', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\150', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\127', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\146', '\125', '\040', '\160', '\162', '\040', '\061',
    '\012', '\157', '\111', '\152', '\040', '\157', '\156', '\040', '\061',
    '\012', '\154', '\150', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\104', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\166', '\112', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\104', '\160', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\151', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\146', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\170', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\106', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\150', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\152', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\155', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\155', '\115', '\040', '\155', '\145', '\040', '\061',
    '\012', '\143', '\126', '\171', '\040', '\143', '\150', '\040', '\061',
    '\012', '\113', '\172', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\146', '\101', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\152', '\122', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\171', '\121', '\040', '\156', '\171', '\040', '\061',
    '\012', '\155', '\102', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\121', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\144', '\132', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\145', '\126', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\116', '\166', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\106', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\150', '\154', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\143', '\156', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\167', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\132', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\150', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\127', '\146', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\112', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\131', '\172', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\105', '\157', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\116', '\152', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\132', '\147', '\144', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\107', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\147', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\171', '\105', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\172', '\105', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\152', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\142', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\163', '\146', '\040', '\163', '\164', '\040', '\061',
    '\012', '\155', '\121', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\121', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\171', '\130', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\131', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\145', '\120', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\141', '\103', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\126', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\170', '\117', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\152', '\127', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\147', '\111', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\132', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\164', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\115', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\124', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\115', '\170', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\142', '\111', '\040', '\142', '\145', '\040', '\061',
    '\012', '\161', '\101', '\165', '\040', '\165', '\156', '\040', '\061',
    '\012', '\167', '\146', '\124', '\040', '\167', '\141', '\040', '\061',
    '\012', '\146', '\143', '\106', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\146', '\113', '\040', '\160', '\162', '\040', '\061',
    '\012', '\142', '\117', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\165', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\112', '\155', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\160', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\161', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\117', '\166', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\130', '\154', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\116', '\162', '\154', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\170', '\127', '\040', '\146', '\157', '\040', '\061',
    '\012', '\123', '\167', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\166', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\160', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\116', '\167', '\040', '\157', '\156', '\040', '\061',
    '\012', '\153', '\131', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\130', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\146', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\145', '\104', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\126', '\161', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\113', '\172', '\040', '\165', '\163', '\040', '\061',
    '\012', '\161', '\152', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\170', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\114', '\153', '\171', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\106', '\171', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\115', '\154', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\131', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\143', '\121', '\145', '\040', '\143', '\150', '\040', '\061',
    '\012', '\157', '\131', '\152', '\040', '\157', '\156', '\040', '\061',
    '\012', '\164', '\142', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\142', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\156', '\126', '\153', '\040', '\156', '\144', '\040', '\061',
    '\012', '\142', '\130', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\114', '\161', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\144', '\113', '\040', '\144', '\145', '\040', '\061',
    '\012', '\160', '\144', '\120', '\040', '\144', '\145', '\040', '\061',
    '\012', '\164', '\161', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\152', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\143', '\103', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\132', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\141', '\123', '\144', '\040', '\141', '\156', '\040', '\061',
    '\012', '\103', '\155', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\172', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\121', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\107', '\161', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\127', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\130', '\162', '\167', '\040', '\145', '\162', '\040', '\061',
    '\012', '\171', '\112', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\163', '\161', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\127', '\142', '\040', '\144', '\145', '\040', '\061',
    '\012', '\156', '\142', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\151', '\167', '\120', '\040', '\151', '\156', '\040', '\061',
    '\012', '\154', '\127', '\163', '\040', '\154', '\145', '\040', '\061',
    '\012', '\124', '\163', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\110', '\172', '\040', '\144', '\145', '\040', '\061',
    '\012', '\164', '\143', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\153', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\102', '\144', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\115', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\152', '\126', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\121', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\144', '\156', '\111', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\171', '\131', '\040', '\156', '\171', '\040', '\061',
    '\012', '\141', '\106', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\131', '\154', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\131', '\171', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\152', '\142', '\126', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\143', '\126', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\172', '\130', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\122', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\152', '\101', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\156', '\111', '\040', '\141', '\156', '\040', '\061',
    '\012', '\114', '\154', '\166', '\040', '\154', '\145', '\040', '\061',
    '\012', '\164', '\155', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\121', '\157', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\164', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\122', '\170', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\170', '\127', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\164', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\161', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\110', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\122', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\116', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\151', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\131', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\144', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\127', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\153', '\102', '\040', '\153', '\141', '\040', '\061',
    '\012', '\153', '\170', '\103', '\040', '\153', '\141', '\040', '\061',
    '\012', '\154', '\152', '\101', '\040', '\154', '\145', '\040', '\061',
    '\012', '\121', '\167', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\155', '\103', '\160', '\040', '\155', '\145', '\040', '\061',
    '\012', '\146', '\112', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\103', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\143', '\172', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\102', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\131', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\110', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\153', '\166', '\127', '\040', '\153', '\141', '\040', '\061',
    '\012', '\112', '\155', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\121', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\142', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\170', '\130', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\106', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\124', '\152', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\170', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\144', '\131', '\040', '\144', '\145', '\040', '\061',
    '\012', '\160', '\155', '\106', '\040', '\155', '\145', '\040', '\061',
    '\012', '\163', '\104', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\162', '\126', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\104', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\102', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\110', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\172', '\121', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\126', '\160', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\146', '\110', '\040', '\156', '\147', '\040', '\061',
    '\012', '\157', '\107', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\166', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\115', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\156', '\123', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\121', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\165', '\157', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\153', '\130', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\110', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\165', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\142', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\167', '\107', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\160', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\122', '\160', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\113', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\125', '\142', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\156', '\112', '\040', '\141', '\156', '\040', '\061',
    '\012', '\122', '\160', '\171', '\040', '\160', '\162', '\040', '\061',
    '\012', '\142', '\143', '\123', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\170', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\152', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\121', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\162', '\130', '\040', '\145', '\162', '\040', '\061',
    '\012', '\106', '\143', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\157', '\126', '\170', '\040', '\157', '\156', '\040', '\061',
    '\012', '\166', '\112', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\102', '\166', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\144', '\155', '\130', '\040', '\144', '\145', '\040', '\061',
    '\012', '\127', '\144', '\152', '\040', '\144', '\145', '\040', '\061',
    '\012', '\131', '\172', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\131', '\143', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\113', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\162', '\110', '\040', '\145', '\162', '\040', '\061',
    '\012', '\114', '\156', '\155', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\103', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\125', '\167', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\125', '\166', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\115', '\146', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\161', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\110', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\147', '\112', '\040', '\156', '\147', '\040', '\061',
    '\012', '\141', '\107', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\152', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\153', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\110', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\116', '\172', '\160', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\132', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\166', '\113', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\154', '\106', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\155', '\104', '\040', '\155', '\145', '\040', '\061',
    '\012', '\131', '\160', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\106', '\171', '\040', '\160', '\162', '\040', '\061',
    '\012', '\150', '\166', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\164', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\161', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\166', '\116', '\040', '\153', '\141', '\040', '\061',
    '\012', '\164', '\143', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\153', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\144', '\110', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\105', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\143', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\126', '\167', '\165', '\040', '\165', '\156', '\040', '\061',
    '\012', '\147', '\130', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\127', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\127', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\112', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\123', '\152', '\040', '\157', '\156', '\040', '\061',
    '\012', '\154', '\167', '\131', '\040', '\154', '\145', '\040', '\061',
    '\012', '\124', '\153', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\160', '\143', '\103', '\040', '\143', '\150', '\040', '\061',
    '\012', '\157', '\150', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\172', '\107', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\144', '\116', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\162', '\123', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\110', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\152', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\142', '\132', '\040', '\166', '\141', '\040', '\061',
    '\012', '\125', '\144', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\172', '\130', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\116', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\146', '\132', '\040', '\167', '\141', '\040', '\061',
    '\012', '\163', '\167', '\102', '\040', '\163', '\164', '\040', '\061',
    '\012', '\144', '\155', '\121', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\143', '\101', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\172', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\112', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\127', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\126', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\167', '\102', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\111', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\142', '\160', '\125', '\040', '\160', '\162', '\040', '\061',
    '\012', '\142', '\167', '\115', '\040', '\167', '\141', '\040', '\061',
    '\012', '\146', '\153', '\101', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\125', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\124', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\113', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\154', '\170', '\123', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\141', '\123', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\166', '\121', '\040', '\166', '\141', '\040', '\061',
    '\012', '\144', '\150', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\144', '\127', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\146', '\112', '\040', '\167', '\141', '\040', '\061',
    '\012', '\127', '\161', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\132', '\152', '\040', '\163', '\164', '\040', '\061',
    '\012', '\114', '\170', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\170', '\130', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\161', '\104', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\113', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\166', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\146', '\110', '\040', '\153', '\141', '\040', '\061',
    '\012', '\141', '\121', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\106', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\152', '\127', '\040', '\141', '\156', '\040', '\061',
    '\012', '\122', '\160', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\115', '\155', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\150', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\113', '\153', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\101', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\146', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\167', '\116', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\160', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\170', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\115', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\167', '\114', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\102', '\142', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\101', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\123', '\144', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\112', '\155', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\142', '\147', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\127', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\150', '\110', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\167', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\106', '\142', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\172', '\157', '\124', '\040', '\157', '\156', '\040', '\061',
    '\012', '\171', '\152', '\107', '\040', '\151', '\152', '\040', '\061',
    '\012', '\122', '\154', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\106', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\143', '\113', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\144', '\103', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\166', '\117', '\040', '\166', '\141', '\040', '\061',
    '\012', '\157', '\121', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\156', '\111', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\172', '\101', '\040', '\163', '\172', '\040', '\061',
    '\012', '\122', '\172', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\121', '\172', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\131', '\152', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\153', '\121', '\040', '\153', '\165', '\040', '\061',
    '\012', '\154', '\162', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\167', '\132', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\107', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\155', '\156', '\114', '\040', '\141', '\156', '\040', '\061',
    '\012', '\122', '\154', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\143', '\104', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\122', '\144', '\040', '\145', '\162', '\040', '\061',
    '\012', '\117', '\146', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\106', '\152', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\165', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\132', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\116', '\142', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\156', '\127', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\142', '\110', '\040', '\151', '\152', '\040', '\061',
    '\012', '\162', '\104', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\121', '\155', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\167', '\126', '\040', '\144', '\145', '\040', '\061',
    '\012', '\117', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\161', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\167', '\111', '\040', '\167', '\141', '\040', '\061',
    '\012', '\156', '\152', '\120', '\040', '\141', '\156', '\040', '\061',
    '\012', '\117', '\161', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\126', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\146', '\117', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\161', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\104', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\124', '\155', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\143', '\113', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\155', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\126', '\170', '\040', '\163', '\164', '\040', '\061',
    '\012', '\127', '\146', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\112', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\165', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\146', '\116', '\040', '\142', '\145', '\040', '\061',
    '\012', '\161', '\146', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\155', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\142', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\152', '\116', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\150', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\116', '\170', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\167', '\170', '\125', '\040', '\167', '\141', '\040', '\061',
    '\012', '\172', '\130', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\116', '\172', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\157', '\150', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\163', '\170', '\040', '\163', '\164', '\040', '\061',
    '\012', '\132', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\125', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\152', '\103', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\124', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\161', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\171', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\111', '\143', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\166', '\116', '\040', '\163', '\164', '\040', '\061',
    '\012', '\112', '\152', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\126', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\144', '\111', '\040', '\144', '\145', '\040', '\061',
    '\012', '\156', '\142', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\146', '\125', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\107', '\155', '\040', '\154', '\145', '\040', '\061',
    '\012', '\117', '\166', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\104', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\147', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\131', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\152', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\120', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\151', '\122', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\162', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\160', '\124', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\163', '\102', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\170', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\106', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\157', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\155', '\104', '\040', '\163', '\164', '\040', '\061',
    '\012', '\154', '\142', '\115', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\103', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\106', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\130', '\154', '\166', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\171', '\125', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\106', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\164', '\152', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\131', '\170', '\040', '\151', '\156', '\040', '\061',
    '\012', '\165', '\112', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\145', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\162', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\102', '\161', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\144', '\142', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\156', '\122', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\155', '\114', '\040', '\155', '\145', '\040', '\061',
    '\012', '\164', '\166', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\124', '\155', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\104', '\147', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\157', '\172', '\117', '\040', '\157', '\156', '\040', '\061',
    '\012', '\146', '\121', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\120', '\161', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\131', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\120', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\147', '\127', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\103', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\145', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\132', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\147', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\152', '\117', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\103', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\163', '\166', '\121', '\040', '\163', '\164', '\040', '\061',
    '\012', '\122', '\161', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\142', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\114', '\153', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\106', '\172', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\154', '\102', '\040', '\154', '\145', '\040', '\061',
    '\012', '\151', '\127', '\152', '\040', '\151', '\156', '\040', '\061',
    '\012', '\132', '\170', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\113', '\170', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\152', '\143', '\112', '\040', '\151', '\152', '\040', '\061',
    '\012', '\165', '\103', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\101', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\126', '\152', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\125', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\115', '\156', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\152', '\115', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\125', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\165', '\132', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\167', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\164', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\122', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\172', '\126', '\040', '\163', '\172', '\040', '\061',
    '\012', '\155', '\166', '\131', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\106', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\102', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\107', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\125', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\147', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\127', '\142', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\167', '\120', '\040', '\167', '\141', '\040', '\061',
    '\012', '\167', '\166', '\105', '\040', '\166', '\141', '\040', '\061',
    '\012', '\106', '\163', '\170', '\040', '\163', '\164', '\040', '\061',
    '\012', '\111', '\172', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\167', '\103', '\040', '\167', '\141', '\040', '\061',
    '\012', '\106', '\155', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\114', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\122', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\151', '\130', '\146', '\040', '\151', '\156', '\040', '\061',
    '\012', '\171', '\115', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\161', '\120', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\163', '\114', '\040', '\163', '\164', '\040', '\061',
    '\012', '\152', '\111', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\165', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\142', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\105', '\161', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\117', '\147', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\107', '\166', '\040', '\153', '\141', '\040', '\061',
    '\012', '\160', '\152', '\113', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\143', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\172', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\125', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\107', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\150', '\155', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\161', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\153', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\147', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\167', '\117', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\155', '\123', '\040', '\155', '\145', '\040', '\061',
    '\012', '\166', '\150', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\171', '\130', '\040', '\163', '\164', '\040', '\061',
    '\012', '\156', '\142', '\103', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\147', '\127', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\161', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\127', '\146', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\167', '\106', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\156', '\106', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\104', '\151', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\123', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\121', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\162', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\107', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\170', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\162', '\127', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\154', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\106', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\160', '\142', '\106', '\040', '\160', '\162', '\040', '\061',
    '\012', '\142', '\116', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\121', '\143', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\126', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\160', '\120', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\160', '\126', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\154', '\107', '\040', '\154', '\145', '\040', '\061',
    '\012', '\104', '\167', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\121', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\154', '\153', '\121', '\040', '\154', '\145', '\040', '\061',
    '\012', '\163', '\161', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\171', '\170', '\040', '\156', '\171', '\040', '\061',
    '\012', '\166', '\106', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\164', '\121', '\157', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\154', '\125', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\154', '\127', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\154', '\127', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\155', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\141', '\127', '\154', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\155', '\126', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\114', '\155', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\154', '\102', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\161', '\101', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\147', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\107', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\167', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\146', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\167', '\155', '\114', '\040', '\155', '\145', '\040', '\061',
    '\012', '\170', '\114', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\142', '\105', '\040', '\163', '\164', '\040', '\061',
    '\012', '\142', '\121', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\153', '\122', '\040', '\153', '\141', '\040', '\061',
    '\012', '\171', '\106', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\117', '\155', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\146', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\112', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\114', '\167', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\167', '\146', '\125', '\040', '\167', '\141', '\040', '\061',
    '\012', '\172', '\146', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\116', '\166', '\040', '\154', '\145', '\040', '\061',
    '\012', '\171', '\153', '\121', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\104', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\104', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\142', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\121', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\166', '\166', '\115', '\040', '\166', '\141', '\040', '\061',
    '\012', '\130', '\161', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\114', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\153', '\132', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\101', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\152', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\106', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\167', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\127', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\131', '\162', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\145', '\125', '\157', '\040', '\145', '\162', '\040', '\061',
    '\012', '\165', '\104', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\115', '\150', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\107', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\122', '\160', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\142', '\106', '\040', '\163', '\164', '\040', '\061',
    '\012', '\156', '\146', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\127', '\146', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\115', '\167', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\104', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\160', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\172', '\106', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\130', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\163', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\132', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\114', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\161', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\152', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\153', '\104', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\112', '\170', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\126', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\110', '\166', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\161', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\122', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\166', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\116', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\127', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\122', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\162', '\107', '\142', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\132', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\130', '\164', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\132', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\126', '\155', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\115', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\120', '\171', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\172', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\152', '\105', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\172', '\106', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\103', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\146', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\143', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\132', '\146', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\167', '\103', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\153', '\115', '\040', '\153', '\157', '\040', '\061',
    '\012', '\166', '\112', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\145', '\103', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\120', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\161', '\112', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\155', '\131', '\040', '\144', '\145', '\040', '\061',
    '\012', '\165', '\115', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\113', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\161', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\116', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\103', '\162', '\152', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\163', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\167', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\123', '\144', '\171', '\040', '\144', '\145', '\040', '\061',
    '\012', '\106', '\160', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\127', '\143', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\152', '\127', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\167', '\127', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\152', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\132', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\143', '\113', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\144', '\122', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\161', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\150', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\147', '\107', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\115', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\156', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\112', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\166', '\103', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\160', '\122', '\040', '\143', '\150', '\040', '\061',
    '\012', '\127', '\164', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\171', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\130', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\113', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\126', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\172', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\120', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\124', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\106', '\152', '\040', '\163', '\164', '\040', '\061',
    '\012', '\155', '\172', '\130', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\115', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\170', '\111', '\040', '\145', '\162', '\040', '\061',
    '\012', '\145', '\131', '\146', '\040', '\145', '\162', '\040', '\061',
    '\012', '\153', '\167', '\102', '\040', '\153', '\141', '\040', '\061',
    '\012', '\145', '\121', '\153', '\040', '\145', '\162', '\040', '\061',
    '\012', '\152', '\102', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\142', '\110', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\103', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\156', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\131', '\144', '\040', '\156', '\147', '\040', '\061',
    '\012', '\132', '\170', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\132', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\110', '\147', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\122', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\160', '\122', '\040', '\160', '\162', '\040', '\061',
    '\012', '\143', '\142', '\122', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\161', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\115', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\121', '\171', '\040', '\164', '\157', '\040', '\061',
    '\012', '\166', '\170', '\107', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\160', '\102', '\040', '\156', '\147', '\040', '\061',
    '\012', '\107', '\153', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\161', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\120', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\156', '\116', '\040', '\141', '\156', '\040', '\061',
    '\012', '\107', '\153', '\160', '\040', '\153', '\141', '\040', '\061',
    '\012', '\155', '\166', '\121', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\110', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\146', '\123', '\040', '\167', '\141', '\040', '\061',
    '\012', '\161', '\103', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\161', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\147', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\115', '\167', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\161', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\153', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\157', '\106', '\166', '\040', '\157', '\156', '\040', '\061',
    '\012', '\104', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\111', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\146', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\147', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\170', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\161', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\110', '\164', '\156', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\166', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\122', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\103', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\162', '\152', '\124', '\040', '\162', '\157', '\040', '\061',
    '\012', '\162', '\152', '\104', '\040', '\145', '\162', '\040', '\061',
    '\012', '\121', '\160', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\130', '\144', '\142', '\040', '\144', '\145', '\040', '\061',
    '\012', '\114', '\153', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\101', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\131', '\154', '\172', '\040', '\154', '\145', '\040', '\061',
    '\012', '\121', '\164', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\110', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\104', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\114', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\150', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\114', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\147', '\113', '\040', '\156', '\147', '\040', '\061',
    '\012', '\145', '\127', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\152', '\123', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\126', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\117', '\153', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\105', '\167', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\104', '\163', '\166', '\040', '\163', '\164', '\040', '\061',
    '\012', '\152', '\150', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\107', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\117', '\153', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\106', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\120', '\166', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\163', '\113', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\114', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\153', '\102', '\040', '\153', '\141', '\040', '\061',
    '\012', '\143', '\103', '\142', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\116', '\160', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\167', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\124', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\120', '\161', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\106', '\166', '\040', '\162', '\157', '\040', '\061',
    '\012', '\122', '\167', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\113', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\161', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\155', '\113', '\040', '\153', '\141', '\040', '\061',
    '\012', '\167', '\165', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\156', '\132', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\147', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\144', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\101', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\167', '\117', '\040', '\167', '\141', '\040', '\061',
    '\012', '\145', '\121', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\106', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\104', '\160', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\160', '\121', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\141', '\106', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\146', '\102', '\040', '\155', '\145', '\040', '\061',
    '\012', '\146', '\160', '\101', '\040', '\160', '\162', '\040', '\061',
    '\012', '\152', '\147', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\154', '\107', '\153', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\143', '\101', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\127', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\154', '\172', '\106', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\163', '\121', '\040', '\163', '\164', '\040', '\061',
    '\012', '\142', '\121', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\167', '\152', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\104', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\127', '\160', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\146', '\126', '\040', '\145', '\162', '\040', '\061',
    '\012', '\132', '\142', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\150', '\113', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\130', '\141', '\040', '\141', '\162', '\040', '\061',
    '\012', '\167', '\152', '\101', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\172', '\123', '\040', '\163', '\172', '\040', '\061',
    '\012', '\143', '\127', '\171', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\152', '\113', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\122', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\161', '\147', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\161', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\156', '\125', '\040', '\141', '\156', '\040', '\061',
    '\012', '\132', '\161', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\161', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\114', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\172', '\126', '\040', '\156', '\147', '\040', '\061',
    '\012', '\113', '\161', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\147', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\161', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\161', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\111', '\145', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\152', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\155', '\116', '\040', '\166', '\141', '\040', '\061',
    '\012', '\151', '\165', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\107', '\171', '\040', '\167', '\141', '\040', '\061',
    '\012', '\113', '\144', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\121', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\127', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\103', '\170', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\113', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\130', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\157', '\121', '\040', '\157', '\156', '\040', '\061',
    '\012', '\167', '\102', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\171', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\150', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\160', '\171', '\040', '\160', '\162', '\040', '\061',
    '\012', '\156', '\112', '\142', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\107', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\150', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\152', '\123', '\040', '\151', '\152', '\040', '\061',
    '\012', '\123', '\143', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\106', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\113', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\130', '\155', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\144', '\124', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\112', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\124', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\152', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\115', '\161', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\110', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\162', '\122', '\156', '\040', '\141', '\162', '\040', '\061',
    '\012', '\130', '\154', '\146', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\116', '\163', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\161', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\151', '\106', '\172', '\040', '\151', '\156', '\040', '\061',
    '\012', '\116', '\154', '\153', '\040', '\154', '\145', '\040', '\061',
    '\012', '\163', '\120', '\167', '\040', '\163', '\164', '\040', '\061',
    '\012', '\166', '\127', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\130', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\156', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\157', '\172', '\112', '\040', '\157', '\156', '\040', '\061',
    '\012', '\172', '\111', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\154', '\123', '\146', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\122', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\102', '\166', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\127', '\167', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\160', '\127', '\147', '\040', '\160', '\162', '\040', '\061',
    '\012', '\160', '\114', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\153', '\162', '\112', '\040', '\145', '\162', '\040', '\061',
    '\012', '\132', '\146', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\171', '\111', '\170', '\040', '\156', '\171', '\040', '\061',
    '\012', '\157', '\113', '\170', '\040', '\157', '\156', '\040', '\061',
    '\012', '\161', '\114', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\110', '\152', '\040', '\144', '\145', '\040', '\061',
    '\012', '\157', '\161', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\170', '\103', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\112', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\132', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\127', '\172', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\161', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\130', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\131', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\107', '\171', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\104', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\113', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\130', '\152', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\152', '\115', '\040', '\163', '\164', '\040', '\061',
    '\012', '\163', '\146', '\103', '\040', '\163', '\164', '\040', '\061',
    '\012', '\144', '\115', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\132', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\143', '\104', '\040', '\143', '\150', '\040', '\061',
    '\012', '\121', '\157', '\152', '\040', '\157', '\156', '\040', '\061',
    '\012', '\147', '\170', '\103', '\040', '\156', '\147', '\040', '\061',
    '\012', '\132', '\146', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\131', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\127', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\132', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\121', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\130', '\154', '\142', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\121', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\156', '\142', '\132', '\040', '\141', '\156', '\040', '\061',
    '\012', '\105', '\172', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\116', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\130', '\162', '\152', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\170', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\121', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\131', '\160', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\116', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\160', '\142', '\121', '\040', '\160', '\162', '\040', '\061',
    '\012', '\147', '\115', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\145', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\126', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\126', '\153', '\040', '\144', '\145', '\040', '\061',
    '\012', '\165', '\115', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\121', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\150', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\124', '\142', '\040', '\151', '\156', '\040', '\061',
    '\012', '\120', '\166', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\103', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\143', '\122', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\166', '\125', '\040', '\163', '\164', '\040', '\061',
    '\012', '\156', '\115', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\152', '\105', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\155', '\110', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\172', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\161', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\154', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\166', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\110', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\161', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\163', '\116', '\040', '\163', '\164', '\040', '\061',
    '\012', '\153', '\103', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\117', '\154', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\107', '\170', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\170', '\167', '\126', '\040', '\167', '\141', '\040', '\061',
    '\012', '\146', '\120', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\122', '\150', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\147', '\126', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\144', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\106', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\153', '\154', '\121', '\040', '\154', '\145', '\040', '\061',
    '\012', '\171', '\112', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\162', '\170', '\105', '\040', '\145', '\162', '\040', '\061',
    '\012', '\165', '\110', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\113', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\160', '\112', '\040', '\160', '\162', '\040', '\061',
    '\012', '\103', '\152', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\164', '\131', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\160', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\132', '\170', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\121', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\106', '\170', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\121', '\157', '\153', '\040', '\157', '\156', '\040', '\061',
    '\012', '\160', '\154', '\113', '\040', '\154', '\145', '\040', '\061',
    '\012', '\154', '\160', '\130', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\144', '\120', '\040', '\144', '\145', '\040', '\061',
    '\012', '\132', '\161', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\122', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\104', '\147', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\161', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\147', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\115', '\142', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\113', '\161', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\116', '\161', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\172', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\107', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\104', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\112', '\152', '\153', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\164', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\167', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\104', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\147', '\146', '\107', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\150', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\125', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\127', '\142', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\153', '\106', '\040', '\153', '\157', '\040', '\061',
    '\012', '\120', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\142', '\113', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\123', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\167', '\111', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\106', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\146', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\150', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\172', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\116', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\167', '\122', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\172', '\113', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\121', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\114', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\125', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\162', '\110', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\112', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\150', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\116', '\172', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\122', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\130', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\124', '\172', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\132', '\153', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\150', '\114', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\125', '\153', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\115', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\166', '\107', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\164', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\170', '\105', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\162', '\110', '\040', '\145', '\162', '\040', '\061',
    '\012', '\106', '\147', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\154', '\106', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\143', '\117', '\040', '\152', '\141', '\040', '\061',
    '\012', '\163', '\103', '\167', '\040', '\163', '\164', '\040', '\061',
    '\012', '\102', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\132', '\171', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\117', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\112', '\142', '\040', '\145', '\162', '\040', '\061',
    '\012', '\162', '\152', '\126', '\040', '\145', '\162', '\040', '\061',
    '\012', '\113', '\167', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\110', '\143', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\103', '\167', '\040', '\155', '\141', '\040', '\061',
    '\012', '\150', '\170', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\124', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\155', '\121', '\040', '\155', '\145', '\040', '\061',
    '\012', '\160', '\152', '\122', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\144', '\120', '\040', '\143', '\150', '\040', '\061',
    '\012', '\132', '\152', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\152', '\161', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\115', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\115', '\161', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\166', '\130', '\040', '\163', '\164', '\040', '\061',
    '\012', '\151', '\130', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\156', '\167', '\122', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\164', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\152', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\103', '\152', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\160', '\130', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\107', '\167', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\111', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\121', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\131', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\166', '\164', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\125', '\163', '\170', '\040', '\163', '\164', '\040', '\061',
    '\012', '\156', '\146', '\120', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\121', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\157', '\130', '\146', '\040', '\157', '\156', '\040', '\061',
    '\012', '\146', '\105', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\163', '\147', '\130', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\120', '\160', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\142', '\127', '\040', '\142', '\145', '\040', '\061',
    '\012', '\153', '\143', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\110', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\166', '\143', '\125', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\130', '\157', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\172', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\103', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\152', '\171', '\040', '\151', '\152', '\040', '\061',
    '\012', '\106', '\170', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\170', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\127', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\154', '\113', '\040', '\154', '\145', '\040', '\061',
    '\012', '\156', '\132', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\117', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\153', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\172', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\124', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\162', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\120', '\164', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\104', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\162', '\116', '\155', '\040', '\145', '\162', '\040', '\061',
    '\012', '\105', '\167', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\150', '\112', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\164', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\161', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\110', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\162', '\150', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\161', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\160', '\132', '\040', '\166', '\141', '\040', '\061',
    '\012', '\104', '\147', '\144', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\170', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\103', '\170', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\154', '\126', '\040', '\160', '\162', '\040', '\061',
    '\012', '\153', '\111', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\113', '\150', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\163', '\131', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\114', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\153', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\155', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\166', '\111', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\150', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\146', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\170', '\132', '\040', '\167', '\141', '\040', '\061',
    '\012', '\152', '\126', '\171', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\121', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\130', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\114', '\150', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\115', '\153', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\153', '\125', '\040', '\151', '\152', '\040', '\061',
    '\012', '\131', '\150', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\162', '\110', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\150', '\107', '\040', '\166', '\141', '\040', '\061',
    '\012', '\144', '\162', '\104', '\040', '\145', '\162', '\040', '\061',
    '\012', '\120', '\163', '\152', '\040', '\163', '\164', '\040', '\061',
    '\012', '\147', '\104', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\130', '\152', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\114', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\153', '\154', '\103', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\124', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\162', '\112', '\040', '\145', '\162', '\040', '\061',
    '\012', '\130', '\147', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\127', '\170', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\146', '\144', '\104', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\110', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\104', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\153', '\120', '\166', '\040', '\153', '\141', '\040', '\061',
    '\012', '\122', '\153', '\155', '\040', '\153', '\141', '\040', '\061',
    '\012', '\155', '\172', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\154', '\110', '\172', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\160', '\122', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\132', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\102', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\120', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\116', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\116', '\166', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\160', '\171', '\125', '\040', '\160', '\162', '\040', '\061',
    '\012', '\123', '\152', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\172', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\157', '\121', '\160', '\040', '\157', '\156', '\040', '\061',
    '\012', '\170', '\144', '\114', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\156', '\132', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\146', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\112', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\127', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\130', '\155', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\107', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\163', '\106', '\146', '\040', '\163', '\164', '\040', '\061',
    '\012', '\126', '\167', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\164', '\113', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\121', '\170', '\040', '\163', '\164', '\040', '\061',
    '\012', '\157', '\116', '\155', '\040', '\157', '\156', '\040', '\061',
    '\012', '\165', '\130', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\163', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\127', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\146', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\111', '\152', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\153', '\127', '\040', '\144', '\145', '\040', '\061',
    '\012', '\116', '\170', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\165', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\120', '\171', '\040', '\142', '\145', '\040', '\061',
    '\012', '\154', '\113', '\163', '\040', '\154', '\145', '\040', '\061',
    '\012', '\141', '\114', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\120', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\160', '\132', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\152', '\105', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\116', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\150', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\121', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\170', '\102', '\040', '\142', '\145', '\040', '\061',
    '\012', '\146', '\144', '\130', '\040', '\144', '\145', '\040', '\061',
    '\012', '\112', '\143', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\106', '\144', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\126', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\164', '\155', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\152', '\112', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\172', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\164', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\143', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\107', '\150', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\132', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\113', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\166', '\117', '\040', '\166', '\141', '\040', '\061',
    '\012', '\147', '\130', '\163', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\122', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\147', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\160', '\117', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\127', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\125', '\160', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\167', '\104', '\040', '\166', '\141', '\040', '\061',
    '\012', '\155', '\170', '\105', '\040', '\155', '\145', '\040', '\061',
    '\012', '\132', '\166', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\157', '\172', '\115', '\040', '\157', '\156', '\040', '\061',
    '\012', '\146', '\142', '\112', '\040', '\142', '\145', '\040', '\061',
    '\012', '\164', '\160', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\145', '\126', '\040', '\145', '\162', '\040', '\061',
    '\012', '\132', '\156', '\142', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\130', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\142', '\143', '\131', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\147', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\146', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\143', '\114', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\130', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\165', '\102', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\170', '\127', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\164', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\147', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\101', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\102', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\107', '\164', '\171', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\146', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\170', '\161', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\102', '\160', '\040', '\143', '\150', '\040', '\061',
    '\012', '\130', '\161', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\166', '\115', '\040', '\166', '\141', '\040', '\061',
    '\012', '\165', '\127', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\123', '\142', '\040', '\145', '\162', '\040', '\061',
    '\012', '\130', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\124', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\114', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\112', '\162', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\157', '\112', '\142', '\040', '\157', '\156', '\040', '\061',
    '\012', '\160', '\130', '\171', '\040', '\160', '\162', '\040', '\061',
    '\012', '\172', '\162', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\156', '\124', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\163', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\132', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\126', '\171', '\040', '\142', '\145', '\040', '\061',
    '\012', '\161', '\111', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\147', '\122', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\114', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\126', '\154', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\122', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\150', '\101', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\114', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\123', '\147', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\114', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\124', '\170', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\160', '\131', '\040', '\160', '\162', '\040', '\061',
    '\012', '\164', '\130', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\143', '\103', '\040', '\143', '\150', '\040', '\061',
    '\012', '\151', '\131', '\146', '\040', '\151', '\156', '\040', '\061',
    '\012', '\127', '\167', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\153', '\132', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\131', '\167', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\106', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\106', '\155', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\121', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\167', '\122', '\040', '\167', '\141', '\040', '\061',
    '\012', '\131', '\146', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\141', '\111', '\157', '\040', '\141', '\156', '\040', '\061',
    '\012', '\163', '\102', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\172', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\167', '\111', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\106', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\141', '\127', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\105', '\141', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\153', '\127', '\040', '\153', '\141', '\040', '\061',
    '\012', '\116', '\146', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\154', '\116', '\040', '\154', '\145', '\040', '\061',
    '\012', '\114', '\160', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\171', '\154', '\113', '\040', '\154', '\145', '\040', '\061',
    '\012', '\132', '\156', '\162', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\143', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\146', '\105', '\040', '\153', '\141', '\040', '\061',
    '\012', '\111', '\171', '\146', '\040', '\156', '\171', '\040', '\061',
    '\012', '\161', '\162', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\120', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\146', '\147', '\112', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\111', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\142', '\120', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\121', '\171', '\170', '\040', '\156', '\171', '\040', '\061',
    '\012', '\121', '\156', '\142', '\040', '\141', '\156', '\040', '\061',
    '\012', '\127', '\144', '\155', '\040', '\144', '\145', '\040', '\061',
    '\012', '\156', '\112', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\103', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\132', '\154', '\040', '\156', '\147', '\040', '\061',
    '\012', '\116', '\154', '\172', '\040', '\154', '\145', '\040', '\061',
    '\012', '\132', '\167', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\127', '\154', '\040', '\151', '\156', '\040', '\061',
    '\012', '\142', '\125', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\142', '\112', '\040', '\154', '\145', '\040', '\061',
    '\012', '\163', '\116', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\152', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\142', '\124', '\040', '\167', '\141', '\040', '\061',
    '\012', '\171', '\116', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\170', '\115', '\040', '\155', '\145', '\040', '\061',
    '\012', '\160', '\110', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\122', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\153', '\105', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\142', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\124', '\147', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\152', '\126', '\040', '\156', '\147', '\040', '\061',
    '\012', '\107', '\152', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\161', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\130', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\121', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\116', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\112', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\171', '\166', '\132', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\116', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\104', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\125', '\172', '\040', '\154', '\145', '\040', '\061',
    '\012', '\104', '\170', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\127', '\167', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\120', '\156', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\116', '\142', '\040', '\153', '\157', '\040', '\061',
    '\012', '\127', '\144', '\142', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\130', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\152', '\114', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\112', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\155', '\115', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\130', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\124', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\131', '\163', '\146', '\040', '\163', '\164', '\040', '\061',
    '\012', '\150', '\155', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\171', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\160', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\121', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\120', '\142', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\126', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\150', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\123', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\107', '\170', '\172', '\040', '\172', '\145', '\040', '\061',
    '\012', '\104', '\146', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\162', '\115', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\115', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\112', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\112', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\146', '\116', '\040', '\146', '\157', '\040', '\061',
    '\012', '\144', '\121', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\165', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\152', '\102', '\040', '\151', '\152', '\040', '\061',
    '\012', '\154', '\120', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\155', '\161', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\146', '\115', '\040', '\155', '\145', '\040', '\061',
    '\012', '\153', '\167', '\107', '\040', '\153', '\141', '\040', '\061',
    '\012', '\145', '\141', '\131', '\040', '\141', '\156', '\040', '\061',
    '\012', '\126', '\155', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\146', '\123', '\040', '\163', '\172', '\040', '\061',
    '\012', '\106', '\155', '\171', '\040', '\155', '\145', '\040', '\061',
    '\012', '\163', '\161', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\113', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\121', '\144', '\166', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\152', '\132', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\162', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\170', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\170', '\110', '\040', '\142', '\145', '\040', '\061',
    '\012', '\152', '\122', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\152', '\104', '\040', '\143', '\150', '\040', '\061',
    '\012', '\123', '\170', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\123', '\170', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\162', '\132', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\155', '\110', '\040', '\155', '\145', '\040', '\061',
    '\012', '\144', '\146', '\110', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\112', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\155', '\167', '\132', '\040', '\155', '\145', '\040', '\061',
    '\012', '\166', '\122', '\155', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\167', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\130', '\161', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\107', '\166', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\172', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\156', '\113', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\150', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\116', '\154', '\163', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\142', '\126', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\124', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\170', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\165', '\160', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\101', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\113', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\154', '\104', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\124', '\154', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\161', '\162', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\170', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\120', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\166', '\132', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\110', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\151', '\130', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\113', '\147', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\112', '\171', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\166', '\106', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\164', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\102', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\147', '\117', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\152', '\116', '\040', '\151', '\152', '\040', '\061',
    '\012', '\104', '\152', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\172', '\111', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\104', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\112', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\101', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\106', '\163', '\152', '\040', '\163', '\164', '\040', '\061',
    '\012', '\171', '\104', '\146', '\040', '\156', '\171', '\040', '\061',
    '\012', '\170', '\152', '\126', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\144', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\167', '\107', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\154', '\127', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\131', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\172', '\117', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\161', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\172', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\155', '\107', '\040', '\155', '\145', '\040', '\061',
    '\012', '\113', '\144', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\126', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\164', '\105', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\112', '\171', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\152', '\127', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\167', '\122', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\126', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\115', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\161', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\154', '\121', '\040', '\154', '\145', '\040', '\061',
    '\012', '\142', '\170', '\121', '\040', '\142', '\145', '\040', '\061',
    '\012', '\150', '\112', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\156', '\131', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\146', '\123', '\040', '\156', '\171', '\040', '\061',
    '\012', '\115', '\144', '\167', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\132', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\163', '\112', '\040', '\163', '\164', '\040', '\061',
    '\012', '\121', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\170', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\101', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\112', '\167', '\040', '\154', '\145', '\040', '\061',
    '\012', '\153', '\167', '\112', '\040', '\153', '\141', '\040', '\061',
    '\012', '\163', '\170', '\103', '\040', '\163', '\164', '\040', '\061',
    '\012', '\150', '\112', '\162', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\107', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\143', '\143', '\106', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\107', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\123', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\161', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\153', '\126', '\040', '\153', '\141', '\040', '\061',
    '\012', '\147', '\126', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\161', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\112', '\160', '\040', '\153', '\141', '\040', '\061',
    '\012', '\127', '\154', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\112', '\167', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\105', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\162', '\114', '\040', '\145', '\162', '\040', '\061',
    '\012', '\164', '\161', '\105', '\040', '\164', '\150', '\040', '\061',
    '\012', '\145', '\112', '\172', '\040', '\145', '\162', '\040', '\061',
    '\012', '\127', '\150', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\127', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\121', '\172', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\143', '\106', '\040', '\143', '\150', '\040', '\061',
    '\012', '\126', '\155', '\170', '\040', '\155', '\145', '\040', '\061',
    '\012', '\144', '\166', '\103', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\152', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\153', '\106', '\040', '\153', '\141', '\040', '\061',
    '\012', '\143', '\166', '\117', '\040', '\143', '\150', '\040', '\061',
    '\012', '\121', '\171', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\116', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\156', '\112', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\152', '\125', '\040', '\151', '\152', '\040', '\061',
    '\012', '\131', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\114', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\162', '\126', '\172', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\117', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\170', '\114', '\040', '\146', '\157', '\040', '\061',
    '\012', '\163', '\156', '\127', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\127', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\167', '\147', '\113', '\040', '\156', '\147', '\040', '\061',
    '\012', '\141', '\124', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\145', '\126', '\146', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\132', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\165', '\126', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\152', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\167', '\124', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\123', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\156', '\116', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\146', '\106', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\143', '\127', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\124', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\141', '\112', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\172', '\131', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\152', '\130', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\115', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\142', '\164', '\102', '\040', '\163', '\164', '\040', '\061',
    '\012', '\172', '\146', '\105', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\170', '\117', '\040', '\142', '\145', '\040', '\061',
    '\012', '\167', '\120', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\147', '\113', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\172', '\127', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\143', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\161', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\115', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\132', '\152', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\164', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\153', '\131', '\040', '\153', '\141', '\040', '\061',
    '\012', '\154', '\103', '\142', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\160', '\117', '\040', '\144', '\145', '\040', '\061',
    '\012', '\155', '\130', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\166', '\127', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\146', '\117', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\147', '\171', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\153', '\104', '\040', '\144', '\145', '\040', '\061',
    '\012', '\146', '\121', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\111', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\132', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\113', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\126', '\160', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\104', '\155', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\116', '\167', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\153', '\131', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\160', '\112', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\130', '\151', '\040', '\161', '\165', '\040', '\061',
    '\012', '\102', '\156', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\146', '\113', '\040', '\146', '\157', '\040', '\061',
    '\012', '\146', '\103', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\120', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\121', '\156', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\160', '\127', '\040', '\160', '\162', '\040', '\061',
    '\012', '\165', '\167', '\112', '\040', '\161', '\165', '\040', '\061',
    '\012', '\120', '\166', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\143', '\156', '\103', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\166', '\101', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\107', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\132', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\142', '\123', '\040', '\153', '\141', '\040', '\061',
    '\012', '\123', '\167', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\150', '\166', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\161', '\107', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\114', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\152', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\125', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\154', '\104', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\132', '\154', '\160', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\167', '\121', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\154', '\116', '\040', '\154', '\145', '\040', '\061',
    '\012', '\146', '\124', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\116', '\160', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\142', '\115', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\116', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\145', '\146', '\126', '\040', '\145', '\162', '\040', '\061',
    '\012', '\141', '\103', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\141', '\127', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\114', '\161', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\172', '\124', '\040', '\163', '\172', '\040', '\061',
    '\012', '\112', '\152', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\166', '\113', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\167', '\124', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\130', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\107', '\155', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\166', '\123', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\104', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\122', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\131', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\121', '\166', '\040', '\151', '\156', '\040', '\061',
    '\012', '\146', '\153', '\110', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\143', '\117', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\116', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\155', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\172', '\122', '\040', '\163', '\172', '\040', '\061',
    '\012', '\104', '\146', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\125', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\161', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\130', '\153', '\040', '\163', '\164', '\040', '\061',
    '\012', '\130', '\171', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\127', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\142', '\114', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\131', '\144', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\161', '\126', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\161', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\157', '\130', '\040', '\157', '\156', '\040', '\061',
    '\012', '\172', '\165', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\125', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\147', '\103', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\102', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\121', '\160', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\156', '\105', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\132', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\153', '\104', '\040', '\153', '\141', '\040', '\061',
    '\012', '\163', '\126', '\153', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\171', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\102', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\103', '\152', '\171', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\120', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\104', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\170', '\102', '\040', '\144', '\145', '\040', '\061',
    '\012', '\104', '\153', '\155', '\040', '\153', '\141', '\040', '\061',
    '\012', '\153', '\120', '\160', '\040', '\153', '\141', '\040', '\061',
    '\012', '\150', '\127', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\102', '\152', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\111', '\172', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\110', '\156', '\153', '\040', '\141', '\156', '\040', '\061',
    '\012', '\162', '\121', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\112', '\167', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\142', '\120', '\040', '\142', '\145', '\040', '\061',
    '\012', '\146', '\162', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\101', '\157', '\166', '\040', '\157', '\156', '\040', '\061',
    '\012', '\171', '\161', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\146', '\131', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\163', '\110', '\040', '\163', '\164', '\040', '\061',
    '\012', '\172', '\170', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\142', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\115', '\152', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\122', '\160', '\040', '\156', '\147', '\040', '\061',
    '\012', '\107', '\166', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\155', '\172', '\106', '\040', '\163', '\172', '\040', '\061',
    '\012', '\157', '\161', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\152', '\125', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\155', '\121', '\040', '\155', '\145', '\040', '\061',
    '\012', '\150', '\117', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\167', '\130', '\040', '\160', '\162', '\040', '\061',
    '\012', '\172', '\147', '\113', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\114', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\161', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\120', '\155', '\040', '\144', '\145', '\040', '\061',
    '\012', '\164', '\103', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\162', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\127', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\162', '\104', '\146', '\040', '\145', '\162', '\040', '\061',
    '\012', '\131', '\156', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\156', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\106', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\160', '\125', '\040', '\145', '\162', '\040', '\061',
    '\012', '\160', '\120', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\152', '\115', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\155', '\131', '\040', '\151', '\152', '\040', '\061',
    '\012', '\103', '\160', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\104', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\165', '\161', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\120', '\152', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\106', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\164', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\143', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\160', '\117', '\040', '\160', '\162', '\040', '\061',
    '\012', '\160', '\147', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\146', '\117', '\040', '\153', '\141', '\040', '\061',
    '\012', '\164', '\132', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\110', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\122', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\104', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\120', '\155', '\040', '\154', '\145', '\040', '\061',
    '\012', '\163', '\166', '\120', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\153', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\116', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\113', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\161', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\121', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\164', '\170', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\160', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\151', '\121', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\166', '\120', '\040', '\166', '\141', '\040', '\061',
    '\012', '\151', '\107', '\146', '\040', '\151', '\156', '\040', '\061',
    '\012', '\164', '\152', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\127', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\121', '\161', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\151', '\106', '\040', '\164', '\151', '\040', '\061',
    '\012', '\132', '\172', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\141', '\131', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\152', '\101', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\167', '\122', '\040', '\153', '\141', '\040', '\061',
    '\012', '\147', '\153', '\115', '\040', '\156', '\147', '\040', '\061',
    '\012', '\103', '\152', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\147', '\115', '\040', '\156', '\147', '\040', '\061',
    '\012', '\122', '\170', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\142', '\103', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\131', '\160', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\171', '\105', '\040', '\167', '\141', '\040', '\061',
    '\012', '\151', '\171', '\102', '\040', '\151', '\156', '\040', '\061',
    '\012', '\150', '\121', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\160', '\121', '\040', '\151', '\156', '\040', '\061',
    '\012', '\125', '\143', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\153', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\162', '\113', '\040', '\145', '\162', '\040', '\061',
    '\012', '\110', '\160', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\156', '\116', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\167', '\102', '\040', '\151', '\152', '\040', '\061',
    '\012', '\132', '\144', '\155', '\040', '\144', '\145', '\040', '\061',
    '\012', '\155', '\131', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\121', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\167', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\110', '\170', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\161', '\104', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\130', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\144', '\117', '\040', '\156', '\147', '\040', '\061',
    '\012', '\141', '\105', '\157', '\040', '\141', '\156', '\040', '\061',
    '\012', '\124', '\167', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\141', '\166', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\154', '\150', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\172', '\126', '\040', '\154', '\145', '\040', '\061',
    '\012', '\142', '\110', '\146', '\040', '\142', '\145', '\040', '\061',
    '\012', '\142', '\112', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\125', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\106', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\116', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\102', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\144', '\122', '\142', '\040', '\144', '\145', '\040', '\061',
    '\012', '\156', '\154', '\124', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\162', '\117', '\040', '\145', '\162', '\040', '\061',
    '\012', '\154', '\172', '\127', '\040', '\154', '\145', '\040', '\061',
    '\012', '\146', '\131', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\155', '\122', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\162', '\130', '\171', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\171', '\122', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\107', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\125', '\167', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\153', '\130', '\155', '\040', '\153', '\141', '\040', '\061',
    '\012', '\150', '\112', '\171', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\147', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\131', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\171', '\131', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\170', '\172', '\103', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\152', '\102', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\172', '\111', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\162', '\117', '\040', '\145', '\162', '\040', '\061',
    '\012', '\164', '\161', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\167', '\115', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\103', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\152', '\114', '\040', '\154', '\145', '\040', '\061',
    '\012', '\166', '\156', '\132', '\040', '\141', '\156', '\040', '\061',
    '\012', '\145', '\104', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\166', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\146', '\114', '\040', '\160', '\162', '\040', '\061',
    '\012', '\151', '\122', '\142', '\040', '\151', '\156', '\040', '\061',
    '\012', '\147', '\144', '\122', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\101', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\156', '\114', '\040', '\141', '\156', '\040', '\061',
    '\012', '\155', '\153', '\124', '\040', '\153', '\141', '\040', '\061',
    '\012', '\160', '\126', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\113', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\116', '\153', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\114', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\116', '\160', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\155', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\126', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\146', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\161', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\104', '\156', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\107', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\163', '\110', '\144', '\040', '\163', '\164', '\040', '\061',
    '\012', '\160', '\167', '\106', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\120', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\104', '\162', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\112', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\121', '\160', '\040', '\163', '\164', '\040', '\061',
    '\012', '\111', '\167', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\165', '\103', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\167', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\162', '\106', '\167', '\040', '\145', '\162', '\040', '\061',
    '\012', '\163', '\112', '\160', '\040', '\163', '\164', '\040', '\061',
    '\012', '\170', '\151', '\111', '\040', '\151', '\156', '\040', '\061',
    '\012', '\122', '\161', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\153', '\121', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\116', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\131', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\126', '\155', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\154', '\131', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\157', '\120', '\167', '\040', '\157', '\156', '\040', '\061',
    '\012', '\153', '\152', '\117', '\040', '\151', '\152', '\040', '\061',
    '\012', '\155', '\113', '\142', '\040', '\155', '\145', '\040', '\061',
    '\012', '\146', '\104', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\146', '\106', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\126', '\150', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\146', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\113', '\152', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\124', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\102', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\110', '\164', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\116', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\121', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\141', '\123', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\167', '\170', '\040', '\151', '\152', '\040', '\061',
    '\012', '\125', '\171', '\170', '\040', '\156', '\171', '\040', '\061',
    '\012', '\167', '\126', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\111', '\157', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\116', '\150', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\125', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\102', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\107', '\161', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\103', '\143', '\167', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\132', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\142', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\106', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\163', '\132', '\166', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\172', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\104', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\143', '\146', '\122', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\172', '\120', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\161', '\117', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\172', '\110', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\123', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\170', '\112', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\142', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\130', '\146', '\040', '\163', '\164', '\040', '\061',
    '\012', '\171', '\142', '\124', '\040', '\142', '\145', '\040', '\061',
    '\012', '\163', '\110', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\124', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\120', '\147', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\113', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\120', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\124', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\152', '\123', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\106', '\147', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\113', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\145', '\125', '\152', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\104', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\106', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\156', '\127', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\125', '\171', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\147', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\165', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\171', '\121', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\103', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\122', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\130', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\107', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\130', '\156', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\120', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\146', '\132', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\126', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\167', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\104', '\172', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\146', '\107', '\040', '\146', '\157', '\040', '\061',
    '\012', '\146', '\130', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\147', '\126', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\112', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\130', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\147', '\107', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\165', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\170', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\170', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\116', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\157', '\102', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\147', '\166', '\040', '\156', '\147', '\040', '\061',
    '\012', '\110', '\167', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\157', '\141', '\127', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\122', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\130', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\172', '\121', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\143', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\102', '\156', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\166', '\102', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\121', '\155', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\166', '\125', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\150', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\170', '\122', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\164', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\153', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\112', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\167', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\123', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\171', '\122', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\156', '\103', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\107', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\147', '\124', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\116', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\157', '\110', '\153', '\040', '\157', '\156', '\040', '\061',
    '\012', '\127', '\172', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\166', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\153', '\130', '\040', '\163', '\164', '\040', '\061',
    '\012', '\166', '\131', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\157', '\132', '\040', '\157', '\156', '\040', '\061',
    '\012', '\156', '\107', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\155', '\115', '\040', '\161', '\165', '\040', '\061',
    '\012', '\102', '\155', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\163', '\126', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\165', '\103', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\151', '\130', '\172', '\040', '\151', '\156', '\040', '\061',
    '\012', '\166', '\113', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\154', '\105', '\167', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\150', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\167', '\123', '\040', '\151', '\156', '\040', '\061',
    '\012', '\161', '\171', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\152', '\131', '\040', '\151', '\152', '\040', '\061',
    '\012', '\131', '\147', '\155', '\040', '\156', '\147', '\040', '\061',
    '\012', '\167', '\112', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\145', '\121', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\131', '\146', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\127', '\160', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\144', '\123', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\155', '\107', '\040', '\166', '\141', '\040', '\061',
    '\012', '\155', '\144', '\124', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\162', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\161', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\102', '\160', '\040', '\160', '\157', '\040', '\061',
    '\012', '\146', '\153', '\132', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\145', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\107', '\163', '\040', '\143', '\150', '\040', '\061',
    '\012', '\105', '\161', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\146', '\117', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\123', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\104', '\150', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\152', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\161', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\121', '\146', '\040', '\156', '\171', '\040', '\061',
    '\012', '\156', '\160', '\131', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\104', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\155', '\121', '\040', '\155', '\145', '\040', '\061',
    '\012', '\153', '\115', '\142', '\040', '\153', '\141', '\040', '\061',
    '\012', '\141', '\161', '\103', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\131', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\153', '\104', '\040', '\153', '\141', '\040', '\061',
    '\012', '\143', '\127', '\163', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\171', '\112', '\040', '\156', '\171', '\040', '\061',
    '\012', '\167', '\166', '\126', '\040', '\166', '\141', '\040', '\061',
    '\012', '\154', '\131', '\142', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\162', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\152', '\103', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\113', '\171', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\152', '\104', '\040', '\151', '\152', '\040', '\061',
    '\012', '\163', '\104', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\113', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\172', '\163', '\124', '\040', '\163', '\164', '\040', '\061',
    '\012', '\152', '\131', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\131', '\167', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\152', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\111', '\171', '\040', '\167', '\141', '\040', '\061',
    '\012', '\146', '\146', '\125', '\040', '\146', '\157', '\040', '\061',
    '\012', '\127', '\156', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\145', '\110', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\127', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\116', '\167', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\171', '\123', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\146', '\103', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\130', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\162', '\111', '\040', '\156', '\147', '\040', '\061',
    '\012', '\157', '\126', '\146', '\040', '\157', '\156', '\040', '\061',
    '\012', '\126', '\146', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\152', '\147', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\110', '\152', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\161', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\171', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\143', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\163', '\105', '\040', '\163', '\164', '\040', '\061',
    '\012', '\160', '\103', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\153', '\167', '\120', '\040', '\153', '\141', '\040', '\061',
    '\012', '\152', '\146', '\121', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\132', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\126', '\170', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\112', '\166', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\163', '\105', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\114', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\117', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\160', '\123', '\040', '\160', '\162', '\040', '\061',
    '\012', '\171', '\111', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\164', '\107', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\110', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\107', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\166', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\116', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\161', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\146', '\113', '\040', '\163', '\164', '\040', '\061',
    '\012', '\144', '\131', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\163', '\115', '\155', '\040', '\163', '\164', '\040', '\061',
    '\012', '\157', '\102', '\170', '\040', '\157', '\156', '\040', '\061',
    '\012', '\161', '\163', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\155', '\111', '\040', '\155', '\145', '\040', '\061',
    '\012', '\164', '\155', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\154', '\127', '\040', '\154', '\145', '\040', '\061',
    '\012', '\124', '\167', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\163', '\162', '\126', '\040', '\145', '\162', '\040', '\061',
    '\012', '\162', '\116', '\172', '\040', '\145', '\162', '\040', '\061',
    '\012', '\125', '\165', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\107', '\152', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\156', '\152', '\131', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\117', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\155', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\106', '\156', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\166', '\131', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\107', '\146', '\040', '\160', '\162', '\040', '\061',
    '\012', '\154', '\110', '\160', '\040', '\141', '\154', '\040', '\061',
    '\012', '\161', '\147', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\142', '\123', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\121', '\151', '\040', '\151', '\156', '\040', '\061',
    '\012', '\164', '\161', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\167', '\111', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\153', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\170', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\150', '\104', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\121', '\145', '\040', '\161', '\165', '\040', '\061',
    '\012', '\151', '\112', '\160', '\040', '\151', '\156', '\040', '\061',
    '\012', '\170', '\162', '\116', '\040', '\145', '\162', '\040', '\061',
    '\012', '\144', '\107', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\153', '\121', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\112', '\161', '\147', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\115', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\152', '\124', '\040', '\154', '\145', '\040', '\061',
    '\012', '\130', '\153', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\164', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\116', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\165', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\157', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\152', '\122', '\040', '\144', '\145', '\040', '\061',
    '\012', '\155', '\106', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\152', '\172', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\152', '\122', '\040', '\163', '\172', '\040', '\061',
    '\012', '\116', '\156', '\154', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\112', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\132', '\162', '\040', '\156', '\147', '\040', '\061',
    '\012', '\102', '\167', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\144', '\127', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\167', '\115', '\040', '\154', '\145', '\040', '\061',
    '\012', '\111', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\167', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\115', '\167', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\152', '\131', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\102', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\151', '\167', '\106', '\040', '\151', '\156', '\040', '\061',
    '\012', '\162', '\110', '\172', '\040', '\145', '\162', '\040', '\061',
    '\012', '\123', '\161', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\157', '\113', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\152', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\164', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\113', '\170', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\161', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\131', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\102', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\155', '\112', '\040', '\156', '\147', '\040', '\061',
    '\012', '\145', '\131', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\107', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\121', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\156', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\142', '\166', '\112', '\040', '\166', '\141', '\040', '\061',
    '\012', '\163', '\170', '\115', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\116', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\154', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\153', '\161', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\144', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\150', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\154', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\161', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\142', '\104', '\040', '\142', '\145', '\040', '\061',
    '\012', '\170', '\101', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\160', '\114', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\110', '\142', '\040', '\154', '\145', '\040', '\061',
    '\012', '\170', '\126', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\150', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\170', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\126', '\146', '\040', '\144', '\145', '\040', '\061',
    '\012', '\132', '\153', '\155', '\040', '\153', '\141', '\040', '\061',
    '\012', '\153', '\160', '\104', '\040', '\153', '\141', '\040', '\061',
    '\012', '\160', '\152', '\110', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\107', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\151', '\171', '\120', '\040', '\151', '\156', '\040', '\061',
    '\012', '\167', '\155', '\113', '\040', '\155', '\145', '\040', '\061',
    '\012', '\155', '\112', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\155', '\114', '\040', '\155', '\145', '\040', '\061',
    '\012', '\143', '\102', '\166', '\040', '\143', '\150', '\040', '\061',
    '\012', '\126', '\166', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\105', '\161', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\150', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\103', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\157', '\127', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\172', '\130', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\111', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\120', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\131', '\155', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\150', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\161', '\116', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\155', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\130', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\154', '\132', '\152', '\040', '\154', '\145', '\040', '\061',
    '\012', '\123', '\170', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\113', '\161', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\127', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\143', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\166', '\102', '\040', '\160', '\157', '\040', '\061',
    '\012', '\164', '\147', '\122', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\162', '\116', '\040', '\145', '\162', '\040', '\061',
    '\012', '\170', '\121', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\130', '\166', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\154', '\112', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\146', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\106', '\166', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\125', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\154', '\132', '\142', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\144', '\111', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\157', '\111', '\040', '\157', '\156', '\040', '\061',
    '\012', '\171', '\113', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\167', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\112', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\170', '\115', '\040', '\166', '\141', '\040', '\061',
    '\012', '\126', '\172', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\152', '\122', '\040', '\151', '\152', '\040', '\061',
    '\012', '\113', '\155', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\161', '\111', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\171', '\104', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\142', '\125', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\153', '\132', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\126', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\106', '\150', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\112', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\120', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\145', '\157', '\040', '\145', '\162', '\040', '\061',
    '\012', '\172', '\130', '\144', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\106', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\112', '\171', '\040', '\151', '\152', '\040', '\061',
    '\012', '\116', '\163', '\152', '\040', '\163', '\164', '\040', '\061',
    '\012', '\154', '\115', '\142', '\040', '\154', '\145', '\040', '\061',
    '\012', '\171', '\121', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\156', '\115', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\122', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\106', '\152', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\113', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\161', '\126', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\103', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\163', '\117', '\172', '\040', '\163', '\164', '\040', '\061',
    '\012', '\150', '\154', '\117', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\142', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\152', '\116', '\040', '\163', '\164', '\040', '\061',
    '\012', '\125', '\152', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\126', '\155', '\040', '\145', '\162', '\040', '\061',
    '\012', '\127', '\152', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\142', '\155', '\115', '\040', '\155', '\145', '\040', '\061',
    '\012', '\126', '\172', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\150', '\132', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\106', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\150', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\116', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\142', '\124', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\155', '\112', '\040', '\155', '\145', '\040', '\061',
    '\012', '\106', '\143', '\163', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\124', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\123', '\147', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\155', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\106', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\144', '\111', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\154', '\113', '\040', '\154', '\145', '\040', '\061',
    '\012', '\142', '\156', '\102', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\171', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\126', '\152', '\153', '\040', '\151', '\152', '\040', '\061',
    '\012', '\150', '\172', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\147', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\161', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\116', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\124', '\152', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\154', '\126', '\040', '\154', '\145', '\040', '\061',
    '\012', '\162', '\126', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\114', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\171', '\144', '\121', '\040', '\144', '\145', '\040', '\061',
    '\012', '\147', '\131', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\150', '\105', '\040', '\164', '\150', '\040', '\061',
    '\012', '\107', '\163', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\127', '\172', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\164', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\110', '\172', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\111', '\157', '\040', '\150', '\157', '\040', '\061',
    '\012', '\153', '\146', '\103', '\040', '\153', '\141', '\040', '\061',
    '\012', '\172', '\102', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\112', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\145', '\111', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\165', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\142', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\112', '\152', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\154', '\130', '\153', '\040', '\154', '\145', '\040', '\061',
    '\012', '\124', '\146', '\170', '\040', '\146', '\157', '\040', '\061',
    '\012', '\172', '\114', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\161', '\124', '\040', '\161', '\165', '\040', '\061',
    '\012', '\157', '\132', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\146', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\150', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\153', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\105', '\152', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\167', '\116', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\121', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\104', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\120', '\167', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\172', '\164', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\164', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\162', '\130', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\167', '\124', '\040', '\166', '\141', '\040', '\061',
    '\012', '\171', '\122', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\121', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\130', '\172', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\146', '\114', '\040', '\143', '\150', '\040', '\061',
    '\012', '\106', '\167', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\162', '\116', '\167', '\040', '\145', '\162', '\040', '\061',
    '\012', '\102', '\150', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\154', '\132', '\040', '\156', '\147', '\040', '\061',
    '\012', '\147', '\143', '\104', '\040', '\143', '\150', '\040', '\061',
    '\012', '\123', '\146', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\125', '\172', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\124', '\144', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\144', '\122', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\131', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\143', '\104', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\143', '\103', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\102', '\170', '\040', '\154', '\145', '\040', '\061',
    '\012', '\147', '\110', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\112', '\171', '\040', '\167', '\141', '\040', '\061',
    '\012', '\171', '\162', '\117', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\161', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\131', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\152', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\114', '\153', '\040', '\151', '\152', '\040', '\061',
    '\012', '\110', '\166', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\160', '\156', '\123', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\143', '\124', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\106', '\153', '\040', '\163', '\164', '\040', '\061',
    '\012', '\144', '\143', '\117', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\120', '\167', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\116', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\107', '\144', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\144', '\154', '\120', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\114', '\170', '\040', '\152', '\157', '\040', '\061',
    '\012', '\152', '\132', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\167', '\124', '\040', '\167', '\141', '\040', '\061',
    '\012', '\164', '\107', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\150', '\123', '\040', '\164', '\150', '\040', '\061',
    '\012', '\130', '\164', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\156', '\127', '\040', '\157', '\156', '\040', '\061',
    '\012', '\160', '\153', '\112', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\111', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\132', '\170', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\156', '\117', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\167', '\110', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\152', '\123', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\144', '\114', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\142', '\116', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\153', '\117', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\161', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\172', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\121', '\142', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\106', '\161', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\127', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\156', '\170', '\115', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\160', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\124', '\164', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\163', '\110', '\040', '\163', '\164', '\040', '\061',
    '\012', '\146', '\152', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\111', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\153', '\131', '\040', '\153', '\141', '\040', '\061',
    '\012', '\106', '\161', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\157', '\107', '\153', '\040', '\157', '\156', '\040', '\061',
    '\012', '\110', '\156', '\143', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\120', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\154', '\127', '\040', '\154', '\145', '\040', '\061',
    '\012', '\165', '\122', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\107', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\131', '\166', '\040', '\151', '\152', '\040', '\061',
    '\012', '\113', '\160', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\121', '\157', '\040', '\156', '\147', '\040', '\061',
    '\012', '\113', '\167', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\152', '\116', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\144', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\107', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\114', '\142', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\122', '\162', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\166', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\150', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\132', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\104', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\120', '\152', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\147', '\106', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\103', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\127', '\167', '\040', '\157', '\167', '\040', '\061',
    '\012', '\155', '\112', '\160', '\040', '\155', '\145', '\040', '\061',
    '\012', '\146', '\130', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\165', '\131', '\160', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\110', '\153', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\144', '\120', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\106', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\162', '\107', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\147', '\104', '\040', '\156', '\147', '\040', '\061',
    '\012', '\146', '\163', '\107', '\040', '\163', '\164', '\040', '\061',
    '\012', '\126', '\147', '\142', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\101', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\164', '\132', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\154', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\124', '\155', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\147', '\171', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\170', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\125', '\170', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\151', '\126', '\162', '\040', '\151', '\156', '\040', '\061',
    '\012', '\172', '\161', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\116', '\142', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\104', '\150', '\144', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\117', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\151', '\102', '\144', '\040', '\151', '\156', '\040', '\061',
    '\012', '\143', '\161', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\121', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\142', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\121', '\153', '\163', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\120', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\146', '\111', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\132', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\160', '\104', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\156', '\112', '\152', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\143', '\160', '\040', '\143', '\150', '\040', '\061',
    '\012', '\164', '\127', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\170', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\166', '\120', '\171', '\040', '\166', '\141', '\040', '\061',
    '\012', '\144', '\170', '\113', '\040', '\144', '\145', '\040', '\061',
    '\012', '\157', '\120', '\166', '\040', '\157', '\156', '\040', '\061',
    '\012', '\162', '\152', '\116', '\040', '\145', '\162', '\040', '\061',
    '\012', '\157', '\121', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\167', '\110', '\040', '\166', '\141', '\040', '\061',
    '\012', '\121', '\150', '\160', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\163', '\125', '\040', '\163', '\164', '\040', '\061',
    '\012', '\153', '\107', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\152', '\127', '\040', '\151', '\152', '\040', '\061',
    '\012', '\120', '\167', '\170', '\040', '\167', '\141', '\040', '\061',
    '\012', '\102', '\142', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\117', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\160', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\142', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\160', '\115', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\155', '\102', '\040', '\151', '\152', '\040', '\061',
    '\012', '\116', '\161', '\152', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\131', '\144', '\040', '\163', '\172', '\040', '\061',
    '\012', '\131', '\142', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\143', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\147', '\120', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\171', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\102', '\150', '\161', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\107', '\170', '\040', '\156', '\171', '\040', '\061',
    '\012', '\161', '\170', '\114', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\146', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\155', '\142', '\126', '\040', '\155', '\145', '\040', '\061',
    '\012', '\160', '\153', '\131', '\040', '\153', '\141', '\040', '\061',
    '\012', '\143', '\127', '\154', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\102', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\117', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\107', '\160', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\120', '\160', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\163', '\130', '\040', '\163', '\164', '\040', '\061',
    '\012', '\166', '\164', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\103', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\157', '\131', '\040', '\157', '\156', '\040', '\061',
    '\012', '\160', '\167', '\121', '\040', '\160', '\162', '\040', '\061',
    '\012', '\171', '\107', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\161', '\164', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\162', '\132', '\040', '\141', '\156', '\040', '\061',
    '\012', '\145', '\126', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\116', '\162', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\164', '\101', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\110', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\147', '\163', '\121', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\154', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\114', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\152', '\103', '\040', '\163', '\172', '\040', '\061',
    '\012', '\152', '\166', '\131', '\040', '\151', '\152', '\040', '\061',
    '\012', '\164', '\111', '\152', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\166', '\114', '\040', '\166', '\141', '\040', '\061',
    '\012', '\110', '\150', '\147', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\115', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\170', '\115', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\164', '\131', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\126', '\160', '\040', '\166', '\141', '\040', '\061',
    '\012', '\131', '\156', '\142', '\040', '\141', '\156', '\040', '\061',
    '\012', '\166', '\155', '\130', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\152', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\121', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\121', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\116', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\146', '\131', '\040', '\163', '\172', '\040', '\061',
    '\012', '\170', '\152', '\123', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\102', '\155', '\040', '\151', '\152', '\040', '\061',
    '\012', '\152', '\160', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\112', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\113', '\156', '\172', '\040', '\141', '\156', '\040', '\061',
    '\012', '\147', '\107', '\146', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\132', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\107', '\161', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\161', '\155', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\127', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\107', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\163', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\150', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\150', '\110', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\170', '\123', '\040', '\156', '\171', '\040', '\061',
    '\012', '\162', '\170', '\113', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\116', '\143', '\040', '\164', '\150', '\040', '\061',
    '\012', '\126', '\167', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\141', '\116', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\121', '\172', '\166', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\121', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\152', '\172', '\110', '\040', '\163', '\172', '\040', '\061',
    '\012', '\122', '\166', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\160', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\130', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\150', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\154', '\142', '\040', '\154', '\145', '\040', '\061',
    '\012', '\142', '\156', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\156', '\152', '\113', '\040', '\141', '\156', '\040', '\061',
    '\012', '\112', '\152', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\164', '\112', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\167', '\130', '\040', '\151', '\156', '\040', '\061',
    '\012', '\156', '\126', '\144', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\172', '\101', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\167', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\124', '\163', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\161', '\115', '\040', '\164', '\150', '\040', '\061',
    '\012', '\122', '\156', '\161', '\040', '\141', '\156', '\040', '\061',
    '\012', '\162', '\104', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\116', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\165', '\161', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\113', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\111', '\161', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\170', '\110', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\127', '\167', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\147', '\115', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\127', '\146', '\040', '\156', '\171', '\040', '\061',
    '\012', '\166', '\143', '\117', '\040', '\143', '\150', '\040', '\061',
    '\012', '\107', '\153', '\155', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\122', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\115', '\143', '\040', '\156', '\144', '\040', '\061',
    '\012', '\132', '\150', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\154', '\110', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\125', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\110', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\103', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\121', '\146', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\153', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\155', '\131', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\143', '\125', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\124', '\146', '\040', '\151', '\152', '\040', '\061',
    '\012', '\162', '\152', '\106', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\170', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\167', '\116', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\114', '\147', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\106', '\144', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\112', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\143', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\130', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\167', '\167', '\121', '\040', '\167', '\141', '\040', '\061',
    '\012', '\145', '\166', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\106', '\143', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\103', '\171', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\160', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\101', '\170', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\172', '\107', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\142', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\166', '\146', '\131', '\040', '\166', '\141', '\040', '\061',
    '\012', '\157', '\130', '\144', '\040', '\157', '\156', '\040', '\061',
    '\012', '\167', '\101', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\142', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\167', '\155', '\122', '\040', '\155', '\145', '\040', '\061',
    '\012', '\162', '\172', '\116', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\143', '\102', '\040', '\143', '\150', '\040', '\061',
    '\012', '\102', '\167', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\147', '\123', '\040', '\156', '\147', '\040', '\061',
    '\012', '\144', '\121', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\153', '\112', '\167', '\040', '\153', '\141', '\040', '\061',
    '\012', '\142', '\147', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\160', '\132', '\163', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\146', '\101', '\040', '\167', '\141', '\040', '\061',
    '\012', '\152', '\155', '\130', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\116', '\160', '\040', '\144', '\145', '\040', '\061',
    '\012', '\126', '\170', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\122', '\166', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\167', '\132', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\167', '\147', '\101', '\040', '\156', '\147', '\040', '\061',
    '\012', '\127', '\162', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\112', '\143', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\154', '\152', '\127', '\040', '\154', '\145', '\040', '\061',
    '\012', '\161', '\120', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\147', '\152', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\125', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\155', '\111', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\110', '\160', '\171', '\040', '\160', '\162', '\040', '\061',
    '\012', '\115', '\160', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\142', '\153', '\117', '\040', '\153', '\141', '\040', '\061',
    '\012', '\101', '\166', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\166', '\113', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\102', '\146', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\131', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\105', '\147', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\170', '\110', '\040', '\167', '\141', '\040', '\061',
    '\012', '\172', '\110', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\166', '\101', '\040', '\163', '\164', '\040', '\061',
    '\012', '\172', '\143', '\120', '\040', '\143', '\150', '\040', '\061',
    '\012', '\102', '\170', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\150', '\123', '\166', '\040', '\164', '\150', '\040', '\061',
    '\012', '\114', '\170', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\150', '\102', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\127', '\153', '\040', '\143', '\150', '\040', '\061',
    '\012', '\170', '\102', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\167', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\153', '\112', '\040', '\153', '\141', '\040', '\061',
    '\012', '\157', '\116', '\152', '\040', '\157', '\156', '\040', '\061',
    '\012', '\125', '\147', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\132', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\146', '\120', '\040', '\146', '\157', '\040', '\061',
    '\012', '\142', '\131', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\170', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\143', '\111', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\150', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\166', '\120', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\125', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\170', '\103', '\040', '\155', '\145', '\040', '\061',
    '\012', '\172', '\120', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\116', '\161', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\146', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\127', '\147', '\160', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\147', '\104', '\040', '\156', '\147', '\040', '\061',
    '\012', '\121', '\146', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\143', '\127', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\170', '\171', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\160', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\167', '\162', '\104', '\040', '\145', '\162', '\040', '\061',
    '\012', '\142', '\105', '\157', '\040', '\157', '\156', '\040', '\061',
    '\012', '\142', '\172', '\126', '\040', '\163', '\172', '\040', '\061',
    '\012', '\146', '\167', '\123', '\040', '\167', '\141', '\040', '\061',
    '\012', '\155', '\114', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\115', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\166', '\106', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\172', '\146', '\124', '\040', '\163', '\172', '\040', '\061',
    '\012', '\156', '\122', '\153', '\040', '\141', '\156', '\040', '\061',
    '\012', '\153', '\112', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\122', '\155', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\156', '\161', '\122', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\160', '\117', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\110', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\124', '\153', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\152', '\107', '\040', '\163', '\164', '\040', '\061',
    '\012', '\161', '\141', '\124', '\040', '\141', '\156', '\040', '\061',
    '\012', '\120', '\161', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\154', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\172', '\127', '\040', '\163', '\172', '\040', '\061',
    '\012', '\171', '\106', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\102', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\170', '\117', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\166', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\131', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\103', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\152', '\153', '\040', '\151', '\152', '\040', '\061',
    '\012', '\146', '\102', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\113', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\115', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\122', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\153', '\125', '\040', '\153', '\141', '\040', '\061',
    '\012', '\142', '\125', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\131', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\120', '\144', '\170', '\040', '\144', '\145', '\040', '\061',
    '\012', '\157', '\107', '\166', '\040', '\157', '\156', '\040', '\061',
    '\012', '\152', '\114', '\171', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\165', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\143', '\160', '\040', '\143', '\150', '\040', '\061',
    '\012', '\157', '\107', '\170', '\040', '\157', '\156', '\040', '\061',
    '\012', '\166', '\107', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\112', '\144', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\151', '\152', '\110', '\040', '\151', '\156', '\040', '\061',
    '\012', '\155', '\154', '\130', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\116', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\153', '\103', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\150', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\162', '\115', '\166', '\040', '\145', '\162', '\040', '\061',
    '\012', '\102', '\147', '\160', '\040', '\156', '\147', '\040', '\061',
    '\012', '\142', '\106', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\127', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\130', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\127', '\143', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\142', '\111', '\040', '\144', '\145', '\040', '\061',
    '\012', '\142', '\107', '\170', '\040', '\142', '\145', '\040', '\061',
    '\012', '\145', '\170', '\121', '\040', '\145', '\162', '\040', '\061',
    '\012', '\152', '\127', '\152', '\040', '\152', '\157', '\040', '\061',
    '\012', '\160', '\121', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\152', '\143', '\110', '\040', '\143', '\150', '\040', '\061',
    '\012', '\161', '\117', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\164', '\114', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\162', '\103', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\102', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\154', '\172', '\040', '\154', '\145', '\040', '\061',
    '\012', '\156', '\110', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\110', '\146', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\130', '\160', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\125', '\170', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\113', '\163', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\127', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\156', '\161', '\132', '\040', '\141', '\156', '\040', '\061',
    '\012', '\103', '\170', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\112', '\170', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\127', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\103', '\142', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\161', '\161', '\120', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\150', '\125', '\040', '\164', '\150', '\040', '\061',
    '\012', '\125', '\146', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\125', '\170', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\112', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\156', '\166', '\121', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\150', '\106', '\040', '\164', '\150', '\040', '\061',
    '\012', '\103', '\166', '\142', '\040', '\166', '\141', '\040', '\061',
    '\012', '\141', '\120', '\146', '\040', '\141', '\156', '\040', '\061',
    '\012', '\112', '\170', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\104', '\167', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\111', '\170', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\153', '\146', '\123', '\040', '\153', '\141', '\040', '\061',
    '\012', '\162', '\132', '\155', '\040', '\145', '\162', '\040', '\061',
    '\012', '\146', '\155', '\105', '\040', '\155', '\145', '\040', '\061',
    '\012', '\163', '\114', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\155', '\122', '\040', '\155', '\145', '\040', '\061',
    '\012', '\165', '\103', '\163', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\106', '\155', '\040', '\153', '\141', '\040', '\061',
    '\012', '\113', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\121', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\123', '\146', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\146', '\147', '\125', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\166', '\124', '\040', '\166', '\141', '\040', '\061',
    '\012', '\155', '\121', '\145', '\040', '\145', '\162', '\040', '\061',
    '\012', '\107', '\142', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\164', '\142', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\121', '\153', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\111', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\124', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\121', '\147', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\131', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\161', '\120', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\117', '\141', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\116', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\112', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\172', '\110', '\142', '\040', '\163', '\172', '\040', '\061',
    '\012', '\153', '\102', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\144', '\105', '\040', '\144', '\145', '\040', '\061',
    '\012', '\167', '\120', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\154', '\126', '\166', '\040', '\154', '\145', '\040', '\061',
    '\012', '\155', '\120', '\167', '\040', '\155', '\145', '\040', '\061',
    '\012', '\122', '\155', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\157', '\105', '\040', '\157', '\156', '\040', '\061',
    '\012', '\150', '\156', '\112', '\040', '\164', '\150', '\040', '\061',
    '\012', '\165', '\166', '\105', '\040', '\161', '\165', '\040', '\061',
    '\012', '\127', '\157', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\165', '\143', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\156', '\155', '\104', '\040', '\141', '\156', '\040', '\061',
    '\012', '\160', '\143', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\104', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\144', '\147', '\111', '\040', '\156', '\147', '\040', '\061',
    '\012', '\166', '\126', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\164', '\104', '\150', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\110', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\150', '\153', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\170', '\124', '\040', '\160', '\162', '\040', '\061',
    '\012', '\170', '\131', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\124', '\160', '\040', '\145', '\162', '\040', '\061',
    '\012', '\125', '\142', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\114', '\154', '\155', '\040', '\154', '\145', '\040', '\061',
    '\012', '\171', '\152', '\132', '\040', '\151', '\152', '\040', '\061',
    '\012', '\121', '\163', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\143', '\146', '\115', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\142', '\107', '\040', '\142', '\145', '\040', '\061',
    '\012', '\112', '\146', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\155', '\127', '\142', '\040', '\155', '\145', '\040', '\061',
    '\012', '\152', '\104', '\160', '\040', '\151', '\152', '\040', '\061',
    '\012', '\154', '\127', '\172', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\130', '\171', '\040', '\143', '\150', '\040', '\061',
    '\012', '\157', '\121', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\165', '\143', '\132', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\166', '\116', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\166', '\113', '\040', '\143', '\150', '\040', '\061',
    '\012', '\172', '\104', '\153', '\040', '\163', '\172', '\040', '\061',
    '\012', '\142', '\114', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\144', '\104', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\150', '\150', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\155', '\113', '\040', '\166', '\141', '\040', '\061',
    '\012', '\150', '\114', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\161', '\127', '\040', '\161', '\165', '\040', '\061',
    '\012', '\102', '\146', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\101', '\143', '\152', '\040', '\143', '\150', '\040', '\061',
    '\012', '\144', '\143', '\107', '\040', '\143', '\150', '\040', '\061',
    '\012', '\171', '\112', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\155', '\146', '\123', '\040', '\155', '\145', '\040', '\061',
    '\012', '\144', '\162', '\114', '\040', '\145', '\162', '\040', '\061',
    '\012', '\161', '\171', '\113', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\121', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\162', '\114', '\040', '\145', '\162', '\040', '\061',
    '\012', '\143', '\143', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\160', '\130', '\040', '\160', '\162', '\040', '\061',
    '\012', '\132', '\172', '\146', '\040', '\163', '\172', '\040', '\061',
    '\012', '\163', '\156', '\125', '\040', '\141', '\156', '\040', '\061',
    '\012', '\161', '\105', '\167', '\040', '\161', '\165', '\040', '\061',
    '\012', '\164', '\121', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\155', '\120', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\112', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\160', '\125', '\040', '\166', '\141', '\040', '\061',
    '\012', '\166', '\172', '\115', '\040', '\163', '\172', '\040', '\061',
    '\012', '\165', '\132', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\171', '\167', '\125', '\040', '\167', '\141', '\040', '\061',
    '\012', '\122', '\152', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\150', '\113', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\102', '\146', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\167', '\165', '\121', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\166', '\115', '\040', '\166', '\141', '\040', '\061',
    '\012', '\171', '\151', '\127', '\040', '\151', '\156', '\040', '\061',
    '\012', '\150', '\161', '\103', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\125', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\154', '\102', '\144', '\040', '\154', '\145', '\040', '\061',
    '\012', '\132', '\170', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\167', '\160', '\127', '\040', '\160', '\162', '\040', '\061',
    '\012', '\162', '\110', '\155', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\150', '\121', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\115', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\166', '\127', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\106', '\144', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\107', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\104', '\150', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\152', '\122', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\166', '\104', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\166', '\104', '\040', '\161', '\165', '\040', '\061',
    '\012', '\130', '\155', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\103', '\152', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\153', '\153', '\130', '\040', '\153', '\141', '\040', '\061',
    '\012', '\161', '\153', '\106', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\127', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\115', '\163', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\116', '\166', '\040', '\141', '\156', '\040', '\061',
    '\012', '\110', '\172', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\162', '\131', '\040', '\145', '\162', '\040', '\061',
    '\012', '\150', '\147', '\102', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\167', '\102', '\040', '\160', '\162', '\040', '\061',
    '\012', '\112', '\170', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\166', '\143', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\163', '\131', '\167', '\040', '\163', '\164', '\040', '\061',
    '\012', '\124', '\161', '\170', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\112', '\146', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\172', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\121', '\171', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\166', '\126', '\040', '\166', '\141', '\040', '\061',
    '\012', '\130', '\171', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\146', '\152', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\131', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\102', '\170', '\040', '\160', '\162', '\040', '\061',
    '\012', '\152', '\166', '\122', '\040', '\151', '\152', '\040', '\061',
    '\012', '\147', '\142', '\110', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\147', '\110', '\040', '\156', '\147', '\040', '\061',
    '\012', '\150', '\142', '\126', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\167', '\125', '\040', '\154', '\145', '\040', '\061',
    '\012', '\164', '\112', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\111', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\126', '\152', '\154', '\040', '\154', '\145', '\040', '\061',
    '\012', '\104', '\147', '\155', '\040', '\156', '\147', '\040', '\061',
    '\012', '\156', '\166', '\122', '\040', '\141', '\156', '\040', '\061',
    '\012', '\171', '\122', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\117', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\105', '\143', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\132', '\162', '\146', '\040', '\145', '\162', '\040', '\061',
    '\012', '\155', '\170', '\104', '\040', '\155', '\145', '\040', '\061',
    '\012', '\111', '\161', '\146', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\102', '\152', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\124', '\163', '\040', '\164', '\150', '\040', '\061',
    '\012', '\154', '\161', '\102', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\103', '\166', '\040', '\153', '\141', '\040', '\061',
    '\012', '\156', '\126', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\152', '\107', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\147', '\121', '\040', '\143', '\150', '\040', '\061',
    '\012', '\120', '\160', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\112', '\143', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\150', '\120', '\040', '\164', '\150', '\040', '\061',
    '\012', '\163', '\114', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\170', '\131', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\121', '\160', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\163', '\146', '\105', '\040', '\163', '\164', '\040', '\061',
    '\012', '\167', '\170', '\122', '\040', '\167', '\141', '\040', '\061',
    '\012', '\160', '\106', '\160', '\040', '\160', '\162', '\040', '\061',
    '\012', '\131', '\155', '\146', '\040', '\155', '\145', '\040', '\061',
    '\012', '\112', '\147', '\171', '\040', '\156', '\147', '\040', '\061',
    '\012', '\171', '\166', '\111', '\040', '\166', '\141', '\040', '\061',
    '\012', '\116', '\143', '\172', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\102', '\146', '\040', '\167', '\141', '\040', '\061',
    '\012', '\162', '\126', '\170', '\040', '\145', '\162', '\040', '\061',
    '\012', '\152', '\166', '\130', '\040', '\151', '\152', '\040', '\061',
    '\012', '\156', '\131', '\160', '\040', '\141', '\156', '\040', '\061',
    '\012', '\156', '\116', '\142', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\121', '\151', '\040', '\143', '\150', '\040', '\061',
    '\012', '\121', '\167', '\171', '\040', '\167', '\141', '\040', '\061',
    '\012', '\166', '\120', '\146', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\166', '\144', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\153', '\104', '\040', '\164', '\150', '\040', '\061',
    '\012', '\127', '\155', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\144', '\131', '\040', '\156', '\147', '\040', '\061',
    '\012', '\113', '\152', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\161', '\163', '\116', '\040', '\161', '\165', '\040', '\061',
    '\012', '\166', '\112', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\155', '\104', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\166', '\106', '\040', '\153', '\141', '\040', '\061',
    '\012', '\153', '\127', '\170', '\040', '\153', '\141', '\040', '\061',
    '\012', '\170', '\131', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\115', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\155', '\131', '\171', '\040', '\155', '\145', '\040', '\061',
    '\012', '\110', '\170', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\142', '\115', '\040', '\160', '\162', '\040', '\061',
    '\012', '\110', '\167', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\155', '\127', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\172', '\116', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\121', '\152', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\141', '\161', '\104', '\040', '\141', '\156', '\040', '\061',
    '\012', '\107', '\143', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\142', '\164', '\130', '\040', '\164', '\150', '\040', '\061',
    '\012', '\132', '\161', '\154', '\040', '\161', '\165', '\040', '\061',
    '\012', '\125', '\152', '\167', '\040', '\151', '\152', '\040', '\061',
    '\012', '\171', '\166', '\115', '\040', '\166', '\141', '\040', '\061',
    '\012', '\110', '\150', '\167', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\127', '\144', '\040', '\163', '\172', '\040', '\061',
    '\012', '\160', '\131', '\152', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\127', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\154', '\117', '\040', '\154', '\145', '\040', '\061',
    '\012', '\143', '\156', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\143', '\115', '\146', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\113', '\142', '\040', '\160', '\162', '\040', '\061',
    '\012', '\167', '\157', '\126', '\040', '\157', '\156', '\040', '\061',
    '\012', '\146', '\172', '\107', '\040', '\163', '\172', '\040', '\061',
    '\012', '\114', '\161', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\117', '\152', '\040', '\145', '\162', '\040', '\061',
    '\012', '\107', '\164', '\142', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\154', '\130', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\144', '\103', '\040', '\144', '\145', '\040', '\061',
    '\012', '\143', '\146', '\161', '\040', '\143', '\150', '\040', '\061',
    '\012', '\150', '\113', '\153', '\040', '\164', '\150', '\040', '\061',
    '\012', '\143', '\112', '\151', '\040', '\143', '\150', '\040', '\061',
    '\012', '\165', '\123', '\142', '\040', '\161', '\165', '\040', '\061',
    '\012', '\152', '\147', '\124', '\040', '\156', '\147', '\040', '\061',
    '\012', '\164', '\143', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\116', '\166', '\040', '\161', '\165', '\040', '\061',
    '\012', '\146', '\160', '\102', '\040', '\160', '\162', '\040', '\061',
    '\012', '\166', '\120', '\167', '\040', '\166', '\141', '\040', '\061',
    '\012', '\152', '\155', '\101', '\040', '\151', '\152', '\040', '\061',
    '\012', '\144', '\170', '\111', '\040', '\144', '\145', '\040', '\061',
    '\012', '\152', '\107', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\102', '\166', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\162', '\103', '\040', '\161', '\165', '\040', '\061',
    '\012', '\156', '\120', '\170', '\040', '\141', '\156', '\040', '\061',
    '\012', '\121', '\155', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\143', '\161', '\103', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\106', '\150', '\040', '\164', '\150', '\040', '\061',
    '\012', '\112', '\164', '\146', '\040', '\164', '\150', '\040', '\061',
    '\012', '\103', '\161', '\172', '\040', '\161', '\165', '\040', '\061',
    '\012', '\162', '\103', '\144', '\040', '\145', '\162', '\040', '\061',
    '\012', '\132', '\155', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\144', '\126', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\107', '\167', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\143', '\167', '\120', '\040', '\143', '\150', '\040', '\061',
    '\012', '\167', '\126', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\144', '\116', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\152', '\130', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\115', '\142', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\167', '\166', '\107', '\040', '\166', '\145', '\040', '\061',
    '\012', '\126', '\160', '\167', '\040', '\160', '\162', '\040', '\061',
    '\012', '\171', '\130', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\154', '\113', '\040', '\164', '\150', '\040', '\061',
    '\012', '\160', '\131', '\166', '\040', '\166', '\141', '\040', '\061',
    '\012', '\106', '\142', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\143', '\126', '\040', '\143', '\150', '\040', '\061',
    '\012', '\162', '\121', '\153', '\040', '\145', '\162', '\040', '\061',
    '\012', '\167', '\164', '\116', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\145', '\111', '\040', '\161', '\165', '\040', '\061',
    '\012', '\145', '\107', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\153', '\115', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\153', '\161', '\123', '\040', '\161', '\165', '\040', '\061',
    '\012', '\143', '\161', '\144', '\040', '\143', '\150', '\040', '\061',
    '\012', '\160', '\114', '\146', '\040', '\160', '\157', '\040', '\061',
    '\012', '\170', '\166', '\117', '\040', '\166', '\141', '\040', '\061',
    '\012', '\162', '\146', '\110', '\040', '\145', '\162', '\040', '\061',
    '\012', '\147', '\111', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\120', '\161', '\153', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\103', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\144', '\126', '\163', '\040', '\163', '\164', '\040', '\061',
    '\012', '\151', '\161', '\131', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\163', '\112', '\040', '\163', '\164', '\040', '\061',
    '\012', '\126', '\167', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\132', '\156', '\155', '\040', '\141', '\156', '\040', '\061',
    '\012', '\131', '\162', '\172', '\040', '\145', '\162', '\040', '\061',
    '\012', '\122', '\166', '\172', '\040', '\163', '\172', '\040', '\061',
    '\012', '\144', '\172', '\113', '\040', '\144', '\145', '\040', '\061',
    '\012', '\172', '\142', '\127', '\040', '\163', '\172', '\040', '\061',
    '\012', '\164', '\153', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\170', '\153', '\120', '\040', '\153', '\141', '\040', '\061',
    '\012', '\153', '\172', '\123', '\040', '\163', '\172', '\040', '\061',
    '\012', '\147', '\130', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\170', '\146', '\040', '\146', '\157', '\040', '\061',
    '\012', '\106', '\167', '\162', '\040', '\145', '\162', '\040', '\061',
    '\012', '\154', '\110', '\163', '\040', '\154', '\145', '\040', '\061',
    '\012', '\172', '\162', '\102', '\040', '\145', '\162', '\040', '\061',
    '\012', '\152', '\116', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\110', '\170', '\171', '\040', '\156', '\171', '\040', '\061',
    '\012', '\107', '\146', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\105', '\147', '\167', '\040', '\156', '\147', '\040', '\061',
    '\012', '\112', '\170', '\167', '\040', '\167', '\141', '\040', '\061',
    '\012', '\164', '\126', '\155', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\167', '\121', '\040', '\167', '\141', '\040', '\061',
    '\012', '\147', '\111', '\170', '\040', '\156', '\147', '\040', '\061',
    '\012', '\127', '\161', '\165', '\040', '\165', '\156', '\040', '\061',
    '\012', '\152', '\166', '\111', '\040', '\151', '\152', '\040', '\061',
    '\012', '\143', '\107', '\143', '\040', '\143', '\150', '\040', '\061',
    '\012', '\153', '\123', '\142', '\040', '\153', '\141', '\040', '\061',
    '\012', '\150', '\170', '\107', '\040', '\164', '\150', '\040', '\061',
    '\012', '\172', '\110', '\155', '\040', '\163', '\172', '\040', '\061',
    '\012', '\112', '\160', '\153', '\040', '\153', '\141', '\040', '\061',
    '\012', '\146', '\126', '\142', '\040', '\142', '\145', '\040', '\061',
    '\012', '\125', '\153', '\146', '\040', '\153', '\141', '\040', '\061',
    '\012', '\162', '\170', '\106', '\040', '\145', '\162', '\040', '\061',
    '\012', '\144', '\126', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\163', '\144', '\130', '\040', '\163', '\164', '\040', '\061',
    '\012', '\155', '\152', '\115', '\040', '\151', '\152', '\040', '\061',
    '\012', '\170', '\167', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\117', '\147', '\153', '\040', '\156', '\147', '\040', '\061',
    '\012', '\161', '\150', '\162', '\040', '\164', '\150', '\040', '\061',
    '\012', '\166', '\146', '\101', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\142', '\101', '\040', '\161', '\165', '\040', '\061',
    '\012', '\114', '\146', '\165', '\040', '\161', '\165', '\040', '\061',
    '\012', '\150', '\172', '\131', '\040', '\164', '\150', '\040', '\061',
    '\012', '\151', '\110', '\146', '\040', '\151', '\156', '\040', '\061',
    '\012', '\152', '\170', '\142', '\040', '\151', '\152', '\040', '\061',
    '\012', '\166', '\155', '\120', '\040', '\166', '\141', '\040', '\061',
    '\012', '\142', '\166', '\111', '\040', '\166', '\141', '\040', '\061',
    '\012', '\146', '\155', '\110', '\040', '\155', '\145', '\040', '\061',
    '\012', '\161', '\164', '\170', '\040', '\164', '\150', '\040', '\061',
    '\012', '\142', '\166', '\121', '\040', '\166', '\141', '\040', '\061',
    '\012', '\161', '\172', '\130', '\040', '\161', '\165', '\040', '\061',
    '\012', '\142', '\126', '\156', '\040', '\141', '\156', '\040', '\061',
    '\012', '\130', '\155', '\164', '\040', '\164', '\150', '\040', '\061',
    '\012', '\161', '\130', '\157', '\040', '\161', '\165', '\040', '\061',
    '\012', '\160', '\146', '\104', '\040', '\160', '\162', '\040', '\061',
    '\012', '\146', '\103', '\144', '\040', '\144', '\145', '\040', '\061',
    '\012', '\166', '\142', '\170', '\040', '\166', '\141', '\040', '\061',
    '\012', '\132', '\150', '\172', '\040', '\164', '\150', '\040', '\061',
    '\012', '\113', '\167', '\147', '\040', '\156', '\147', '\040', '\061',
    '\012', '\162', '\143', '\112', '\040', '\143', '\150', '\040', '\061',
    '\012', '\152', '\154', '\124', '\040', '\154', '\145', '\040', '\061',
    '\012', '\152', '\172', '\115', '\040', '\163', '\172', '\040', '\061',
    '\012', '\162', '\160', '\120', '\040', '\145', '\162', '\040', '\061',
    '\012', '\164', '\155', '\101', '\040', '\164', '\150', '\040', '\061',
    '\012', '\141', '\131', '\167', '\040', '\141', '\156', '\040', '\061',
    '\012', '\172', '\102', '\161', '\040', '\161', '\165', '\040', '\061',
    '\012', '\170', '\150', '\124', '\040', '\164', '\150', '\040', '\061',
    '\012', '\171', '\114', '\161', '\040', '\161', 