<TeXmacs|1.0.7.3>

<style|tmdoc>

<\body>
  <tmdoc-title|Styles bibliographiques pour <TeXmacs>>

  <section|Styles bibliographiques>

  Il est possible d'associer  une bibliographie BibTeX un ou plusieurs
  styles, qu'ils soient standards ou personnaliss. Les styles BibTeX sont
  dnots par leur nom usuel. Les styles personnaliss propres  <TeXmacs>
  sont systmatiquement prfixs par <verbatim|tm-> (par exemple, le syle
  <verbatim|tm-plain> correspond au style <verbatim|plain> de <TeXmacs>).
  D'autres styles peuvent tre ajouts dans le rpertoire
  <verbatim|$TEXMACS_PATH\\prog\\bibtex>.

  Pour l'diteur, chaque style correspond  un fichier <verbatim|.scm>. Les
  fichiers correspondant  chaque style sont traits comme des programmes
  Scheme ordinaire : il est ncessaire de respecter scrupuleusement
  l'utilisation des fonctions spcifiques aux styles bibliographiques.

  <section|Styles BibTeX>

  Actuellement, les styles BibTeX suivants ont t implments :
  <verbatim|abbrv>, <verbatim|alpha>, <verbatim|ieeetr>, <verbatim|plain> et
  <verbatim|siam>. Leur utilisation ne ncessite pas l'installation de
  BibTeX.

  <section|Cration de styles bibliographiques>

  Si les fichiers de style standards de <TeXmacs> ne sont pas adapts  vos
  besoins, vous pouvez en crer d'autres. Nanmoins, la cration d'un fichier
  de style  partir de rien est une tche complexe. Nous vous recommandons
  donc de vous servir des fichiers de style ou des modules existants ou de
  les personnaliser.

  <subsection|tude d'un exemple>

  Un fichier de style bibliographique est un<with|font-shape|italic|> fichier
  plac dans le rpertoire <verbatim|$TEXMACS_PATH/prog/bibtex> portant le
  nom du style suivi de l'extension <verbatim|.scm>, par exemple
  <verbatim|example.scm> pour un style <verbatim|example> ; ce dernier sera
  dnot par <verbatim|tm-example> lors de son utilisation dans un document
  <TeXmacs>.

  Tout fichier de style doit se dclarer en tant que module  l'aide de la
  dclaration suivante :

  <\scm-fragment>
    (texmacs-module (bibtex example)

    \ \ (:use (bibtex bib-utils)))
  </scm-fragment>

  Le module <verbatim|bib-utils> contient toutes les fonctions ncessaires 
  la rdation et  l'interprtation d'un fichier de style bibliographique.

  Tout fichier de style doit se dclarer en tant que style bibliographique 
  l'aide de la commande suivante :

  <scm-fragment|(bib-define-style "example" "plain")>

  Le premier paramtre de la fonction <scm|bib-define-style> est le nom du
  style courant, et le second paramtre est le nom du style par dfaut,
  <verbatim|plain> dans notre cas. Si une fonction n'est pas dfinie dans le
  style courant, la version du style par dfaut est alors utilise
  automatiquement.

  Ainsi, notre fichier de style minimal a l'aspect suivant :

  <\scm-fragment>
    (texmacs-module (bibtex example)

    \ \ (:use (bibtex bib-utils)))

    \;

    (bib-define-style "example" "plain")
  </scm-fragment>

  Chaque fonction de formatage dfinie dans le style par dfaut peut tre
  surcharge dans le fichier de style courant. Par exemple, la fonction de
  formatage de la date dans le style <verbatim|plain> s'appelle
  <scm|bib-format-date> ; elle redfinissable dans notre style de la manire
  suivante :

  <\scm-fragment>
    (tm-define (bib-format-date e)

    \ \ (:mode bib-example?)

    \ \ (bib-format-field e "year"))
  </scm-fragment>

  Toute fonction exporte doit tre prfixe par <verbatim|bib->. Une
  fonction surcharge doit tre suivie de la directive <scm|(:mode
  bib-example?)>, dans laquelle <verbatim|example> est le nom du style en
  cours.

  Voici maintenant  quoi ressemble notre fichier de style
  <verbatim|example.scm> :

  <\scm-fragment>
    (texmacs-module (bibtex example)

    \ \ (:use (bibtex bib-utils)))

    \;

    (bib-define-style "example" "plain")

    \;

    (tm-define (bib-format-date e)

    \ \ (:mode bib-example?)

    \ \ (bib-format-field e "year"))
  </scm-fragment>

  <subsection|Fonctions utiles pour la cration de fichiers de style>

  <\explain>
    <scm|(bib-abbreviate name dot spc)><explain-synopsis|abbrviation d'un
    nom>
  <|explain>
    Cette fonction cre un arbre <TeXmacs> correspondant  l'abbrviation du
    nom contenu dans <scm|name> (un arbre <TeXmacs>) : on rcupre la liste
    des premires lettres de chaque mot, suivi de <scm|dot> (un arbre
    <TeXmacs>) et spares par <scm|spc> (un arbre <TeXmacs>).
  </explain>

  <\explain>
    <scm|(bib-add-period tm)><explain-synopsis|ajout d'un point>
  <|explain>
    Cette fonction cre un arbre <TeXmacs> en ajoutant un point  la fin de
    l'arbre <TeXmacs> <scm|tm>.
  </explain>

  <\explain>
    <scm|(bib-default tm)><explain-synopsis|arbre <TeXmacs> par dfaut>
  <|explain>
    Cette fonction cre un arbre <TeXmacs> sans occurence du label
    <verbatim|keepkase>.
  </explain>

  <\explain>
    <scm|(bib-define-style name default)><explain-synopsis|dclaration d'un
    style>
  <|explain>
    Cette fonction dclare un style nomm <scm|name> (de type string) avec
    <scm|default> (de type string) le style par dfaut. Le style est alors
    slectionn en choisissant <verbatim|tm-><scm|name> lors de l'ajout d'une
    bibliographie  un document. Quand une fonction de formatage n'est pas
    dfinie dans le style, celle du style <scm|default> est value en
    remplacement.
  </explain>

  <\explain>
    <scm|(bib-emphasize tm)><explain-synopsis|mise en italique>
  <|explain>
    Cette fonction renvoie un arbre <TeXmacs> correspondant  la mise en
    italique de l'abre <TeXmacs> <scm|tm>.
  </explain>

  <\explain>
    <scm|(bib-empty? entry field)><explain-synopsis|test  zro d'un champ>
  <|explain>
    Cette fonction renvoie le boolen <scm|#t> si le champ de l'entre
    <scm|entry> dont le nom est <scm|field> (de type string) est vide ou
    inexistant ; elle renvoie <scm|#f> dans le cas contraire.
  </explain>

  <\explain>
    <scm|(bib-field entry field)><explain-synopsis|rcupration d'un champ>
  <|explain>
    Cette fonction cre un arbre <TeXmacs> correspondant au contenu du champ
    de l'entre <scm|entry> dont le nom est <scm|field> (de type string),
    sans aucun formatage. Dans certains cas, une donne spcifique est
    renvoye :

    <\itemize-dot>
      <item>si <scm|field> est gal  <scm|"author"> ou <scm|"editor">, la
      donne renvoye est un arbre dont le label est <verbatim|bib-names>,
      contenant une liste de noms d'auteurs ; chaque nom d'auteur est un
      arbre dont le label est <verbatim|bib-name> et qui contient quatre
      lments, dans l'ordre : le prnom, la particule, le nom et un
      qualificatif (junior ou senior).

      <item>si <scm|field> est gal  <scm|"page">, la donne contient une
      liste d'entiers : soit une liste vide, soit un singleton contenant la
      page rfrence, soit un couple dnotant l'intervalle des pages
      rfrences.
    </itemize-dot>
  </explain>

  <\explain>
    <scm|(bib-format-field entry field)><explain-synopsis|formatage basique
    d'un champ>
  <|explain>
    Cette fonction cre un arbre <TeXmacs> correspondant au contenu du champ
    de l'entre <scm|entry> dont le nom est <scm|field> (de type string),
    avec un formatage basique.
  </explain>

  <\explain>
    <scm|(bib-format-field-Locase entry field)><explain-synopsis|formatage
    spcial d'un champ>
  <|explain>
    Cette fonction est similaire  la fonction <scm|bib-format-entry> ; mais
    le champ est format en minuscules, avec une majuscule en tte.
  </explain>

  <\explain>
    <scm|(bib-locase tm)><explain-synopsis|mise en minucule>
  <|explain>
    Cette fonction cre un arbre <TeXmacs> en mettant en minuscule toutes les
    lettres de l'arbre <TeXmacs> <scm|tm>, sauf celles englobes dans un bloc
    <verbatim|keepkase>.
  </explain>

  <\explain>
    <scm|(bib-new-block tm)><explain-synopsis|nouveau bloc>
  <|explain>
    Cette fonction cre un arbre <TeXmacs> consistant en un bloc contenant
    l'arbre <TeXmacs> <scm|tm>.
  </explain>

  <\explain>
    <scm|(bib-new-list sep ltm)><explain-synopsis|liste spare>
  <|explain>
    Cette fonction cre un arbre <TeXmacs> en concatnant tous les lments
    de la liste <scm|ltm> (ses lments sont des arbres <TeXmacs>) en les
    sparant par l'arbre <TeXmacs> <scm|sep>.
  </explain>

  <\explain>
    <scm|(bib-new-list-spc ltm)><explain-synopsis|liste spare par des
    blancs>
  <|explain>
    Cette fonction est quivalente  l'appel de <scm|(bib-new-list " " ltm)>.
  </explain>

  <\explain>
    <scm|(bib-new-sentence ltm)><explain-synopsis|nouvelle phrase>
  <|explain>
    Cette fonction cre un arbre <TeXmacs> correspondant  une phrase
    correctement ponctue, contenant tous les lments de la liste <scm|ltm>
    (ses lments sont des arbres <TeXmacs>) spars par des virgules.
  </explain>

  <\explain>
    <scm|(bib-null? v)><explain-synopsis|test  zro>
  <|explain>
    Cette fonction renvoie le boolen <scm|#t> si la valeur <scm|v> est vide
    (<with|font-shape|italic|i.e.> la donne vide correspondant  son type,
    comme la liste vide pour le type list) ; elle renvoie <scm|#f> dans le
    cas contraire.
  </explain>

  <\explain>
    <scm|(bib-prefix tm nbcar)><explain-synopsis|prfix d'un arbre <TeXmacs>>
  <|explain>
    Cette fonction renvoie une chane de caractres contenant les <scm|nbcar>
    premiers caractres de l'arbre <TeXmacs> <scm|tm>.
  </explain>

  <\explain>
    <scm|(bib-purify tm)><explain-synopsis|applatissement d'un arbre
    <TeXmacs>>
  <|explain>
    Cette fonction cre une chane de caractres  partir des suites de
    lettres de l'arbre <TeXmacs> <scm|tm>.
  </explain>

  <\explain>
    <scm|(bib-simplify tm)><explain-synopsis|simplification d'un arbre
    <TeXmacs>>
  <|explain>
    Cette fonction renvoie un arbre <TeXmacs> correspondant  la
    simplification de l'abre <TeXmacs> <scm|tm>, c'est--dire la
    concatnation des chanes de caractres adjacentes, l'limination des
    nuds inutiles, etc.
  </explain>

  <\explain>
    <scm|(bib-text-length tm)><explain-synopsis|longueur d'un arbre
    <TeXmacs>>
  <|explain>
    Cette fonction renvoie le nombre de caractres de l'arbre <TeXmacs>
    <scm|tm>.
  </explain>

  <\explain>
    <scm|(bib-translate msg)><explain-synopsis|traduction>
  <|explain>
    Cette fonction traduit le message <scm|msg> (de type string) de l'anglais
    vers la langue du document en cours d'dition.
  </explain>

  <\explain>
    <scm|(bib-upcase tm)><explain-synopsis|mise en majuscule>
  <|explain>
    Cette fonction cre un arbre <TeXmacs> en mettant en majuscule toutes les
    lettres de l'arbre <TeXmacs> <scm|tm>, sauf celles englobes dans un bloc
    <verbatim|keepkase>.
  </explain>

  <\explain>
    <scm|(bib-upcase-first tm)><explain-synopsis|majuscule en tte>
  <|explain>
    Cette fonction cre un arbre <TeXmacs> en mettant en majuscule la
    premire lettre de l'arbre <TeXmacs> <scm|tm>, sauf si elle est englobe
    dans un bloc <verbatim|keepkase>.
  </explain>

  <\explain>
    <scm|(bib-with-style style expr)><explain-synopsis|style local>
  <|explain>
    Cette fonction excute l'expression <scm|expr> comme si le style en cours
    tait <scm|style> (de type string).
  </explain>
</body>

<\initial>
  <\collection>
    <associate|language|french>
    <associate|preamble|false>
  </collection>
</initial>