[comment {-*- tcl -*- doctools manpage}]
[manpage_begin Plotchart n 2.3.5]
[copyright {2013 Arjen Markus <arjenmarkus@users.sourceforge.net>}]
[moddesc   Plotchart]
[titledesc {Simple plotting and charting package}]
[require Tcl [opt 8.5]]
[require Tk [opt 8.5]]
[require Plotchart [opt 2.4.0]]

[description]
[para]

Plotchart is a Tcl-only package that focuses on the easy creation of
xy-plots, barcharts and other common types of graphical presentations.
The emphasis is on ease of use, rather than flexibility. The procedures
that create a plot use the entire canvas window, making the layout
of the plot completely automatic.

[para]

This results in the creation of an xy-plot in, say, ten lines of code:

[para]
[example {
    package require Plotchart

    canvas .c -background white -width 400 -height 200
    pack   .c -fill both

    #
    # Create the plot with its x- and y-axes
    #
    set s [::Plotchart::createXYPlot .c {0.0 100.0 10.0} {0.0 100.0 20.0}]

    foreach {x y} {0.0 32.0 10.0 50.0 25.0 60.0 78.0 11.0 } {
        $s plot series1 $x $y
    }

    $s title "Data series"
}]
[para]

A drawback of the package might be that it does not do any data
management. So if the canvas that holds the plot is to be resized, the
whole plot must be redrawn.

The advantage, though, is that it offers a number of plot and chart
types:

[list_begin itemized]

[item]
XY-plots like the one shown above with any number of data series.

[item]
Stripcharts, a kind of XY-plots where the horizontal axis is adjusted
automatically. The result is a kind of sliding window on the data
series.

[item]
Polar plots, where the coordinates are polar instead of cartesian.

[item]
Histograms, for plotting statistical information.

[item]
Barcharts, piecharts, Gantt charts, time charts.

[item]

Isometric plots, where the scale of the coordinates in the two
directions is always the same, i.e. a circle in world coordinates
appears as a circle on the screen.

[para]

You can zoom in and out, as well as pan with these plots ([emph Note:]
this works best if no axes are drawn, the zooming and panning routines
do not distinguish the axes), using the mouse buttons with the control
key and the arrow keys with the control key.

[item]
Piecharts, with automatic scaling to indicate the proportions.

[item]
Barcharts, with either vertical or horizontal bars, stacked bars or
bars side by side.

[item]
Timecharts, where bars indicate a time period and milestones or other
important moments in time are represented by triangles.

[item]
3D plots (both for displaying surfaces and 3D bars)
[list_end]

With version 1.5 a new command has been introduced: plotconfig, which
can be used to configure the plot options for particular types of plots
and charts (cf. [sectref "CONFIGURATION OPTIONS AND OTHER COMMANDS"])

With version 1.8.3 several new features were introduced, which allow more interactivity
(cf. [sectref "INTERACTIVE USE"])

With version 2.0 it has become possible to put several plots or charts in one canvas.


[section "PLOT CREATION COMMANDS"]

You create the plot or chart with one single command and then fill the
plot with data:

[list_begin definitions]

[call [cmd ::Plotchart::createXYPlot] [arg w] [arg xaxis] [arg yaxis] [arg args]]

Create a new xy-plot (configuration type: xyplot).

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def list xaxis in]
A 3-element list containing minimum, maximum and stepsize for the x-axis, in this order.
For an inverted axis, where the maximum appears on the left-hand side,
use: maximum, minimum and a [emph negative] stepsize.

[arg_def list yaxis in]
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order.
For an inverted axis, where the maximum appears at the bottom,
use: maximum, minimum and a [emph negative] stepsize.

[arg_def list args in]
Zero or more options that influence the appearance of the plot:
[list_begin itemized]
[item]
[emph "-xlabels {labels}:"] Custom labels for the x-axis. If the labels
are numeric, they are positioned according to the given scale,
otherwise they are positioned with equal distance, based on the number
of labels. Note: this only works if the stepsize of the xaxis argument is
the empty string.
[item]
[emph "-ylabels {labels}:"] Similarly, custom labels for the y-axis.
[item]
[emph "-box {measures}:"] See [sectref "ARRANGING MULTIPLE PLOTS IN A CANVAS"]
[item]
[emph "-axesbox {measures}:"] See [sectref "ARRANGING MULTIPLE PLOTS IN A CANVAS"]
[item]
[emph "-timeformat format:"] See [sectref "USING DATE/TIME LABELS"]
[item]
[emph "-gmt 0/1:"] See [sectref "USING DATE/TIME LABELS"]
[item]
[emph "-axestozero:"] Draw the axes at the origin (1), or at the sides of the plot area (0, default).
This option is implemented for XY plots only.
[item]
[emph "-isometric:"] Rescale the axes, so that a square in the coordinates appears as a square on the
screen (1), or use the given extremes (0, default). This option is implemented for XY plots only.
[list_end]

[list_end]
[para]


[call [cmd ::Plotchart::createStripchart] [arg w] [arg xaxis] [arg yaxis] [arg args]]

Create a new strip chart (configuration type: stripchart). The
only difference to a regular XY plot is
that the x-axis will be automatically adjusted when the x-coordinate
of a new point exceeds the maximum.

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def list xaxis in]
A 3-element list containing minimum, maximum and stepsize for the x-axis, in this order.
Note that an inverted x-axis is [emph not] supported for this type of plot.

[arg_def list yaxis in]
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order.
For an inverted axis, where the maximum appears at the bottom,
use: maximum, minimum and a [emph negative] stepsize.

[arg_def list args in]
Zero or more options - see the XY-plot for more information.

[list_end]
[para]


[call [cmd ::Plotchart::createTXPlot] [arg w] [arg timeaxis] [arg xaxis] [arg args]]

Create a new time-x-plot (configuration type: txplot). The horizontal axis represents the date/time
of the data and the vertical axis the values themselves.

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def list timeaxis in]
A 3-element list containing the minimum and maximum date/time to be
shown and the stepsize ([emph "in days"]) for the time-axis, in this order.
Note that an inverted time-axis is [emph not] supported.

[arg_def list xaxis in]
A 3-element list containing minimum, maximum and stepsize for the
vertical axis, in this order.
For an inverted axis, where the maximum appears at the bottom,
use: maximum, minimum and a [emph negative] stepsize.

[arg_def list args in]
Zero or more options - see the XY-plot for more information.

[list_end]
[para]


[call [cmd ::Plotchart::createXLogYPlot] [arg w] [arg xaxis] [arg yaxis] [arg args]]

Create a new xy-plot where the y-axis has a logarithmic scale (configuration type: xlogyplot).
[para]
The data should be given as for a linear scale, as the logarithmic transformation
is taken of internally.

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def list xaxis in]
A 3-element list containing minimum, maximum and stepsize for the x-axis, in this order.
For an inverted axis, where the maximum appears on the left-hand side,
use: maximum, minimum and a [emph negative] stepsize.

[arg_def list yaxis in]
A 2-element list containing minimum and maximum for the y-axis, in this order.
Note that an inverted logarithmic axis is [emph not] supported.

[arg_def list args in]
Zero or more options - see the XY-plot for more information.

[list_end]
[para]


[call [cmd ::Plotchart::createLogXYPlot] [arg w] [arg xaxis] [arg yaxis] [arg args]]

Create a new xy-plot where the x-axis has a logarithmic scale (configuration type: logxyplot).
[para]
The data should be given as for a linear scale, as the logarithmic transformation
is taken of internally.

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def list xaxis in]
A 2-element list containing minimum and maximum for the x-axis, in this order.
Note that an inverted logarithmic axis is [emph not] supported.

[arg_def list yaxis in]
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order.
For an inverted axis, where the maximum appears on the left-hand side,
use: maximum, minimum and a [emph negative] stepsize.

[arg_def list args in]
Zero or more options - see the XY-plot for more information.

[list_end]
[para]


[call [cmd ::Plotchart::createLogXLogYPlot] [arg w] [arg xaxis] [arg yaxis] [arg args]]

Create a new xy-plot where both the x-axis and the y-axis have a logarithmic scale
(configuration type: logxlogyplot).
[para]
The data should be given as for a linear scale, as the logarithmic transformation
is taken of internally.

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def list xaxis in]
A 2-element list containing minimum and maximum for the x-axis, in this order.
Note that an inverted logarithmic axis is [emph not] supported.

[arg_def list yaxis in]
A 2-element list containing minimum and maximum for the y-axis, in this order.
Note that an inverted logarithmic axis is [emph not] supported.

[arg_def list args in]
Zero or more options - see the XY-plot for more information.

[list_end]
[para]


[call [cmd ::Plotchart::createPolarPlot] [arg w] [arg radius_data] [arg args]]

Create a new polar plot (configuration type: polarplot).

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def list radius_data in]
A 2-element list containing maximum radius and stepsize for the radial
axis, in this order.

[arg_def list args in]
Zero or more options - see the XY-plot for more information.

[list_end]
[para]


[call [cmd ::Plotchart::createWindrose] [arg w] [arg radius_data] [arg sectors]]

Create a new windrose diagram. The diagram will consist of concentric
circles as defined by the [term radius_data] argument and a number of
sectors (given by the [term sectors] argument). The sectors are drawn in
the "nautical" convention, that is: the first is located at the positive
y-axis, the second is to the right and so on in a clockwise direction.

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the diagram

[arg_def list radius_data in]
A 2-element list, the first element is the maximum radius, the second is
the step to be used for the circles.

[arg_def int sectors]
Number of sectors to use (defaults to 16).

[list_end]
[para]


[call [cmd ::Plotchart::createIsometricPlot] [arg w] [arg xaxis] [arg yaxis] [arg stepsize]]

Create a new isometric plot, where the vertical and the horizontal
coordinates are scaled so that a circle will truly appear as a circle (configuration type: isometric).

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def list xaxis in]
A 2-element list containing minimum, and maximum for the x-axis, in this order.

[arg_def list yaxis in]
A 2-element list containing minimum, and maximum for the y-axis, in this order.

[arg_def float|[const noaxes] stepsize in]

Either the stepsize used by both axes or the keyword [const noaxes] to
signal the plot that it should use the full area of the widget, to not
draw any of the axes.

[list_end]
[para]


[call [cmd ::Plotchart::createHistogram] [arg w] [arg xaxis] [arg yaxis] [arg args]]

Create a new histogram (configuration type: histogram).

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def list xaxis in]
A 3-element list containing minimum, maximum and stepsize for the x-axis, in this order.

[arg_def list yaxis in]
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order.

[arg_def list args in]
Zero or more options - see the XY-plot for more information.

[list_end]
[para]


[call [cmd ::Plotchart::create3DPlot] [arg w] [arg xaxis] [arg yaxis] [arg zaxis] [arg args]]

Create a new 3D plot.

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def list xaxis in]
A 3-element list containing minimum, maximum and stepsize for the x-axis, in this order.

[arg_def list yaxis in]
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order.

[arg_def list zaxis in]
A 3-element list containing minimum, maximum and stepsize for the z-axis, in this order.

[arg_def list args in]
Optional list of options (keyword-value pairs). Currently supported: -xlabels to set the
labels for the x-axis.

[list_end]
[para]


[call [cmd ::Plotchart::create3DRibbonPlot] [arg w] [arg yaxis] [arg zaxis]]

Create a new 3D ribbon plot. It is a simplification of the full 3D plot and allows for
the drawing of a ribbon only (the x-axis is dropped).

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def list yaxis in]
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order.

[arg_def list zaxis in]
A 3-element list containing minimum, maximum and stepsize for the z-axis, in this order.

[list_end]
[para]


[call [cmd ::Plotchart::createPiechart] [arg w]]

Create a new piechart (configuration type: piechart).

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[list_end]
[para]


[call [cmd ::Plotchart::createSpiralPie] [arg w]]

Create a new "spiral pie" (configuration type: spiralpie), a variation on the ordinary
piechart. The value is used to scale the radius, rather than the angle. By default the
data are sorted.

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[list_end]
[para]


[call [cmd ::Plotchart::createRadialchart] [arg w] [arg names] [arg scale] [arg style]]

Create a new radial chart (the data are drawn as a line connecting the
spokes of the diagram) (configuration type: radialchart).

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def list names in]
Names for the spokes.

[arg_def float scale in]
Scale value to determine the position of the data along the spokes.

[arg_def string style in]
Style of the chart (optional). One of:
[list_begin itemized]
[item]
[emph lines] - the default: draw the data as independent polylines.
[item]
[emph cumulative] - draw the data as polylines where the data are
accumulated.
[item]
[emph filled] - draw the data as filled polygons where the data are
accumulated
[list_end]

[list_end]
[para]


[call [cmd ::Plotchart::createBarchart] [arg w] [arg xlabels] [arg yaxis] [arg noseries] [arg args]]

Create a new barchart with vertical bars (configuration type: vertbars). The horizontal axis will
display the labels contained in the argument [arg xlabels]. The number
of series given by [arg noseries] determines both the width of the
bars, and the way the series will be drawn.

[para]

If the keyword [const stacked] was specified the series will be drawn
stacked on top of each other. Otherwise each series that is drawn will
be drawn shifted to the right.

[para]

The number of series determines the width of the bars, so that there is
space of that number of bars. If you use a floating-point number, like
2.2, instead of an integer, like 2, a small gap between the sets of bars
will be drawn - the width depends on the fractional part.

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def list xlabels in]
List of labels for the x-axis. Its length also determines the number of
bars that will be plotted per series.

[arg_def list yaxis in]
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order.

[arg_def int|[const stacked] noseries in]
The number of data series that will be plotted. This has to be an
integer number greater than zero (if [const stacked] is not used).

[arg_def string args in]
One or more key-value pairs defining the options. Specific to barcharts: [const -xlabelangle] value,
the angle under which the labels should be drawn. This defaults to 0 - horizontal text. This option
is especially useful if you have fairly long labels.

[list_end]
[para]


[call [cmd ::Plotchart::createHorizontalBarchart] [arg w] [arg xaxis] [arg ylabel] [arg noseries]]

Create a new barchart with horizontal bars (configuration type: horizbars). The vertical axis will
display the labels contained in the argument [arg ylabels]. The number
of series given by [arg noseries] determines both the width of the
bars, and the way the series will be drawn.

[para]

If the keyword [const stacked] was specified the series will be drawn
stacked from left to right. Otherwise each series that is drawn will
be drawn shifted upward.

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def list xaxis in]
A 3-element list containing minimum, maximum and stepsize for the x-axis, in this order.

[arg_def list ylabels in]
List of labels for the y-axis. Its length also determines the number of
bars that will be plotted per series.

[arg_def int|[const stacked] noseries in]
The number of data series that will be plotted. This has to be an
integer number greater than zero (if [const stacked] is not used).

[list_end]
[para]


[call [cmd ::Plotchart::create3DBarchart] [arg w] [arg yaxis] [arg nobars]]

Create a new barchart with 3D vertical bars (configuration type: 3dbars). The horizontal axis will
display the labels per bar. The number of bars given by [arg nobars]
determines the position and the width of the bars. The colours can be
varied per bar. (This type of chart was inspired by the Wiki page on 3D
bars by Richard Suchenwirth.)

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def list yaxis in]
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order.

[arg_def int nobars in]
The number of bars that will be plotted.

[list_end]
[para]


[call [cmd ::Plotchart::create3DRibbonChart] [arg w] [arg names] [arg yaxis] [arg zaxis]]

Create a new "ribbon chart" (configuration type: 3dribbon). This is
a chart where the data series are
represented as ribbons in a three-dimensional axis system. Along the
x-axis (which is "into" the screen) the names are plotted, each
representing a single series. The first plot command draws the furthest
series, the second draws the series in front of that and so on.

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def widget w in]
Names of the series, plotted as labels along the x-axis

[arg_def list yaxis in]
A 3-element list containing minimum, maximum and stepsize for the y-axis
(drawn horizontally!), in this order.

[arg_def list zaxis in]
A 3-element list containing minimum, maximum and stepsize for the z-axis
(drawn vertically), in this order.

[arg_def int nobars in]
The number of bars that will be plotted.

[list_end]
[para]


[call [cmd ::Plotchart::createBoxplot] [arg w] [arg xdata] [arg ydata] [arg orientation]]

Create a new boxplot with horizontal or vertical boxes (box-and-whiskers) (configuration type: boxplot). Depending
on the orientation the x- or y-axis is drawn with labels. The boxes are drawn based on the raw data
(see the plot subcommand for this type of plot).

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def list xdata in]
This is either a 3-element list containing minimum, maximum and stepsize for the x-axis, in this order
(when orientation is horizontal), or a list of labels for the x-axis (when orientation is vertical). The length
of the label list also determines the number of boxes that can be plotted. The labels are also used in the plot
subcommand.

[arg_def list ydata in]
This is either a 3-element list containing minimum, maximum and stepsize for the y-axis, in this order
(when orientation is vertical), or a list of labels for the y-axis (when orientation is horizontal). The length
of the label list also determines the number of boxes that can be plotted. The labels are also used in the plot
subcommand.

[arg_def string orientation in]
If given, "horizontal" or "vertical" determines the orientation of the boxes. This optional value (default: horizontal)
also determines the interpretation of the xdata and ydata arguments.

[list_end]
[para]


[call [cmd ::Plotchart::createTimechart] [arg w] [arg time_begin] [arg time_end] [arg args]]

Create a new timechart (configuration type: timechart).

The time axis (= x-axis) goes from [arg time_begin] to [arg time_end],
and the vertical spacing is determined by the number of items to plot.

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def string time_begin in]
The start time given in a form that is recognised by the [cmd "clock scan"]
command (e.g. "1 january 2004").

[arg_def string time_end in]
The end time given in a form that is recognised by the [cmd "clock scan"]
command (e.g. "1 january 2004").

[arg_def arguments args in]
The remaining arguments can be:
[list_begin itemized]
[item]
The expected/maximum number of items. This determines the vertical
spacing. (If given, it must be the first argument after "time_end"
[item]
The keyword -barheight and the number of pixels per bar. This is an
alternative method to determine the vertical spacing.
[item]
The keyword -ylabelwidth and the number of pixels to reserve for the
labels at the y-axis.
[list_end]

[list_end]


[call [cmd ::Plotchart::createGanttchart] [arg w] [arg time_begin] [arg time_end] [arg args]]

Create a new Gantt chart (configuration type: ganttchart).

The time axis (= x-axis) goes from [arg time_begin] to [arg time_end],
and the vertical spacing is determined by the number of items to plot.
Via the specific commands you can then add tasks and connections between
the tasks.

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def string time_begin in]
The start time given in a form that is recognised by the [cmd "clock scan"]
command (e.g. "1 january 2004").

[arg_def string time_end in]
The end time given in a form that is recognised by the [cmd "clock scan"]
command (e.g. "1 january 2004").

[arg_def arguments args in]
The remaining arguments can be:
[list_begin itemized]
[item]
The expected/maximum number of items. This determines the vertical
spacing. (If given this way, it must be the first argument after "time_end")
[item]
The expected/maximum width of the descriptive text (roughly in characters,
for the actual space reserved for the text, it is assumed that a
character is about ten pixels wide). Defaults to 20. (If given this way,
it must be the second argument after "time_end").
[item]
The keyword -barheight and the number of pixels per bar. This is an
alternative method to determine the vertical spacing.
[item]
The keyword -ylabelwidth and the number of pixels to reserve for the
labels at the y-axis.
[list_end]

[list_end]


[call [cmd ::Plotchart::createRightAxis] [arg w_or_plot] [arg yaxis]]

Create a plot command that will use a right axis instead of the left
axis (configuration type: inherited from the existing plot). The canvas widget
must already contain an ordinary plot, as the
horizontal axis and other properties are reused. Preferably use the
plot command, as with multiple plots in a canvas (also when redefining an existing
plot!), the wrong geometry might be used.
[para]
To plot data using the
right axis, use this new command, to plot data using the [emph left]
axis, use the original plot command.

[list_begin arguments]
[arg_def widget w_or_plot in]
Name of the [emph existing] canvas widget to hold the plot or preferably the
plot command for the plot with the left axis.

[arg_def list yaxis in]
A 3-element list containing minimum, maximum and stepsize for the y-axis, in this order.

[list_end]


[call [cmd ::Plotchart::createTableChart] [arg w] [arg columns] [opt widths]]

Create a command to draw a table. You can use a variety of commands to
draw the actual rows of the table, but the number of columns is fixed.
(See [sectref "TABLE CHARTS"] for an example)

[list_begin arguments]
[arg_def widget w in]
Name of the canvas widget to hold the table.

[arg_def list columns in]
The headers of the columns in the table. The number of elements
determines the number of columns.

[arg_def list widths in]
If given, either a single value, the width in pixels for all columns or
for each column the width of that column. If not given, the table is
spread out over the width of the canvas (minus the margins).

[list_end]
[para]


[call [cmd ::Plotchart::createTernaryDiagram] [arg w] [arg args]]

Create a command to draw a ternary diagram (configuration type: ternary). You can draw
individual (labelled) data points in the diagram, lines and filled polygons.

[list_begin arguments]
[arg_def widget w in]
Name of the canvas widget to hold the ternary diagram.

[arg_def list args in]
Zero or more option-value pairs to influence the position and the appearance of the
diagram. In addition to the positioning options (-box and -axesbox) the diagram supports:
[term "-fractions yes/no"], to display numbers 0 to 1 instead of 0 to 100% and [term "-steps number"]
to influence the number of labels along the three sides.

[list_end]
[para]


[call [cmd ::Plotchart::createNormalPlot] [arg w] [arg xscale] [arg args]]

Create a command to draw a normal plot - useful to investigate whether a data set is normally
distributed or not. In that case the data will fall on or near the diagonal. As such, it is a
specialised plotting procedure.
[para]
The details of the plotting procedure have been adopted from the [term qqnorm] in the "R" [term stats]
package and described on Wikipedia.
[para]
As the implementation of this plot type relies on the [term math::statistics] package, it is only
available if that package can be loaded.

[list_begin arguments]
[arg_def widget w in]
Name of the canvas widget to hold the normal plot.

[arg_def list xscale in]
A 3-element list containing minimum, maximum and stepsize for the x-axis
in this order. The scaling of the y-axis is determined from that. [emph Important:] the scale
is to be given in terms of the normalised data, that is: 0 represents the mean of the data,
1 one standard deviation away from the mean etc.

[arg_def list args in]
Zero or more option-value pairs to influence the position and the appearance of the
plot - see the XY-plot for more details.

[list_end]
[para]


[call [cmd ::Plotchart::createStatusTimeline] [arg w] [arg xaxis] [arg ylabel] [arg args]]

Create a command to draw a so-called status timeline. Its layout is similar to a horizontal
barchart, but the bars are drawn in different colours, each representing the status of
the item as it varies over time (the horizontal axis).

[list_begin arguments]
[arg_def widget w in]
Name of the canvas widget to hold the ternary diagram.

[arg_def list xaxis in]
A 3-element list containing minimum, maximum and stepsize for the x-axis, in this order.

[arg_def list ylabels in]
List of labels for the y-axis. Its length also determines the number of
bars that will be plotted per series.

[arg_def list args in]
Zero or more option-value pairs to influence the position and the appearance of the
diagram. In addition to the positioning options (-box and -axesbox) the diagram supports:
[term "-xaxis yes/no"], to turn displaying the numeric labels on or off.

[list_end]
[para]

[list_end]

[section "PLOT METHODS"]

Each of the creation commands explained in the last section returns
the name of a new object command that can be used to manipulate the
plot or chart. The subcommands available to a chart command depend on
the type of the chart.

[para]

General subcommands for all types of charts. \$anyplot is the command
returned by the creation command:

[list_begin definitions]
[call [cmd \$anyplot] title [arg text] [arg position]]

Specify the title of the whole chart.

[list_begin arguments]
[arg_def string text in]
The text of the title to be drawn.
[arg_def string position in]
The position of the title. The default position is "center", but you can
alternatively use "left" or "right". You can use multiple titles with
different positions.

[list_end]
[para]

[call [cmd \$anyplot] subtitle [arg text]]

Specify the subtitle of the whole chart.

[list_begin arguments]
[arg_def string text in]
The text of the subtitle to be drawn.
[list_end]
[para]

[call [cmd \$anyplot] canvas]

Return the name of the canvas (or the alias if you use more than one plot within a
canvas). Use this value for the coordinate transformations.
[para]


[call [cmd \$anyplot] saveplot [arg filename] [arg args]]

Draws the plot into a file, using PostScript.

[list_begin arguments]
[arg_def string filename in]
Contain the path name of the file to write the plot to.

[arg_def list args in]
If the standard PostScript output is used, the option -plotregion can be specifed
to save the whole plot (value: bbox) regardless of what is visible in the window.
The default (value: window) is to only plot the visible part of the plot.
[para]
Optionally you can specify the option -format "some picture format" to
store the plot in a different file than a PostScript file. This,
however, relies on the Img package to do the actual job.
[para]
[emph Note:]
Because the window holding the plot must be fully visible before Img can
successfully grab it, it is raised first.
On some systems, for instance Linux with KDE, raising
a window is not done automatically, but instead you need to click on the
window in the task bar. Similar things happen on Windows XP.
[para]
There seems to be something wrong under some circumstances, so instead
of waiting for the visibility of the window, the procedure simply waits
two seconds. It is not ideal, but it seems to work better.

[list_end]
[para]


[call [cmd \$anyplot] xtext [arg text]]

Specify the title of the (horizontal) x-axis, for those plots that have
a straight x-axis.

[list_begin arguments]
[arg_def string text in]
The text of the x-axis label to be drawn.

[list_end]
[para]


[call [cmd \$anyplot] ytext [arg text]]

Specify the title of the (horizontal) y-axis, for those plots that have
a straight y-axis.

[list_begin arguments]
[arg_def string text in]
The text of the y-axis label to be drawn.

[list_end]

[call [cmd \$anyplot] vtext [arg text]]
Draw a [emph vertical] label to the y-axis. Note: this requires Tk 8.6
or later, for older versions it does nothing.

[list_begin arguments]
[arg_def string text in]
Text to drawn to the y-axis

[list_end]

[para]


[call [cmd \$anyplot] xsubtext [arg text]]

Specify the subtext of the (horizontal) x-axis, for those plots that have
a straight x-axis. This text is drawn below the primary text.
[para]
Since this involves positioning the primary text and setting margins, you need to
set the option "usesubtext" for the bottom axis via the plotstyle command. The relevant
options are: usesubtext, subtextcolor and subtextfont.

[list_begin arguments]
[arg_def string text in]
The secondary text of the x-axis label to be drawn.

[list_end]
[para]


[call [cmd \$anyplot] ysubtext [arg text]]

Specify the subtext of the (vertical) y-axis, for those plots that have
a straight y-axis. This text is drawn below the primary text, for both
axes on the left and the right.
[para]
Since this involves positioning the primary text and setting margins, you need to
set the option "usesubtext" for the left or right axis via the plotstyle command. The relevant
options are: usesubtext, subtextcolor and subtextfont.

[list_begin arguments]
[arg_def string text in]
The secondary text of the y-axis label to be drawn.

[list_end]
[para]


[call [cmd \$anyplot] vsubtext [arg text]]

Specify the subtext of the (vertical) y-axis, for those plots that have
a straight y-axis. This text is drawn to the [emph right] of the primary text, for both
axes on the left and the right.
[para]
Since this involves positioning the primary text and setting margins, you need to
set the option "usesubtext" for the left or right axis via the plotstyle command. The relevant
options are: usevsubtext, vsubtextcolor and vsubtextfont. (Note the "v" to distinguish this
option from the text at the top of a vertical axis that is drawn via [term "\$anyplot ytext"] or
[term "\$anyplot ysubtext"].)

[list_begin arguments]
[arg_def string text in]
The secondary (vertical) text of the y-axis label to be drawn.

[list_end]
[para]


[call [cmd \$anyplot] xconfig [option -option] [arg value] ...]

Set one or more configuration parameters for the x-axis.

The following options are supported:

[list_begin options]

[opt_def format fmt]
The format for the numbers along the axis.

[opt_def ticklength length]
The length of the tickmarks (in pixels).

[opt_def ticklines boolean]
Whether to draw ticklines ([const true]) or not ([const false]).

[opt_def scale scale_data]
New scale data for the axis, i.e. a 3-element list containing minimum,
maximum and stepsize for the axis, in this order.

[para]
[emph Beware:] Setting this option will clear all data from the plot.

[list_end]
[para]


[call [cmd \$anyplot] yconfig [option -option] [arg value] ...]

Set one or more configuration parameters for the y-axis. This method
accepts the same options and values as the method [method xconfig].


[call [cmd \$anyplot] background [arg part] [arg colour_or_image] [arg dir] [opt brightness]]

Set the background of a part of the plot

[list_begin arguments]

[arg_def string part]
Which part of the plot: "axes" for the axes area and "plot" for the
inner part. The interpretation depends on the type of plot. Two further
possibilities are:
[list_begin itemized]
[item]
[emph image], in which case a predefined image is loaded
into the background of the plot.
[item]
[emph gradient], in which case the background is coloured in different
shades of the given colour. The "dir" argument specifies the direction
in which the colour gets whiter.
[list_end]

[arg_def string colour_or_image]
Colour for that part or the name of the image if "part" is "image"

[arg_def string dir]
The direction of the gradient. One of: top-down, bottom-up, left-right
or right-left.

[arg_def string brightness]
Indicates whether the colour should become brighter (bright) or darker (dark). Defaults to bright

[list_end]
[para]


[call [cmd \$anyplot] xticklines [arg colour] [opt dash]]

Draw vertical ticklines at each tick location

[list_begin arguments]

[arg_def string colour]
Colour of the lines. Specifying an empty colour ("") removes them again.
Defaults to "black"

[arg_def string dash]
Optional argument to specify the dash pattern for the lines. Defaults to "lines"
Possible values: lines, dots1, dots2, dots3, dots4, dots5.
The actual effect depends on the platform.

[list_end]
[para]


[call [cmd \$anyplot] yticklines [arg colour] [opt dash]]

Draw horizontal ticklines at each tick location

[list_begin arguments]

[arg_def string colour]
Colour of the lines. Specifying an empty colour ("") removes them again
Defaults to "black"

[arg_def string dash]
Optional argument to specify the dash pattern for the lines. Defaults to "lines"
Possible values: lines, dots1, dots2, dots3, dots4, dots5.
The actual effect depends on the platform.

[list_end]
[para]


[call [cmd \$anyplot] legend [arg series] [arg text] [opt spacing]]

Add an entry to the legend. The series determines which graphical
symbol is to be used. (As a side effect the legend is actually drawn.)

[list_begin arguments]

[arg_def string series]
Name of the data series. This determines the colour of the line and the
symbol (if any) that will be drawn.

[arg_def string text]
Text to be drawn next to the line/symbol.

[arg_def integer spacing]
Optional argument to specify the vertical spacing between the entries (in pixels).
(Note that this spacing will be reused later.)

[list_end]
[para]


[call [cmd \$anyplot] removefromlegend [arg series]]

Remove an entry for a series from the legend and redraw it.

[list_begin arguments]

[arg_def string series]
Name of the data series to be removed.

[list_end]
[para]


[call [cmd \$anyplot] legendconfig [option -option] [arg value] ...]

Set one or more options for the legend. The legend is drawn as a
rectangle with text and graphics inside.

[list_begin options]

[opt_def background colour]
Set the colour of the background (the default colour is white).
Set to the empty string for a transparant legend.

[opt_def border colour]
Set the colour of the border (the default colour is black). Set to the
empty string if you do not want a border.

[opt_def canvas c]
Draw the legend in a different canvas widget. This gives you the freedom
to position the legend outside the actual plot.

[opt_def font font]
Set the font used to draw the text next to the symbol.

[opt_def legendtype type]
Override the type of the legend, that is pre-defined for the current type of
plot. May be one of: rectangle or line.

[opt_def position corner]
Set the position of the legend. May be one of: top-left, top-right,
bottom-left or bottom-right. (Default value is top-right.)

[opt_def spacing pixels]
Set the vertical spacing between entries in the legend (in pixels).
bottom-left or bottom-right. (Default value is 10 pixels.)

[list_end]
[para]


[call [cmd \$anyplot] balloon [arg x] [arg y] [arg text] [arg dir]]

Add balloon text to the plot (except for 3D plots). The arrow will point
to the given x- and y-coordinates. For xy-graphs and such, the
coordinates are directly related to the axes; for vertical barcharts the
x-coordinate is measured as the number of bars minus 1 and similar for
horizontal barcharts.

[list_begin arguments]

[arg_def float x]
X-coordinate of the point that the arrow of the balloon will point to.

[arg_def float y]
Y-coordinate of the point that the arrow of the balloon will point to.

[arg_def string text]
Text to be drawn in the balloon.

[arg_def string dir]
Direction of the arrow, one of: north, north-east, east, south-east,
south, south-west, west or north-west.

[list_end]
[para]


[call [cmd \$anyplot] balloonconfig [arg args]]

Configure the balloon text for the plot. The new settings will be used
for the next balloon text.

[list_begin options]

[opt_def font fontname]
Font to be used for the text

[opt_def justify left|center|right]
Way to justify multiline text

[opt_def textcolour colour]
Colour for the text (synonym: textcolor)

[opt_def background colour]
Background colour for the balloon

[opt_def outline colour]
Colour of the outline of the balloon

[opt_def margin value]
Margin around the text (in pixels)

[opt_def rimwidth value]
Width of the outline of the balloon (in pixels)

[opt_def arrowsize value]
Length factor for the arrow (in pixels)

[list_end]


[call [cmd \$anyplot] plaintext [arg x] [arg y] [arg text] [arg dir]]

Add plain text to the plot (except for 3D plots). The text is positioned at
the given x- and y-coordinates. For xy-graphs and such, the
coordinates are directly related to the axes; for vertical barcharts the
x-coordinate is measured as the number of bars minus 1 and similar for
horizontal barcharts.

[list_begin arguments]

[arg_def float x]
X-coordinate of the text position

[arg_def float y]
Y-coordinate of the text position

[arg_def string text]
Text to be drawn.

[arg_def string dir]
Anchor for the text, one of: north, north-east, east, south-east,
south, south-west, west or north-west.

[list_end]
[para]


[call [cmd \$anyplot] plaintextconfig [arg args]]

Configure the plain text annotation for the plot. The new settings will be used
for the next plain text.

[list_begin options]

[opt_def font fontname]
Font to be used for the text

[opt_def justify left|center|right]
Way to justify multiline text

[opt_def textcolour colour]
Colour for the text (synonym: textcolor)

[list_end]


[call [cmd \$anyplot] object [arg itemtype] [arg series] [arg args]]

Draw a canvas item in the plot where the coordinates are scaled using the
coordinate system of the plot. In addition to the standard canvas types, it
also supports circles, dots and crosses.
[para]
[emph Note:] Currently implemented for xy-plots, (vertical and horizontal)
barcharts, and piecharts.
[para]
[emph Note:] To add an entry in the legend for the object, you can use the
[term dataconfig] subcommand with a type "rectangle". This will cause a rectangle
to be shown.


[list_begin arguments]

[arg_def string itemtype in]
Name of a standard canvas item or "circle", "dot" or "cross"

[arg_def string series in]
The data series it belongs to, used for setting the default drawing options

[arg_def list args in]
List of coordinates and drawing options

[list_end]


[call [cmd \$anyplot] deletedata]

Remove the lines, symbols and other graphical object associated with the
actual data from the plot.
[para]
[emph Note:] Currently implemented for xy-plots only
[para]
[emph Note:] The existing options for data series and the legend entry are
kept as they were.
[para]
[emph Note:] Currently there are side effects if the canvas contains more than
one plot.


[list_end]
[para]

[emph Note:] The commands [method xconfig] and [method yconfig] are
currently implemented only for XY-plots
and only the option [option -format] has any effect.

[para]

For [emph {xy plots}], [emph stripcharts], [emph histograms] and
[emph time-x-plots]:

[list_begin definitions]
[call [cmd \$xyplot] plot [arg series] [arg xcrd] [arg ycrd]]

Add a data point to the plot.

[list_begin arguments]
[arg_def string series in]
Name of the data series the new point belongs to.

[arg_def float xcrd in]
X-coordinate of the new point. (For time-x plots this must be valid
date/time that can be read with the [emph "clock scan"] command).

[arg_def float ycrd in]
Y-coordinate of the new point.

[list_end]
[list_end]
[para]

For [emph {normal plots}]:

[list_begin definitions]
[call [cmd \$normalplot] plot [arg series] [arg mean] [arg stdev] [arg data]]

Plot the data set using the given mean and stanard deviation.
[para]
As you give the mean and standard deviation separately, the plot can be used for several data series
or for adding to an existing data series.

[list_begin arguments]
[arg_def string series in]
Name of the data series - used to determine the appearance

[arg_def float mean in]
Assumed mean of the data set.

[arg_def float stdev in]
Assumed standard deviation of the data set.

[arg_def list data in]
List of the data comprising the data set
[list_end]

[call [cmd \$normalplot] diagonal]

Draw a diagonal line, indicating the ideal normally distributed data set.
[list_end]
[para]

For [emph "xy, x-log y, log-x-y, log-x-log-y plots"] there is the additional command [emph plotlist],
which is useful for plotting a large amount of data:

[list_begin definitions]
[call [cmd \$xyplot] plotlist [arg series] [arg xlist] [arg ylist] [arg every]]

Draw a series of data as a whole. If symbols are asked for, draw them only
for every Nth data point.

[list_begin arguments]
[arg_def string series in]
Name of the data series the new line belongs to.

[arg_def float xlist in]
List of X-coordinates for the data series.

[arg_def float ycrd in]
List of Y-coordinates for the data series.

[arg_def int every in]
Optional argument stating how often a symbol (if any) should be drawn.
If left out, use a simple heuristic: N = sqrt(number of data points).
[list_end]
[list_end]

Other commands for [emph "xy, x-log y, log-x-y, log-x-log-y plots"] are [emph region] and [emph minmax] to draw filled polygons:

[list_begin definitions]
[call [cmd \$xyplot] region [arg series] [arg xlist] [arg ylist]]

Draw a filled polygon (region). The configuration of the series influences the polygon as follows:
[term -fillcolour] is used to fill the polygon, [term -colour] is used for the boundary (set it to {} if
no boundary is required and [term -width] determines the width of the boundary.

[list_begin arguments]
[arg_def string series in]
Name of the data series the new region belongs to.

[arg_def float xlist in]
List of X-coordinates for the region.

[arg_def float ycrd in]
List of Y-coordinates for the region.
[list_end]

[call [cmd \$xyplot] minmax [arg series] [arg xcrd] [arg ymin] [arg ymax]]

Draw a filled strip representing a minimum and a maximum. The configuration of the series influences the polygon as follows:
[term -fillcolour] is used to fill the polygon, [term -colour] is used for the boundary (set it to {} if
no boundary is required and [term -width] determines the width of the boundary.
[nl]
The arguments [term ymin] and [term ymax] may be empty to get an extra vertex in the strip. If both
are empty, a new strip is started. For best results, the x-coordinate should be specified in ascending
order.

[list_begin arguments]
[arg_def string series in]
Name of the data series the new min/max strip belongs to.

[arg_def float xcrd in]
X-coordinate for the strip.

[arg_def float ymin in]
The minimum y-coordinate for the strip.

[arg_def float ymax in]
The maximum y-coordinate for the strip.
[list_end]
[list_end]
[para]

[emph "Note on histograms:"]
[para]
For histograms the x-coordinate that is given is interpreted to be
the x-coordinate of the [emph right] side of the bar (or line segment). The first
bar starts at the y-axis on the left. To completely fill the range
of the x-axis, you should draw a bar at the maximum x-coordinate.
[para]
For histograms you can also use the [const plotcumulative] command:

[list_begin definitions]
[call [cmd \$histogram] plotcumulative [arg series] [arg xcrd] [arg ycrd]]
[list_end]

The arguments mean exactly the same as for the [const plot] command, but
the data are accumulated to the previous values.

[para]
For [emph {xy plots}]:

[list_begin definitions]
[call [cmd \$xyplot] trend [arg series] [arg xcrd] [arg ycrd]]

Draw or update a trend line using the data given sofar.

[list_begin arguments]
[arg_def string series in]
Name of the data series the trend line belongs to.

[arg_def float xcrd in]
X-coordinate of the new data point

[arg_def float ycrd in]
Y-coordinate of the new data point
[list_end]

[call [cmd \$xyplot] rchart [arg series] [arg xcrd] [arg ycrd]]

Draw data in the same way as the plot method, but with two lines added
that indicate the expected range (+/- 3*standard deviation) of the data.

[list_begin arguments]
[arg_def string series in]
Name of the data series the data point belongs to.

[arg_def float xcrd in]
X-coordinate of the new data point

[arg_def float ycrd in]
Y-coordinate of the new data point
[list_end]


[call [cmd \$xyplot] interval [arg series] [arg xcrd] [arg ymin] [arg ymax] [opt ycentr]]

Add a vertical error interval to the plot. The interval is drawn from
ymin to ymax. If the ycentr argument is given, a symbol is drawn at that
position.

[list_begin arguments]
[arg_def string series in]
Name of the data series the interval belongs to.

[arg_def float xcrd in]
X-coordinate of the interval

[arg_def float ymin in]
Minimum y-coordinate of the interval.

[arg_def float ymax in]
Maximum y-coordinate of the interval.

[arg_def float ycentr in]
Y-coordinate to draw the symbol at (optional)

[list_end]


[call [cmd \$xyplot] box-and-whiskers [arg series] [arg xcrd] [arg ycrd]]

Draw a box and whiskers in the plot. If the argument [term xcrd] is a
list of
several values and the argument [term ycrd] is a single value, a
horizontal
box is drawn with the quartiles determined from the list of values
contained in [term xcrd].
[para]
If, instead, the argument [term ycrd] contains a list of several values
and the argument [term xcrd] a single value, then a vertical box is
drawn and the quartiles are determined from [term ycrd]. (There must be
exactly one list of several values. Otherwise an error is reported.)
[para]

The option -boxwidth to the dataconfig command determines the width (or
height) of the box (default: 10 pixels).
[para]
The option -whiskers to the dataconfig command determines whether the
whiskers are drawn to the extreme values (value: extremes), to 1.5
times the interquartile range (value: IQR or iqr), or not at all (value: none).
If the value is 'IQR' (uppercase), then
also extreme values will be shown (from 1.5 to 3 times the IQR as dots,
above 3 times IQR as stars). If the value is 'iqr' (lowercase) no extreme
values will be shown (default value: IQR).
[para]
The option -whiskerwidth to the dataconfig command determines the thickness of the line
that draws the whiskers (default: 1 pixel).
[para]
The option -mediancolour to the dataconfig command determines the
colour of the line used to draw the median within the box (default: same as -colour).
[para]
The option -medianwidth to the dataconfig command determines the thickness of the line
that draws the median within the box (default: 1 pixel).

[list_begin arguments]
[arg_def string series in]
Name of the data series the box-and-whiskers belongs to.

[arg_def float xcrd in]
X-coordinate of the box or a list of values.

[arg_def float ymin in]
Y-coordinate of the box or a list of values.

[list_end]
[para]
The box ends at the 1st and 3rd quartile, while the whiskers by default
are plotted to span 1.5 IQR (interquartile range) from the 1st and 3rd quartile.

[call [cmd \$xyplot] vector [arg series] [arg xcrd] [arg ycrd] [arg ucmp] [arg vcmp]]

Draw a vector in the plot. The vector can be given as either cartesian
coordinates or as length/angle, where the angle is in degrees and is
interpreted according to the mathematical convention or the nautical.
(See the vectorconfig subcommand)

[list_begin arguments]
[arg_def string series in]
Name of the series the vector belongs to. Determines the appearance and
interpretation.

[arg_def float xcrd in]
X-coordinate of the point where the arrow appears

[arg_def float ycrd in]
Y-coordinate of the point where the arrow appears

[arg_def float ucmp in]
X-component or the length of the vector

[arg_def float ycentr in]
Y-component or the angle of the vector

[list_end]


[call [cmd \$xyplot] vectorconfig [arg series] [option -option] [arg value] ...]]

Set the vector drawing options for a particular series

[list_begin arguments]
[arg_def string series in]
Name of the series the vector belongs to.
[list_end]

The options can be one of the following:
[list_begin options]
[opt_def colour]
The colour of the arrow (default: black; synonym: color)
[opt_def scale value]
The scale factor used to convert the length of the
arrow into a number of pixels (default: 1.0)
[opt_def centred onoff]
Logical value indicating that the xy-coordinates
are to be used as the start of the arrow or as the centre (default: 0;
synonym: centered)
[opt_def type keyword]
Interpretation of the vector components. Can be "cartesian"
(default), in which case the x- and y-components are expected, "polar"
(the angle 0 coincides with the positive x-axis, 90 coincides with the
positive y-axis) or "nautical" (0 is "north" and 90 is "east").
[list_end]
[para]


[call [cmd \$xyplot] dot [arg series] [arg xcrd] [arg ycrd] [arg value]]

Draw a dot in the plot. The size and colour is determined by the value
and by the options set for the series it belongs to.
(See the dotconfig subcommand)

[list_begin arguments]
[arg_def string series in]
Name of the series the dot belongs to. Determines size and colour

[arg_def float xcrd in]
X-coordinate of the point where the arrow appears

[arg_def float ycrd in]
Y-coordinate of the point where the arrow appears

[arg_def float value in]
Value determining size and colour

[list_end]


[call [cmd \$xyplot] dotconfig [arg series] [option -option] [arg value] ...]]

Set the dot drawing options for a particular series

[list_begin arguments]
[arg_def string series in]
Name of the series the dot belongs to.
[list_end]

The options can be one of the following:
[list_begin options]
[opt_def colour]
The colour of the dot if no scaling is used or the value exceeds the
last limit of the classes.
[opt_def scale value]
The scale factor used to convert the value into the radius of the dot
in pixels (default: 1.0)
[opt_def radius value]
The default radius of the dots, used if there is no scaling by value
(in pixels; default: 3)
[opt_def scalebyvalue onoff]
Determines whether the dots all have the same size or a size depending
on the given value (default: on).
[opt_def outline onoff]
Draw a black circle around the dot or not (default: on)
[opt_def classes list]
Set the limits and the corresponding colours. For instance:
[example {
    $xyplot series1 -classes {0 blue 1 green} -colour red
}]
will cause a blue dot to be drawn for values smaller than 0, a green dot
for values larger/equal 0 but lower than 1 and a red dot for values
larger/equal 1.
[opt_def 3deffect onoff]
Show a highlight in the dots, to mimick a 3D effect (default: off)
[para]
If there is no list of classes for the particular series, the dots are
scaled by the value.
[para]
You can combine the colouring by value and the scaling by value by
setting a list of classes and setting the [emph scalebyvalue] option on.
[list_end]
[para]


[call [cmd \$xyplot] contourlines [arg xcrd] [arg ycrd] [arg values] [opt classes]]

Draw contour lines for the values given on the grid. The grid is defined
by the xcrd and ycrd arguments. The xcrd argument (resp. ycrd)
is expected to be a matrix, implemented as a list of lists which gives the
x-coordinates (resp. y-coordinates) of the grid cell corners.
The function values are given at these corners.
The number of rows in xcrd (resp. ycrd) is ny and each row contains nx values
so that the total number of values in xcrd (resp. ycrd) is nx * ny.
The classes determine which contour lines are drawn. If a value on one of
the corners is missing, the contour lines in that cell will not be
drawn.
[para]
Entries in the legend are drawn via the [emph legendisolines] subcommand.


[list_begin arguments]
[arg_def list xcrd in]
List of lists, each value is an x-coordinate for a grid cell corner

[arg_def list ycrd in]
List of lists, each value is an y-coordinate for a grid cell corner

[arg_def list values in]
List of lists, each value is the value at a grid cell corner

[arg_def list classes in]
List of class values or a list of lists of two elements (each inner list
the class value and the colour to be used). If empty or missing, the
classes are determined automatically.
[para]
[emph Note:] The class values must enclose the whole range of values.
[emph Note:] The xcrd argument is generally made of nypoints identical rows, while
each row of ycrd is made with one single value.
[para]

[list_end]

[call [cmd \$xyplot] contourlinesfunctionvalues [arg xvec] [arg yvec] [arg valuesmat] [opt classes]]

Draw contour lines for the values given on the grid. The grid is defined
by the xvec and yvec arguments. Here, xvec (resp. yvec) is a list of x-coordinates
(resp. y-coordinates). The number of values in xvec (resp. yvec) is the number of points in
the x-coordinate (resp. y-coordinate).
The function values are given at these corners. The
classes determine which contour lines are drawn. If a value on one of
the corners is missing, the contour lines in that cell will not be
drawn.
[para]
Entries in the legend are drawn via the [emph legendisolines] subcommand.

[list_begin arguments]
[arg_def list xvec in]
List of x-coordinates in increasing order.

[arg_def list yvec in]
List y-coordinates in increasing order.

[arg_def list valuesmat in]
List of ny lists of nx values, each value is the value at a grid cell corner.
The total number of values is valuesmat is nx * ny.

[arg_def list classes in]
List of class values or a list of lists of two elements (each inner list
the class value and the colour to be used). If empty or missing, the
classes are determined automatically.
[para]
[emph Note:] The class values must enclose the whole range of values.
[para]

[list_end]


[call [cmd \$xyplot] contourfill [arg xcrd] [arg ycrd] [arg values] [opt classes]]

Draw filled contours for the values given on the grid. (The use of this
method is identical to the "contourlines" method).
[para]
Entries in the legend are drawn via the [emph legendshades] subcommand.

[call [cmd \$xyplot] contourbox [arg xcrd] [arg ycrd] [arg values] [opt classes]]

Draw the cells as filled quadrangles. The colour is determined from
the average of the values on all four corners.
[para]
Entries in the legend are drawn via the [emph legendshades] subcommand.


[call [cmd \$xyplot] colorMap [arg colours]]

Set the colours to be used with the contour methods. The argument is
either a predefined colourmap (grey/gray, jet, hot or cool)
or a list of colours. When selecting the colours for actually drawing the
contours, the given colours will be interpolated (based on the HLS scheme).

[list_begin arguments]
[arg_def list colours in]
List of colour names or colour values or one of the predefined maps:
[list_begin itemized]
[item]
grey or gray: gray colours from dark to light
[item]
jet: rainbow colours
[item]
hot: colours from yellow via red to darkred
[item]
cool: colours from cyan via blue to magenta
[list_end]

[list_end]


[call [cmd \$xyplot] legendisolines [arg values] [arg classes]]

Add the contour classes to the legend as coloured lines. The text indicates the
values.

[list_begin arguments]
[arg_def list values in]
The list of values as used for the actual drawing. This argument is used only
if the list of classes is empty.
[arg_def list values in]
The list of classes as used for the actual drawing.
[list_end]


[call [cmd \$xyplot] legendshades [arg values] [arg classes]]

Add the contour classes to the legend as coloured rectangles. The text indicates the
values.

[list_begin arguments]
[arg_def list values in]
The list of values as used for the actual drawing. This argument is used only
if the list of classes is empty.
[arg_def list values in]
The list of classes as used for the actual drawing.
[list_end]


[call [cmd \$xyplot] grid [arg xcrd] [arg ycrd]]

Draw the grid cells as lines connecting the (valid) grid points.

[list_begin arguments]
[arg_def list xcrd in]
List of lists, each value is an x-coordinate for a grid cell corner

[arg_def list ycrd in]
List of lists, each value is an y-coordinate for a grid cell corner

[list_end]
[para]

[call [cmd \$xyplot] xband [arg ymin] [arg ymax]]
Draw a light grey band in the plot, ranging over the full x-axis. This
can be used to indicate a "typical" range for the data.

[list_begin arguments]
[arg_def float ymin in]
Lower bound for the band

[arg_def float ymax in]
Upper bound for the band

[list_end]
[para]

[call [cmd \$xyplot] yband [arg xmin] [arg xmax]]
Draw a light grey band in the plot, ranging over the full y-axis. This
can be used to indicate a "typical" range for the data.

[list_begin arguments]
[arg_def float xmin in]
Lower bound for the band

[arg_def float xmax in]
Upper bound for the band

[list_end]
[para]


[call [cmd \$xyplot] labeldot [arg x] [arg y] [arg text] [arg orient]]
Draw a label and a symbol in the plot. The label will appear near the
symbol. The label will be drawn in grey, so as not to be too
conspicuous.
[para]
You can configure the appearance of the symbol by using the data series
name "labeldot":
[term "\$w dataconfig labeldot -colour red -type symbol -symbol dot"]

[list_begin arguments]
[arg_def float x in]
X-coordinate of the symbol to be drawn

[arg_def float y in]
Y-coordinate of the symbol to be drawn

[arg_def string text in]
Text for the label

[arg_def string orient in]
Optional orientation (one of w, e, n, s) defining the position of the
label with respect to the symbol. It defaults to w (so the label
appears left of the symbol).

[list_end]

[list_end]
[para]


For [emph {polar plots}]:

[list_begin definitions]
[call [cmd \$polarplot] plot [arg series] [arg radius] [arg angle]]
Add a data point to the polar plot.

[list_begin arguments]
[arg_def string series in]
Name of the data series the new point belongs to.

[arg_def float radius in]
Radial coordinate of the new point.

[arg_def float angle in]
Angular coordinate of the new point (in degrees).

[list_end]
[list_end]
[para]

For [emph {wind rose diagrams}]:

[list_begin definitions]
[call [cmd \$windrose] plot [arg data] [arg colour]]
Draw the data contained in the [term data] argument. The data are added to
the existing spokes towards the outer circle.

[list_begin arguments]
[arg_def list data in]
List of data (the length should correspond to the number of sectors)

[arg_def string colour]
Colour in which the new segments will be drawn
[list_end]
[list_end]
[para]

For [emph {3D plots}]:

[list_begin definitions]
[call [cmd \$plot3d] plotfunc [arg function]]

Plot a function defined over two variables [var x] and [var y].

The resolution is determined by the set grid sizes (see the method
[method gridsize] for more information).

[list_begin arguments]
[arg_def string function in]
Name of the procedure that calculates the z-value for the given x and
y coordinates. The procedure has to accept two float arguments (x is
first argument, y is second) and return a floating-point value.

[list_end]
[para]

[call [cmd \$plot3d] plotfuncont [arg function] [arg contours]]

Plot a function defined over two variables [var x] and [var y] using
the contour levels in [var contours] to colour the surface.

The resolution is determined by the set grid sizes (see the method
[method gridsize] for more information).

[list_begin arguments]
[arg_def string function in]
Name of the procedure that calculates the z-value for the given x and
y coordinates. The procedure has to accept two float arguments (x is
first argument, y is second) and return a floating-point value.

[arg_def list contours in]
List of values in ascending order that represent the contour levels
(the boundaries between the colours in the contour map).

[list_end]
[para]


[call [cmd \$plot3d] gridsize [arg nxcells] [arg nycells]]

Set the grid size in the two directions. Together they determine how
many polygons will be drawn for a function plot.

[list_begin arguments]
[arg_def int nxcells in]
Number of grid cells in x direction. Has to be an integer number
greater than zero.

[arg_def int nycells in]
Number of grid cells in y direction. Has to be an integer number
greater than zero.

[list_end]
[para]


[call [cmd \$plot3d] plotdata [arg data]]

Plot a matrix of data.

[list_begin arguments]
[arg_def list data in]
The data to be plotted. The data has to be provided as a nested list
with 2 levels. The outer list contains rows, drawn in y-direction, and
each row is a list whose elements are drawn in x-direction, for the
columns. Example:

[para]
[example {
    set data {
    {1.0 2.0 3.0}
    {4.0 5.0 6.0}
    }
}]

[list_end]
[para]

[call [cmd \$plot3d] interpolatedata [arg data] [arg contours]]

Plot the data using bilinear interpolation with
the contour levels in [var contours] to colour the surface.

The resolution is determined by the set grid sizes (see the method
[method gridsize] for more information).

[list_begin arguments]
[arg_def list data in]
The data to be plotted, just as for the plotdata subcommand.

[arg_def list contours in]
List of values in ascending order that represent the contour levels
(the boundaries between the colours in the contour map).

[list_end]
[para]


[call [cmd \$plot3d] colour [arg fill] [arg border]]

Configure the colour to use for polygon borders and inner area.
[emph Note:] The "color" subcommand is a synonym.

[list_begin arguments]

[arg_def color fill in]
The colour to use for filling the polygons.

[arg_def color border in]
The colour to use for the border of the polygons.

[list_end]


[call [cmd \$plot3d] ribbon [arg yzpairs]]

Plot a ribbon based on the pairs of yz-coordinates. The colours for
the ribbon itself and the edge are taken from the colours option.

[list_begin arguments]

[arg_def list yzpairs in]
List of pairs of yz-coordinates

[list_end]
[list_end]
[para]

For 3D ribbon plots:

[list_begin definitions]
[call [cmd \$plot3d] plot [arg yzpairs]]

Plot a ribbon based on the pairs of yz-coordinates. The colours for
the ribbon itself and the edge are taken from the colours option.

[list_begin arguments]

[arg_def list yzpairs in]
List of pairs of yz-coordinates

[list_end]
[list_end]
[para]

For [emph {xy plots}], [emph stripcharts], [emph histograms], [emph {polar plots}] and [emph {ternary diagrams}]:

[list_begin definitions]
[call [cmd \$xyplot] dataconfig [arg series] [option -option] [arg value] ...]

Set the value for one or more options regarding the drawing of data of
a specific series.

[list_begin arguments]
[arg_def string series in]
Name of the data series whose configuration we are changing.

[list_end]
[para]

The following options are allowed:

[list_begin options]
[opt_def colour c]
[opt_def color c]
The colour to be used when drawing the data series.

[opt_def type enum]
The drawing mode chosen for the series.
This can be one of [const line], [const symbol], or [const both].

[opt_def symbol enum]

What kind of symbol to draw. The value of this option is ignored when
the drawing mode [const line] was chosen. This can be one of

[const plus], [const cross], [const circle], [const up] (triangle
pointing up), [const down] (triangle pointing down), [const dot]
(filled circle), [const upfilled] or [const downfilled] (filled
triangles).

[opt_def radius integer]

The size of the radius of the symbol. The total width of the symbol will be
2 times the radius size. The default radius is 4.

[opt_def width integer]

The width of the line (if drawn) or the width of the polygon outline (if -filled).

[opt_def filled enum]

Whether to fill the area above or below the data line or not. Can be one
of: [const no], [const up] or [const down] ([sectref "SPECIAL EFFECTS"])

[opt_def fillcolour colour]

Colour to use when filling the area associated with the data line.

[opt_def style enum]

The style to be used for histograms:
[list_begin itemized]
[item]
[const filled]: Fill the area under the data points with bars (default)
[item]
[const spike]: Draw vertical lines from the y-axis (lower boundary) to the data point
[item]
[const symbol]: Draw a symbol at the data point
[item]
[const plateau]: Draw a horizontal line at the height of the data point
[item]
[const stair]: Draw a continuous stair-like line connecting the data points
[list_end]

[opt_def smooth boolean]

(Used with ternary diagrams) Whether to draw the lines and filled polygons with the
smooth option on (rounded corners) or not.

[list_end]
[list_end]
[para]

For [emph piecharts] and [emph "spiral pies"]:

[list_begin definitions]
[call [cmd \$pie] plot [arg data]]

Fill a piechart.

[list_begin arguments]
[arg_def list data in]
A list of pairs (labels and values). The values determine the relative
size of the circle segments. The labels are drawn beside the circle.

[list_end]

[call [cmd \$pie] colours [arg colour1] [arg colour2] ...]

Set the colours to be used.

[list_begin arguments]
[arg_def color colour1 in]
The first colour.

[arg_def color colour2 in]
The second colour, and so on.

[list_end]

[call [cmd \$pie] explode [arg segment]]

Explode a segment (that is: move one segment out of the circle). If the segment is
indicated as "auto", then you can click on a segment. This will be exploded instead of
any previously exploded segment.

[list_begin arguments]
[arg_def int segment]
The segment to be exploded or "auto" if you want to do this interactively.

[list_end]

[list_end]
[para]

For [emph "radial charts"]:

[list_begin definitions]
[call [cmd \$radial] plot [arg data] [arg colour] [arg thickness]]

Draw a new line in the radial chart

[list_begin arguments]
[arg_def list data in]
A list of data (one for each spoke). The values determine the distance
from the centre of the line connecting the spokes.

[arg_def color colour in]
The colour for the line.

[arg_def int thickness in]
An optional argument for the thickness of the line.

[list_end]

[call [cmd \$pie] colours [arg colour1] [arg colour2] ...]

Set the colours to be used.

[list_begin arguments]
[arg_def color colour1 in]
The first colour.

[arg_def color colour2 in]
The second colour, and so on.

[list_end]
[list_end]
[para]

For [emph {vertical barcharts}]:

[list_begin definitions]
[call [cmd \$barchart] plot [arg series] [arg ydata] [arg colour] [opt dir] [opt brightness]]

Add a data series to a barchart. The bars are tagged with a tag "data_\$series" to identify them.

[list_begin arguments]
[arg_def string series in]
Name of the series the values belong to.

[arg_def list ydata in]
A list of values, one for each x-axis label.

[arg_def color colour in]
The colour of the bars.

[arg_def string dir in]
If given, "top-down" or "bottom-up", to indicate the direction in which the colour changes.
(If not given, a uniform colour is used).

[arg_def string brightness in]
If given, "bright" or "dark" (defaulting to "bright"). The colour will change to respectively
white or black, depending on the direction.


[list_end]

[call [cmd \$barchart] config [option -option] [arg value] ...]

Set options for drawing the bars.

[list_begin options]

[opt_def showvalues boolean]
Whether to show the values or not (above the bars)

[opt_def valuefont newfont]
Name of the font to use for the values

[opt_def valuecolour colour]
Colour for the values

[opt_def valueformat format]
Format string to use for formatting the values

[list_end]
[list_end]
[para]

For [emph {horizontal barcharts}]:

[list_begin definitions]
[call [cmd \$barchart] plot [arg series] [arg xdata] [arg colour] [opt dir] [opt brightness]]

Add a data series to a barchart. The bars are tagged with a tag "data_\$series" to identify them.

[list_begin arguments]
[arg_def string series in]
Name of the series the values belong to.

[arg_def list xdata in]
A list of values, one for each y-axis label.

[arg_def color colour in]
The colour of the bars.

[arg_def string dir in]
If given, "left-right" or "right-left", to indicate the direction in which the colour changes.
(If not given, a uniform colour is used).

[arg_def string brightness in]
If given, "bright" or "dark" (defaulting to "bright"). The colour will change to respectively
white or black, depending on the direction.

[list_end]

[call [cmd \$barchart] config [option -option] [arg value] ...]

Set options for drawing the bars.

[list_begin options]

[opt_def showvalues boolean]
Whether to show the values or not (to the right of the bars)

[opt_def valuefont newfont]
Name of the font to use for the values

[opt_def valuecolour colour]
Colour for the values

[opt_def valueformat format]
Format string to use for formatting the values

[list_end]
[list_end]
[para]

For [emph {3D barcharts}]:

[list_begin definitions]
[call [cmd \$barchart] plot [arg label] [arg yvalue] [arg colour]]

Add the next bar to the barchart.

[list_begin arguments]
[arg_def string label in]
The label to be shown below the column.

[arg_def float yvalue in]
The value that determines the height of the column

[arg_def color colour in]
The colour of the column.

[list_end]

[call [cmd \$barchart] config [option -option] [arg value] ...]

Set one or more configuration parameters. The following options are
supported:

[list_begin options]

[opt_def usebackground boolean]
Whether to draw walls to the left and to the back of the columns or not

[opt_def useticklines boolean]
Whether to draw ticklines on the walls or not

[opt_def showvalues boolean]
Whether to show the values or not

[opt_def labelfont newfont]
Name of the font to use for labels

[opt_def labelcolour colour]
Colour for the labels

[opt_def valuefont newfont]
Name of the font to use for the values

[opt_def valuecolour colour]
Colour for the values

[list_end]

[list_end]
[para]

For [emph {3D ribbon charts}]:

[list_begin definitions]
[call [cmd \$ribbon] line [arg xypairs] [arg colour]]

Plot the given xy-pairs as a ribbon in the chart

[list_begin arguments]
[arg_def list xypairs in]
The pairs of x/y values to be drawn (the series is drawn as a whole)

[arg_def color colour in]
The colour of the ribbon.

[list_end]

[call [cmd \$ribbon] area [arg xypairs] [arg colour]]

Plot the given xy-pairs as a ribbon with a filled area in front. The
effect is that of a box with the data as its upper surface.

[list_begin arguments]
[arg_def list xypairs in]
The pairs of x/y values to be drawn (the series is drawn as a whole)

[arg_def color colour in]
The colour of the ribbon/area.

[list_end]
[list_end]


For [emph boxplots]:

[list_begin definitions]
[call [cmd \$boxplot] plot [arg series] [arg label] [arg values]]

Add a box-and-whisker to the plot. The dataconfig command can be used to customize
the box-and-whisker (see the box-and-whiskers command for the xyplot for details).

[list_begin arguments]
[arg_def string series in]
Name of the data series the box belongs to

[arg_def string label in]
The label along the x- or y-axis to which the data belong

[arg_def list values in]
List of raw values, the extent of the box and the whiskers will be
determined from this list.

[list_end]
[list_end]


For [emph timecharts]:

[list_begin definitions]
[call [cmd \$timechart] period [arg text] [arg time_begin] [arg time_end] [arg colour]]

Add a time period to the chart.

[list_begin arguments]
[arg_def string text in]
The text describing the period.

[arg_def string time_begin in]
Start time of the period.

[arg_def string time_end in]
Stop time of the period.

[arg_def color colour in]
The colour of the bar (defaults to black).

[list_end]
[para]

[call [cmd \$timechart] addperiod [arg time_begin] [arg time_end] [arg colour]]

Add a new period to the current row in the chart. This allows you to highlight several periods
in the same row. No new text is drawn.

[list_begin arguments]
[arg_def string time_begin in]
Start time of the period.

[arg_def string time_end in]
Stop time of the period.

[arg_def color colour in]
The colour of the bar (defaults to black).

[list_end]
[para]


[call [cmd \$timechart] milestone [arg text] [arg time] [arg colour]]

Add a [term milestone] (represented as an point-down triangle) to the
chart.

[list_begin arguments]
[arg_def string text in]
The text describing the milestone.

[arg_def string time in]
Time at which the milestone must be positioned.

[arg_def color colour in]
The colour of the triangle (defaults to black).

[list_end]
[para]

[call [cmd \$timechart] addmilestone [arg time] [arg colour]]

Add another [term milestone] to the current row in the chart.

[list_begin arguments]
[arg_def string time in]
Time at which the milestone must be positioned.

[arg_def color colour in]
The colour of the triangle (defaults to black).

[list_end]
[para]


[call [cmd \$timechart] vertline [arg text] [arg time] [arg colour]]

Add a vertical line (to indicate the start of the month for instance)
to the chart in the specified colour.

[list_begin arguments]
[arg_def string text in]
The text appearing at the top (an abbreviation of the
date/time for instance).

[arg_def string time in]
Time at which the line must be positioned.

[arg_def color colour in]
The colour of the line to be drawn (defaults to black)

[list_end]


[call [cmd \$timechart] hscroll [arg scrollbar]]

Connect a horizontal scrollbar to the chart. See also the section on
scrolling.

[list_begin arguments]
[arg_def widget scrollbar in]
The horizontal scrollbar that is to be connected to the chart

[list_end]


[call [cmd \$timechart] vscroll [arg scrollbar]]

Connect a vertical scrollbar to the chart. See also the section on
scrolling.

[list_begin arguments]
[arg_def widget scrollbar in]
The vertical scrollbar that is to be connected to the chart

[list_end]

[list_end]
[para]

For [emph "Gantt charts"]:

[list_begin definitions]
[call [cmd \$ganttchart] task [arg text] [arg time_begin] [arg time_end] [arg completed]]

Add a task with its period and level of completion to the chart. Returns
a list of canvas items that can be used for further manipulations, like
connecting two tasks.

[list_begin arguments]
[arg_def string text in]
The text describing the task.

[arg_def string time_begin in]
Start time of the task.

[arg_def string time_end in]
Stop time of the task.

[arg_def float completed in]
The percentage of the task that is completed.

[list_end]
[para]


[call [cmd \$ganttchart] milestone [arg text] [arg time] [arg colour]]

Add a [term milestone] (represented as an point-down triangle) to the
chart.

[list_begin arguments]
[arg_def string text in]
The text describing the milestone.

[arg_def string time in]
Time at which the milestone must be positioned.

[arg_def color colour in]
The colour of the triangle (defaults to black).

[list_end]
[para]


[call [cmd \$ganttchart] vertline [arg text] [arg time]]

Add a vertical line (to indicate the start of the month for instance)
to the chart.

[list_begin arguments]
[arg_def string text in]
The text appearing at the top (an abbreviation of the
date/time for instance).

[arg_def string time in]
Time at which the line must be positioned.

[list_end]
[para]


[call [cmd \$ganttchart] connect [arg from] [arg to]]

Add an arrow that connects the [emph from] task with the [emph to] task.

[list_begin arguments]
[arg_def list from in]
The list of items returned by the "task" command that represents the
task from which the arrow starts.
[arg_def string text in]
The text summarising the tasks

[arg_def list args in]
One or more tasks (the lists returned by the "task" command). They are
shifted down to make room for the summary.

[arg_def list to in]
The list of items returned by the "task" command that represents the
task at which the arrow ends.

[list_end]
[para]


[call [cmd \$ganttchart] summary [arg text] [arg args]]

Add a summary item that spans all the tasks listed. The graphical
representation is a thick bar running from the leftmost task to the
rightmost.
[para]
Use this command before connecting the tasks, as the arrow would not be
shifted down!

[list_begin arguments]
[arg_def string text in]
The text summarising the tasks

[arg_def list args in]
One or more tasks (the lists returned by the "task" command). They are
shifted down to make room for the summary.

[list_end]
[para]


[call [cmd \$ganttchart] color [arg keyword] [arg newcolor]]

Set the colour of a part of the Gantt chart. These colours hold for all
items of that type.

[list_begin arguments]
[arg_def string keyword in]
The keyword indicates which part of the Gantt chart to change:
[list_begin itemized]
[item]
description - the colour of the descriptive text
[item]
completed - the colour of the filled bar representing the completed part
of a task
[item]
left - the colour for the part that is not yet completed
[item]
odd - the background colour for the odd entries
[item]
even - the background colour for the even entries
[item]
summary - the colour for the summary text
[item]
summarybar - the colour for the bar for a summary
[list_end]

[arg_def string newcolor in]
The new colour for the chosen items.

[list_end]
[para]


[call [cmd \$ganttchart] font [arg keyword] [arg newfont]]

Set the font of a part of the Gantt chart. These fonts hold for all
items of that type.

[list_begin arguments]
[arg_def string keyword in]
The keyword indicates which part of the Gantt chart to change:
[list_begin itemized]
[item]
description - the font used for descriptive text
[item]
summary - the font used for summaries
[item]
scale - the font used for the time scale
[list_end]

[arg_def string newfont in]
The new font for the chosen items.

[list_end]


[call [cmd \$ganttchart] hscroll [arg scrollbar]]

Connect a horizontal scrollbar to the chart. See also the section on
scrolling.

[list_begin arguments]
[arg_def widget scrollbar in]
The horizontal scrollbar that is to be connected to the chart

[list_end]


[call [cmd \$ganttchart] vscroll [arg scrollbar]]

Connect a vertical scrollbar to the chart. See also the section on
scrolling.

[list_begin arguments]
[arg_def widget scrollbar in]
The vertical scrollbar that is to be connected to the chart

[list_end]
[list_end]
[para]

For [emph {isometric plots}] (to be extended):

[list_begin definitions]
[call [cmd \$isoplot] plot rectangle [arg x1] [arg y1] [arg x2] [arg y2] [arg colour]]

Plot the outlines of a rectangle.

[list_begin arguments]
[arg_def float x1 in]
Minimum x coordinate of the rectangle to be drawn.

[arg_def float y1 in]
Minimum y coordinate of the rectangle.

[arg_def float x2 in]
Maximum x coordinate of the rectangle to be drawn.

[arg_def float y2 in]
Maximum y coordinate of the rectangle.

[arg_def color colour in]
The colour of the rectangle.

[list_end]
[para]


[call [cmd \$isoplot] plot filled-rectangle [arg x1] [arg y1] [arg x2] [arg y2] [arg colour]]

Plot a rectangle filled with the given colour.

[list_begin arguments]
[arg_def float x1 in]
Minimum x coordinate of the rectangle to be drawn.

[arg_def float y1 in]
Minimum y coordinate of the rectangle.

[arg_def float x2 in]
Maximum x coordinate of the rectangle to be drawn.

[arg_def float y2 in]
Maximum y coordinate of the rectangle.

[arg_def color colour in]
The colour of the rectangle.

[list_end]
[para]


[call [cmd \$isoplot] plot circle [arg xc] [arg yc] [arg radius] [arg colour]]

Plot the outline of a circle.

[list_begin arguments]
[arg_def float xc in]
X coordinate of the circle's centre.

[arg_def float yc in]
Y coordinate of the circle's centre.

[arg_def color colour in]
The colour of the circle.

[list_end]
[para]


[call [cmd \$isoplot] plot filled-circle [arg xc] [arg yc] [arg radius] [arg colour]]

Plot a circle filled with the given colour.

[list_begin arguments]
[arg_def float xc in]
X coordinate of the circle's centre.

[arg_def float yc in]
Y coordinate of the circle's centre.

[arg_def color colour in]
The colour of the circle.

[list_end]
[list_end]
[para]

For [emph tables] you can use the following subcommands:

[list_begin definitions]
[call [cmd \$table] row [arg items]]
Draw a single row of items. The appearance of the items can be
controlled explicitly via the format command.

[list_begin arguments]
[arg_def list items in]
List of text items to be drawn, one per column
[list_end]

[call [cmd \$table] separator]
Draw a horizontal line to separate two rows

[call [cmd \$table] formatcommand [arg procname]]
Set the procedure that controls the formatting of items. By default
items are simply drawn as centered text.

[list_begin arguments]
[arg_def string procname in]
Name of the procedure to be used. Its signature is:
[example {
proc procname {table widget row column value} {...}
}]
Use the cellconfigure subcommand to set the attributes per cell.
[list_end]

[call [cmd \$table] cellconfigure [arg args]]
Set the attributes for the next cell(s) to be drawn.

[list_begin arguments]
[arg_def list args in]
Key-value pairs: -background sets the background colour of the cells,
-cell sets the foreground colour, -font sets the text font, -anchor sets
the position of the text within the cell and -justify controls the
layout of multiline text.
[list_end]

[list_end]


For [emph {ternary diagrams}] you can use the following subcommands:

[list_begin definitions]
[call [cmd \$ternary] plot [arg series] [arg xcrd] [arg ycrd] [arg zcrd] [arg text] [arg dir]]
Draw a single data point with a label. The three coordinates are scaled so that a unique point
in the triangle results. A label is drawn next to it.

[list_begin arguments]
[arg_def string series in]
Name of the data series the point belongs to (used to determine colour and symbol)

[arg_def float xcrd in]
X-coordinate of the data point (refers to the lower-left corner).

[arg_def float ycrd in]
Y-coordinate of the data point (refers to the lower-right corner).

[arg_def float zcrd in]
Z-coordinate of the data point (refers to the top corner).

[arg_def string text in]
Label describing the data point.

[arg_def string dir in]
Optional string indicating the direction in which to plot the label (e, n, etc.)
[list_end]

[call [cmd \$ternary] line [arg series] [arg coords]]
Draw a continuous line based on the given coordinates (triplets).

[list_begin arguments]
[arg_def string series in]
Name of the data series the line belongs to (used to determine colour and smoothness)

[arg_def list coords in]
The coordinates of the points that determine the line (note that a point is defined by
three coordinates).
[list_end]

[call [cmd \$ternary] fill [arg series] [arg coords]]
Draw a filled polygon based on the given coordinates (triplets).

[list_begin arguments]
[arg_def string series in]
Name of the data series the polygon belongs to (used to determine colour and smoothness)

[arg_def list coords in]
The coordinates of the points that determine the polygon (note that a point is defined by
three coordinates).
[list_end]

[call [cmd \$ternary] text [arg xtext] [arg ytext] [arg ztext]]
Draw text at the three corners of the diagram to identify the components.

[list_begin arguments]
[arg_def string xtext in]
Text to be plotted at the lower-left corner

[arg_def string ytext in]
Text to be plotted at the lower-right corner

[arg_def string ztext in]
Text to be plotted at the top corner
[list_end]

[call [cmd \$ternary] ticklines [arg colour]]
Draw ticklines to facilitate reading off the diagram.

[list_begin arguments]
[arg_def string colour in]
Optional argument used as the colour of the ticklines. Defaults to grey.
[list_end]
[list_end]


For [emph {status timeline plots}] you can use the following subcommands:

[list_begin definitions]
[call [cmd \$timeline] plot [arg series] [arg item] [arg start] [arg stop] [arg color]]
Draw a bar in the given colour from [term start] to [term stop] for the item [term item].
The item is a convenient label - there is no relation to the labels along the axis.
The items are drawn from bottom to top.

[list_begin arguments]
[arg_def string item in]
Name to identify the bar. See remark above.

[arg_def float start in]
X-coordinate (or time) at which the bar starts

[arg_def float stop in]
X-coordinate (or time) at which the bar stops

[arg_def string color in]
Colour to use for the bar. Defaults to black.
[list_end]


[call [cmd \$timeline] vertline [arg text] [arg time] [arg args]]
Draw a vertical line to indicate a significant moment.

[list_begin arguments]
[arg_def string text in]
Text to identify the moment.

[arg_def float time in]
X-coordinate (or time) at which the line is to be drawn

[arg_def list args in]
Individual optional arguments that will be passed to the [term "create line"] subcommand
of the underlying canvas. This way you can set the colour or the line width
of the vertical line.
[list_end]
[list_end]


[section {COORDINATE TRANSFORMATIONS}]

Besides the commands that deal with the plots and charts directly,
there are a number of commands that can be used to convert world
coordinates to pixels and vice versa.

These include:

[list_begin definitions]

[call [cmd ::Plotchart::viewPort] [arg w] [arg pxmin] [arg pymin] [arg pxmax] [arg pymax]]

Set the viewport for window [arg w]. Should be used in cooperation
with [cmd ::Plotchart::worldCoordinates].

[list_begin arguments]
[arg_def widget w in]
Name of the window (canvas widget) in question.

[arg_def float pxmin in]
Left-most pixel coordinate.

[arg_def float pymin in]
Top-most pixel coordinate (remember: the vertical pixel coordinate
starts with 0 at the top!).

[arg_def float pxmax in]
Right-most pixel coordinate.

[arg_def float pymax in]
Bottom-most pixel coordinate.

[list_end]
[para]


[call [cmd ::Plotchart::worldCoordinates] [arg w] [arg xmin] [arg ymin] [arg xmax] [arg ymax]]

Set the extreme world coordinates for window [arg w]. The world
coordinates need not be in ascending order (i.e. xmin can be larger
than xmax, so that a reversal of the x-axis is achieved).

[list_begin arguments]
[arg_def widget w in]
Name of the window (canvas widget) in question.

[arg_def float xmin in]
X-coordinate to be mapped to left side of viewport.

[arg_def float ymin in]
Y-coordinate to be mapped to bottom of viewport.

[arg_def float xmax in]
X-coordinate to be mapped to right side of viewport.

[arg_def float ymax in]
Y-coordinate to be mapped to top side of viewport.

[list_end]
[para]


[call [cmd ::Plotchart::world3DCoordinates] [arg w] [arg xmin] [arg ymin] [arg zmin] [arg xmax] [arg ymax] [arg zmax]]

Set the extreme three-dimensional world coordinates for window
[arg w]. The world coordinates need not be in ascending order (i.e. xmin
can be larger than xmax, so that a reversal of the x-axis is
achieved).

[list_begin arguments]
[arg_def widget w in]
Name of the window (canvas widget) in question.

[arg_def float xmin in]
X-coordinate to be mapped to front side of the 3D viewport.

[arg_def float ymin in]
Y-coordinate to be mapped to left side of the viewport.

[arg_def float zmin in]
Z-coordinate to be mapped to bottom of viewport.

[arg_def float xmax in]
X-coordinate to be mapped to back side of viewport.

[arg_def float ymax in]
Y-coordinate to be mapped to right side of viewport.

[arg_def float zmax in]
Z-coordinate to be mapped to top side of viewport.

[list_end]
[para]


[call [cmd ::Plotchart::coordsToPixel] [arg w] [arg x] [arg y]]

Return a list of pixel coordinates valid for the given window.

[list_begin arguments]
[arg_def widget w in]
Name of the canvas alias (as returned by [lb]\$anyplot canvas[rb]) in question.

[arg_def float x in]
X-coordinate to be mapped.

[arg_def float y in]
Y-coordinate to be mapped.

[list_end]
[para]


[call [cmd ::Plotchart::coords3DToPixel] [arg w] [arg x] [arg y] [arg z]]

Return a list of pixel coordinates valid for the given window.

[list_begin arguments]
[arg_def widget w in]
Name of the canvas alias (as returned by [lb]\$anyplot canvas[rb]) in question.

[arg_def float x in]
X-coordinate to be mapped.

[arg_def float y in]
Y-coordinate to be mapped.

[arg_def float y in]
Z-coordinate to be mapped.

[list_end]
[para]


[call [cmd ::Plotchart::polarCoordinates] [arg w] [arg radmax]]

Set the extreme polar coordinates for window [arg w]. The angle always
runs from 0 to 360 degrees and the radius starts at 0. Hence you only
need to give the maximum radius.

[emph Note:] If the viewport is not square, this procedure will not
adjust the extremes, so that would result in an elliptical plot. The
creation routine for a polar plot always determines a square viewport.

[list_begin arguments]
[arg_def widget w in]
Name of the canvas alias (as returned by [lb]\$anyplot canvas[rb]) in question.

[arg_def float radmax in]
Maximum radius.

[list_end]
[para]


[call [cmd ::Plotchart::polarToPixel] [arg w] [arg rad] [arg phi]]

Wrapper for a call to [cmd ::Plotchart::coordsToPixel].
[emph Note:] This procedure has been deprecated - you should
use the procedure [cmd ::Plotchart::coordsToPixel] instead.

[list_begin arguments]
[arg_def widget w in]
Name of the canvas alias (as returned by [lb]\$anyplot canvas[rb]) in question.

[arg_def float rad in]
Radius of the point.

[arg_def float phi in]
Angle to the positive x-axis.

[list_end]
[para]


[call [cmd ::Plotchart::pixelToCoords] [arg w] [arg x] [arg y]]

Return a list of world coordinates valid for the given window.

[list_begin arguments]
[arg_def widget w in]
Name of the canvas alias (as returned by [lb]\$anyplot canvas[rb]) in question.

[arg_def float x in]
X-pixel to be mapped.

[arg_def float y in]
Y-pixel to be mapped.

[list_end]

[call [cmd ::Plotchart::pixelToIndex] [arg w] [arg x] [arg y]]

Return the index of the pie segment containing the pixel coordinates
(x,y)

[list_begin arguments]
[arg_def widget w in]
Name of the canvas alias (as returned by [lb]\$anyplot canvas[rb]) in question,
holding a piechart.

[arg_def float x in]
X-pixel to be mapped.

[arg_def float y in]
Y-pixel to be mapped.

[list_end]
[list_end]
[para]

Furthermore there is a routine to determine "pretty" numbers for use
with an axis:

[list_begin definitions]
[call [cmd ::Plotchart::determineScale] [arg xmin] [arg xmax] [arg inverted]]

Determine "pretty" numbers from the given range and return a list
containing the minimum, maximum and stepsize that can be used for a
(linear) axis.

[list_begin arguments]
[arg_def float xmin in]
Rough minimum value for the scaling

[arg_def float xmax in]
Rough maximum value for the scaling.

[arg_def boolean inverted in]
Optional argument: if 1, then the returned list produces an
inverted axis. Defaults to 0 (the axis will be from minimum to maximum)

[list_end]

[call [cmd ::Plotchart::determineScaleFromList] [arg values] [arg inverted]]

Determine "pretty" numbers from the given list of values and return a list
containing the minimum, maximum and stepsize that can be used for a
(linear) axis.

[list_begin arguments]
[arg_def float values in]
List of values that will be examined. May contain missing values (empty strings)

[arg_def boolean inverted in]
Optional argument: if 1, then the returned list produces an
inverted axis. Defaults to 0 (the axis will be from minimum to maximum)

[list_end]
[list_end]


[section {MISSING VALUES}]
Often data that need to be plotted contain gaps - in a series of
measurement data, they can occur because the equipment failed, a sample
was not collected correctly or for many other reasons. The
[emph Plotchart] handles these gaps by assuming that one or both
coordinates of such data points are an empty string:

[example {
    #
    # Create the plot with its x- and y-axes
    #
    set s [::Plotchart::createXYPlot .c {0.0 100.0 10.0} {0.0 100.0 20.0}]

    foreach {x y} {0.0 32.0 10.0 {} 25.0 60.0 78.0 11.0 } {
        $s plot series1 $x $y
    }
}]

The effect varies according to the type of plot:

[list_begin itemized]
[item]
For xy-plots, radial plots and strip charts the missing data point
causes a gap in the line through the points.
[item]
For barchats, missing values are treated as if a value of zero was
given.
[item]
For time charts and Gantt charts missing values cause errors - there is
no use for them there.
[list_end]


[section {OTHER OUTPUT FORMATS}]

Besides output to the canvas on screen, the module is capable, via
[cmd {canvas postscript}], of producing PostScript files. One may wonder
whether it is possible to extend this set of output formats and the
answer is "yes". This section tries to sum up the aspects of using this
module for another sort of output.
[para]
One way you can create output files in a different format, is by
examining the contents of the canvas after everything has been drawn and
render that contents in the right form. This is probably the easiest
way, as it involves nothing more than the re-creation of all the
elements in the plot that are already there.
[para]
The drawback of that method is that you need to have a display, which is
not always the case if you run a CGI server or something like that.
[para]
An alternative is to emulate the canvas command. For this to work, you
need to know which canvas subcommands are used and what for. Obviously,
the [emph create] subcommand is used to create the lines, texts and
other items. But also the [emph raise] and [emph lower] subcommands are
used, because with these the module can influence the drawing order -
important to simulate a clipping rectangle around the axes. (The routine
DrawMask is responsible for this - if the output format supports proper
clipping areas, then a redefinition of this routine might just solve
this).
[para]
Furthermore, the module uses the [emph cget] subcommand to find out the
sizes of the canvas. A more mundane aspect of this is that the module
currently assumes that the text is 14 pixels high and that 80 pixels in
width suffice for the axis' labels. No "hook" is provided to customise
this.
[para]
In summary:
[list_begin itemized]
[item]
Emulate the [emph create] subcommand to create all the items in the
correct format

[item]
Emulate the [emph cget] subcommand for the options -width and -height to
allow the correct calculation of the rectangle's position and size

[item]
Solve the problem of [emph raising] and [emph lowering] the items so
that they are properly clipped, for instance by redefining the
routine DrawMask.

[item]
Take care of the currently fixed text size properties

[list_end]


[section {SPECIAL EFFECTS}]

As an example of some special effects you can achieve, here is the
code for a plot where the area below the data line varies in colour:

[example {
canvas .c  -background white -width 400 -height 200
pack .c -fill both

set s [::Plotchart::createXYPlot .c {0.0 100.0 10.0} {0.0 100.0 20.0}]

$s background gradient green top-down

$s dataconfig series1 -filled up -fillcolour white

$s plot series1  0.0 20.0
$s plot series1 10.0 20.0
$s plot series1 30.0 50.0
$s plot series1 35.0 45.0
$s plot series1 45.0 25.0
$s plot series1 75.0 55.0
$s plot series1 100.0 55.0

$s plaintext 30.0 60.0 "Peak" south
}]

The trick is to fill the background with a colour that changes from
green at the top to white at the bottom. Then the area above the data
line is filled with a white polygon. Thus the green shading varies with
the height of the line.

[section {ROOM FOR IMPROVEMENT}]

In this version there are a lot of things that still need to
be implemented:

[list_begin itemized]
[item]
More robust handling of incorrect calls (right now the procedures may
fail when called incorrectly):

[list_begin itemized]
[item]
The axis drawing routines can not handle inverse axes right now.

[item]
If the user provides an invalid date/time string, the routines simply
throw an error.

[list_end]
[list_end]


[section RESIZING]

[package Plotchart] has not been designed to create plots and charts
that keep track of the data that are put in. This means that if an
application needs to allow the user to resize the window holding the
plot or chart, it must take care to redraw the complete plot.

[para]
The code below is a simple example of how to do that:

[example {
package require Plotchart

grid [canvas .c -background white] -sticky news
grid columnconfigure . 0 -weight 1
grid rowconfigure . 0 -weight 1

bind .c <Configure> {doResize}

proc doPlot {} {
    #
    # Clean up the contents (see also the note below!)
    #
    .c delete all

    #
    # (Re)draw the bar chart
    #
    set p [::Plotchart::createBarchart .c {x y z} {0 100 10} 3]
    $p plot R {10 30 40} red
    $p plot G {30 40 60} green
}

proc doResize {} {
    global redo

    #
    # To avoid redrawing the plot many times during resizing,
    # cancel the callback, until the last one is left.
    #
    if { [info exists redo] } {
        after cancel $redo
    }

    set redo [after 50 doPlot]
}}]


[emph "Please note:"]
The code above will work fine for barcharts and many other types of
plots, but as [package Plotchart] keeps some private information for
xy plots, more is needed in these cases. This actually requires a
command "destroyPlot" to take care of such details. A next version
of [package Plotchart] may have that.

[para]
Alternatively, you can use the [package xyplot] package which is built
on top of Plotchart. This package supports zooming in and zooming out,
as well as resizing the plot as a whole. Here is a small demonstration
program:

[example {
# xyplot_demo.tcl --
#     Demonstration of the xyplot package
#

package require xyplot

set xydata1 {}
set xydata2 {}
set xydata3 {}
set xydata4 {}
for { set i 0 } { $i < 1024 } { incr i } {
    lappend xydata1 [expr {$i-1000}] [expr {$i * sin($i/4096.0*3.1415*2) * (sin($i/256.0*3.1415*2))}]
    lappend xydata2 [expr {$i-1000}] [expr {$i * sin($i/4096.0*3.1415*2) * (sin($i/256.0*3.1415*2) + 0.25 * sin($i/256.0*3.1415*6))}]
    lappend xydata3 [expr {$i-1000}] [expr {$i * sin($i/4096.0*3.1415*2) * (sin($i/256.0*3.1415*2) + 0.25 * sin($i/256.0*3.1415*6) + 0.0625 * sin($i/256.0*3.1415*10))}]
    lappend xydata4 [expr {$i-1000}] [expr {$i * sin($i/4096.0*3.1415*2) * (sin($i/256.0*3.1415*2) + 0.25 * sin($i/256.0*3.1415*6) + 0.0625 * sin($i/256.0*3.1415*10) + 0.015625 * sin($i/256.0*3.1415*14))}]
}

set xyp [xyplot .xyp -xformat "%5.0f" -yformat "%5.0f" -title "XY plot testing" -background gray90]
pack $xyp -fill both -expand true

set s1 [$xyp add_data sf1 $xydata1 -legend "Serie 1 data" -color red]
set s2 [$xyp add_data sf2 $xydata2 -legend "Serie 2 data" -color green]
set s3 [$xyp add_data sf3 $xydata3 -legend "Serie 3 data" -color blue]
set s4 [$xyp add_data sf4 $xydata4 -legend "Serie 4 data" -color orange]

set xyp2 [xyplot .xyp2 -xticks 8 -yticks 4 -yformat %.2f -xformat %.0f]
pack $xyp2 -fill both -expand true

set s1 [$xyp2 add_data sf1 $xydata1]
set s2 [$xyp2 add_data sf2 $xydata2]
set s3 [$xyp2 add_data sf3 $xydata3]
set s4 [$xyp2 add_data sf4 $xydata4]
}]

Zooming in is done by selecting a rectangle with the left mouse button
pressed. Zooming out is done by pressing the right mouse button. If you
resize the window, the canvases inside are resized too. If you zoom in,
you can scroll the plot via the scrollbars that are automatically
attached.


[section "ZOOMING IN"]

As the Plotchart package does not keep track of the data itself,
rescaling an existing plot - for instance when zooming in - would have
to be done by redefining the plot and redrawing the data. However, the
canvas widget offers a way out by scaling and moving items, so that
zooming in becomes a bit simpler.

[para]
Whether zooming is indeed useful, depends on the type of plot. Currently
it is defined for XY-plots only. The method is called "rescale" and
simply redraws the axes and scales and moves the data items so that they
conform to the new axes. The drawback is that any symbols are scaled by
the same amount. The rescale method works best for plots that only have
lines, not symbols.

[para]
The method works very simply:

[example {
   $p rescale {newxmin newxmax newxstep} {newymin newymax newystep}
}]


[section "CONFIGURATION OPTIONS AND OTHER COMMANDS"]

The commands [cmd plotconfig] and [cmd plotstyle] can be used to set all
manner of options. The command [cmd eraseplot] can be used to completely erase a plot or
chart. The syntax of these commands is:

[list_begin definitions]

[call [cmd ::Plotchart::plotconfig] [arg charttype] [arg component] [arg property] [arg value]]

Set a new value for the property of a component in a particular chart or
plot type or query its current value. Changed properties only have effect for
the consecutive plots, not for the ones already created. Each argument is optional.
[para]
[emph Note:] The [cmd plotstyle] command offers a more
flexible way to control the configuration options.

[list_begin arguments]
[arg_def string charttype in]
The type of chart or plot (see the configuration type that is mentioned
for each create command). If not given or empty, a list of chart types
is returned. If it is given, the properties for that particular type are
used.

[arg_def string component in]
The component of the plot/chart: leftaxis, rightaxis, background, margin
and so on. If not given or empty, a list of components is returned. If
it is given, the properties for that particular component will be set
for that particular type of chart.

[arg_def string property in]
The property of the component of the plot/chart: textcolor, thickness of
the axis line, etc. If not given or empty, a list of properties is returned. If
it is given, that particular property for that particular component
will be set for that particular type of chart.

[arg_def string value in]
The new value for the property. If empty, the current value is returned.
If the value is "default", the default value will be restored.
[para]
Note, that in some cases an empty value is useful. Use "none" in this
case - it can be useful for colours and for formats.

[list_end]

[call [cmd ::Plotchart::plotstyle] [arg subcmd] [arg style] [arg args]]

Manipulate the [emph style] in which subsequent plots will be drawn. The
default style is "default", but you can define and load any number of
other styles.

[list_begin arguments]
[arg_def string subcmd in]
The subcommand to be executed:
[list_begin itemized]
[item]
[emph configure] - this subcommand allows you to set the options per chart type.
It takes the same options as the [cmd plotconfig] command.
[item]
[emph current] - return the current style
[item]
[emph load] - make the given style the active style for subsequent plots and charts
[item]
[emph names] - return the list of currently defined styles
[list_end]

[arg_def string style in]
The name of the plot style to manipulate

[arg_def list args in]
The new options for the style. Each option is described by: chart type, component of the chart,
property of the component and the new value for the property - see the [cmd plotconfig] command for details.

[list_end]
[list_end]

Below is a detailed list of the components and properties:

[list_begin itemized]

[item]
Axes come in a wide variety:

[list_begin itemized]
[item]
leftaxis, rightaxis, topaxis, bottomaxis for the plots with a
rectangular shape.
[item]
xaxis, yaxis and zaxis are used for the 3D plots
[item]
axis, this represents the radial and tangential axes of a polar plot
[list_end]

All axes have the following properties:

[list_begin itemized]

[item]
color - the colour of the line and the tickmarks
[item]
thickness - the width of the line of the axis itself, not the tickmarks
[item]
ticklength - the length of the tickmarks in pixels. A positive value is
outward, a negative value is inward.
[item]
font - the font for the labels and the text at the axis
[item]
format - the format for rendering the (numerical) labels. For the time
axis it is the format for a date and time.
[item]
textcolor - the colour for the labels and the text.
[item]
labeloffset - space (in pixels) between the tickmark and the actual label
[item]
minorticks - number of minor tickmarks between the major tickmarks
[item]
shownumbers - show the numbers/labels or not.
[item]
showaxle - show the axis line or not.

[list_end]

[item]
The [emph margin] is important for the layout. Currently only the
rectangular plots allow the margins to be set: left, right, top and bottom.
The values are in pixels.

[item]
The [emph text] component is meant for any text appearing via the
plaintext subcommand. The properties are: textcolor, font and anchor
(positioning of the text relative to the given coordinates).

[item]
The [emph background] has two properties: outercolor, the colour outside
of the actual plot, and innercolor, the colour inside the plot. (Note:
only "outercolor" has now been implemented).

[item]
The [emph mask] has one property only: draw. If set to 1, the default, white rectangles
are drawn to mimick the effects of clipping - excess data are made invisible this way.
Otherwise these rectangles are not drawn. This is useful to control
the layout more tightly, for instance with multiple plots in one canvas.

[item]
The [emph title] component has the same properties as the [emph text] component
(but it is independent of that component). It also has a [emph background] property:
If not set (or set to the empty string) this is the same as the outercolor property
of the [emph background] component, otherwise it is a separate colour.

[item]
The [emph legend] has three properties: background, border and position.
See the legend subcommand for the meaning.

[item]
The [emph bar] components is used for all barchart-like plots and has
three properties: [emph barwidth] (relative width of the bars in
relation to the items along the axis), [emph innermargin] (the
relative width of the gaps between bars or groups of bars) and
the [emph outline] colour.

[item]
The [emph labels] component is used to describe the appearance of the
labels of piecharts and "spiral" piecharts. The properties are:
[list_begin itemized]
[item]
textcolor - colour of the label text
[item]
font - font to be used for the label text
[item]
placement - [emph out] of the circle or [emph in] the circle
[item]
sorted - the data are sorted in ascending order first
[item]
shownumbers - the labels are combined with the numbers according to the
format
[item]
format - the format to be used (defaults to: "%s (%g)")
if the numbers are to shown. The format command gets the label first,
then the number)
[item]
formatright - if given, the format to be used for labels and numbers
appearing to the right of the pie. The format command gets the
number first, then the label. (Defaults to "")
[list_end]

[item]
The [emph slice] component has properties to control the appearance of
the sections in the pie diagram:
[list_begin itemized]
[item]
outline - the colour of the line around the slices (default: black)
[item]
outlinewidth - width of the line around the slices (default: 1 pixel)
[item]
startangle - the angle w.r.t. positive x-axis where the first slice
starts
[item]
direction - the direction in which to draw the slices (default: +, that
is clockwise)
[list_end]

[item]
The table charts use the general components [emph title] and [emph margin]
and further more the specific components [emph header], [emph oddrow],
[emph evenrow], [emph cell] and [emph frame]:
[list_begin itemized]
[item]
[emph header], [emph oddrow] and [emph evenrow] have the properties:
[emph background], [emph font], [emph color], [emph height] and
[emph anchor] with obvious meanings.
[item]
The [emph cell] component defines in addition [emph leftspace],
[emph rightspace] and [emph topspace] for fine-grained control of the spacing
inside the cell. These are not set via the [term cellconfigure]
subcommand however.
[item]
Finally the [emph frame] component uses [emph color], [emph outerwidth]
(for the width of the line surrounding the whole table) and
[emph innerwidth] (for the width of lines separating columns and rows).
[list_end]


[list_begin definitions]
[call [cmd ::Plotchart::eraseplot] [arg anyplot]]

Erase the plot/chart with all resources connected to it.

[list_begin arguments]
[arg_def string anyplot in]
The plot/chart command. All canvas items associated with this command and all
internal resources will be removed, including the plot/chart command itself.
[list_end]

[list_end]
[list_end]

See the examples in plotdemos7.tcl for its use.


[section "SCROLLING FOR TIMECHARTS AND GANTT CHARTS"]

For two types of plots automatic scrolling management has been
implemented: timecharts and Gantt charts. The subcommands [term hscroll]
and [term vscroll] associate (existing) scrollbars to the plot, in much
the same way as for text and canvas widgets.

[para]
Once the association is made, the scrollbars are automatically
updated if:
[list_begin itemized]
[item]
You add an item with a period wider than the current one.
[item]
You add a vertical line for a time beyond the current bounds.
[item]
You add an extra item beyond the number that was used to create the
chart.
[list_end]

For instance:

[example {
package require Plotchart

canvas .c -width 400 -height 200
scrollbar .y -orient vertical
scrollbar .x -orient horizontal

grid .c .y -sticky news
grid .x    -sticky news

source plotchart.tcl

set s [::Plotchart::createTimechart .c "1 january 2004" \
                                       "31 december 2004" 4]

$s period "Spring" "1 march 2004" "1 june 2004" green
$s period "Summer" "1 june 2004" "1 september 2004" yellow
$s vertline "1 jan" "1 january 2004"
$s vertline "1 apr" "1 april 2004"
$s vertline "1 jul" "1 july 2004"
$s vertline "1 oct" "1 october 2004"
$s vertline "1 jan" "1 january 2005"
$s vertline "1 apr" "1 april 2005"
$s vertline "1 jul" "1 july 2005"
$s milestone "Longest day" "21 july 2004"
$s milestone "Longest day 2" "21 july 2004"
$s milestone "Longest day 3" "21 july 2004"
$s milestone "Longest day 4" "21 july 2004"
$s milestone "Longest day 5" "21 july 2004"
$s milestone "Longest day 6" "21 july 2004"
$s title "Seasons (northern hemisphere)"

$s vscroll .y
$s hscroll .x
}]

The original extent of the chart is from 1 january 2004 to 31 december
2004. But because of the addition of vertical lines in 2005 and
more items than was specified at the creation of the chart, both the
horizontal and the vertical scrollbar will be enabled.


[section "SPECIALISED PLOTS"]

Most of the plot and chart types described above have a fairly general use
and you simply prepares the data to be plotted yourself. This section describes
several plot types that are more specialised, in the sense that they have specific
purposes and you pass raw data that are then processed in the plotting routines.

[para]
Currently there are the following types:
[list_begin itemized]

[item]
Target diagrams are used to assess the capacity of numerical models to reproduce measurement
data. They are described in detail in:
[example {
Jason K. Joliff et al.
    Summary diagrams for coupled hydrodynamic-ecosystem model skill assessment
    Journal of Marine Systems 76 (2009) 64-82
    DOI: 10.1016/j.jmarsys.2008.05.014
}]

[item]
Performance profiles are used for comparing the performance of numerical methods or
implementations thereof with each other. For more information:
[example {
Desmond Higham and Nicholas Higham
    Matlab Guide
    SIAM, 2005, Philadephia
}]

[list_end]

Most of the general methods for XY-plots work for these plots as well, but their
creation and the methods to plot the data are very specific.

[list_begin definitions]

[call [cmd ::Plotchart::createTargetDiagram] [arg w] [arg limits] [arg scale]]

Create a new target diagram with circles indicating specific limits. The x-axis represents the
unbiased "root-mean-square difference" (typically varying between -1 and 1) and the y-axis
represents the normalised bias.
[para]
Data points closer to the origin represent better results than data points further away.

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def list limits in]
List of radii for the circles that represent the limits (for instance: 0.5 and 0.7)

[arg_def double scale in]
Scale for the axes - defaults to 1, but if the model results are a poor fit, then
that may be too small a value. Both axes are scaled in the same way.

[list_end]
[para]

[call [cmd \$target] plot [arg series] [arg xvalues] [arg yvalues]]
The plot method takes two series of data of the same length, the first one
representing the model results, the second one represent the measurements
or, more general, the data that need to be reproduced.

[list_begin arguments]
[arg_def string series in]
Name of the series (it will be plotted as a symbol that is configured via the
[emph {$target dataconfig}] command (see the XY-plot equivalent for an explanation)

[arg_def list xvalues in]
List of model results (missing values are represented as empty strings)

[arg_def list yvalues in]
List of measured values (missing values are represented as empty strings; only if
both the x and the y values are given, is the pair used in the computations)
[list_end]


[call [cmd ::Plotchart::createPerformanceProfile] [arg w] [arg max]]

Create a diagram to show the performance of various numerical methods (or solvers). The idea is
to first run these methods on a set of problems and measure their performance. The smaller the
number the better. Then these methods are compared via a so-called performance profile:
the data are scaled and ordered, such that the best method ends up highest.
[para]
Because of the nature of the plot all data must be given at once.

[list_begin arguments]
[arg_def widget w in]
Name of the [emph existing] canvas widget to hold the plot.

[arg_def float max in]
Maximum value for the x-axis (the x-axis is the scaled performance of the series).
[list_end]

[call [cmd \$performance] plot [arg series_and_data_pairs]]
Plot the data for each given method. The data are identified by the series name and the
appearance is controlled via prior dataconfig subcommand.

[list_begin arguments]
[arg_def list series_and_data_pairs in]
List of series names and data. All data must be given at once.
[list_end]

[list_end]

The command [term plotmethod] can be used to add new methods for a particular
plot or chart type. It is intended to help you develop specialised graphical displays.

[list_begin definitions]

[call [cmd ::Plotchart::plotmethod] [arg charttype] [arg methodname] [arg plotproc]]

Adds a new method for the given plot or chart type. The method is implemented by the
command or procedure given in the plotproc argument. The procedure will be called with
two extra arguments, the name of the created plot and the canvas widget that contains
(see the example below).

[list_begin arguments]
[arg_def string charttype in]
The type of plot or chart that the new method should be added to.

[arg_def string methodname in]
Name of the method to be used.

[arg_def string plotproc in]
Name of the command or procedure that implements the method.

[list_end]
[list_end]
[para]

Here is a trivial example of how to use this:

[example {
#
# The custom method "doodle" always adds the text "DOODLE"
# to the plot
#
proc doodle {p w x y} {
    $p plaintext $x $y "DOODLE"
}
::Plotchart::plotmethod xyplot doodle doodle

#
# Use it
pack [canvas .c]

set p [::Plotchart::createXYPlot .c {0 100 10} {0 20 5}]

$p doodle 40 10
}]


[section "TABLE CHARTS"]
To show what you can do with table charts, here is a simple example that
plots a number of random data. The colours depend on the range that the
data belong to. For this the procedure [term setColor] is used.

[example {
package require Plotchart

pack [canvas .c -bg white -height 300] -fill both -expand yes

::Plotchart::plotconfig table frame outerwidth 3
::Plotchart::plotconfig table frame color red

set t [::Plotchart::createTableChart .c {"Column 1" "Column 2" "Column 3"} 80]


proc setColor {table widget row col value} {
    $table cellconfigure -background white -color black
    if { $value < 2.0 } {
        $table cellconfigure -background red -color white
    }
    if { $value > 6.0 } {
        $table cellconfigure -background green
    }

    return [format "%6.3f" $value]
}

# Command must already exist ...
$t formatcommand setColor

$t title "Demonstration of table charts"
$t separator

for {set i 0} {$i < 9} {incr i} {
    set row {}

    for {set j 0} {$j < 3} {incr j} {
        lappend row [expr {10.0 * rand()}]
    }

    if { $i == 3 } {
        $t separator
    }

    $t row $row
}}]


[section "CONTROL DISPLAYS"]
TODO


[section "USING DATE/TIME LABELS"]
The options -timeformat and -gmt are used to control the display of date/time
labels along the x-axis for those plot types for which it makes sense. These
options were implemented to take care of date/time labels for stripcharts,
as you can also use custom labels (the option -xlabels) if the axis is "static".
Since this is not the case for stripcharts, this was not an option (Tcllib/Tklib bug 3613718).

The example below illustrates how to use the -timeformat option. The -gmt option
merely suppresses the handling of daylight saving time by the [lb]clock format[rb] command.

[example {
package require Plotchart

pack [canvas .c -width 500 -bg white]

#
# Note that we need to present the x values as clock seconds
#
set start [clock scan  "0:00"]
set stop  [clock scan "10:00"]
set s [Plotchart::createStripchart .c [list $start $stop 7200] {0 10 1} -timeformat "%H:%M"]

foreach {x y} {0 0 2 5 5 2 9 9 12 10} {
    set x [expr {$start + 3600 * $x}] ;# Convert hour to clock seconds
    $s plot a $x $y
}}]

The [emph plot] subcommand simply interprets the x and y data as straightforward
numbers, so that you need to do the conversion from date/time to "clock seconds" yourself.


[section "ARRANGING MULTIPLE PLOTS IN A CANVAS"]

The command [term plotpack] allows you to copy the contents of a plot
into another canvas widget. This canvas widget does not act as a
composite plot, but it can be saved as a PostScript file for instance:

Note: the command simply takes a snapshot of the plots/charts as they
are at that moment.

[list_begin definitions]

[call [cmd ::Plotchart::plotpack] [arg w] [arg dir] [arg args]]

Copy the contents of the plots/charts into another widget, in a manner
similar to the [term pack] geometry manager.

[list_begin arguments]
[arg_def widget w in]
The name of the canvas widget to copy the plots/charts into

[arg_def string dir in]
The direction of the arrangement - top, left, bottom or right

[arg_def list args in]
List of plots/charts to be copied.

[list_end]
[list_end]

For example:
[example {
    set p1 [createXYPlot ...]
    set p2 [createBarchart ...]

    ... fill the plots ...

    toplevel .t
    pack [canvas .t.c2 -width ...]

    #
    # Copy the two plots above each other in the new canvas
    #
    plotpack .t.c2 top $p1 $p2
}]

A different method is to use the [emph -box] and [emph -axesbox] options
when creating the plot. These control the area in the canvas where the
plot or chart will be drawn.
[para]
The [emph -box] option takes as its value a list of four numbers:
[list_begin itemized]
[item]
X-coordinate of the upper-left corner of the area that will contain the
plot or chart (simply a canvas coordinate)
[item]
Y-coordinate of the upper-left corner
[item]
Width of the area
[item]
Height of the area
[list_end]
Specifying the width and height makes it easier to reposition the area
with respect to other plots.

[para]
The [emph -axesbox] option is meant to make aligning the axes of a
plot with those of other plots easier. The option takes a list of
six arguments:
[list_begin itemized]
[item]
Identification of the plot with respect to which it should be
positioned (the command returned by the creation command).
[item]
The anchor position that should be used (n, nw, ...)
[item]
X-coordinate of the upper-left corner of the area that will contain the
plot or chart. This coordinates is taken relative to the
[emph "anchor position"]
[item]
Y-coordinate of the upper-left corner
[item]
Width of the axis area
[item]
Height of the axis area
[list_end]
With this option the area the axes occupy is first determined and the
complete area is derived from the margins.
[para]
For example:
[example {
    set p2 [::Plotchart::createXYPlot .c {0 10 1} {-5 5 2.5} -axesbox [list $p1 ne 0 0 200 200]]
}]
will create a second plot whose left axis coincides with the right axis
of plot "\$p1" and the top of the axis is at the same heigt as well -
because the axes are positioned at a point 0 pixels to the left and 0
pixels below the north-east corner.


[section {INTERACTIVE USE}]
[emph Plotchart] has several features for interactive use (cf. [sectref {NOTES ON TAGS}]):

[list_begin itemized]

[item]
The legend can be moved around by pressing mouse button 1 in the legend's box and
keeping it down.

[item]
You can use the [emph bindplot] and [emph bindlast] commands to
define actions that are to be taken when the user clicks on an element of the plot or chart.
(see below, see also the sample code in plotdemos12.tcl)

[item]
[emph Piecharts] can show an "exploded" segment that you can select with mouse button 1.

[list_end]

If you require different forms of interaction, not covered by [emph Plotchart] itself,
you can use the tags on the various canvas elements to define other bindings.

[para]
The [emph bindplot] and [emph bindlast] are defined as follows:
[list_begin definitions]

[call [cmd \$anyplot] bindplot [arg event] [arg command] [arg args]]
Register a command that will be run whenever the given event occurs in the plot.

[list_begin arguments]
[arg_def string event]
The event that you want to bind the command to

[arg_def string command]
Name of the command/procedure that you want to run. The following arguments
are prefixed: the x- and y-coordinates of the point in the plot (the world coordinates!),
so that the procedure has the signature:
[example {
    cmd $xworld $yworld $string1 $string2 $string3
}]
assuming the argument "command" is: {cmd A B C}

[list_end]

[call [cmd \$anyplot] bindlast [arg series] [arg event] [arg command]]
Register a command that will be run when the event occurs within the neighbourhood of
the last point added to the given series. (You can use directly after inserting
a data point. All such commands will remain active).

[list_begin arguments]
[arg_def string event]
The event that you want to bind the command to

[arg_def list command]
Name of the command/procedure that you want to run. The following arguments
are prefixed: the x- and y-coordinates of the point in the plot (the world coordinates!),
so that the procedure has the signature:
[example {
    cmd $xworld $yworld $string1 $string2 $string3
}]
assuming the argument "command" is: {cmd A B C}

[list_end]
[list_end]

Here is an example - show the values of the data points in an annotation
(from the sample code in plotdemos12.tcl):
[example {
#
# Procedure for showing an annotation
#
proc showAnnotation {xcoord ycoord plot w} {

    $plot balloon $xcoord $ycoord "Data point: [format "%.3f, %.3f" $xcoord $ycoord]" north

    after 2000 [list removeAnnotation $w]
}

#
# Procedure for erase an annotation
#
proc removeAnnotation {w} {

    # Use the tags to remove all annotations
    $w delete BalloonText
    $w delete BalloonFrame
}

#
# Create a simple plot and a label
#
pack [canvas .c -bg white] [label .l -textvariable coords]

set p [::Plotchart::createXYPlot .c {0 1000 200} {0 10 1}]

$p dataconfig series1 -type both -symbol cross

foreach x {1 2 5 10 20 50 100 200 500 1000} {
    $p plot series1 $x [expr {log($x)}]

    #
    # Show the annotation for each data point
    #
    $p bindlast series1 <Enter> [list showAnnotation $p %W]
}
}]


[section {NOTES ON TAGS}]

The implementation of [emph Plotchart] relies heavily on the canvas's
ability to identify graphical objects by tags and to change the drawing order of
the objects. This section documents the tags that are used.

[para]
([emph Note:] the tags are not always used consistently - see the notes appearing with
the various tags. This section describes the current state.)

[para]
[emph "General graphical objects:"]
[list_begin itemized]
[item]
[emph mask] - Used to manipulate the opaque rectangles that ensure data outside
the viewport are not shown.
[item]
[emph "topmask, horizmask, vertmask"] - specialised tags, used for scrollable plots.
[item]
[emph title] - Used for title strings.
[item]
[emph "BalloonText, BalloonFrame"] - Used to manipulate balloon text.
[item]
[emph PlainText] - Used to manipulate ordinary text without any decoration.
[item]
[emph background] - Tag used for gradient and image backgrounds (and for gradient-filled bars).
[item]
[emph "xaxis, yaxis"] - Tags used for all objects related to horizontal or vertical axes.
(also: both for numerical axes and axes with labels as in barcharts).
Note, however, that the [emph text] along the axes has no particular tag.
[item]
[emph raxis] - Tag used for all objects related to a [emph right] axis.
[item]
[emph taxis] - Tag used for all objects related to a [emph time] axis.
[item]
[emph axis3d] - Tag used for 3D axes
[item]
[emph "xtickline, ytickline"] - Tags used for ticklines.
[item]
[emph "legend, legengb, legendobj"] - Tags used for the legend. The latter is used to manipulate
the legend as a whole.
[item]
[emph "legend_series"] - Tag used to control the appearance of the legend entry ("series" should
be replaced by the series name).
[item]
[emph object] - used as standard tag for all objects drawn with the [cmd ::Plotchart::drawobject]
procedure. Tags given at object creation time are added to this tag.

[list_end]

[emph "XY-plots (all types of axes):"]
[list_begin itemized]
[item]
[emph data] - The general tag to identify graphical objects associated with data.
[emph data_seriesname] - The tag specific to a data series ("seriesname" should be replaced).
[emph band] - The horizontal or vertical band drawn with the xband otr yband subcommands have this tag
by the actual name).
[emph xtext] - The text labelling the xaxis.
[emph ytext] - The text labelling hte yaxis horizontically.
[emph vtext] - The text labelling the yaxis vertically.
[list_end]
Items such as labelled dots only have the "data" tag.

[para]
[emph "Piecharts and spiral pies:"]
[list_begin itemized]
[item]
[emph segment_segmentnumber] - The tag identifying the segment, the string "segmentnumber" should
be replaced by the actual number. This tag is used to explode the segments.
[list_end]

[emph "Barcharts:"]
[para]
Barcharts use the same tags as xy-plots (but for gradient-filled bars the data_seriesname is not used).

[para]
[emph "Histograms and isometric plots:"]
[para]
Currently the only tag used is "data".

[para]
[emph "Time-charts:"]
[para]
As these plots are scrollable, several tags are used specific to the scrolling:
vertscroll, horizscroll, below, lowest, above, timeline, tline.
Each item also has a tag of the form "item_number",
where "number" is to be replaced by the actual sequence number of the item.

[para]
[emph "Gantt charts:"]
[para]
In addition to the tags described for the time-charts, the following tags are used:
description, completed, summary and summarybar.

[para]
[emph "Radial charts and polar plots:"]
[para]
Currently the radial lines indicating the grid have no tags. The graphical objects associated with
data only have the "data" tag.

[para]
[emph "Windroses:"]
[para]
Only the tag [emph data_number] is currently used ("number" should be replaced by the
sequence number of the data, starting at 0.

[para]
[emph "Contour and isoline plots:"]
[para]
No tags are used.

[para]
[emph "3D plots and 3D ribbon plots:"]
[para]
Tags are used for the axes and for the data objects:
[list_begin itemized]
[item]
[emph data] - The general tag to identify graphical objects associated with data.
[emph line] - The tag used for lines created with the plotline subcommand.
[list_end]

[para]
[emph "Charts decorated with 3D effects:"]
[para]
The following tags are used to identify various types of graphical objects: platform, background, d, u,
ticklines.
[para]
The text associated with the bars has no tags. The ribbon lines and areas have no tags either.

[para]
[emph "Tables:"]
[para]
Tags used are: frame, cellbg and celltext


[emph "In addition:"]
To implement multiple plots and charts in a single canvas, all items
also get as a tag the plot/chart they belong to. This enables Plotchart
to manipulate only those items.


[section {TODO - SOME PRIVATE NOTES}]

I have the following wishlist:

[list_begin itemized]
[item]
Isometric plots - allow new items to be implemented easily.

[item]
A general 3D viewer - emphasis on geometry, not a ray-tracer.

[item]
Several improvements for boxplots:
[list_begin itemized]
[item]
Height of the box scales with the logarithm of the number of points
[item]
Marker line to indicate a "current" value
[item]
Box drawn from quantiles
[list_end]

[list_end]

[vset CATEGORY plotchart]                                                        <
[include ../../support/devel/doc/feedback.inc]                                   <
[manpage_end]
