''' 
'''  Copyright (C) 1991,96  Lele Gaifax
'''
'''  This program is free software; you can redistribute it and/or modify
'''  it under the terms of the GNU General Public License as published by
'''  the Free Software Foundation; either version 2 of the license, or (at
'''  your option) any later version.
'''
'''  This program is distributed in the hope that it will be useful,
'''  but WITHOUT ANY WARRANTY; without even the implied warranty of
'''  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'''  GNU General Public License for more details.
'''
'''  You should have received a copy of the GNU General Public License
'''  along with this program; if not, write to the Free Software
'''  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
'''
''' The next definitions are from Larry Wall's perl manual pages.
.de Sh
.br
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp
.if t .sp .5v
.if n .sp
..
.de Ip
.br
.ie \\n.$>=3 .ne \\$3
.el .ne 3
.IP "\\$1" \\$2
..
'''
'''     Set up \*(-- to give an unbreakable dash;
'''     string Tr holds user defined translation string.
'''     Bell System Logo is used as a dummy character.
'''
.tr \(*W-|\(bv\*(Tr
.ie n \{\
.ds -- \(*W-
.if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\" diablo 12 pitch
.ds L" ""
.ds R" ""
.ds L' '
.ds R' '
'br\}
.el\{\
.ds -- \(em\|
.tr \*(Tr
.ds L" ``
.ds R" ''
.ds L' `
.ds R' '
'br\}
.TH TUA 1L "16 November 1991" "Release 3.4" "LOCAL USER COMMANDS"
.SH NAME
TUA \- The Uucp Analyzer
.SH SYNOPSIS
.B tua
[ option ]
.SH NOTE
This manual page is no longer supported. See
.IR tua.texinfo
for up-to-dated information.
.SH DESCRIPTION
.LP
The purpose of the
.I TUA
utility is to produce a readable and complete analysis of the
.IR HoneyDanBer
UUCP connections.
This manual page describes the 
.I TUA
command line options and shortly explains its output.
.SH OPTIONS
To specify any of the options, you can use either the short form or the
more mnemonic long form. In the latter case, you can abbreviate the name
as long as it is unique. For more information on the long format, please
refer to the
.IR "GNU getopt"
package description.
.sp 1
.TP 0.5i
.B \-S, +no-sys-rep
Do not print the
.BR "per System report" .
The default is to print it out.
.TP 0.5i
.B \-U, +no-user-rep
Do not print the
.BR "per User report" .
The default is to print it out.
.TP 0.5i
.B \-D, +no-daily-rep
Do not print the
.BR "Daily report" .
The default is to print it out.
.TP 0.5i
.B \-C, +command-lists
Show also the command lists. It is off by default because it makes
.I TUA
very hungry of memory.
.TP 0.5i
.BI "\-O, +only-system " SYSTEM
Consider just system
.I SYSTEM
in the reports. You can specify more than one of this option, so you can have
.I TUA
consider just those systems.
.TP 0.5i
.B \-m, +no-monthly-act
Do not output the last 12 months activity summary.
.TP 0.5i
.B \-h, +no-history
Do not output the history at the end of the reports.
.TP 0.5i
.B \-c, +separate-com
Separate command lists from the other data. So there will be two tables
with the header
.I "By System" ,
the first containing only the amounts and the timing of each transfer,
the second with all the commands invoked by each System. You must specify
also the
.B \-C
option to make it works.
.TP 0.5i
.BI "\-k, +kill-system " SYSTEM
Eliminate each reference to
.I SYSTEM
from the reports. Neither the transfer table nor the
.I SYSTEM
command list will be printed.
.TP 0.5i
.BI "\-K, +kill-user " USER
Like
.B \-k
, but it applies to the user called
.I USER .
.TP 0.5i
.B \-H, +update-hist
Update the
.I history
database (see the FILES section below) with the new values. You must have
the
.B uucp
write permission.
.TP 0.5i
.B \-0, +reset-hist
Reset the
.I history
database, deleting any systems in it. Then put in the database the
analysis since the last
.I uuclean .
You have to specify also
.B \-H
to make this option do his job.
.TP 0.5i
.B \-y, +no-hourly-chart
Do not display the hourly activity chart.
.TP 0.5i
.BI "-z, +chart-size " SIZE
Set the size of the hourly activity chart to
.I SIZE
rows. The greater is this number, the smaller is the scale. By default it
is set to 10.
.TP 0.5i
.B \-o, +chart-only
Display only the hourly activity chart. Since with this options
.I TUA
reads only 
.BR .Admin/xferstats ,
it is faster.
.TP 0.5i
.B \-v, +verbose
Print, on standard error, what is going on. While
.I TUA
reads the various logs, it displays a counter of the loaded lines.
.TP 0.5i
.BI "\-p, +prefix-path " PATH
By default,
.I TUA
looks for uucp data in 
.BR "/usr/spool/uucp/"
and in the relative subdirectory. For debugging purpose, this option lets you
change this directory, so that
.I TUA
looks for the data in the specified
.I PATH.
Below this point
.I TUA
needs a hierarchy like the standard one (see FILES below).
.TP 0.5i
.BI "\-u, +user-alias " USER=ALIAS
Inserts ALIAS as the new name for USER. Where ever appears USER it will be
replaced with ALIAS. Since this occurs at the lowest level, if happens that
ALIAS is another user name, this will cause that all the data that belongs
to USER will be added to the ALIAS user.
.TP 0.5i
.BI "\-r, +port-alias " PORT=ALIAS
Like
.B \-u
, but it applies to the serial port names. This can be useful on those OS
where a single serial port has two names, one for normal use and the other
with modem control (eg.
.BR tty1a
and
.BR tty1A
).
.TP 0.5i
.BI "\-s, +sys-alias " SYS=ALIAS
Like
.B \-u
, but it applies to the systems names.
.TP 0.5i
.BI "\-E, +glob-user-alias " GLOB=ALIAS
.TP 0.5i
.BI "\-R, +glob-port-alias " GLOB=ALIAS
.TP 0.5i
.BI "\-M, +glob-sys-alias " GLOB=ALIAS
These are the counterpart respectively of
.B \-u
,
.B \-r
and
.B \-s
with 
.BR meta-characters
searches. You can use for example
.nf

        tua +glob-user-alias uu*=UUCPUSERS

.fi
and every user name that begins with
.B "uu"
will be mapped in a meta user called
.B "UUCPUSERS"
\. See the manual page for
.I sh(1)
for a description of
.BR meta-characters
\.
.TP 0.5i
.B \-i, +help
Show a summary and a description of all the options.
.SH OUTPUT
All reports are printed on the standard output, so you can easily
redirect them wherever you want. Assuming, unless otherwise stated,
that you do not explicity request to disable some of the reports
(eg. when you do not specify
any command line option), here is a short description of what you get.
.Sh "By System"
With this report, you get all the information relative to all the 
nodes that talk with your machine but those which didn't sent or received
something. The data are divided in 
.I inbound
and
.I outbound.
For each system, displayed in alphabetical order, you have the total 
count of the files transferred, with the relative 
bytes and times, as well as an average transfer rate (ATP). 
If
.B \+commands-lists
was specified, next there is
the list of the commands invoked by that node, or directed to it. If a
command is preceeded by a number between brackets, that number indicates how 
many times that command was invoked.
.Sh "By User"
This report is similar to the previous one, but it shows, in
alphabetical order for each local user, all the commands the user invoked, 
and the transfers he caused.
.Sh "By Day"
This report summarize the per day activity on the local machine. It doesn't
depend on the destinations and on the users.
.Sh "SUMMARY by System"
It shows a summary of the activity of each system, and the number of calls
(inbound and outbound) for it. Please note that sometimes
.I TUA
fails in calculating the exact number of calls, because of the misleading 
log of uucico. Note also that the "total connection time" always differs from
the sum of the trasmissions times, because it takes care also of the various
uucp dead time. In fact, it is calculated from the difference between
the time in which the nodes are really connected (ie. at the end of dial 
phase, when the modem answers) and the time in which the link is dropped, 
due to the the end of the conversation as well as to any error.
Then comes the time of the last connection with that system.
There is also the subdivision of the connection time based on the phone
costs, ie "day", "evening", "night". This is completely configurable,
so if your telephone company uses a different hourly division you can
adjust it (see
.BR config.h
and
.BR phonesw.c .)
.Sh "SUMMARY by System (table format)"
Substancially, this report summarizes some of the previous informations in a
tabular form. Nothing new...
.Sh "and since ..."
This is the historical data maintained by
.I TUA.
It looks like the previous table, but it includes the history
of the system, incrementally.
.Sh "Last 12 Months Activity"
This table shows the activity of the local machine during the last 12 months.
Only the transferred amounts are computed.
.br
The months are displayed in a manner so that the last column contains the
current one, so it is very readable (of course, it is a matter of opinions!)
.Sh "Hourly Activity (per communication port)"
This chart shows the uucp hourly load for each used communication port. 
Each hour is divided in 20 minutes slices. 
.Sh "Global Hourly Activity"
The same as the previous chart, but it reports the sums of all the ports.
.SH HISTORY
.I TUA
maintains a database with the history of each system and of the activity
in each of the last 12 months
activities. It is usually located in
.BR /usr/spool/uucp/.Admin/tua.history
and it is actually an ASCII file. It is up to you to update it or not, because
probably you will like to run
.I TUA
simply to have a notion of what is going on. To make it working correctly, 
you have to run
.I TUA
with the option 
.BR +update-hist 
just before you run uuclean. So probably you will have to modify that
script including in it a line like
.nf

        tua +update-hist {whatever options you like} | mail lele

.fi
before it cleans up the uucp logs.
.SH BUGS
Since HDB\-Uucp doesn't put a complete datestamp in its logs, but omits
the year, it may be possible that
.IR TUA
fails to compute the various times in the first analysis of the year.
This is in my opinion its major weakness. For this silliness,
.IR TUA
cannot correctly handle logs that cover several years. There is little
that I can do to correct the situation; I tried to adjust the year
when the to\-be\-parsed date refers obviously to the previous year,
but this is just a work\-around...
.PP
There is a limit: if your system spent more than 9999 hours
linked with someone (or the sum exceed that value), the reports will be
garbaged...
.SH DISCLAIMER
.I TUA
is
.BR free ,
and it is redistribuitable under the terms of the GNU
General Public License. You can find a copy of it in the file
.BR COPYING
in the distribution package.
I reject any responsability about it. It is simple and safe, but
I did not try it under all the possible conditions and environments, so if it
causes you some trouble, I'll be sad for a while, but that's it. However, 
I will try to correct any bugs you will tell me.
.PP
And 
.BR please,
forgive my poor english, but I put my soul in it...
.SH AUTHOR
Lele Gaifas, Idea Informatica, Rovereto (TN) - Italy
.br
( piggy@idea.sublink.org )
.SH FILES
 .../.Log/uucico/*       uucico's logs
 .../.Log/uucp/*         uucp's logs
 .../.Log/uux/*          uux's logs
 .../.Log/uuxqt/*        uuxqt's logs
 .../.Admin/xferstat     Transfer stats
 .../.Admin/tua.history  TUA's system history
.SH BUGS REPORT TO
Lele Gaifas, piggy@idea.sublink.org
.SH ACKNOLEDGMENT
I want to thank expecially Marco Lorenzini 
(marlor@gear.sublink.org) for his help in debugging the previous 
releases of
.I TUA
on the SCO Unix architecture, and for his suggestions on the layout of
the reports. And to the "omnipresent" Paolo Ventafridda 
(venta@i2ack.sublink.org) for his support and interest, and several
other people that encouraged me to add more and more functionality, or
that let me scan their huge logs.
.br
Thanks also to all the people that, with their PD or GPL software, helped
me indirectly with ideas or examples.
